/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.stream;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualStream
extends ProcessEquipmentBaseClass {
    static Logger logger = LogManager.getLogger(VirtualStream.class);
    protected StreamInterface refStream = null;
    protected StreamInterface outStream = null;
    protected double flowRate;
    protected String flowUnit;
    protected boolean setFlowRate = false;
    protected double temperature;
    protected String temperatureUnit;
    protected boolean setTemperature = false;
    protected double pressure;
    protected String pressureUnit;
    protected boolean setPressure = false;
    protected double[] composition;
    protected String compositionUnit;
    protected boolean setComposition = false;

    public VirtualStream(String name, StreamInterface stream) {
        super(name);
        this.refStream = stream;
    }

    public VirtualStream(String name) {
        super(name);
    }

    public void setReferenceStream(StreamInterface stream) {
        this.refStream = stream;
    }

    public void setFlowRate(double rate, String unit) {
        this.flowRate = rate;
        this.flowUnit = unit;
        this.setFlowRate = true;
    }

    public void setComposition(double[] comps, String unit) {
        this.composition = comps;
        this.compositionUnit = unit;
        this.setComposition = true;
    }

    public void setTemperature(double temp, String unit) {
        this.temperature = temp;
        this.temperatureUnit = unit;
        this.setTemperature = true;
    }

    public void setPressure(double pres, String unit) {
        this.pressure = pres;
        this.pressureUnit = unit;
        this.setPressure = true;
    }

    @Override
    public void run(UUID id) {
        this.outStream = new Stream("new stram", this.refStream.getFluid().clone());
        if (this.setFlowRate) {
            this.outStream.setFlowRate(this.flowRate, this.flowUnit);
        }
        if (this.setTemperature) {
            this.outStream.setTemperature(this.temperature, this.temperatureUnit);
        }
        if (this.setPressure) {
            this.outStream.setPressure(this.pressure, this.pressureUnit);
        }
        if (this.setComposition) {
            this.outStream.getFluid().setMolarComposition(this.composition);
        }
        this.outStream.run();
    }

    public StreamInterface getOutStream() {
        return this.outStream;
    }

    @Override
    public boolean solved() {
        return false;
    }
}

