/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import java.util.ArrayList;
import java.util.UUID;
import neqsim.processSimulation.mechanicalDesign.separator.GasScrubberMechanicalDesign;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.sectionType.SeparatorSection;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;

public class NeqGasScrubber
extends Separator {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    ArrayList<SeparatorSection> scrubberSection = null;
    StreamInterface inletStream;
    StreamInterface gasOutStream;
    StreamInterface liquidOutStream;
    String name = new String();

    @Deprecated
    public NeqGasScrubber() {
        this("NeqGasScrubber");
    }

    @Deprecated
    public NeqGasScrubber(StreamInterface inletStream) {
        this("NeqGasScrubber", inletStream);
    }

    public NeqGasScrubber(String name) {
        super(name);
        this.setOrientation("vertical");
    }

    public NeqGasScrubber(String name, StreamInterface inletStream) {
        super(name, inletStream);
        this.setOrientation("vertical");
    }

    @Override
    public GasScrubberMechanicalDesign getMechanicalDesign() {
        return new GasScrubberMechanicalDesign(this);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasOutStream = new Stream("gasOutStream", this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidOutStream = new Stream("liquidOutStream", this.liquidSystem);
    }

    public void addScrubberSection(String type) {
        this.scrubberSection.add(new SeparatorSection("section" + this.scrubberSection.size() + 1, type, this));
    }

    @Override
    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    @Override
    public StreamInterface getGas() {
        return this.getGasOutStream();
    }

    @Override
    public StreamInterface getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasSystem.setNumberOfPhases(1);
        this.gasOutStream.setThermoSystem(this.gasSystem);
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidSystem.setNumberOfPhases(1);
        this.liquidOutStream.setThermoSystem(this.liquidSystem);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void displayResult() {
    }
}

