/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.expander;

import java.util.UUID;
import neqsim.processSimulation.processEquipment.compressor.Compressor;
import neqsim.processSimulation.processEquipment.expander.ExpanderInterface;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Expander
extends Compressor
implements ExpanderInterface {
    private static final long serialVersionUID = 1000L;

    @Deprecated
    public Expander() {
    }

    @Deprecated
    public Expander(StreamInterface inletStream) {
        super(inletStream);
    }

    public Expander(String name) {
        super(name);
    }

    public Expander(String name, StreamInterface inletStream) {
        super(name, inletStream);
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.getThermoSystem());
        thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double hinn = this.getThermoSystem().getEnthalpy();
        double entropy = this.getThermoSystem().getEntropy();
        this.inletEnthalpy = hinn;
        if (this.usePolytropicCalc) {
            int numbersteps = 40;
            double dp = (this.pressure - this.getThermoSystem().getPressure()) / (1.0 * (double)numbersteps);
            for (int i = 0; i < numbersteps; ++i) {
                entropy = this.getThermoSystem().getEntropy();
                hinn = this.getThermoSystem().getEnthalpy();
                this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + dp);
                thermoOps.PSflash(entropy);
                double hout = hinn + (this.getThermoSystem().getEnthalpy() - hinn) * this.polytropicEfficiency;
                thermoOps.PHflash(hout, 0);
            }
        } else {
            this.getThermoSystem().setPressure(this.pressure);
            thermoOps.PSflash(entropy);
            if (!this.powerSet) {
                this.dH = (this.getThermoSystem().getEnthalpy() - hinn) * this.isentropicEfficiency;
            }
            double hout = hinn + this.dH;
            this.isentropicEfficiency = this.dH / (this.getThermoSystem().getEnthalpy() - hinn);
            this.dH = hout - hinn;
            thermoOps.PHflash(hout, 0);
        }
        this.outStream.setThermoSystem(this.getThermoSystem());
        this.setCalculationIdentifier(id);
    }
}

