/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.compressor;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Objects;
import java.util.UUID;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.processSimulation.mechanicalDesign.compressor.CompressorMechanicalDesign;
import neqsim.processSimulation.processEquipment.TwoPortEquipment;
import neqsim.processSimulation.processEquipment.compressor.AntiSurge;
import neqsim.processSimulation.processEquipment.compressor.CompressorChart;
import neqsim.processSimulation.processEquipment.compressor.CompressorChartAlternativeMapLookup;
import neqsim.processSimulation.processEquipment.compressor.CompressorChartInterface;
import neqsim.processSimulation.processEquipment.compressor.CompressorInterface;
import neqsim.processSimulation.processEquipment.compressor.CompressorPropertyProfile;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Compressor
extends TwoPortEquipment
implements CompressorInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Compressor.class);
    public SystemInterface thermoSystem;
    private double outTemperature = 298.15;
    private boolean useOutTemperature = false;
    private CompressorPropertyProfile propertyProfile = new CompressorPropertyProfile();
    public double dH = 0.0;
    public double inletEnthalpy = 0.0;
    public double pressure = 0.0;
    private int speed = 3000;
    public double isentropicEfficiency = 1.0;
    public double polytropicEfficiency = 1.0;
    public boolean usePolytropicCalc = false;
    public boolean powerSet = false;
    private CompressorChartInterface compressorChart = new CompressorChart();
    private AntiSurge antiSurge = new AntiSurge();
    private double polytropicHead = 0.0;
    private double polytropicFluidHead = 0.0;
    private double polytropicHeadMeter = 0.0;
    private double polytropicExponent = 0.0;
    private int numberOfCompressorCalcSteps = 40;
    private boolean useRigorousPolytropicMethod = false;
    private boolean useGERG2008 = false;
    private String pressureUnit = "bara";
    private String polytropicMethod = "detailed";

    @Deprecated
    public Compressor() {
        this("Compressor");
    }

    @Deprecated
    public Compressor(StreamInterface inletStream) {
        this();
        this.setInletStream(inletStream);
    }

    @Deprecated
    public Compressor(boolean interpolateMapLookup) {
        this("Compressor", interpolateMapLookup);
    }

    public Compressor(String name) {
        super(name);
    }

    public Compressor(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public Compressor(String name, boolean interpolateMapLookup) {
        this(name);
        if (interpolateMapLookup) {
            this.compressorChart = new CompressorChartAlternativeMapLookup();
        }
    }

    @Override
    public CompressorMechanicalDesign getMechanicalDesign() {
        return new CompressorMechanicalDesign(this);
    }

    @Override
    public Compressor copy() {
        return (Compressor)super.copy();
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        try {
            this.outStream = inletStream.clone();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public void solveAntiSurge() {
        if (this.getAntiSurge().isActive()) {
            // empty if block
        }
    }

    @Override
    public void setOutletPressure(double pressure) {
        this.pressure = pressure;
    }

    public void setOutletPressure(double pressure, String unit) {
        this.pressure = pressure;
        this.pressureUnit = unit;
    }

    @Override
    public double getOutletPressure() {
        return this.pressure;
    }

    @Override
    public double getEnergy() {
        return this.getTotalWork();
    }

    public double getPower() {
        return this.getTotalWork();
    }

    public double getPower(String unit) {
        double conversionFactor = 1.0;
        if (unit.equals("MW")) {
            conversionFactor = 1.0E-6;
        } else if (unit.equals("kW")) {
            conversionFactor = 0.001;
        }
        return conversionFactor * this.getPower();
    }

    public void setPower(double p) {
        this.powerSet = true;
        this.dH = p;
    }

    public double solveEfficiency(double outTemperature) {
        double newPoly;
        double funk = 0.0;
        double funkOld = 0.0;
        double dfunkdPoly = 100.0;
        double dPoly = 100.0;
        double oldPoly = outTemperature;
        this.useOutTemperature = false;
        this.run();
        this.useOutTemperature = true;
        int iter = 0;
        boolean useOld = this.usePolytropicCalc;
        do {
            funk = this.getThermoSystem().getTemperature() - outTemperature;
            dfunkdPoly = (funk - funkOld) / dPoly;
            newPoly = this.polytropicEfficiency - funk / dfunkdPoly;
            if (++iter <= 1) {
                newPoly = this.polytropicEfficiency + 0.01;
            }
            oldPoly = this.polytropicEfficiency;
            this.polytropicEfficiency = newPoly;
            this.isentropicEfficiency = newPoly;
            dPoly = this.polytropicEfficiency - oldPoly;
            funkOld = funk;
            this.useOutTemperature = false;
            this.run();
            this.useOutTemperature = true;
        } while ((Math.abs(this.getThermoSystem().getTemperature() - outTemperature) > 1.0E-5 || iter < 3) && iter < 50);
        this.usePolytropicCalc = useOld;
        return newPoly;
    }

    public double findOutPressure(double hinn, double hout, double polytropicEfficiency) {
        double entropy = this.getThermoSystem().getEntropy();
        this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + 1.0, this.pressureUnit);
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.getThermoSystem());
        thermoOps.PSflash(entropy);
        double houtGuess = hinn + this.dH / polytropicEfficiency;
        thermoOps.PHflash(houtGuess, 0);
        System.out.println("TEMPERATURE .." + this.getThermoSystem().getTemperature());
        return this.getThermoSystem().getPressure();
    }

    @Override
    public void run(UUID id) {
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        if (Math.abs(this.pressure - this.thermoSystem.getPressure(this.pressureUnit)) < 1.0E-6 && !this.compressorChart.isUseCompressorChart()) {
            this.thermoSystem.initProperties();
            this.outStream.setThermoSystem(this.getThermoSystem());
            this.outStream.setCalculationIdentifier(id);
            this.dH = 0.0;
            this.polytropicFluidHead = 0.0;
            this.polytropicHeadMeter = 0.0;
            return;
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.getThermoSystem());
        thermoOps = new ThermodynamicOperations(this.getThermoSystem());
        this.getThermoSystem().init(3);
        this.getThermoSystem().initPhysicalProperties("density");
        double presinn = this.getThermoSystem().getPressure();
        double hinn = this.getThermoSystem().getEnthalpy();
        double densInn = this.getThermoSystem().getDensity();
        double entropy = this.getThermoSystem().getEntropy();
        if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
            double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
            hinn = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
            entropy = gergProps[8] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
            densInn = this.getThermoSystem().getPhase(0).getDensity_GERG2008();
        }
        this.inletEnthalpy = hinn;
        boolean surgeCheck = false;
        double orginalMolarFLow = this.thermoSystem.getTotalNumberOfMoles();
        double fractionAntiSurge = 0.0;
        double kappa = 0.0;
        if (this.useOutTemperature) {
            double polyPow;
            if (this.useRigorousPolytropicMethod) {
                this.solveEfficiency(this.outTemperature);
                this.polytropicFluidHead = this.polytropicHead = this.getPower() / this.getThermoSystem().getFlowRate("kg/sec") / 1000.0 * this.getPolytropicEfficiency();
                this.polytropicHeadMeter = this.polytropicFluidHead * 1000.0 / 9.80665;
                return;
            }
            double MW = this.thermoSystem.getMolarMass();
            this.thermoSystem.setPressure(this.getOutletPressure(), this.pressureUnit);
            thermoOps.PSflash(entropy);
            if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                thermoOps.PSflashGERG2008(entropy);
            }
            this.thermoSystem.initPhysicalProperties("density");
            double densOutIsentropic = this.thermoSystem.getDensity("kg/m3");
            double enthalpyOutIsentropic = this.thermoSystem.getEnthalpy();
            if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                densOutIsentropic = this.getThermoSystem().getPhase(0).getDensity_GERG2008();
                enthalpyOutIsentropic = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
            }
            this.thermoSystem.setTemperature(this.outTemperature);
            thermoOps.TPflash();
            this.thermoSystem.init(2);
            this.thermoSystem.initPhysicalProperties("density");
            double outEnthalpy = this.thermoSystem.getEnthalpy();
            double densOut = this.thermoSystem.getDensity("kg/m3");
            if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                outEnthalpy = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
                densOut = this.getThermoSystem().getPhase(0).getDensity_GERG2008();
            }
            this.dH = outEnthalpy - this.inletEnthalpy;
            double n = Math.log(this.getOutletPressure() / presinn) / Math.log(densOut / densInn);
            double CF = (enthalpyOutIsentropic - this.inletEnthalpy) / this.thermoSystem.getFlowRate("kg/sec") / (n / (n - 1.0) * (this.getOutletPressure() * 100000.0 / densOutIsentropic - presinn * 100000.0 / densInn));
            double F1 = this.thermoSystem.getTotalNumberOfMoles();
            double polytropicPower = F1 * MW * (n / (n - 1.0)) * CF * presinn * 100000.0 / densInn * (Math.pow(this.getOutletPressure() / presinn, (n - 1.0) / n) - 1.0);
            this.polytropicEfficiency = polytropicPower / this.getThermoSystem().getFlowRate("kg/sec") / (this.dH / this.getThermoSystem().getFlowRate("kg/sec"));
            this.isentropicEfficiency = (enthalpyOutIsentropic - this.inletEnthalpy) / this.dH;
            double k = Math.log(this.getOutletPressure() / presinn) / Math.log(densOutIsentropic / densInn);
            double term1 = Math.pow(this.getOutletPressure() / presinn, (n - 1.0) / n) - 1.0;
            double term2 = n / (n - 1.0) * (k - 1.0) / k;
            double term3 = Math.pow(this.getOutletPressure() / presinn, (k - 1.0) / k) - 1.0;
            this.polytropicEfficiency = polyPow = term1 * term2 / term3 * this.isentropicEfficiency;
            polytropicPower = this.dH * this.polytropicEfficiency;
            this.polytropicFluidHead = polytropicPower / this.getThermoSystem().getFlowRate("kg/sec") / 1000.0;
            this.polytropicHeadMeter = this.polytropicFluidHead * 1000.0 / 9.81;
            this.polytropicHead = this.polytropicFluidHead;
            if (this.getCompressorChart().isUseCompressorChart()) {
                this.polytropicHead = this.getCompressorChart().getHeadUnit().equals("meter") ? this.polytropicHeadMeter : this.polytropicFluidHead;
            }
            this.outStream.setThermoSystem(this.getThermoSystem());
            this.outStream.setCalculationIdentifier(id);
            this.setCalculationIdentifier(id);
            return;
        }
        if (this.compressorChart.isUseCompressorChart()) {
            do {
                double n;
                double actualFlowRate = this.thermoSystem.getFlowRate("m3/hr");
                double z_inlet = this.thermoSystem.getZ();
                double MW = this.thermoSystem.getMolarMass();
                kappa = this.getCompressorChart().useRealKappa() ? this.thermoSystem.getGamma() : this.thermoSystem.getGamma2();
                if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                    double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                    actualFlowRate *= gergProps[1] / z_inlet;
                    kappa = gergProps[14];
                    z_inlet = gergProps[1];
                }
                double polytropEff = this.getCompressorChart().getPolytropicEfficiency(actualFlowRate, this.getSpeed());
                this.setPolytropicEfficiency(polytropEff / 100.0);
                this.polytropicHead = this.getCompressorChart().getPolytropicHead(actualFlowRate, this.getSpeed());
                double temperature_inlet = this.thermoSystem.getTemperature();
                this.polytropicExponent = n = 1.0 / (1.0 - (kappa - 1.0) / kappa * 1.0 / (polytropEff / 100.0));
                if (this.getCompressorChart().getHeadUnit().equals("meter")) {
                    this.polytropicFluidHead = this.polytropicHead / 1000.0 * 9.81;
                    this.polytropicHeadMeter = this.polytropicHead;
                } else {
                    this.polytropicFluidHead = this.polytropicHead;
                    this.polytropicHeadMeter = this.polytropicHead * 1000.0 / 9.81;
                }
                double pressureRatio = Math.pow((this.polytropicFluidHead * 1000.0 + n / (n - 1.0) * z_inlet * 8.314 * temperature_inlet / MW) / (n / (n - 1.0) * z_inlet * 8.314 * temperature_inlet / MW), n / (n - 1.0));
                this.setOutletPressure(this.thermoSystem.getPressure() * pressureRatio);
                if (this.getAntiSurge().isActive()) {
                    logger.info("surge flow " + this.getCompressorChart().getSurgeCurve().getSurgeFlow(this.polytropicHead) + " m3/hr");
                    surgeCheck = this.isSurge(this.polytropicHead, actualFlowRate);
                }
                if (this.getCompressorChart().getStoneWallCurve().isActive()) {
                    // empty if block
                }
                if (surgeCheck && this.getAntiSurge().isActive()) {
                    this.thermoSystem.setTotalFlowRate(this.getAntiSurge().getSurgeControlFactor() * this.getCompressorChart().getSurgeCurve().getSurgeFlow(this.polytropicFluidHead), "Am3/hr");
                    this.thermoSystem.init(3);
                    fractionAntiSurge = this.thermoSystem.getTotalNumberOfMoles() / orginalMolarFLow - 1.0;
                    this.getAntiSurge().setCurrentSurgeFraction(fractionAntiSurge);
                }
                this.powerSet = true;
                this.dH = this.polytropicFluidHead * 1000.0 * this.thermoSystem.getMolarMass() / this.getPolytropicEfficiency() * this.thermoSystem.getTotalNumberOfMoles();
            } while (surgeCheck && this.getAntiSurge().isActive());
        }
        if (this.usePolytropicCalc) {
            if (this.powerSet) {
                double hout = hinn * (1.0 + fractionAntiSurge) + this.dH;
                this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
                thermoOps = new ThermodynamicOperations(this.getThermoSystem());
                thermoOps.PHflash(hout, 0);
                if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                    thermoOps.PHflashGERG2008(hout);
                }
            } else if (this.polytropicMethod.equals("detailed")) {
                int numbersteps = this.numberOfCompressorCalcSteps;
                double dp = (this.pressure - this.getThermoSystem().getPressure()) / (1.0 * (double)numbersteps);
                for (int i = 0; i < numbersteps; ++i) {
                    entropy = this.getThermoSystem().getEntropy();
                    hinn = this.getThermoSystem().getEnthalpy();
                    if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                        double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                        hinn = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
                        entropy = gergProps[8] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
                    }
                    this.getThermoSystem().setPressure(this.getThermoSystem().getPressure() + dp, this.pressureUnit);
                    thermoOps = new ThermodynamicOperations(this.getThermoSystem());
                    if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                        thermoOps.PSflashGERG2008(entropy);
                    } else {
                        double oleTemp = this.getThermoSystem().getTemperature();
                        thermoOps.PSflash(entropy);
                        if (Math.abs(this.getThermoSystem().getEntropy() - entropy) > 0.001) {
                            this.getThermoSystem().setTemperature(oleTemp);
                            thermoOps.TPflash();
                            this.getThermoSystem().init(2);
                            continue;
                        }
                    }
                    double newEnt = this.getThermoSystem().getEnthalpy();
                    if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                        double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                        newEnt = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
                    }
                    double hout = hinn + (newEnt - hinn) / this.polytropicEfficiency;
                    thermoOps.PHflash(hout, 0);
                    if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                        thermoOps.PHflashGERG2008(hout);
                    }
                    if (!this.propertyProfile.isActive()) continue;
                    this.propertyProfile.addFluid(this.thermoSystem.clone());
                }
            } else if (this.polytropicMethod.equals("schultz")) {
                double schultzX = this.thermoSystem.getTemperature() / this.thermoSystem.getVolume() * this.thermoSystem.getdVdTpn() - 1.0;
                double schultzY = -this.thermoSystem.getPressure() / this.thermoSystem.getVolume() * this.thermoSystem.getdVdPtn();
                this.thermoSystem.setPressure(this.getOutletPressure(), this.pressureUnit);
                thermoOps.PSflash(entropy);
                this.thermoSystem.initProperties();
                double densOutIsentropic = this.thermoSystem.getDensity("kg/m3");
                double enthalpyOutIsentropic = this.thermoSystem.getEnthalpy();
                if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                    thermoOps.PSflashGERG2008(entropy);
                    double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                    densOutIsentropic = this.getThermoSystem().getPhase(0).getDensity_GERG2008();
                    enthalpyOutIsentropic = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
                }
                double isenthalpicvolumeexponent = Math.log(this.getOutletPressure() / presinn) / Math.log(densOutIsentropic / densInn);
                double nV = (1.0 + schultzX) / (1.0 / isenthalpicvolumeexponent * (1.0 / this.polytropicEfficiency + schultzX) - schultzY * (1.0 / this.polytropicEfficiency - 1.0));
                double term = nV / (nV - 1.0);
                double term2 = 100000.0 * (this.getOutletPressure() / densOutIsentropic - presinn / densInn);
                double term3 = isenthalpicvolumeexponent / (isenthalpicvolumeexponent - 1.0);
                double CF = (enthalpyOutIsentropic - this.inletEnthalpy) / (term2 * term3);
                this.dH = term * CF * 100000.0 * presinn / densInn * (Math.pow(this.getOutletPressure() / presinn, 1.0 / term) - 1.0) / this.polytropicEfficiency;
                double hout = hinn + this.dH;
                thermoOps = new ThermodynamicOperations(this.getThermoSystem());
                thermoOps.PHflash(hout, 0);
                if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                    thermoOps.PHflashGERG2008(hout);
                }
            } else {
                this.thermoSystem.setPressure(this.getOutletPressure(), this.pressureUnit);
                thermoOps.PSflash(entropy);
                this.thermoSystem.initProperties();
                double densOutIsentropic = this.thermoSystem.getDensity("kg/m3");
                double enthalpyOutIsentropic = this.thermoSystem.getEnthalpy();
                if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                    thermoOps.PSflashGERG2008(entropy);
                    double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                    densOutIsentropic = this.getThermoSystem().getPhase(0).getDensity_GERG2008();
                    enthalpyOutIsentropic = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
                }
                double isenthalpicvolumeexponent = Math.log(this.getOutletPressure() / presinn) / Math.log(densOutIsentropic / densInn);
                double term = isenthalpicvolumeexponent / (isenthalpicvolumeexponent - 1.0) * this.polytropicEfficiency;
                double term2 = 100000.0 * (this.getOutletPressure() / densOutIsentropic - presinn / densInn);
                double CF = (enthalpyOutIsentropic - this.inletEnthalpy) / (term * term2);
                this.dH = term * CF * 100000.0 * presinn / densInn * (Math.pow(this.getOutletPressure() / presinn, 1.0 / term) - 1.0);
                double hout = hinn + this.dH;
                thermoOps = new ThermodynamicOperations(this.getThermoSystem());
                thermoOps.PHflash(hout, 0);
                if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                    thermoOps.PHflashGERG2008(hout);
                }
            }
        } else {
            this.getThermoSystem().setPressure(this.pressure, this.pressureUnit);
            thermoOps = new ThermodynamicOperations(this.getThermoSystem());
            thermoOps.PSflash(entropy);
            if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                thermoOps.PSflashGERG2008(entropy);
            }
            double newEnt = this.getThermoSystem().getEnthalpy();
            if (!this.powerSet) {
                this.dH = (this.getThermoSystem().getEnthalpy() - hinn) / this.isentropicEfficiency;
                if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                    double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
                    newEnt = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
                    this.dH = (newEnt - hinn) / this.isentropicEfficiency;
                }
            }
            double hout = hinn + this.dH;
            this.isentropicEfficiency = (newEnt - hinn) / this.dH;
            this.dH = hout - hinn;
            thermoOps = new ThermodynamicOperations(this.getThermoSystem());
            thermoOps.PHflash(hout, 0);
            if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
                thermoOps.PHflashGERG2008(hout);
            }
        }
        if (this.getCompressorChart().isUseCompressorChart() && this.getAntiSurge().isActive()) {
            this.thermoSystem.setTotalNumberOfMoles(orginalMolarFLow);
            this.thermoSystem.init(3);
        }
        this.thermoSystem.initProperties();
        this.outStream.setThermoSystem(this.getThermoSystem());
        this.outStream.setCalculationIdentifier(id);
        this.polytropicFluidHead = this.getPower() / this.getThermoSystem().getFlowRate("kg/sec") / 1000.0 * this.getPolytropicEfficiency();
        this.polytropicHeadMeter = this.polytropicFluidHead * 1000.0 / 9.81;
        this.setCalculationIdentifier(id);
    }

    public void generateCompressorCurves() {
        double flowRef = this.getThermoSystem().getFlowRate("m3/hr");
        double factor = flowRef / 4000.0;
        double[] chartConditions = new double[]{0.3, 1.0, 1.0, 1.0};
        double[] speed = new double[]{12913.0, 12298.0, 11683.0, 11098.0, 10453.0, 9224.0, 8609.0, 8200.0};
        double[][] flow = new double[][]{{2789.1285, 3174.0375, 3689.2288, 4179.4503, 4570.2768, 4954.7728, 5246.0329, 5661.0331}, {2571.1753, 2943.7254, 3440.2675, 3837.4448, 4253.0898, 4668.6643, 4997.1926, 5387.4952}, {2415.3793, 2763.0706, 3141.7095, 3594.7436, 4047.6467, 4494.1889, 4853.7353, 5138.7858}, {2247.2043, 2799.7342, 3178.3428, 3656.1551, 4102.778, 4394.1591, 4648.3224, 4840.4998}, {2072.8397, 2463.9483, 2836.4078, 3202.5266, 3599.6333, 3978.0203, 4257.0022, 4517.345}, {1835.9552, 2208.455, 2618.1322, 2940.8034, 3244.7852, 3530.1279, 3753.3738, 3895.9746}, {1711.3386, 1965.8848, 2356.9431, 2685.9247, 3008.5154, 3337.2855, 3591.5092}, {1636.5807, 2002.8708, 2338.0319, 2642.1245, 2896.4894, 3113.6264, 3274.8764, 3411.2977}};
        for (int i = 0; i < flow.length; ++i) {
            int j = 0;
            while (j < flow[i].length) {
                double[] dArray = flow[i];
                int n = j++;
                dArray[n] = dArray[n] * factor;
            }
        }
        double[][] head = new double[][]{{80.0375, 78.8934, 76.2142, 71.8678, 67.0062, 60.6061, 53.0499, 39.728}, {72.2122, 71.8369, 68.9009, 65.8341, 60.7167, 54.702, 47.2749, 35.7471}, {65.1576, 64.5253, 62.6118, 59.1619, 54.0455, 47.0059, 39.195, 31.6387}, {58.6154, 56.9627, 54.6647, 50.4462, 44.4322, 38.4144, 32.9084, 28.8109}, {52.3295, 51.0573, 49.5283, 46.3326, 42.3685, 37.2502, 31.4884, 25.598}, {40.6578, 39.6416, 37.6008, 34.6603, 30.9503, 27.1116, 23.2713, 20.4546}, {35.2705, 34.6359, 32.7228, 31.0645, 27.0985, 22.7482, 18.0113}, {32.192, 31.1756, 29.1329, 26.833, 23.8909, 21.3324, 18.7726, 16.3403}};
        for (int i = 0; i < head.length; ++i) {
            int j = 0;
            while (j < head[i].length) {
                double[] dArray = head[i];
                int n = j++;
                dArray[n] = dArray[n] * (factor / 5.0);
            }
        }
        double[][] polyEff = new double[][]{{77.2452238409573, 79.4154186459363, 80.737960012489, 80.5229826589649, 79.2210931638144, 75.4719133864634, 69.6034181197298, 58.7322388482707}, {77.0107837113504, 79.3069974136389, 80.8941189021135, 80.7190194665918, 79.5313242980328, 75.5912622896367, 69.6846136362097, 60.0043057990909}, {77.0043065299874, 79.1690958847856, 80.8038169975675, 80.6543975614197, 78.8532389102705, 73.6664774270613, 66.2735600426727, 57.671664571658}, {77.0716623789093, 80.4629750233093, 81.1390811169072, 79.6374242667478, 75.380928428817, 69.5332969549779, 63.7997587622339, 58.8120614497758}, {76.9705872525642, 79.8335492585324, 80.9468133671171, 80.5806471927835, 78.0462158225426, 73.0403707523258, 66.5572286338589, 59.8624822515064}, {77.5063036680357, 80.2056198362559, 81.0339108025933, 79.6085962687939, 76.3814534404405, 70.8027503005902, 64.6437367160571, 60.5299349982342}, {77.8175271586685, 80.065165942218, 81.0631362122632, 79.8955051771299, 76.1983240929369, 69.289982774309, 60.8567149372229}, {78.0924334304045, 80.9353551568667, 80.7904437766234, 78.8639325223295, 75.2170936751143, 70.3105081673411, 65.5507568533569, 61.0391468300337}};
        this.getCompressorChart().setCurves(chartConditions, speed, flow, head, polyEff);
        this.getCompressorChart().setHeadUnit("kJ/kg");
    }

    @Override
    public void displayResult() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from TPflash");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        this.getThermoSystem().initPhysicalProperties();
        Object[][] table = new String[50][5];
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test = new FieldPosition(0);
        for (int i = 0; i < this.getThermoSystem().getNumberOfPhases(); ++i) {
            for (int j = 0; j < this.getThermoSystem().getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + 1][0] = this.getThermoSystem().getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(this.getThermoSystem().getPhases()[i].getComponents()[j].getx(), buf, test).toString();
                table[j + 1][4] = "[-]";
            }
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(this.getThermoSystem().getPhases()[i].getPhysicalProperties().getDensity(), buf, test).toString();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 2][4] = "[kg/m^3]";
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 3][0] = "PhaseFraction";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(this.getThermoSystem().getPhases()[i].getBeta(), buf, test).toString();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 4][0] = "MolarMass";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 4][i + 1] = nf.format(this.getThermoSystem().getPhases()[i].getMolarMass() * 1000.0, buf, test).toString();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 4][4] = "[kg/kmol]";
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 5][0] = "Cp";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 5][i + 1] = nf.format(this.getThermoSystem().getPhases()[i].getCp() / this.getThermoSystem().getPhases()[i].getNumberOfMolesInPhase() * 1.0 / this.getThermoSystem().getPhases()[i].getMolarMass() * 1000.0, buf, test).toString();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 5][4] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 7][0] = "Viscosity";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 7][i + 1] = nf.format(this.getThermoSystem().getPhases()[i].getPhysicalProperties().getViscosity(), buf, test).toString();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 7][4] = "[kg/m*sec]";
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 8][0] = "Conductivity";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 8][i + 1] = nf.format(this.getThermoSystem().getPhases()[i].getPhysicalProperties().getConductivity(), buf, test).toString();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 8][4] = "[W/m*K]";
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 10][0] = "Pressure";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 10][i + 1] = Double.toString(this.getThermoSystem().getPhases()[i].getPressure());
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 10][4] = "[bar]";
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 11][0] = "Temperature";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 11][i + 1] = Double.toString(this.getThermoSystem().getPhases()[i].getTemperature());
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 11][4] = "[K]";
            Double.toString(this.getThermoSystem().getPhases()[i].getTemperature());
            buf = new StringBuffer();
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 13][0] = "Stream";
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 13][i + 1] = this.name;
            table[this.getThermoSystem().getPhases()[0].getNumberOfComponents() + 13][4] = "-";
        }
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public String[][] getResultTable() {
        return this.thermoSystem.getResultTable();
    }

    public double getTotalWork() {
        double multi = 1.0;
        if (this.getAntiSurge().isActive()) {
            multi = 1.0 + this.getAntiSurge().getCurrentSurgeFraction();
        }
        if (this.useGERG2008 && this.inStream.getThermoSystem().getNumberOfPhases() == 1) {
            double[] gergProps = this.getThermoSystem().getPhase(0).getProperties_GERG2008();
            double enth = gergProps[7] * this.getThermoSystem().getPhase(0).getNumberOfMolesInPhase();
            return (enth - this.inletEnthalpy) * multi;
        }
        return multi * (this.getThermoSystem().getEnthalpy() - this.inletEnthalpy);
    }

    @Override
    public double getIsentropicEfficiency() {
        return this.isentropicEfficiency;
    }

    @Override
    public void setIsentropicEfficiency(double isentropicEfficiency) {
        this.isentropicEfficiency = isentropicEfficiency;
    }

    public boolean usePolytropicCalc() {
        return this.usePolytropicCalc;
    }

    public void setUsePolytropicCalc(boolean usePolytropicCalc) {
        this.usePolytropicCalc = usePolytropicCalc;
    }

    @Override
    public double getPolytropicEfficiency() {
        return this.polytropicEfficiency;
    }

    @Override
    public void setPolytropicEfficiency(double polytropicEfficiency) {
        this.polytropicEfficiency = polytropicEfficiency;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    public CompressorChartInterface getCompressorChart() {
        return this.compressorChart;
    }

    public void setCompressorChart(CompressorChart compressorChart) {
        this.compressorChart = compressorChart;
    }

    @Override
    public AntiSurge getAntiSurge() {
        return this.antiSurge;
    }

    public boolean isSurge(double flow, double head) {
        this.getAntiSurge().setSurge(this.getCompressorChart().getSurgeCurve().isSurge(flow, head));
        return this.getAntiSurge().isSurge();
    }

    public boolean isStoneWall(double flow, double head) {
        return this.getCompressorChart().getStoneWallCurve().isStoneWall(flow, head);
    }

    public void setAntiSurge(AntiSurge antiSurge) {
        this.antiSurge = antiSurge;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public double getPolytropicHead(String unit) {
        if (unit.equals("kJ/kg")) {
            return this.polytropicFluidHead;
        }
        if (unit.equals("meter")) {
            return this.polytropicHeadMeter;
        }
        return this.polytropicHead;
    }

    public double getPolytropicHead() {
        return this.polytropicHead;
    }

    public double getPolytropicFluidHead() {
        return this.polytropicFluidHead;
    }

    public double getPolytropicExponent() {
        return this.polytropicExponent;
    }

    public double getPolytropicHeadMeter() {
        return this.polytropicHeadMeter;
    }

    public void setPolytropicHeadMeter(double polytropicHeadMeter) {
        this.polytropicHeadMeter = polytropicHeadMeter;
    }

    public double getOutTemperature() {
        if (this.useOutTemperature) {
            return this.outTemperature;
        }
        return this.getThermoSystem().getTemperature();
    }

    public void setOutTemperature(double outTemperature) {
        this.useOutTemperature = true;
        this.outTemperature = outTemperature;
    }

    public void useOutTemperature(boolean useOutTemperature) {
        this.useOutTemperature = useOutTemperature;
    }

    public int getNumberOfCompressorCalcSteps() {
        return this.numberOfCompressorCalcSteps;
    }

    public void setNumberOfCompressorCalcSteps(int numberOfCompressorCalcSteps) {
        this.numberOfCompressorCalcSteps = numberOfCompressorCalcSteps;
    }

    public boolean isUseRigorousPolytropicMethod() {
        return this.useRigorousPolytropicMethod;
    }

    public void setUseRigorousPolytropicMethod(boolean useRigorousPolytropicMethod) {
        this.useRigorousPolytropicMethod = useRigorousPolytropicMethod;
    }

    @Override
    public void setPressure(double pressure) {
        this.setOutletPressure(pressure);
    }

    public void setPressure(double pressure, String unit) {
        this.setOutletPressure(pressure);
        this.pressureUnit = unit;
    }

    @Override
    public double getEntropyProduction(String unit) {
        return this.outStream.getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        return this.outStream.getThermoSystem().getExergy(surroundingTemperature, unit) - this.inStream.getThermoSystem().getExergy(surroundingTemperature, unit);
    }

    public String getPolytropicMethod() {
        return this.polytropicMethod;
    }

    public void setPolytropicMethod(String polytropicMethod) {
        this.polytropicMethod = polytropicMethod;
    }

    public boolean isUseGERG2008() {
        return this.useGERG2008;
    }

    public void setUseGERG2008(boolean useGERG2008) {
        this.useGERG2008 = useGERG2008;
    }

    public CompressorPropertyProfile getPropertyProfile() {
        return this.propertyProfile;
    }

    public void setPropertyProfile(CompressorPropertyProfile propertyProfile) {
        this.propertyProfile = propertyProfile;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.antiSurge, this.compressorChart, this.dH, this.inletEnthalpy, this.inStream, this.isentropicEfficiency, this.numberOfCompressorCalcSteps, this.outStream, this.outTemperature, this.polytropicEfficiency, this.polytropicExponent, this.polytropicFluidHead, this.polytropicHead, this.polytropicHeadMeter, this.polytropicMethod, this.powerSet, this.pressure, this.pressureUnit, this.speed, this.thermoSystem, this.useGERG2008, this.useOutTemperature, this.usePolytropicCalc, this.useRigorousPolytropicMethod);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Compressor other = (Compressor)obj;
        return Objects.equals(this.antiSurge, other.antiSurge) && Objects.equals(this.compressorChart, other.compressorChart) && Double.doubleToLongBits(this.dH) == Double.doubleToLongBits(other.dH) && Double.doubleToLongBits(this.inletEnthalpy) == Double.doubleToLongBits(other.inletEnthalpy) && Objects.equals(this.inStream, other.inStream) && Double.doubleToLongBits(this.isentropicEfficiency) == Double.doubleToLongBits(other.isentropicEfficiency) && this.numberOfCompressorCalcSteps == other.numberOfCompressorCalcSteps && Objects.equals(this.outStream, other.outStream) && Double.doubleToLongBits(this.outTemperature) == Double.doubleToLongBits(other.outTemperature) && Double.doubleToLongBits(this.polytropicEfficiency) == Double.doubleToLongBits(other.polytropicEfficiency) && Double.doubleToLongBits(this.polytropicExponent) == Double.doubleToLongBits(other.polytropicExponent) && Double.doubleToLongBits(this.polytropicFluidHead) == Double.doubleToLongBits(other.polytropicFluidHead) && Double.doubleToLongBits(this.polytropicHead) == Double.doubleToLongBits(other.polytropicHead) && Double.doubleToLongBits(this.polytropicHeadMeter) == Double.doubleToLongBits(other.polytropicHeadMeter) && Objects.equals(this.polytropicMethod, other.polytropicMethod) && this.powerSet == other.powerSet && Double.doubleToLongBits(this.pressure) == Double.doubleToLongBits(other.pressure) && Objects.equals(this.pressureUnit, other.pressureUnit) && this.speed == other.speed && Objects.equals(this.thermoSystem, other.thermoSystem) && this.useGERG2008 == other.useGERG2008 && this.useOutTemperature == other.useOutTemperature && this.usePolytropicCalc == other.usePolytropicCalc && this.useRigorousPolytropicMethod == other.useRigorousPolytropicMethod;
    }
}

