/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.absorber;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.processSimulation.processEquipment.absorber.SimpleAbsorber;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WaterStripperColumn
extends SimpleAbsorber {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(WaterStripperColumn.class);
    protected ArrayList<StreamInterface> streams = new ArrayList(0);
    protected double pressure = 0.0;
    protected int numberOfInputStreams = 0;
    protected StreamInterface mixedStream;
    protected StreamInterface gasInStream;
    protected StreamInterface solventInStream;
    private StreamInterface gasOutStream;
    private StreamInterface solventOutStream;
    protected String name = "mixer";
    protected StreamInterface outStream;
    private double waterDewPointTemperature = 263.15;
    private double dewPressure = 70.0;
    private double kwater = 1.0E-4;
    int solventStreamNumber = 0;

    @Deprecated
    public WaterStripperColumn() {
    }

    public WaterStripperColumn(String name) {
        super(name);
    }

    @Override
    public void addStream(StreamInterface newStream) {
        this.streams.add(newStream);
        if (this.numberOfInputStreams == 0) {
            this.mixedStream = (Stream)this.streams.get(0).clone();
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixedStream.getThermoSystem().init(3);
        }
        ++this.numberOfInputStreams;
    }

    public void addGasInStream(StreamInterface newStream) {
        this.gasInStream = (Stream)newStream;
        this.gasOutStream = (Stream)newStream.clone();
        this.addStream(newStream);
    }

    public void addSolventInStream(StreamInterface newStream) {
        this.solventInStream = (Stream)newStream;
        this.solventOutStream = (Stream)newStream.clone();
        this.addStream(newStream);
        this.solventStreamNumber = this.streams.size() - 1;
    }

    public void replaceSolventInStream(StreamInterface newStream) {
        this.solventInStream = (Stream)newStream;
        this.streams.set(this.solventStreamNumber, this.solventInStream);
    }

    @Override
    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public void mixStream() {
        String compName = new String();
        for (int k = 1; k < this.streams.size(); ++k) {
            for (int i = 0; i < this.streams.get(k).getThermoSystem().getPhases()[0].getNumberOfComponents(); ++i) {
                boolean gotComponent = false;
                String componentName = this.streams.get(k).getThermoSystem().getPhases()[0].getComponents()[i].getName();
                double moles = this.streams.get(k).getThermoSystem().getPhases()[0].getComponents()[i].getNumberOfmoles();
                for (int p = 0; p < this.mixedStream.getThermoSystem().getPhases()[0].getNumberOfComponents(); ++p) {
                    if (!this.mixedStream.getThermoSystem().getPhases()[0].getComponents()[p].getName().equals(componentName)) continue;
                    gotComponent = true;
                    compName = this.streams.get(0).getThermoSystem().getPhases()[0].getComponents()[p].getComponentName();
                }
                if (gotComponent) {
                    this.mixedStream.getThermoSystem().addComponent(compName, moles);
                    continue;
                }
                this.mixedStream.getThermoSystem().addComponent(compName, moles);
            }
        }
        this.mixedStream.getThermoSystem().init_x_y();
        this.mixedStream.getThermoSystem().initBeta();
        this.mixedStream.getThermoSystem().init(2);
    }

    public double guessTemperature() {
        double gtemp = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            gtemp += this.streams.get(k).getThermoSystem().getTemperature() * this.streams.get(k).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
        }
        return gtemp;
    }

    public double calcMixStreamEnthalpy() {
        double enthalpy = 0.0;
        for (int k = 0; k < this.streams.size(); ++k) {
            this.streams.get(k).getThermoSystem().init(3);
            enthalpy += this.streams.get(k).getThermoSystem().getEnthalpy();
        }
        return enthalpy;
    }

    @Override
    public StreamInterface getOutStream() {
        return this.mixedStream;
    }

    public StreamInterface getInStream() {
        return this.gasInStream;
    }

    @Override
    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    @Override
    public StreamInterface getLiquidOutStream() {
        return this.solventOutStream;
    }

    @Override
    public StreamInterface getSolventInStream() {
        return this.solventInStream;
    }

    public double calcEa() {
        double A = this.mixedStream.getThermoSystem().getPhase(1).getNumberOfMolesInPhase() / this.mixedStream.getThermoSystem().getPhase(0).getNumberOfMolesInPhase() / this.kwater;
        this.absorptionEfficiency = (Math.pow(A, this.getNumberOfTheoreticalStages() + 1.0) - A) / (Math.pow(A, this.getNumberOfTheoreticalStages() + 1.0) - 1.0);
        return this.absorptionEfficiency;
    }

    public double calcX0() {
        return 0.0;
    }

    public double calcNumberOfTheoreticalStages() {
        this.setNumberOfTheoreticalStages(this.getStageEfficiency() * (double)this.getNumberOfStages());
        return this.getNumberOfTheoreticalStages();
    }

    public double calcNTU(double y0, double y1, double yb, double ymix) {
        return Math.log((yb - ymix) / (y1 - y0));
    }

    @Override
    public void run(UUID id) {
        try {
            double x2 = this.getSolventInStream().getFluid().getPhase(0).getComponent("water").getz();
            double x0 = 0.0;
            double absorptionEffiency = 0.0;
            this.mixedStream.setThermoSystem(this.streams.get(0).getThermoSystem().clone());
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            double enthalpy = this.calcMixStreamEnthalpy();
            this.mixedStream.getThermoSystem().setTemperature(this.guessTemperature());
            ThermodynamicOperations testOps = new ThermodynamicOperations(this.mixedStream.getThermoSystem());
            testOps.TPflash();
            testOps.PHflash(enthalpy, 0);
            if (this.mixedStream.getThermoSystem().getNumberOfPhases() == 1) {
                SystemInterface tempSystem;
                if (this.mixedStream.getThermoSystem().getPhase(0).getPhaseTypeName().equals("aqueous")) {
                    tempSystem = this.mixedStream.getThermoSystem().clone();
                    this.gasOutStream.setEmptyThermoSystem(tempSystem);
                    this.gasOutStream.run(id);
                    this.solventOutStream.setThermoSystem(tempSystem);
                    this.solventOutStream.run(id);
                }
                if (this.mixedStream.getThermoSystem().getPhase(0).getPhaseTypeName().equals("gas")) {
                    tempSystem = this.mixedStream.getThermoSystem().clone();
                    this.solventOutStream.setEmptyThermoSystem(tempSystem);
                    this.solventOutStream.run(id);
                    this.gasOutStream.setThermoSystem(tempSystem);
                    this.gasOutStream.run(id);
                }
            } else {
                this.kwater = this.mixedStream.getThermoSystem().getPhase(0).getComponent("water").getx() / this.mixedStream.getThermoSystem().getPhase(1).getComponent("water").getx();
                double Ntheoretical = this.calcNumberOfTheoreticalStages();
                absorptionEffiency = this.calcEa();
                x0 = this.calcX0();
                double revA = 1.0 / absorptionEffiency;
                double x1 = x2 - (Math.pow(revA, Ntheoretical + 1.0) - revA) / (Math.pow(revA, Ntheoretical + 1.0) - 1.0) * (x2 - x0);
                double xMean = this.mixedStream.getThermoSystem().getPhase(1).getComponent("water").getx();
                double molesWaterToMove = (xMean - x1) * this.mixedStream.getThermoSystem().getPhase(1).getNumberOfMolesInPhase();
                StreamInterface stream = this.mixedStream.clone();
                stream.setName("test");
                stream.getThermoSystem().addComponent("water", molesWaterToMove, 0);
                stream.getThermoSystem().addComponent("water", -molesWaterToMove, 1);
                stream.getThermoSystem().initBeta();
                stream.getThermoSystem().init_x_y();
                stream.getThermoSystem().init(2);
                this.mixedStream = stream;
                SystemInterface tempSystem = this.mixedStream.getThermoSystem().clone();
                SystemInterface gasTemp = tempSystem.phaseToSystem(tempSystem.getPhases()[0]);
                gasTemp.init(2);
                this.gasOutStream.setThermoSystem(gasTemp);
                this.gasOutStream.setCalculationIdentifier(id);
                tempSystem = this.mixedStream.getThermoSystem().clone();
                SystemInterface liqTemp = tempSystem.phaseToSystem(tempSystem.getPhases()[1]);
                liqTemp.init(2);
                this.solventOutStream.setThermoSystem(liqTemp);
                this.solventOutStream.run(id);
                this.mixedStream.setCalculationIdentifier(id);
            }
            this.setCalculationIdentifier(id);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    @Override
    public void displayResult() {
        SystemInterface thermoSystem = this.mixedStream.getThermoSystem();
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from TPflash");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        thermoSystem.initPhysicalProperties();
        Object[][] table = new String[50][5];
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test = new FieldPosition(0);
        for (int i = 0; i < thermoSystem.getNumberOfPhases(); ++i) {
            for (int j = 0; j < thermoSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + 1][0] = thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(thermoSystem.getPhases()[i].getComponents()[j].getx(), buf, test).toString();
                table[j + 1][4] = "[-]";
            }
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getDensity(), buf, test).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 2][4] = "[kg/m^3]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "PhaseFraction";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(thermoSystem.getPhases()[i].getBeta(), buf, test).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][0] = "MolarMass";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][i + 1] = nf.format(thermoSystem.getPhases()[i].getMolarMass() * 1000.0, buf, test).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 4][4] = "[kg/kmol]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][0] = "Cp";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][i + 1] = nf.format(thermoSystem.getPhases()[i].getCp() / (thermoSystem.getPhases()[i].getNumberOfMolesInPhase() * thermoSystem.getPhases()[i].getMolarMass() * 1000.0), buf, test).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 5][4] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][0] = "Viscosity";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getViscosity(), buf, test).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 7][4] = "[kg/m*sec]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][0] = "Conductivity";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][i + 1] = nf.format(thermoSystem.getPhases()[i].getPhysicalProperties().getConductivity(), buf, test).toString();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 8][4] = "[W/m*K]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Pressure";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][i + 1] = Double.toString(thermoSystem.getPhases()[i].getPressure());
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[bar]";
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Temperature";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][i + 1] = Double.toString(thermoSystem.getPhases()[i].getTemperature());
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[K]";
            Double.toString(thermoSystem.getPhases()[i].getTemperature());
            buf = new StringBuffer();
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][0] = "Stream";
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][i + 1] = this.name;
            table[thermoSystem.getPhases()[0].getNumberOfComponents() + 13][4] = "-";
        }
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    public double getWaterDewPointTemperature() {
        return this.waterDewPointTemperature;
    }

    public void setWaterDewPointTemperature(double waterDewPointTemperature, double dewPressure) {
        this.waterDewPointTemperature = waterDewPointTemperature;
        this.dewPressure = dewPressure;
    }

    public void setGasOutStream(StreamInterface gasOutStream) {
        this.gasOutStream = gasOutStream;
    }

    public StreamInterface getSolventOutStream() {
        return this.solventOutStream;
    }

    public void setSolventOutStream(StreamInterface solventOutStream) {
        this.solventOutStream = solventOutStream;
    }
}

