/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice;

import neqsim.processSimulation.measurementDevice.MeasurementDeviceBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;

public class VolumeFlowTransmitter
extends MeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface stream = null;
    private int measuredPhaseNumber = 0;

    public VolumeFlowTransmitter() {
    }

    public VolumeFlowTransmitter(StreamInterface stream) {
        this.stream = stream;
        this.name = "volume flow rate";
        this.unit = "m^3/hr";
    }

    @Override
    public void displayResult() {
        System.out.println("measured volume " + Double.toString(this.getMeasuredValue()) + " " + this.unit);
    }

    @Override
    public double getMeasuredValue() {
        this.stream.getThermoSystem().initPhysicalProperties();
        if (this.unit.equals("kg/hr")) {
            return this.stream.getFlowRate(this.unit);
        }
        if (this.unit.equals("m^3/hr")) {
            return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getMolarMass() / this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getPhysicalProperties().getDensity() * 3600.0;
        }
        if (this.unit.equals("Nm^3/day")) {
            return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * 8.3144621 * 273.15 / 101325.0 * 3600.0 * 24.0;
        }
        if (this.unit.equals("Sm^3/day")) {
            return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * 8.3144621 * 288.15 / 101325.0 * 3600.0 * 24.0;
        }
        return this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getNumberOfMolesInPhase() * this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getMolarMass() / this.stream.getThermoSystem().getPhase(this.measuredPhaseNumber).getPhysicalProperties().getDensity() * 3600.0;
    }

    public int getMeasuredPhaseNumber() {
        return this.measuredPhaseNumber;
    }

    public void setMeasuredPhaseNumber(int measuredPhase) {
        this.measuredPhaseNumber = measuredPhase;
    }
}

