/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompInterfaceTension;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompInterfaceTension.InfluenceParamGTFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestInfluenceParamGTFunction {
    static Logger logger = LogManager.getLogger(TestInfluenceParamGTFunction.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        boolean includePureCompData = true;
        double[] guess = new double[]{-0.02864071915872797, -1.85760887578596, 0.520588, -0.1386439759, 1.1216308727071944};
        try (ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentsurfacetension2 WHERE ComponentName IN ('n-pentane','ethane','methane', 'propane','CO2', 'c-hexane','M-cy-C5', 'n-pentane','n-hexane', 'n-nonane','nC10')");){
            while (dataSet.next() && includePureCompData) {
                InfluenceParamGTFunction function = new InfluenceParamGTFunction();
                function.setInitialGuess(guess);
                SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(280.0, 10.1);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                testSystem.createDatabase(true);
                testSystem.setMixingRule(7);
                testSystem.init(0);
                testSystem.setNumberOfPhases(2);
                testSystem.getInterphaseProperties().setInterfacialTensionModel(2);
                testSystem.init(3);
                double[] sample1 = new double[]{testSystem.getTemperature(), testSystem.getPressure()};
                double[] standardDeviation1 = new double[]{0.1, 0.1};
                double surfTens = Double.parseDouble(dataSet.getString("SurfaceTension"));
                SampleValue sample = new SampleValue(surfTens, Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
                Double.toString(sample.getFunction().calcValue(new double[0]));
                sample.setReference(testSystem.getPhase(0).getComponent(0).getComponentName());
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

