/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertySystem;

import neqsim.physicalProperties.mixingRule.PhysicalPropertyMixingRuleInterface;
import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.conductivity.PFCTConductivityMethodMod86;
import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.diffusivity.CorrespondingStatesDiffusivity;
import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity.FrictionTheoryViscosityMethod;
import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity.LBCViscosityMethod;
import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity.PFCTViscosityMethodHeavyOil;
import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.viscosity.PFCTViscosityMethodMod86;
import neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.conductivity.ChungConductivityMethod;
import neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.diffusivity.WilkeLeeDiffusivity;
import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.conductivity.Conductivity;
import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.density.Costald;
import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.density.Density;
import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.diffusivity.AmineDiffusivity;
import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.diffusivity.SiddiqiLucasMethod;
import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.viscosity.Viscosity;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.ConductivityInterface;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DensityInterface;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DiffusivityInterface;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.ViscosityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PhysicalProperties
implements PhysicalPropertiesInterface,
ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhysicalProperties.class);
    public PhaseInterface phase;
    protected int binaryDiffusionCoefficientMethod;
    protected int multicomponentDiffusionMethod;
    private PhysicalPropertyMixingRuleInterface mixingRule = null;
    public ConductivityInterface conductivityCalc;
    public ViscosityInterface viscosityCalc;
    public DiffusivityInterface diffusivityCalc;
    public DensityInterface densityCalc;
    public double kinematicViscosity = 0.0;
    public double density = 0.0;
    public double viscosity = 0.0;
    public double conductivity = 0.0;
    private double[] waxViscosityParameter = new double[]{37.82, 83.96, 8559000.0};

    public PhysicalProperties() {
    }

    public PhysicalProperties(PhaseInterface phase) {
        this.phase = phase;
    }

    public PhysicalProperties(PhaseInterface phase, int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        this.phase = phase;
        this.binaryDiffusionCoefficientMethod = binaryDiffusionCoefficientMethod;
        this.multicomponentDiffusionMethod = multicomponentDiffusionMethod;
    }

    @Override
    public PhysicalProperties clone() {
        PhysicalProperties properties = null;
        try {
            properties = (PhysicalProperties)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        properties.densityCalc = this.densityCalc.clone();
        properties.diffusivityCalc = this.diffusivityCalc.clone();
        properties.viscosityCalc = this.viscosityCalc.clone();
        properties.conductivityCalc = this.conductivityCalc.clone();
        if (this.mixingRule != null) {
            properties.mixingRule = this.mixingRule.clone();
        }
        return properties;
    }

    @Override
    public PhaseInterface getPhase() {
        return this.phase;
    }

    @Override
    public PhysicalPropertyMixingRuleInterface getMixingRule() {
        return this.mixingRule;
    }

    @Override
    public void setMixingRule(PhysicalPropertyMixingRuleInterface mixingRule) {
        this.mixingRule = mixingRule;
    }

    @Override
    public void setMixingRuleNull() {
        this.setMixingRule(null);
    }

    @Override
    public ViscosityInterface getViscosityModel() {
        return this.viscosityCalc;
    }

    @Override
    public void setDensityModel(String model) {
        if ("Peneloux volume shift".equals(model)) {
            this.densityCalc = new Density(this);
        } else if ("Costald".equals(model)) {
            this.densityCalc = new Costald(this);
        }
    }

    @Override
    public void setConductivityModel(String model) {
        this.conductivityCalc = "PFCT".equals(model) ? new PFCTConductivityMethodMod86(this) : ("polynom".equals(model) ? new Conductivity(this) : ("Chung".equals(model) ? new ChungConductivityMethod(this) : new PFCTConductivityMethodMod86(this)));
    }

    @Override
    public void setViscosityModel(String model) {
        if ("polynom".equals(model)) {
            this.viscosityCalc = new Viscosity(this);
        } else if ("friction theory".equals(model)) {
            this.viscosityCalc = new FrictionTheoryViscosityMethod(this);
        } else if ("LBC".equals(model)) {
            this.viscosityCalc = new LBCViscosityMethod(this);
        } else if ("PFCT".equals(model)) {
            this.viscosityCalc = new PFCTViscosityMethodMod86(this);
        } else if ("PFCT-Heavy-Oil".equals(model)) {
            this.viscosityCalc = new PFCTViscosityMethodHeavyOil(this);
        }
    }

    public void setDiffusionCoefficientModel(String model) {
        if ("CSP".equals(model)) {
            this.diffusivityCalc = new CorrespondingStatesDiffusivity(this);
        } else if ("Wilke Lee".equals(model)) {
            this.diffusivityCalc = new WilkeLeeDiffusivity(this);
        } else if ("Siddiqi Lucas".equals(model)) {
            this.diffusivityCalc = new SiddiqiLucasMethod(this);
        } else if ("Alkanol amine".equals(model)) {
            this.diffusivityCalc = new AmineDiffusivity(this);
        }
    }

    @Override
    public ConductivityInterface getConductivityModel() {
        return this.conductivityCalc;
    }

    @Override
    public void setBinaryDiffusionCoefficientMethod(int i) {
        this.binaryDiffusionCoefficientMethod = i;
    }

    @Override
    public void setMulticomponentDiffusionMethod(int i) {
        this.multicomponentDiffusionMethod = i;
    }

    public double calcKinematicViscosity() {
        this.kinematicViscosity = this.viscosity / this.phase.getDensity();
        return this.kinematicViscosity;
    }

    public void setPhases() {
        this.conductivityCalc.setPhase(this);
        this.densityCalc.setPhase(this);
        this.viscosityCalc.setPhase(this);
        this.diffusivityCalc.setPhase(this);
    }

    @Override
    public void setPhase(PhaseInterface phase) {
        this.phase = phase;
        this.setPhases();
    }

    @Override
    public void init(PhaseInterface phase) {
        this.phase = phase;
        this.setPhases();
        try {
            this.density = this.densityCalc.calcDensity();
            this.viscosity = this.viscosityCalc.calcViscosity();
            this.kinematicViscosity = this.calcKinematicViscosity();
            this.diffusivityCalc.calcDiffusionCoefficients(this.binaryDiffusionCoefficientMethod, this.multicomponentDiffusionMethod);
            this.conductivity = this.conductivityCalc.calcConductivity();
        }
        catch (Exception ex) {
            phase.resetPhysicalProperties();
            phase.initPhysicalProperties();
        }
    }

    @Override
    public void init(PhaseInterface phase, String type) {
        if (type.equals("density")) {
            this.density = this.densityCalc.calcDensity();
        } else if (type.equals("viscosity")) {
            this.viscosity = this.viscosityCalc.calcViscosity();
        } else if (type.equals("conductivity")) {
            this.conductivity = this.conductivityCalc.calcConductivity();
        } else {
            this.init(phase);
        }
    }

    @Override
    public double getViscosityOfWaxyOil(double waxVolumeFraction, double shareRate) {
        return this.viscosity * (Math.exp(this.waxViscosityParameter[0] * waxVolumeFraction) + this.waxViscosityParameter[1] * waxVolumeFraction / Math.sqrt(shareRate) + this.waxViscosityParameter[2] * Math.pow(waxVolumeFraction, 4.0) / shareRate);
    }

    @Override
    public double getViscosity() {
        if (this.viscosity < 0.0) {
            return 1.0E-5;
        }
        return this.viscosity;
    }

    @Override
    public double getPureComponentViscosity(int i) {
        return this.viscosityCalc.getPureComponentViscosity(i);
    }

    @Override
    public double getConductivity() {
        if (this.conductivity < 0.0) {
            return 1.0E-5;
        }
        return this.conductivity;
    }

    @Override
    public double getDensity() {
        return this.density;
    }

    @Override
    public double calcDensity() {
        return this.densityCalc.calcDensity();
    }

    @Override
    public double getKinematicViscosity() {
        if (this.kinematicViscosity < 0.0) {
            return 1.0E-5;
        }
        return this.kinematicViscosity;
    }

    @Override
    public double getDiffusionCoefficient(int i, int j) {
        return this.diffusivityCalc.getMaxwellStefanBinaryDiffusionCoefficient(i, j);
    }

    @Override
    public double getDiffusionCoefficient(String comp1, String comp2) {
        return this.diffusivityCalc.getMaxwellStefanBinaryDiffusionCoefficient(this.phase.getComponent(comp1).getComponentNumber(), this.phase.getComponent(comp2).getComponentNumber());
    }

    @Override
    public double getFickDiffusionCoefficient(int i, int j) {
        return this.diffusivityCalc.getFickBinaryDiffusionCoefficient(i, j);
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        this.init(this.phase);
        this.diffusivityCalc.calcEffectiveDiffusionCoefficients();
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.diffusivityCalc.getEffectiveDiffusionCoefficient(i);
    }

    @Override
    public double getEffectiveDiffusionCoefficient(String compName) {
        return this.diffusivityCalc.getEffectiveDiffusionCoefficient(this.phase.getComponent(compName).getComponentNumber());
    }

    @Override
    public double getEffectiveSchmidtNumber(int i) {
        return this.getKinematicViscosity() / this.diffusivityCalc.getEffectiveDiffusionCoefficient(i);
    }

    public double[] getWaxViscosityParameter() {
        return this.waxViscosityParameter;
    }

    public void setWaxViscosityParameter(double[] waxViscosityParameter) {
        this.waxViscosityParameter = waxViscosityParameter;
    }

    public void setWaxViscosityParameter(int paramNumber, double waxViscosityParameter) {
        this.waxViscosityParameter[paramNumber] = waxViscosityParameter;
    }
}

