/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.timeSeries;

import java.io.Serializable;
import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.thermo.system.SystemInterface;

public class TimeSeries
implements Serializable {
    private static final long serialVersionUID = 1000L;
    protected double[] timeSeries = new double[1];
    protected double[] outletMolarFlowRate;
    protected double[] outletMolarFlowRates;
    protected SystemInterface[] inletThermoSystem;
    protected SystemInterface[] thermoSystems;
    protected int numberOfTimeStepsInInterval;
    protected double[] times;
    protected double[] timeSteps;

    public void setTimes(double[] times) {
        this.timeSeries = times;
    }

    public void setInletThermoSystems(SystemInterface[] inletThermoSystem) {
        this.inletThermoSystem = inletThermoSystem;
    }

    public void setOutletMolarFlowRate(double[] outletMolarFlowRate) {
        this.outletMolarFlowRate = outletMolarFlowRate;
    }

    public double[] getOutletMolarFlowRates() {
        return this.outletMolarFlowRates;
    }

    public void setNumberOfTimeStepsInInterval(int numberOfTimeStepsInInterval) {
        this.numberOfTimeStepsInInterval = numberOfTimeStepsInInterval;
    }

    public void init(FlowSystemInterface flowSystem) {
        int p = 0;
        this.thermoSystems = new SystemInterface[(this.timeSeries.length - 1) * this.numberOfTimeStepsInInterval];
        this.outletMolarFlowRates = new double[(this.timeSeries.length - 1) * this.numberOfTimeStepsInInterval];
        this.timeSteps = new double[(this.timeSeries.length - 1) * this.numberOfTimeStepsInInterval];
        this.times = new double[(this.timeSeries.length - 1) * this.numberOfTimeStepsInInterval];
        double temp = 0.0;
        for (int k = 0; k < this.timeSeries.length - 1; ++k) {
            double stepLength = (this.timeSeries[k + 1] - this.timeSeries[k]) / (double)this.numberOfTimeStepsInInterval;
            for (int i = 0; i < this.numberOfTimeStepsInInterval; ++i) {
                this.timeSteps[p] = stepLength;
                this.times[p] = temp += stepLength;
                if (Double.isNaN(this.outletMolarFlowRate[0])) {
                    this.outletMolarFlowRates[p] = this.outletMolarFlowRate[k];
                }
                this.thermoSystems[p++] = this.inletThermoSystem[k].clone();
            }
        }
    }

    public SystemInterface[] getThermoSystem() {
        return this.thermoSystems;
    }

    public double[] getTimeStep() {
        return this.timeSteps;
    }

    public double[] getTime() {
        return this.times;
    }

    public double getTime(int i) {
        return this.times[i];
    }
}

