/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.FlowNodeVisualizationInterface;

public class FlowNodeVisualization
implements FlowNodeVisualizationInterface {
    public double[] temperature = new double[2];
    public double[] reynoldsNumber = new double[2];
    public double[] interfaceTemperature = new double[2];
    public double[] pressure = new double[2];
    public double[] velocity = new double[2];
    public double[] phaseFraction = new double[2];
    public double[] wallContactLength = new double[2];
    public double[][] bulkComposition;
    public double[][] interfaceComposition;
    public double[][] effectiveMassTransferCoefficient;
    public double[][] effectiveSchmidtNumber;
    public double[][] molarFlux;
    public double interphaseContactLength = 0.0;
    public double nodeCenter;
    public int numberOfComponents = 0;

    @Override
    public void setData(FlowNodeInterface node) {
        this.temperature[0] = node.getBulkSystem().getPhases()[0].getTemperature();
        this.temperature[1] = node.getBulkSystem().getPhases()[1].getTemperature();
        this.pressure[0] = node.getBulkSystem().getPhases()[0].getPressure();
        this.pressure[1] = node.getBulkSystem().getPhases()[1].getPressure();
        this.velocity[0] = node.getVelocity(0);
        this.velocity[1] = node.getVelocity(1);
        this.reynoldsNumber[0] = node.getReynoldsNumber(0);
        this.interphaseContactLength = node.getInterphaseContactLength(0);
        this.wallContactLength[0] = node.getWallContactLength(0);
        this.wallContactLength[1] = node.getWallContactLength(1);
        this.numberOfComponents = node.getBulkSystem().getPhases()[0].getNumberOfComponents();
        this.nodeCenter = node.getDistanceToCenterOfNode();
    }

    @Override
    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    @Override
    public double getInterphaseContactLength() {
        return this.interphaseContactLength;
    }

    @Override
    public double getWallContactLength(int phase) {
        return this.wallContactLength[phase];
    }

    @Override
    public double getPressure(int i) {
        return this.pressure[i];
    }

    @Override
    public double getReynoldsNumber(int i) {
        return this.reynoldsNumber[i];
    }

    @Override
    public double getDistanceToCenterOfNode() {
        return this.nodeCenter;
    }

    @Override
    public double getTemperature(int i) {
        return this.temperature[i];
    }

    @Override
    public double getInterfaceTemperature(int i) {
        return this.interfaceTemperature[i];
    }

    @Override
    public double getVelocity(int i) {
        return this.velocity[i];
    }

    @Override
    public double getBulkComposition(int i, int phase) {
        return this.bulkComposition[phase][i];
    }

    @Override
    public double getInterfaceComposition(int i, int phase) {
        return this.interfaceComposition[phase][i];
    }

    @Override
    public double getMolarFlux(int i, int phase) {
        return this.molarFlux[phase][i];
    }

    @Override
    public double getEffectiveMassTransferCoefficient(int i, int phase) {
        return this.effectiveMassTransferCoefficient[phase][i];
    }

    @Override
    public double getEffectiveSchmidtNumber(int i, int phase) {
        return this.effectiveSchmidtNumber[phase][i];
    }

    @Override
    public double getPhaseFraction(int phase) {
        return this.phaseFraction[phase];
    }
}

