/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhaseReactorFlowNode;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.KrishnaStandartFilmModel;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphaseReactorFlow.InterphasePackedBed;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.TwoPhaseFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.reactor.ReactorData;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class TwoPhasePackedBedFlowNode
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public TwoPhasePackedBedFlowNode() {
        this.flowNodeType = "packed bed";
    }

    public TwoPhasePackedBedFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "packed bed";
        this.interphaseTransportCoefficient = new InterphasePackedBed(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public TwoPhasePackedBedFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "packed bed";
        this.interphaseTransportCoefficient = new InterphasePackedBed(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public TwoPhasePackedBedFlowNode clone() {
        TwoPhasePackedBedFlowNode clonedSystem = null;
        try {
            clonedSystem = (TwoPhasePackedBedFlowNode)super.clone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public void initFlowCalc() {
        this.phaseFraction[0] = 1.0;
        this.phaseFraction[1] = 1.0;
        this.initVelocity();
        this.init();
    }

    @Override
    public double calcHydraulicDiameter() {
        return this.getGeometry().getDiameter();
    }

    @Override
    public double calcReynoldNumber() {
        this.reynoldsNumber[1] = this.getSuperficialVelocity(1) / this.getGeometry().getPacking().getSurfaceAreaPrVolume() * this.bulkSystem.getPhases()[1].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[1].getPhysicalProperties().getViscosity();
        this.reynoldsNumber[0] = this.getSuperficialVelocity(0) / this.getGeometry().getPacking().getSurfaceAreaPrVolume() * this.bulkSystem.getPhases()[0].getPhysicalProperties().getDensity() / this.bulkSystem.getPhases()[0].getPhysicalProperties().getViscosity();
        System.out.println("rey liq " + this.reynoldsNumber[1]);
        System.out.println("rey gas " + this.reynoldsNumber[0]);
        return this.reynoldsNumber[1];
    }

    @Override
    public double calcContactLength() {
        this.interphaseContactArea = this.pipe.getPacking().getSurfaceAreaPrVolume() * this.getLengthOfNode() * this.pipe.getArea();
        return this.wallContactLength[0];
    }

    @Override
    public double calcGasLiquidContactArea() {
        return this.pipe.getPacking().getSurfaceAreaPrVolume() * this.getLengthOfNode() * this.pipe.getArea() * 5.0;
    }

    @Override
    public FlowNodeInterface getNextNode() {
        TwoPhasePackedBedFlowNode newNode = this.clone();
        for (int i = 0; i < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++i) {
        }
        return newNode;
    }

    @Override
    public void update() {
        for (int componentNumber = 0; componentNumber < this.getBulkSystem().getPhases()[0].getNumberOfComponents(); ++componentNumber) {
            if (componentNumber != 1) continue;
            double liquidMolarRate = this.getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.getInterphaseContactArea();
            double gasMolarRate = -this.getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.getInterphaseContactArea();
            System.out.println("liquidMolarRate" + liquidMolarRate);
            this.getBulkSystem().addComponent(componentNumber, (double)this.flowDirection[0] * gasMolarRate, 0);
            this.getBulkSystem().getPhase(1).addMolesChemReac(componentNumber, (double)this.flowDirection[1] * liquidMolarRate);
        }
        this.getBulkSystem().initBeta();
        this.getBulkSystem().init_x_y();
        this.getBulkSystem().init(1);
        if (this.bulkSystem.isChemicalSystem()) {
            this.getOperations().chemicalEquilibrium();
        }
        this.getBulkSystem().init(3);
        System.out.println("reac heat " + this.getBulkSystem().getChemicalReactionOperations().getDeltaReactionHeat());
        double heatFlux = this.getInterphaseTransportCoefficient().calcInterphaseHeatTransferCoefficient(0, this.getPrandtlNumber(0), this) * (this.getBulkSystem().getPhase(1).getTemperature() - this.getBulkSystem().getPhase(0).getTemperature()) * this.getInterphaseContactArea();
        double liquid_dT = (double)(-this.flowDirection[1]) * heatFlux / this.getBulkSystem().getPhase(1).getCp();
        double gas_dT = (double)this.flowDirection[0] * heatFlux / this.getBulkSystem().getPhase(0).getCp();
        liquid_dT += 0.0;
        System.out.println("liq dT1 " + (liquid_dT += 0.0));
        System.out.println("Cp " + this.getBulkSystem().getPhase(1).getCp());
        System.out.println("liq dT2 " + (liquid_dT += (double)this.flowDirection[1] * this.getBulkSystem().getChemicalReactionOperations().getDeltaReactionHeat() / this.getBulkSystem().getPhase(1).getCp()));
        System.out.println("gas dT " + gas_dT);
        this.getBulkSystem().getPhase(1).setTemperature(this.getBulkSystem().getPhase(1).getTemperature() + liquid_dT);
        this.getBulkSystem().getPhase(0).setTemperature(this.getBulkSystem().getPhase(0).getTemperature() + gas_dT);
        this.getBulkSystem().init(3);
    }

    public static void main(String[] args) {
        SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(313.315, 50.01325);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        ReactorData pipe1 = new ReactorData(0.25, 0.025);
        pipe1.setPackingType("pallring", "metal", 50);
        testSystem.addComponent("methane", 100000.11152187, "Nlitre/min", 0);
        testSystem.addComponent("CO2", 3000.511152181, "Nlitre/min", 0);
        testSystem.addComponent("water", 100.502204876, "kg/min", 1);
        testSystem.addComponent("MDEA", 100.502204876, "kg/min", 1);
        testSystem.chemicalReactionInit();
        testSystem.createDatabase(true);
        testSystem.setMixingRule(4);
        testOps.TPflash();
        testSystem.addComponent("CO2", 2000.11152181, "Nlitre/min", 0);
        testSystem.setPhysicalPropertyModel(3);
        testSystem.init_x_y();
        testSystem.getPhases()[1].setTemperature(313.0);
        testSystem.getPhases()[0].setTemperature(325.0);
        TwoPhasePackedBedFlowNode test = new TwoPhasePackedBedFlowNode(testSystem, pipe1);
        test.setLengthOfNode(0.1);
        test.setInterphaseModelType(1);
        test.getFluidBoundary().useFiniteFluxCorrection(false);
        test.getFluidBoundary().useThermodynamicCorrections(false);
        test.setFlowDirection(-1, 0);
        test.initFlowCalc();
        test.initFlowCalc();
        String fileName = "c:/labsim/exp-abs-heat.txt";
        test.write("node 0", fileName, true);
        for (int i = 0; i < 120; ++i) {
            test.calcFluxes();
            test.update();
            test.display();
            test.write("node " + i, fileName, false);
        }
    }
}

