/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import java.util.ArrayList;
import neqsim.PVTsimulation.simulation.BasePVTsimulation;
import neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompViscosity.linearLiquidModel.ViscosityFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class ViscosityWaxOilSim
extends BasePVTsimulation {
    double[] temperature = new double[1];
    double[] pressure = new double[1];
    private double[] waxFraction = null;
    private double[] gasViscosity;
    private double[] oilViscosity;
    private double[] oilwaxDispersionViscosity;
    private double[] aqueousViscosity;
    private double[] shareRate;

    public ViscosityWaxOilSim(SystemInterface tempSystem) {
        super(tempSystem);
        this.temperature[0] = tempSystem.getTemperature();
        this.pressure[0] = tempSystem.getPressure();
    }

    public void setTemperaturesAndPressures(double[] temperature, double[] pressure) {
        this.pressure = pressure;
        this.temperature = temperature;
        this.experimentalData = new double[temperature.length][1];
    }

    public void runTuning() {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            for (int i = 0; i < this.experimentalData[0].length; ++i) {
                ViscosityFunction function = new ViscosityFunction();
                double[] guess = new double[]{1.0};
                function.setInitialGuess(guess);
                SystemInterface tempSystem = this.getThermoSystem().clone();
                tempSystem.setTemperature(this.temperature[i]);
                tempSystem.setPressure(this.pressure[i]);
                this.thermoOps.TPflash();
                double[] sample1 = new double[]{this.shareRate[i]};
                double viscosity = this.experimentalData[0][i];
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(viscosity, viscosity / 50.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            System.out.println("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        this.optimizer = new LevenbergMarquardt();
        this.optimizer.setMaxNumberOfIterations(20);
        this.optimizer.setSampleSet(sampleSet);
        this.optimizer.solve();
        this.runCalc();
        this.optimizer.displayCurveFit();
    }

    public void runCalc() {
        this.gasViscosity = new double[this.pressure.length];
        this.oilViscosity = new double[this.pressure.length];
        this.aqueousViscosity = new double[this.pressure.length];
        this.waxFraction = new double[this.pressure.length];
        this.oilwaxDispersionViscosity = new double[this.pressure.length];
        for (int i = 0; i < this.pressure.length; ++i) {
            this.getThermoSystem().setPressure(this.pressure[i]);
            this.getThermoSystem().setTemperature(this.temperature[i]);
            this.thermoOps.TPflash();
            this.getThermoSystem().initPhysicalProperties();
            this.waxFraction[i] = 0.0;
            if (this.getThermoSystem().hasPhaseType("wax") && this.getThermoSystem().hasPhaseType("oil")) {
                this.waxFraction[i] = this.getThermoSystem().getWtFraction(this.getThermoSystem().getPhaseNumberOfPhase("wax"));
                this.oilwaxDispersionViscosity[i] = this.getThermoSystem().getPhase("oil").getPhysicalProperties().getViscosityOfWaxyOil(this.waxFraction[i], this.getShareRate()[i]);
            }
            if (this.getThermoSystem().hasPhaseType("gas")) {
                this.gasViscosity[i] = this.getThermoSystem().getPhase("gas").getPhysicalProperties().getViscosity();
            }
            if (this.getThermoSystem().hasPhaseType("oil")) {
                this.oilViscosity[i] = this.getThermoSystem().getPhase("oil").getPhysicalProperties().getViscosity();
            }
            if (!this.getThermoSystem().hasPhaseType("aqueous")) continue;
            this.aqueousViscosity[i] = this.getThermoSystem().getPhase("aqueous").getPhysicalProperties().getViscosity();
        }
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(298.0, 10.0);
        tempSystem.addTBPfraction("C19", 10.13, 0.27, 0.814);
        tempSystem.addPlusFraction("C20", 10.62, 0.33, 0.83);
        tempSystem.getCharacterization().characterisePlusFraction();
        tempSystem.getWaxModel().addTBPWax();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        tempSystem.init(0);
        tempSystem.init(1);
        ViscosityWaxOilSim sepSim = new ViscosityWaxOilSim(tempSystem);
        double[] temps = new double[]{300.15, 293.15, 283.15, 273.15, 264.15};
        double[] pres = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        sepSim.setTemperaturesAndPressures(temps, pres);
        sepSim.setShareRate(new double[]{0.0, 0.0, 0.0, 100.0, 100.0});
        sepSim.runCalc();
        double[][] expData = new double[][]{{2.0E-4, 3.0E-4, 4.0E-4, 5.0E-4, 6.0E-4}};
        sepSim.setExperimentalData(expData);
        sepSim.runTuning();
        double a = sepSim.getGasViscosity()[0];
        double a2 = sepSim.getOilViscosity()[0];
        sepSim.getThermoSystem().display();
    }

    public double[] getWaxFraction() {
        return this.waxFraction;
    }

    public double[] getGasViscosity() {
        return this.gasViscosity;
    }

    public double[] getOilViscosity() {
        return this.oilViscosity;
    }

    public double[] getAqueousViscosity() {
        return this.aqueousViscosity;
    }

    public double[] getShareRate() {
        return this.shareRate;
    }

    public void setShareRate(double[] shareRate) {
        this.shareRate = shareRate;
    }

    public double[] getOilwaxDispersionViscosity() {
        return this.oilwaxDispersionViscosity;
    }
}

