/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import neqsim.PVTsimulation.simulation.BasePVTsimulation;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SeparatorTest
extends BasePVTsimulation {
    double[] temperature = null;
    double[] pressure = null;
    double[] Sm3gas;
    double[] m3oil;
    private double[] Bofactor;
    private double[] GOR = null;
    double oilVolumeStdCond = 0.0;
    static Logger logger = LogManager.getLogger(SeparatorTest.class);

    public SeparatorTest(SystemInterface tempSystem) {
        super(tempSystem);
    }

    public void setSeparatorConditions(double[] temperature, double[] pressure) {
        this.pressure = pressure;
        this.temperature = temperature;
    }

    public void runCalc() {
        int i;
        this.Sm3gas = new double[this.pressure.length];
        this.m3oil = new double[this.pressure.length];
        this.GOR = new double[this.pressure.length];
        this.Bofactor = new double[this.pressure.length];
        for (i = 0; i < this.pressure.length; ++i) {
            this.thermoOps.setSystem(this.getThermoSystem());
            this.getThermoSystem().setPressure(this.pressure[i]);
            this.getThermoSystem().setTemperature(this.temperature[i]);
            this.thermoOps.TPflash();
            this.m3oil[i] = this.getThermoSystem().getNumberOfPhases() > 1 ? this.getThermoSystem().getPhase(1).getVolume() : this.getThermoSystem().getVolume();
            if (this.getThermoSystem().getNumberOfPhases() <= 1 || !this.getThermoSystem().getPhase(0).getPhaseTypeName().equals("gas")) continue;
            this.getThermoSystem().getPhase(0).setPressure(1.01325);
            this.getThermoSystem().getPhase(0).setTemperature(288.15);
            this.getThermoSystem().init(1);
            this.Sm3gas[i] = this.getThermoSystem().getPhase(0).getVolume();
            this.setThermoSystem(this.getThermoSystem().phaseToSystem(1));
        }
        this.getThermoSystem().setPressure(1.01325);
        this.getThermoSystem().setTemperature(288.15);
        this.thermoOps.TPflash();
        this.oilVolumeStdCond = this.getThermoSystem().getPhase("oil").getVolume();
        for (i = 0; i < this.pressure.length; ++i) {
            if (this.Sm3gas[i] > 1.0E-10) {
                this.GOR[i] = this.Sm3gas[i] / this.oilVolumeStdCond;
                this.Bofactor[i] = this.m3oil[i] / this.oilVolumeStdCond;
            }
            logger.info("GOR " + this.getGOR()[i] + " Bo " + this.Bofactor[i]);
        }
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(298.0, 300.0);
        tempSystem.addComponent("nitrogen", 0.64);
        tempSystem.addComponent("CO2", 3.53);
        tempSystem.addComponent("methane", 70.78);
        tempSystem.addComponent("ethane", 8.94);
        tempSystem.addComponent("propane", 5.05);
        tempSystem.addComponent("i-butane", 0.85);
        tempSystem.addComponent("n-butane", 1.68);
        tempSystem.addComponent("i-pentane", 0.62);
        tempSystem.addComponent("n-pentane", 0.79);
        tempSystem.addComponent("n-hexane", 0.83);
        tempSystem.addTBPfraction("C7", 1.06, 0.0922, 0.7324);
        tempSystem.addTBPfraction("C8", 1.06, 0.1046, 0.7602);
        tempSystem.addTBPfraction("C9", 0.79, 0.1191, 0.7677);
        tempSystem.addTBPfraction("C10", 0.57, 0.133, 0.79);
        tempSystem.addTBPfraction("C11", 0.38, 0.155, 0.795);
        tempSystem.addTBPfraction("C12", 0.37, 0.162, 0.806);
        tempSystem.addTBPfraction("C13", 0.32, 0.177, 0.824);
        tempSystem.addTBPfraction("C14", 0.27, 0.198, 0.835);
        tempSystem.addTBPfraction("C15", 0.23, 0.202, 0.84);
        tempSystem.addTBPfraction("C16", 0.19, 0.215, 0.846);
        tempSystem.addTBPfraction("C17", 0.17, 0.234, 0.84);
        tempSystem.addTBPfraction("C18", 0.13, 0.251, 0.844);
        tempSystem.addTBPfraction("C19", 0.13, 0.27, 0.854);
        tempSystem.addPlusFraction("C20", 10.62, 0.381, 0.88);
        tempSystem.getCharacterization().characterisePlusFraction();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        SeparatorTest sepSim = new SeparatorTest(tempSystem);
        double[] temps = new double[]{313.15, 313.15, 313.15, 313.15, 313.15, 313.15, 313.15};
        double[] pres = new double[]{500.0, 400.0, 200.0, 100.0, 50.0, 5.0, 1.01325};
        sepSim.setSeparatorConditions(temps, pres);
        sepSim.runCalc();
    }

    public double[] getGOR() {
        return this.GOR;
    }

    public double[] getBofactor() {
        return this.Bofactor;
    }
}

