/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import neqsim.PVTsimulation.simulation.SimulationInterface;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class BasePVTsimulation
implements SimulationInterface {
    private SystemInterface thermoSystem = null;
    private SystemInterface baseThermoSystem = null;
    public ThermodynamicOperations thermoOps = null;
    private double pressure;
    public double[] pressures = new double[]{381.5, 338.9, 290.6, 242.3, 194.1, 145.8, 145.8, 97.5, 49.3};
    public double temperature = 289.0;
    double[][] experimentalData = null;
    double saturationVolume = 0.0;
    double saturationPressure = 0.0;
    double saturationTemperature;
    double Zsaturation = 0.0;
    public LevenbergMarquardt optimizer = new LevenbergMarquardt();

    public BasePVTsimulation(SystemInterface tempSystem) {
        this.thermoSystem = tempSystem;
        this.thermoOps = new ThermodynamicOperations(this.getThermoSystem());
        this.baseThermoSystem = this.thermoSystem.clone();
    }

    public void setExperimentalData(double[][] expData) {
        this.experimentalData = expData;
    }

    public double getSaturationPressure() {
        return this.saturationPressure;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public void run() {
        this.thermoOps = new ThermodynamicOperations(this.getThermoSystem());
    }

    @Override
    public SystemInterface getBaseThermoSystem() {
        return this.baseThermoSystem;
    }

    @Override
    public void setThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem;
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double[] getPressures() {
        return this.pressures;
    }

    public void setPressures(double[] pressures) {
        this.pressures = pressures;
    }

    @Override
    public LevenbergMarquardt getOptimizer() {
        return this.optimizer;
    }

    public double getZsaturation() {
        return this.Zsaturation;
    }

    public double getSaturationTemperature() {
        return this.saturationTemperature;
    }
}

