# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['exo_language',
 'exo_language.exo_classes',
 'exo_language.exo_errors',
 'exo_language.exo_utils']

package_data = \
{'': ['*'], 'exo_language': ['exo_examples/*']}

entry_points = \
{'console_scripts': ['exo = exo_language.exo:main']}

setup_kwargs = {
    'name': 'exo-language',
    'version': '0.1.4',
    'description': 'A programming language designed to be simple and fast, written in python',
    'long_description': '# Exo\nThe is a programming language designed to be simple and fast, written in python\n\n<a name="Installation"></a>\n## Installation\nThis project was built on Python 3\nTo install Exo, (after you install python) run the command:\n```shell\npip install exo\n```\n\n<a name="Usage"></a>\n## Usage\n### Running the Exo code\n\n```shell\nexo path/to/file.exo\n```\n\n<a name="LanguageSpecification"></a>\n## Language Specification\n\nNote: Comments start with a #, similar to python. There are no multiline comments\n\n<a name="types"></a>\n### Data Types\n\nThere are four data types that the user can use: integer, float, string and function. In general, the following is true for operations:\n\n- an Int and an Int will result in an Int\n- a Float and a Float results in a Float\n- a Float and an Int will result in a Float\n- any number type and a String will result in a string\n\n<a name="literals"></a>\n### Literals\n\nLiterals are values like ```5, "hello", 6.6```. A number is considered a float if it has a decimal point; otherwise it is taken as an int. String literals are surrounded in quotation marks.\n\n<a name="variables"></a>\n### Variables\n\nVariables are dynamically typed (data types can be changed). There is type inference, but you can explicitly state the type of the variable if you want the type to be explicit. Once you set the type explicitly, it cannot be changed.\n\n```\nvar x = 5 + 3.0 # 5 + 3.0 = 8.0 so x is a float\nstring y = "Hello" + " World" # y is now a string\nvar y = "Hi" # y is now \'Hi\'\nint y = 1 # This will throw an error\nvar y = 1 # This will also throw an error\n```\n\n```\nvar x = 5\nvar x = 3\n```\n\nThe syntax for initialization and assignment is identical.\n\n```\nvar a = 6.0\nvar a = a + 1\n```\n\n<a name="if"></a>\n### If Statements\n\nIf statements follow the following format:\n\n```\nif (condition){\n  statements  #indents are optional\n} elif (condition){\n  statements\n} else{\n  statements\n}\n```\n\nThe elif clause is optional or can also be used as many times as necessary in a single if statement.\n\nif statements can be nested. The else statement is also optional and can be ommited entirely:\n\n```\nif (condition){\n  statements\n} \n```\n\nThere is no boolean type in the language. Therefore the condition can also be an integer. If its value is 0, it will qualify as false, otherwise as true\n\n```\nx > 3\nx + 1 < 40/x\n5\n```\n\n<a name="while"></a>\n### While Loops\n\nA while loop can be represented like so:\n\n```\nwhile (condition){\n   statements\n}\n```\n\nWhile statements can also be nested inside one another and combined with If statements flexibly.\n\n```\nint a = 1\nwhile (a < 5) {\n  int a = a + 1\n  print(a)\n}\n```\n\n<a name="for loops"></a>\n### For Loops\n\nA for loop can be represented like so:\n\n```\nfor type(int / float) identifier in (initial, final, step){\n  statements\n}\n```\nNote that initial is inclusive and final is exclusive\nFor example:\n\n```\nfor int a in (1, 5, 1){\n  print(a)\n}\n```\n\nWill output: \n```\n1\n2\n3\n4\n```\n\nThese will not work:\n\n```\nfor var b in (1, 5, 2){\n  print(b)\n}\n\nfor string c in ("hi", "hiiiii", "i"){\n  print(c)\n}\n```\n\n<a name="lists"></a>\n### Lists\n\n#### List usage\n\n```\nvar x = [1, 2, 3]\nvar y = [4, 5, 6]\n```\n\n#### List Elements\n\nList elements can be accessed through the square bracket notation:\n\n```\nvar y = x[1] + 6  # x[1] gives the 2nd element of the list x\n```\n\nThey can be assigned to just like variables, and there are no type checks on the element added to the array:\n\n```\nvar x[10] = 345 + 3\n```\n\n<a name="print"></a>\n### Print\n\nThe print statement prints whatever it is given to the screen.\n\n```print("Hello World")```\n\nIt can be given variables, expressions, and array indices.\n\n```\nprint(5 + (4.0 * 3))\nprint(x + y[1])\nprint("Hello" + " " + "World")\n```\n\n<a name="input"></a>\n### Input\n\nThe input statement takes user input. There are 2 types: input, and input_int\n\n```\nvar x = input() #This will be stored as a string value\nvar y = input_int() #This will be stored as an int value\n```\n\nIt can only take String and Int inputs.\n\n<a name="functions"></a>\n### Functions\n\nFunctions are defined like so:\n\n```\nfun (type) name(type arg1, type arg2){\n  statements\n  (return statement)\n}\n```\n\nProviding a type to the function is optional. If no type is provided, no type checks are performed on the return value\nProviding a type to the argument is mandatory. If you do not wish to perform type checks, you can use the type \'var\'\n\n```\nfun double(int a){\n  int b = a * 2\n  return b\n}\n\nfun int triple(int a){\n  return a * 3\n}\n\nfun concat_print(string a1, string a2){\n  var a3 = a1 + " " + a2\n  print(a3)\n}\n\nfun float double_2(int a){\n  int b = a * 2\n  return b\n} # This will throw an error, since the output is always an int\n\nfun triple_2(int a){\n  return a * 3\n}\n\ntriple_2(1.0) # This will throw an error, since a is supposed to be of type int\n\nfun concat(string a1, var a2){\n  return a1 + " " + a2\n}\n\nconcat("Hello", "World") # This will run fine\nconcat("Hello", 1) # This will also run fine\nconcat(1, 1) # This will throw an error, since a1 is supposed to be of type string\n```\nIf there is no return statement, the function will return 0\nIMPORTANT NOTE: Nested return statements are not supported as of v0.1.x\nSupport will be added for these in the future\n\nThis is the syntax to call a function:\n\n```\nfunction(arg, arg2, ...)\n```\n\nThe function call can be used just like a normal variable. For example:\n\n```\nvar z = list1[add(x,y) - 2]\n',
    'author': 'supercoder186',
    'author_email': 'aadit.kolar@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/supercoder186/Exo',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
