# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['udemy_enroller', 'udemy_enroller.scrapers']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp[speedups]>=3.8.1,<4.0.0',
 'beautifulsoup4>=4.11.1,<5.0.0',
 'cloudscraper>=1.2.60,<2.0.0',
 'price-parser>=0.3.4,<0.4.0',
 'requests>=2.27.1,<3.0.0',
 'ruamel.yaml>=0.16.13,<0.17.0',
 'selenium>=3.141.0,<4.0.0',
 'webdriver-manager>=3.7.0,<4.0.0']

entry_points = \
{'console_scripts': ['udemy_enroller = udemy_enroller.cli:main']}

setup_kwargs = {
    'name': 'udemy-enroller',
    'version': '4.1.3',
    'description': '',
    'long_description': '[![forthebadge](https://forthebadge.com/images/badges/made-with-python.svg)](https://forthebadge.com)\n[![forthebadge](https://forthebadge.com/images/badges/it-works-why.svg)](https://forthebadge.com)\n\n* Udemy Coupon Grabber & Course Enroller: Grab FREE Coupons!\n<br/>\n\nDo you want to LEARN NEW STUFF for FREE? Don\'t worry, with the power of\nweb-scraping and automation, this script will find the necessary Udemy Coupons\n&amp; enroll you to PAID UDEMY COURSES, ABSOLUTELY FREE!\n\n**NOTE: THIS PROJECT IS NOT AFFILIATED WITH UDEMY.**\n\n**NOTE: THIS PROJECT WILL NOT WORK WITH NON ENGLISH UDEMY.**\n\n<br/>\n\nThe code scrapes course links and coupons from:\n\n - [tutorialbar.com](https://tutorialbar.com)\n - [discudemy.com](https://discudemy.com)\n - [coursevania.com](https://coursevania.com)\n - [freebiesglobal.com](https://freebiesglobal.com)\n - [idownloadcoupon.com](https://idownloadcoupon.com) -> _New_\n\n\nIn case of any bugs or issues, please open an issue in github. Also, don\'t forget to **Fork & Star the repository if you like it!**\n\n**We are also on _[GitLab](https://gitlab.com/the-automators/Automatic-Udemy-Course-Enroller-GET-PAID-UDEMY-COURSES-for-FREE)_**\n<br/><br/>\n\n## Video Proof:\n\n[![Udemy Auto-Course-Enroller](https://img.youtube.com/vi/tdLsVoraMxw/0.jpg)](https://www.youtube.com/watch?v=tdLsVoraMxw "GET Udemy Courses for FREE with Python | 2 Minute Tuesday")\n\n---\n\n## Disclaimer & WARNINGS:\n\n&emsp; 1. Use this ONLY for **Educational Purposes!** By using this code you agree that \n   **I\'m not responsible for any kind of trouble** caused by the code. **THIS PROJECT IS NOT AFFILIATED WITH UDEMY.** \n   <br/>\n&emsp; 2. **Make sure web-scraping is legal in your region.**\n   <br/>\n&emsp; 3. This is **NOT a hacking script**, i.e., it can\'t enroll you for a specific\n   course! Instead it finds courses that provide coupon links to make the\n   transaction free and then LEGALLY enroll you to the course!\n\n---\n\n## Requirements:\n\n### How to Install the Requirements?\n\n&emsp; __Required Python version:__ [Python 3.8+](https://www.python.org/downloads/)\n\n&emsp; __(Windows users only) Required Microsoft Visual C++ 14.0+ version:__ [Microsoft Visual C++ 14.0+](https://visualstudio.microsoft.com/visual-cpp-build-tools/)\n\n![alt text](https://docs.microsoft.com/answers/storage/attachments/34873-10262.png)\n\n&emsp; __You must have pip or poetry installed. Please look up how to install them in your OS.__\n\nDownload a release of this project or clone the repository then navigate to the\nfolder where you placed the files on. Type `pip install -r requirements.txt` to\nget all the requirements installed in one go. Similar instructions applies for poetry.\n\n---\n\n## Instructions\n\nProps to Davidd Sargent for making a super simple video tutorial. If you prefer written instructions then continue reading further, else click on the image below for a quick video tutorial:\n\n[![GET Udemy Courses for FREE with Python | 2 Minute Tuesday](https://i.ytimg.com/vi/6HLbqM-598k/hq720.jpg)](https://www.youtube.com/watch?v=6HLbqM-598k "pip installation of Automatic Udemy Course Enroller")\n\n1 . Install from PyPI `pip install udemy-enroller`\n\n-   Run the script and the cli will guide you through the settings required.\n-   If you decide to save the settings they will be stored in your home directory: <br>\n    **Windows**:\n    C:/Users/CurrentUserName/.udemy_enroller<br>\n    **Linux**:\n    /home/username/.udemy_enroller \n    **The values in settings.yaml should be in the same language as the site you are browsing on.**\n\n<br/>\n\n2 . The script can be passed arguments:\n\n- `--help`: View full list of arguments available\n- `--browser=<BROWSER_NAME>`: Run with a specific browser \n- `--discudemy`: Run the discudemy scraper only\n- `--coursevania`: Run the coursevania scraper only\n- `--tutorialbar`: Run the tutorialbar scraper only\n- `--freebiesglobal`: Run the freebiesglobal scraper only\n- `--idownloadcoupon`: Run the idownloadcoupon scraper only\n- `--max-pages=<NUMBER>`: Max number of pages to scrape from sites before exiting the script (default is 5)\n- `--delete-settings`: Delete existing settings file\n- `--delete-cookie`: Delete the cookie file if it exists\n- `--debug`: Enable debug logging \n\n<br/>\n\n\n3 . Run the script in terminal with your target runner:\n\n- `udemy_enroller`\n- `udemy_enroller --browser=chrome`\n- `udemy_enroller --browser=chromium` \n\n<br/>\n\n4 . The bot starts scraping the course links from the first **All Courses** page\non [Tutorial Bar](https://www.tutorialbar.com/all-courses/page/1), [DiscUdemy](https://www.discudemy.com/all), [Coursevania](https://coursevania.com) and [FreebiesGlobal](https://freebiesglobal.com) and starts\nenrolling you to Udemy courses. After it has enrolled you to courses from the\nfirst page, it then moves to the next site page and the cycle continues.\n\n-   Stop the script by pressing `ctrl+c` in terminal to stop the enrollment process. \n\n<br/>\n\n5 . *[New]* At the end of process a detailed result is shown:\n\n```\n================== Run Statistics ==================\n\nEnrolled:                   56\nUnwanted Category:          0\nUnwanted Language:          1\nAlready Claimed:            93\nExpired:                    7\nTotal Enrolments:           1705\nSavings:                    €2674.44\n================== Run Statistics ==================\n```\n\n### Docker\n\nAlternatively you can run the script in docker.\n\nTo build the image run:\n\n```\ndocker build -t udemy_enroller .\n```\n\nAfter the build is finished you can run your container with one of the commands below (you can pass arguments as you would in the cli):\n\n```\ndocker run -it udemy_enroller \n```\n\nAfter you entered your login credentials and settings detach from the interactive mode by pressing the `Ctrl-P` followed by `Ctrl-Q`.\n\nYou can also create a `settings.yaml` file from the `sample_settings.yaml` and mount to the container with the command:\n\n```\ndocker run -v $(pwd)/settings.yaml:/home/enroller/.udemy_enroller/settings.yaml udemy_enroller \n```\n\n\n\n---\n\n## FAQs\n\n__1. Can I get a specific course for free with this script?__\n\n&emsp; Unfortunately no, but let me assure you that you may be lucky enough to get a\nparticular course for free when the instructor posts its coupon code in order\nto promote it. Also, over time you would build a library of courses by running\nthe script often and have all the required courses in your collection. In fact,\nI made this course after completing a\n[Python automation course](https://www.udemy.com/course/automate/) and [Selenium](https://www.selenium.dev/),\nwhich of course I got for free! :)\n<br/><br/>\n \n__2. How does the bot work?__\n\n&emsp; The bot retrieves coupon links from [Tutorial Bar](https://www.tutorialbar.com/all-courses/page/1), [DiscUdemy](https://www.discudemy.com/all) and [Coursevania](https://coursevania.com)\'s lists to cut the prices and\nthen uses REST requests to authenticate and enroll to the\ncourses. Think of it this way: Epic Games & other clients like Steam provide you\na handful of games each week, for free; Only in this case, we need a coupon code\nto make those courses free. <br/><br/>\n\n\n__3. How frequently should you run the script?__\n\n&emsp; Daily, at least once! I\'ve painstakingly amassed over 4000\ncourses in the last four years! And out of those 4000, I\'ve only paid for 4 of\nthese courses.\n\nSo, a mere **0.001%** of courses are **actually paid** in my collection!\nThankfully, you can get more than what I gathered in 4 years, in a matter of\nweeks! 🙌🏻 <br/><br/>\n\n\n__4. Why did I create this?__\n\n&emsp; It used to be my daily habit to redeem courses and it was an extremely tedious\ntask that took around 15 minutes, for 10 courses. And then I suddenly got the\nidea to automate it, after I found the automation course mentioned above. I bet,\nit will save your precious time too! :) <br/><br/>\n\n\n__5. The code compiles successfully, but it\'s taking too long to work! IS there any way to fix that?__\n\n&emsp; Since we are heavily dependent on a third-party site to retrieve coupons links,\nthere may be issues when the site is down. Needless to mention the connectivity\nissues too. If everything is working fine, you can see the courses being\nretrieved in the Python console/shell, which may take a while. <br/><br/>\n\n\n__6. Which is the best way to run the script?__\n\n&emsp; It is recommended to run the script using your terminal and system python. <br/><br/>\n\n\n__7. Which branch to commit against?__\n\n&emsp; Pull request should be made on "_develop_" branch. <br/><br/>\n\n\n__8. What\'s the roadmap?__\n\n&emsp; Take a look at our [Roadmap here](https://github.com/aapatre/Automatic-Udemy-Course-Enroller-GET-PAID-UDEMY-COURSES-for-FREE/projects/1) and help us on what you want or talk to us about your proposed changes. <br/><br/>\n\n\n---\n\n## Support & Maintenance Notice\n\nBy using this repo/script, you agree that the authors and contributors are under no obligation to provide support for the script and can discontinue it\'s development, as and when necessary, without prior notice.\n\n---\n\n## Supporters\n\n### Jetbrains\n\n[![JetBrains](https://i.imgur.com/h2R018M.jpg)](https://jetbrains.com/?from=udemy-free-course-enroller)\n\nThanks to [JetBrains](https://jetbrains.com/?from=udemy-free-course-enroller) for supporting us. They are the maker of world class IDE and developer tooling. If you think their product might help you, please support them.\n\n### GitBook\n\n[![GitBook](https://i.imgur.com/OkuB14I.jpg)](https://gitbook.com)\n\nThanks to [GitBook](https://gitbook.com) for supporting us. GitBook is the best place to track personal notes and ideas for teams. If you think their product might help you, please support them.\n\n### GitLab\n\n[![GitLab](https://i.imgur.com/aUWtSn4.png)](https://gitlab.com)\n\nThanks to [GitLab](https://gitlab.com) for supporting us. GitLab is one of the main code hosting and CI/CD providers out there. They support the open source community through their GitLab for [Open Source program](https://about.gitlab.com/solutions/open-source/). Please check them out.\n',
    'author': 'aapatre',
    'author_email': 'udemyenroller@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/aapatre/Automatic-Udemy-Course-Enroller-GET-PAID-UDEMY-COURSES-for-FREE',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
