"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcceleratorSecurityGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const custom_resources_1 = require("@aws-cdk/custom-resources");
/**
 * (experimental) The security group used by a Global Accelerator to send traffic to resources in a VPC.
 *
 * @experimental
 */
class AcceleratorSecurityGroup {
    constructor() { }
    /**
     * (experimental) Lookup the Global Accelerator security group at CloudFormation deployment time.
     *
     * As of this writing, Global Accelerators (AGA) create a single security group per VPC. AGA security groups are shared
     * by all AGAs in an account. Additionally, there is no CloudFormation mechanism to reference the AGA security groups.
     *
     * This makes creating security group rules which allow traffic from an AGA complicated in CDK. This lookup will identify
     * the AGA security group for a given VPC at CloudFormation deployment time, and lets you create rules for traffic from AGA
     * to other resources created by CDK.
     *
     * @experimental
     */
    static fromVpc(scope, id, vpc, endpointGroup) {
        // The security group name is always 'GlobalAccelerator'
        const globalAcceleratorSGName = 'GlobalAccelerator';
        // How to reference the security group name in the response from EC2
        const ec2ResponseSGIdField = 'SecurityGroups.0.GroupId';
        // The AWS Custom Resource that make a call to EC2 to get the security group ID, for the given VPC
        const lookupAcceleratorSGCustomResource = new custom_resources_1.AwsCustomResource(scope, id + 'CustomResource', {
            onCreate: {
                service: 'EC2',
                action: 'describeSecurityGroups',
                parameters: {
                    Filters: [
                        {
                            Name: 'group-name',
                            Values: [
                                globalAcceleratorSGName,
                            ],
                        },
                        {
                            Name: 'vpc-id',
                            Values: [
                                vpc.vpcId,
                            ],
                        },
                    ],
                },
                // We get back a list of responses, but the list should be of length 0 or 1
                // Getting no response means no resources have been linked to the AGA
                physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse(ec2ResponseSGIdField),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
        // Look up the security group ID
        const sg = aws_ec2_1.SecurityGroup.fromSecurityGroupId(scope, id, lookupAcceleratorSGCustomResource.getResponseField(ec2ResponseSGIdField));
        // We add a dependency on the endpoint group, guaranteeing that CloudFormation won't
        // try and look up the SG before AGA creates it. The SG is created when a VPC resource
        // is associated with an AGA
        lookupAcceleratorSGCustomResource.node.addDependency(endpointGroup);
        return sg;
    }
}
exports.AcceleratorSecurityGroup = AcceleratorSecurityGroup;
_a = JSII_RTTI_SYMBOL_1;
AcceleratorSecurityGroup[_a] = { fqn: "@aws-cdk/aws-globalaccelerator.AcceleratorSecurityGroup", version: "1.95.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWNjZWxlcmF0b3Itc2VjdXJpdHktZ3JvdXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhY2NlbGVyYXRvci1zZWN1cml0eS1ncm91cC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDhDQUF1RTtBQUV2RSxnRUFBMkc7Ozs7OztBQVUzRyxNQUFhLHdCQUF3QjtJQTREbkMsZ0JBQXVCLENBQUM7Ozs7Ozs7Ozs7Ozs7SUFqRGpCLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsR0FBUyxFQUFFLGFBQTRCO1FBRXpGLHdEQUF3RDtRQUN4RCxNQUFNLHVCQUF1QixHQUFHLG1CQUFtQixDQUFDO1FBRXBELG9FQUFvRTtRQUNwRSxNQUFNLG9CQUFvQixHQUFHLDBCQUEwQixDQUFDO1FBRXhELGtHQUFrRztRQUNsRyxNQUFNLGlDQUFpQyxHQUFHLElBQUksb0NBQWlCLENBQUMsS0FBSyxFQUFFLEVBQUUsR0FBRyxnQkFBZ0IsRUFBRTtZQUM1RixRQUFRLEVBQUU7Z0JBQ1IsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsTUFBTSxFQUFFLHdCQUF3QjtnQkFDaEMsVUFBVSxFQUFFO29CQUNWLE9BQU8sRUFBRTt3QkFDUDs0QkFDRSxJQUFJLEVBQUUsWUFBWTs0QkFDbEIsTUFBTSxFQUFFO2dDQUNOLHVCQUF1Qjs2QkFDeEI7eUJBQ0Y7d0JBQ0Q7NEJBQ0UsSUFBSSxFQUFFLFFBQVE7NEJBQ2QsTUFBTSxFQUFFO2dDQUNOLEdBQUcsQ0FBQyxLQUFLOzZCQUNWO3lCQUNGO3FCQUNGO2lCQUNGO2dCQUNELDJFQUEyRTtnQkFDM0UscUVBQXFFO2dCQUNyRSxrQkFBa0IsRUFBRSxxQ0FBa0IsQ0FBQyxZQUFZLENBQUMsb0JBQW9CLENBQUM7YUFDMUU7WUFDRCxNQUFNLEVBQUUsMENBQXVCLENBQUMsWUFBWSxDQUFDO2dCQUMzQyxTQUFTLEVBQUUsMENBQXVCLENBQUMsWUFBWTthQUNoRCxDQUFDO1NBQ0gsQ0FBQyxDQUFDO1FBRUgsZ0NBQWdDO1FBQ2hDLE1BQU0sRUFBRSxHQUFHLHVCQUFhLENBQUMsbUJBQW1CLENBQUMsS0FBSyxFQUNoRCxFQUFFLEVBQ0YsaUNBQWlDLENBQUMsZ0JBQWdCLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO1FBQzVFLG9GQUFvRjtRQUNwRixzRkFBc0Y7UUFDdEYsNEJBQTRCO1FBQzVCLGlDQUFpQyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDcEUsT0FBTyxFQUFFLENBQUM7SUFDWixDQUFDOztBQTFESCw0REE2REMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJU2VjdXJpdHlHcm91cCwgU2VjdXJpdHlHcm91cCwgSVZwYyB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuXG5pbXBvcnQgeyBBd3NDdXN0b21SZXNvdXJjZSwgQXdzQ3VzdG9tUmVzb3VyY2VQb2xpY3ksIFBoeXNpY2FsUmVzb3VyY2VJZCB9IGZyb20gJ0Bhd3MtY2RrL2N1c3RvbS1yZXNvdXJjZXMnO1xuaW1wb3J0IHsgRW5kcG9pbnRHcm91cCB9IGZyb20gJy4uL2xpYic7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEFjY2VsZXJhdG9yU2VjdXJpdHlHcm91cCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBmcm9tVnBjKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHZwYzogSVZwYywgZW5kcG9pbnRHcm91cDogRW5kcG9pbnRHcm91cCk6IElTZWN1cml0eUdyb3VwIHtcblxuICAgIC8vIFRoZSBzZWN1cml0eSBncm91cCBuYW1lIGlzIGFsd2F5cyAnR2xvYmFsQWNjZWxlcmF0b3InXG4gICAgY29uc3QgZ2xvYmFsQWNjZWxlcmF0b3JTR05hbWUgPSAnR2xvYmFsQWNjZWxlcmF0b3InO1xuXG4gICAgLy8gSG93IHRvIHJlZmVyZW5jZSB0aGUgc2VjdXJpdHkgZ3JvdXAgbmFtZSBpbiB0aGUgcmVzcG9uc2UgZnJvbSBFQzJcbiAgICBjb25zdCBlYzJSZXNwb25zZVNHSWRGaWVsZCA9ICdTZWN1cml0eUdyb3Vwcy4wLkdyb3VwSWQnO1xuXG4gICAgLy8gVGhlIEFXUyBDdXN0b20gUmVzb3VyY2UgdGhhdCBtYWtlIGEgY2FsbCB0byBFQzIgdG8gZ2V0IHRoZSBzZWN1cml0eSBncm91cCBJRCwgZm9yIHRoZSBnaXZlbiBWUENcbiAgICBjb25zdCBsb29rdXBBY2NlbGVyYXRvclNHQ3VzdG9tUmVzb3VyY2UgPSBuZXcgQXdzQ3VzdG9tUmVzb3VyY2Uoc2NvcGUsIGlkICsgJ0N1c3RvbVJlc291cmNlJywge1xuICAgICAgb25DcmVhdGU6IHtcbiAgICAgICAgc2VydmljZTogJ0VDMicsXG4gICAgICAgIGFjdGlvbjogJ2Rlc2NyaWJlU2VjdXJpdHlHcm91cHMnLFxuICAgICAgICBwYXJhbWV0ZXJzOiB7XG4gICAgICAgICAgRmlsdGVyczogW1xuICAgICAgICAgICAge1xuICAgICAgICAgICAgICBOYW1lOiAnZ3JvdXAtbmFtZScsXG4gICAgICAgICAgICAgIFZhbHVlczogW1xuICAgICAgICAgICAgICAgIGdsb2JhbEFjY2VsZXJhdG9yU0dOYW1lLFxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgTmFtZTogJ3ZwYy1pZCcsXG4gICAgICAgICAgICAgIFZhbHVlczogW1xuICAgICAgICAgICAgICAgIHZwYy52cGNJZCxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgXSxcbiAgICAgICAgfSxcbiAgICAgICAgLy8gV2UgZ2V0IGJhY2sgYSBsaXN0IG9mIHJlc3BvbnNlcywgYnV0IHRoZSBsaXN0IHNob3VsZCBiZSBvZiBsZW5ndGggMCBvciAxXG4gICAgICAgIC8vIEdldHRpbmcgbm8gcmVzcG9uc2UgbWVhbnMgbm8gcmVzb3VyY2VzIGhhdmUgYmVlbiBsaW5rZWQgdG8gdGhlIEFHQVxuICAgICAgICBwaHlzaWNhbFJlc291cmNlSWQ6IFBoeXNpY2FsUmVzb3VyY2VJZC5mcm9tUmVzcG9uc2UoZWMyUmVzcG9uc2VTR0lkRmllbGQpLFxuICAgICAgfSxcbiAgICAgIHBvbGljeTogQXdzQ3VzdG9tUmVzb3VyY2VQb2xpY3kuZnJvbVNka0NhbGxzKHtcbiAgICAgICAgcmVzb3VyY2VzOiBBd3NDdXN0b21SZXNvdXJjZVBvbGljeS5BTllfUkVTT1VSQ0UsXG4gICAgICB9KSxcbiAgICB9KTtcblxuICAgIC8vIExvb2sgdXAgdGhlIHNlY3VyaXR5IGdyb3VwIElEXG4gICAgY29uc3Qgc2cgPSBTZWN1cml0eUdyb3VwLmZyb21TZWN1cml0eUdyb3VwSWQoc2NvcGUsXG4gICAgICBpZCxcbiAgICAgIGxvb2t1cEFjY2VsZXJhdG9yU0dDdXN0b21SZXNvdXJjZS5nZXRSZXNwb25zZUZpZWxkKGVjMlJlc3BvbnNlU0dJZEZpZWxkKSk7XG4gICAgLy8gV2UgYWRkIGEgZGVwZW5kZW5jeSBvbiB0aGUgZW5kcG9pbnQgZ3JvdXAsIGd1YXJhbnRlZWluZyB0aGF0IENsb3VkRm9ybWF0aW9uIHdvbid0XG4gICAgLy8gdHJ5IGFuZCBsb29rIHVwIHRoZSBTRyBiZWZvcmUgQUdBIGNyZWF0ZXMgaXQuIFRoZSBTRyBpcyBjcmVhdGVkIHdoZW4gYSBWUEMgcmVzb3VyY2VcbiAgICAvLyBpcyBhc3NvY2lhdGVkIHdpdGggYW4gQUdBXG4gICAgbG9va3VwQWNjZWxlcmF0b3JTR0N1c3RvbVJlc291cmNlLm5vZGUuYWRkRGVwZW5kZW5jeShlbmRwb2ludEdyb3VwKTtcbiAgICByZXR1cm4gc2c7XG4gIH1cblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKCkge31cbn1cbiJdfQ==