#!python

import cellconstructor as CC, cellconstructor.Structure, cellconstructor.Manipulate
import ase, ase.visualize
import sys, os


def print_info():
    TXT = """
This script is part of CellConstructor.
Display with ASE the scf file format.

Usage:
    view_scf_atoms.py filename.scf

filename.scf is the file containing the structure in scf format.
scf format can be saved from cellconstructor.Structure.Structure class 
with the method save_scf.
Or generated by the python-sscha package.
"""
    print(TXT)

if __name__ == "__main__":
    if not len(sys.argv) == 2:
        print_info()
        exit()

    all_s = CC.Manipulate.load_scf_trajectory(sys.argv[1])
    all_atms = [x.get_ase_atoms() for x in all_s]

    ase.visualize.view(all_atms)
