"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppsyncFunction = void 0;
const core_1 = require("@aws-cdk/core");
const appsync_generated_1 = require("./appsync.generated");
/**
 * (experimental) AppSync Functions are local functions that perform certain operations onto a backend data source.
 *
 * Developers can compose operations (Functions)
 * and execute them in sequence with Pipeline Resolvers.
 *
 * @experimental
 * @resource AWS::AppSync::FunctionConfiguration
 */
class AppsyncFunction extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        this.function = new appsync_generated_1.CfnFunctionConfiguration(this, 'Resource', {
            name: props.name,
            description: props.description,
            apiId: props.api.apiId,
            dataSourceName: props.dataSource.name,
            functionVersion: '2018-05-29',
            requestMappingTemplate: (_a = props.requestMappingTemplate) === null || _a === void 0 ? void 0 : _a.renderTemplate(),
            responseMappingTemplate: (_b = props.responseMappingTemplate) === null || _b === void 0 ? void 0 : _b.renderTemplate(),
        });
        this.functionName = this.function.attrName;
        this.functionArn = this.function.attrFunctionArn;
        this.functionId = this.function.attrFunctionId;
        this.dataSource = props.dataSource;
        this.function.addDependsOn(this.dataSource.ds);
        props.api.addSchemaDependency(this.function);
    }
    /**
     * (experimental) Import Appsync Function from arn.
     *
     * @experimental
     */
    static fromAppsyncFunctionAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor(s, i) {
                super(s, i);
                this.functionId = core_1.Lazy.stringValue({
                    produce: () => core_1.Fn.select(3, core_1.Fn.split('/', attrs.functionArn)),
                });
                this.functionArn = attrs.functionArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.AppsyncFunction = AppsyncFunction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwc3luYy1mdW5jdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcHN5bmMtZnVuY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0NBQThEO0FBRTlELDJEQUErRDs7Ozs7Ozs7OztBQWtGL0QsTUFBYSxlQUFnQixTQUFRLGVBQVE7Ozs7SUE0QzNDLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTJCOztRQUMxRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSw0Q0FBd0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQzdELElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsS0FBSztZQUN0QixjQUFjLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJO1lBQ3JDLGVBQWUsRUFBRSxZQUFZO1lBQzdCLHNCQUFzQixRQUFFLEtBQUssQ0FBQyxzQkFBc0IsMENBQUUsY0FBYyxFQUFFO1lBQ3RFLHVCQUF1QixRQUFFLEtBQUssQ0FBQyx1QkFBdUIsMENBQUUsY0FBYyxFQUFFO1NBQ3pFLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUM7UUFDM0MsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQztRQUNqRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsY0FBYyxDQUFDO1FBQy9DLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUVuQyxJQUFJLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQy9DLEtBQUssQ0FBQyxHQUFHLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQy9DLENBQUM7Ozs7OztJQTFETSxNQUFNLENBQUMsNkJBQTZCLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBZ0M7UUFDeEcsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUszQixZQUFhLENBQVksRUFBRSxDQUFTO2dCQUNsQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO2dCQUxFLGVBQVUsR0FBRyxXQUFJLENBQUMsV0FBVyxDQUFDO29CQUM1QyxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsU0FBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsU0FBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDO2lCQUM5RCxDQUFDLENBQUM7Z0JBQ2EsZ0JBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1lBR2hELENBQUM7U0FDRjtRQUNELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLENBQUM7Q0FnREY7QUEvREQsMENBK0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVzb3VyY2UsIElSZXNvdXJjZSwgTGF6eSwgRm4gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuRnVuY3Rpb25Db25maWd1cmF0aW9uIH0gZnJvbSAnLi9hcHBzeW5jLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBCYXNlRGF0YVNvdXJjZSB9IGZyb20gJy4vZGF0YS1zb3VyY2UnO1xuaW1wb3J0IHsgSUdyYXBocWxBcGkgfSBmcm9tICcuL2dyYXBocWxhcGktYmFzZSc7XG5pbXBvcnQgeyBNYXBwaW5nVGVtcGxhdGUgfSBmcm9tICcuL21hcHBpbmctdGVtcGxhdGUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VBcHBzeW5jRnVuY3Rpb25Qcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXF1ZXN0TWFwcGluZ1RlbXBsYXRlPzogTWFwcGluZ1RlbXBsYXRlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZXNwb25zZU1hcHBpbmdUZW1wbGF0ZT86IE1hcHBpbmdUZW1wbGF0ZTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEFwcHN5bmNGdW5jdGlvblByb3BzIGV4dGVuZHMgQmFzZUFwcHN5bmNGdW5jdGlvblByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBpOiBJR3JhcGhxbEFwaTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGF0YVNvdXJjZTogQmFzZURhdGFTb3VyY2U7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEFwcHN5bmNGdW5jdGlvbkF0dHJpYnV0ZXMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZ1bmN0aW9uQXJuOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJQXBwc3luY0Z1bmN0aW9uIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGZ1bmN0aW9uSWQ6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmdW5jdGlvbkFybjogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEFwcHN5bmNGdW5jdGlvbiBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUFwcHN5bmNGdW5jdGlvbiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUFwcHN5bmNGdW5jdGlvbkF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IEFwcHN5bmNGdW5jdGlvbkF0dHJpYnV0ZXMpOiBJQXBwc3luY0Z1bmN0aW9uIHtcbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBSZXNvdXJjZSB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgZnVuY3Rpb25JZCA9IExhenkuc3RyaW5nVmFsdWUoe1xuICAgICAgICBwcm9kdWNlOiAoKSA9PiBGbi5zZWxlY3QoMywgRm4uc3BsaXQoJy8nLCBhdHRycy5mdW5jdGlvbkFybikpLFxuICAgICAgfSk7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgZnVuY3Rpb25Bcm4gPSBhdHRycy5mdW5jdGlvbkFybjtcbiAgICAgIGNvbnN0cnVjdG9yIChzOiBDb25zdHJ1Y3QsIGk6IHN0cmluZykge1xuICAgICAgICBzdXBlcihzLCBpKTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBmdW5jdGlvbk5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgZnVuY3Rpb25Bcm46IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBmdW5jdGlvbklkOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGRhdGFTb3VyY2U6IEJhc2VEYXRhU291cmNlO1xuXG4gIHByaXZhdGUgcmVhZG9ubHkgZnVuY3Rpb246IENmbkZ1bmN0aW9uQ29uZmlndXJhdGlvbjtcblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFwcHN5bmNGdW5jdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICB0aGlzLmZ1bmN0aW9uID0gbmV3IENmbkZ1bmN0aW9uQ29uZmlndXJhdGlvbih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBuYW1lOiBwcm9wcy5uYW1lLFxuICAgICAgZGVzY3JpcHRpb246IHByb3BzLmRlc2NyaXB0aW9uLFxuICAgICAgYXBpSWQ6IHByb3BzLmFwaS5hcGlJZCxcbiAgICAgIGRhdGFTb3VyY2VOYW1lOiBwcm9wcy5kYXRhU291cmNlLm5hbWUsXG4gICAgICBmdW5jdGlvblZlcnNpb246ICcyMDE4LTA1LTI5JyxcbiAgICAgIHJlcXVlc3RNYXBwaW5nVGVtcGxhdGU6IHByb3BzLnJlcXVlc3RNYXBwaW5nVGVtcGxhdGU/LnJlbmRlclRlbXBsYXRlKCksXG4gICAgICByZXNwb25zZU1hcHBpbmdUZW1wbGF0ZTogcHJvcHMucmVzcG9uc2VNYXBwaW5nVGVtcGxhdGU/LnJlbmRlclRlbXBsYXRlKCksXG4gICAgfSk7XG4gICAgdGhpcy5mdW5jdGlvbk5hbWUgPSB0aGlzLmZ1bmN0aW9uLmF0dHJOYW1lO1xuICAgIHRoaXMuZnVuY3Rpb25Bcm4gPSB0aGlzLmZ1bmN0aW9uLmF0dHJGdW5jdGlvbkFybjtcbiAgICB0aGlzLmZ1bmN0aW9uSWQgPSB0aGlzLmZ1bmN0aW9uLmF0dHJGdW5jdGlvbklkO1xuICAgIHRoaXMuZGF0YVNvdXJjZSA9IHByb3BzLmRhdGFTb3VyY2U7XG5cbiAgICB0aGlzLmZ1bmN0aW9uLmFkZERlcGVuZHNPbih0aGlzLmRhdGFTb3VyY2UuZHMpO1xuICAgIHByb3BzLmFwaS5hZGRTY2hlbWFEZXBlbmRlbmN5KHRoaXMuZnVuY3Rpb24pO1xuICB9XG59Il19