# Contribution guide

## ⚙️ Setting up the environment

1. Run `make install-uv` to install [uv](https://docs.astral.sh/uv/) if not already installed
2. Run `make install` to install all dependencies and pre-commit hooks

## 🤝 Code contributions

1. [Fork](https://github.com/gazorby/strawchemy/fork) the [strawchemy repository](https://github.com/gazorby/strawchemy)
2. Clone your fork locally with git
3. Set up the environment
4. Make your changes
5. Run `make lint` to run linters and formatters. This step is optional and will be executed automatically by git before you make a commit, but you may want to run it manually in order to apply fixes automatically by git before you make a commit, but you may want to run it manually in order to apply fixes
6. Commit your changes to git
7. Push the changes to your fork
8. Open a pull request. Give the pull request a descriptive title indicating what it changes. If it has a corresponding open issue, the issue number should be included in the title as well. For example a pull request that fixes issue `bug: Increased stack size making it impossible to find needle #100` could be titled `fix(#100): Make needles easier to find by applying fire to`

💡 Tip

Pull requests and commits all need to follow the Conventional Commit format

## Creating a new release

1. **Increment the version** in pyproject.toml.

   Note: The version should follow [semantic versioning](https://semver.org/) and [PEP 440](https://www.python.org/dev/peps/pep-0440/).

2. Commit your changes and push to `main`

3. Go to [Actions](https://github.com/gazorby/strawchemy/actions) and approve the release workflow

   Check that the workflow runs successfully
