# Develop in a notebook or editor

One of the main design goals for Panel was that it should make it possible to seamlessly transition back and forth between interactively prototyping a dashboard in the notebook or on the commandline to deploying it as a standalone server app.

This guide will provide simple how-to guides on how to display panels interactively in a notebook or in your favorite editor environment.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`note;2.5em;sd-mr-1 sd-animate-grow50` Display output in notebooks
:link: notebook
:link-type: doc
:class-title: sd-text-center

How to display output in Jupyter and non-Jupyter based notebook environments.
:::

:::{grid-item-card} {octicon}`code-square;2.5em;sd-mr-1 sd-animate-grow50` Develop apps in an editor
:link: editor
:link-type: doc
:class-title: sd-text-center

How to rapidly develop a Panel application in your favorite IDE or editor.
:::

:::{grid-item-card} {octicon}`moon;2.5em;sd-mr-1 sd-animate-grow50` Preview apps in JupyterLab
:link: jupyterlab
:link-type: doc
:class-title: sd-text-center

How to use the Preview functionality in JupyterLab to rapidly develop applications.
:::

::::

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 2

notebook
editor
jupyterlab
```
