# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.async_support.base.exchange import Exchange
from ccxt.base.errors import AuthenticationError
from ccxt.base.errors import ArgumentsRequired
from ccxt.base.errors import BadRequest
from ccxt.base.errors import InsufficientFunds
from ccxt.base.errors import OrderNotFound
from ccxt.base.errors import NetworkError
from ccxt.base.decimal_to_precision import TICK_SIZE
from ccxt.base.precise import Precise


class hollaex(Exchange):

    def describe(self):
        return self.deep_extend(super(hollaex, self).describe(), {
            'id': 'hollaex',
            'name': 'HollaEx',
            'countries': ['KR'],
            # 4 requests per second => 1000ms / 4 = 250 ms between requests
            'rateLimit': 250,
            'version': 'v2',
            'has': {
                'CORS': None,
                'spot': True,
                'margin': None,
                'swap': False,
                'future': False,
                'option': False,
                'addMargin': False,
                'cancelAllOrders': True,
                'cancelOrder': True,
                'createLimitBuyOrder': True,
                'createLimitSellOrder': True,
                'createMarketBuyOrder': True,
                'createMarketSellOrder': True,
                'createOrder': True,
                'createReduceOnlyOrder': False,
                'fetchBalance': True,
                'fetchBorrowRate': False,
                'fetchBorrowRateHistories': False,
                'fetchBorrowRateHistory': False,
                'fetchBorrowRates': False,
                'fetchBorrowRatesPerSymbol': False,
                'fetchClosedOrders': True,
                'fetchCurrencies': True,
                'fetchDepositAddress': 'emulated',
                'fetchDepositAddresses': True,
                'fetchDeposits': True,
                'fetchFundingHistory': False,
                'fetchFundingRate': False,
                'fetchFundingRateHistory': False,
                'fetchFundingRates': False,
                'fetchIndexOHLCV': False,
                'fetchLeverage': False,
                'fetchMarkets': True,
                'fetchMarkOHLCV': False,
                'fetchMyTrades': True,
                'fetchOHLCV': True,
                'fetchOpenOrder': True,
                'fetchOpenOrders': True,
                'fetchOrder': True,
                'fetchOrderBook': True,
                'fetchOrderBooks': True,
                'fetchOrders': True,
                'fetchPosition': False,
                'fetchPositions': False,
                'fetchPositionsRisk': False,
                'fetchPremiumIndexOHLCV': False,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchTrades': True,
                'fetchTradingFee': False,
                'fetchTradingFees': True,
                'fetchTransactions': None,
                'fetchWithdrawals': True,
                'reduceMargin': False,
                'setLeverage': False,
                'setMarginMode': False,
                'setPositionMode': False,
                'withdraw': True,
            },
            'timeframes': {
                '1m': '1m',
                '5m': '5m',
                '15m': '15m',
                '1h': '1h',
                '4h': '4h',
                '1d': '1d',
                '1w': '1w',
            },
            'urls': {
                'logo': 'https://user-images.githubusercontent.com/1294454/75841031-ca375180-5ddd-11ea-8417-b975674c23cb.jpg',
                'test': 'https://api.sandbox.hollaex.com',
                'api': {
                    'rest': 'https://api.hollaex.com',
                },
                'www': 'https://hollaex.com',
                'doc': 'https://apidocs.hollaex.com',
                'referral': 'https://pro.hollaex.com/signup?affiliation_code=QSWA6G',
            },
            'precisionMode': TICK_SIZE,
            'requiredCredentials': {
                'apiKey': True,
                'secret': True,
            },
            'api': {
                'public': {
                    'get': {
                        'health': 1,
                        'constants': 1,
                        'kit': 1,
                        'tiers': 1,
                        'ticker': 1,
                        'tickers': 1,
                        'orderbook': 1,
                        'orderbooks': 1,
                        'trades': 1,
                        'chart': 1,
                        'charts': 1,
                        # TradingView
                        'udf/config': 1,
                        'udf/history': 1,
                        'udf/symbols': 1,
                    },
                },
                'private': {
                    'get': {
                        'user': 1,
                        'user/balance': 1,
                        'user/deposits': 1,
                        'user/withdrawals': 1,
                        'user/withdrawal/fee': 1,
                        'user/trades': 1,
                        'orders': 1,
                        'order': 1,
                    },
                    'post': {
                        'user/withdrawal': 1,
                        'order': 1,
                    },
                    'delete': {
                        'order/all': 1,
                        'order': 1,
                    },
                },
            },
            'fees': {
                'trading': {
                    'tierBased': True,
                    'percentage': True,
                    'taker': 0.001,
                    'maker': 0.001,
                },
            },
            'exceptions': {
                'broad': {
                    'Invalid token': AuthenticationError,
                    'Order not found': OrderNotFound,
                    'Insufficient balance': InsufficientFunds,
                },
                'exact': {
                    '400': BadRequest,
                    '403': AuthenticationError,
                    '404': BadRequest,
                    '405': BadRequest,
                    '410': BadRequest,
                    '429': BadRequest,
                    '500': NetworkError,
                    '503': NetworkError,
                },
            },
            'options': {
                # how many seconds before the authenticated request expires
                'api-expires': int(self.timeout / 1000),
            },
        })

    async def fetch_markets(self, params={}):
        response = await self.publicGetConstants(params)
        #
        #     {
        #         coins: {
        #             xmr: {
        #                 id: 7,
        #                 fullname: "Monero",
        #                 symbol: "xmr",
        #                 active: True,
        #                 allow_deposit: True,
        #                 allow_withdrawal: True,
        #                 withdrawal_fee: 0.02,
        #                 min: 0.001,
        #                 max: 100000,
        #                 increment_unit: 0.001,
        #                 deposit_limits: {'1': 0, '2': 0, '3': 0, '4': 0, '5': 0, '6': 0},
        #                 withdrawal_limits: {'1': 10, '2': 15, '3': 100, '4': 100, '5': 200, '6': 300, '7': 350, '8': 400, '9': 500, '10': -1},
        #                 created_at: "2019-12-09T07:14:02.720Z",
        #                 updated_at: "2020-01-16T12:12:53.162Z"
        #             },
        #             # ...
        #         },
        #         pairs: {
        #             'btc-usdt': {
        #                 id: 2,
        #                 name: "btc-usdt",
        #                 pair_base: "btc",
        #                 pair_2: "usdt",
        #                 taker_fees: {'1': 0.3, '2': 0.25, '3': 0.2, '4': 0.18, '5': 0.1, '6': 0.09, '7': 0.08, '8': 0.06, '9': 0.04, '10': 0},
        #                 maker_fees: {'1': 0.1, '2': 0.08, '3': 0.05, '4': 0.03, '5': 0, '6': 0, '7': 0, '8': 0, '9': 0, '10': 0},
        #                 min_size: 0.0001,
        #                 max_size: 1000,
        #                 min_price: 100,
        #                 max_price: 100000,
        #                 increment_size: 0.0001,
        #                 increment_price: 0.05,
        #                 active: True,
        #                 created_at: "2019-12-09T07:15:54.537Z",
        #                 updated_at: "2019-12-09T07:15:54.537Z"
        #             },
        #         },
        #         config: {tiers: 10},
        #         status: True
        #     }
        #
        pairs = self.safe_value(response, 'pairs', {})
        keys = list(pairs.keys())
        result = []
        for i in range(0, len(keys)):
            key = keys[i]
            market = pairs[key]
            baseId = self.safe_string(market, 'pair_base')
            quoteId = self.safe_string(market, 'pair_2')
            base = self.common_currency_code(baseId.upper())
            quote = self.common_currency_code(quoteId.upper())
            result.append({
                'id': self.safe_string(market, 'name'),
                'symbol': base + '/' + quote,
                'base': base,
                'quote': quote,
                'settle': None,
                'baseId': baseId,
                'quoteId': quoteId,
                'settleId': None,
                'type': 'spot',
                'spot': True,
                'margin': False,
                'swap': False,
                'future': False,
                'option': False,
                'active': self.safe_value(market, 'active'),
                'contract': False,
                'linear': None,
                'inverse': None,
                'contractSize': None,
                'expiry': None,
                'expiryDatetime': None,
                'strike': None,
                'optionType': None,
                'precision': {
                    'amount': self.safe_number(market, 'increment_size'),
                    'price': self.safe_number(market, 'increment_price'),
                },
                'limits': {
                    'leverage': {
                        'min': None,
                        'max': None,
                    },
                    'amount': {
                        'min': self.safe_number(market, 'min_size'),
                        'max': self.safe_number(market, 'max_size'),
                    },
                    'price': {
                        'min': self.safe_number(market, 'min_price'),
                        'max': self.safe_number(market, 'max_price'),
                    },
                    'cost': {
                        'min': None,
                        'max': None,
                    },
                },
                'info': market,
            })
        return result

    async def fetch_currencies(self, params={}):
        response = await self.publicGetConstants(params)
        #
        #     {
        #         "coins":{
        #             "bch":{
        #                 "id":4,
        #                 "fullname":"Bitcoin Cash",
        #                 "symbol":"bch",
        #                 "active":true,
        #                 "verified":true,
        #                 "allow_deposit":true,
        #                 "allow_withdrawal":true,
        #                 "withdrawal_fee":0.0001,
        #                 "min":0.001,
        #                 "max":100000,
        #                 "increment_unit":0.001,
        #                 "logo":"https://bitholla.s3.ap-northeast-2.amazonaws.com/icon/BCH-hollaex-asset-01.svg",
        #                 "code":"bch",
        #                 "is_public":true,
        #                 "meta":{},
        #                 "estimated_price":null,
        #                 "description":null,
        #                 "type":"blockchain",
        #                 "network":null,
        #                 "standard":null,
        #                 "issuer":"HollaEx",
        #                 "withdrawal_fees":null,
        #                 "created_at":"2019-08-09T10:45:43.367Z",
        #                 "updated_at":"2021-12-13T03:08:32.372Z",
        #                 "created_by":1,
        #                 "owner_id":1
        #             },
        #         },
        #         "network":"https://api.hollaex.network"
        #     }
        #
        coins = self.safe_value(response, 'coins', {})
        keys = list(coins.keys())
        result = {}
        for i in range(0, len(keys)):
            key = keys[i]
            currency = coins[key]
            id = self.safe_string(currency, 'symbol')
            numericId = self.safe_integer(currency, 'id')
            code = self.safe_currency_code(id)
            name = self.safe_string(currency, 'fullname')
            depositEnabled = self.safe_value(currency, 'allow_deposit')
            withdrawEnabled = self.safe_value(currency, 'allow_withdrawal')
            isActive = self.safe_value(currency, 'active')
            active = isActive and depositEnabled and withdrawEnabled
            fee = self.safe_number(currency, 'withdrawal_fee')
            precision = self.safe_number(currency, 'increment_unit')
            withdrawalLimits = self.safe_value(currency, 'withdrawal_limits', [])
            result[code] = {
                'id': id,
                'numericId': numericId,
                'code': code,
                'info': currency,
                'name': name,
                'active': active,
                'deposit': depositEnabled,
                'withdraw': withdrawEnabled,
                'fee': fee,
                'precision': precision,
                'limits': {
                    'amount': {
                        'min': self.safe_number(currency, 'min'),
                        'max': self.safe_number(currency, 'max'),
                    },
                    'withdraw': {
                        'min': None,
                        'max': self.safe_value(withdrawalLimits, 0),
                    },
                },
            }
        return result

    async def fetch_order_books(self, symbols=None, limit=None, params={}):
        await self.load_markets()
        response = await self.publicGetOrderbooks(params)
        result = {}
        marketIds = list(response.keys())
        for i in range(0, len(marketIds)):
            marketId = marketIds[i]
            orderbook = response[marketId]
            symbol = self.safe_symbol(marketId, None, '-')
            timestamp = self.parse8601(self.safe_string(orderbook, 'timestamp'))
            result[symbol] = self.parse_order_book(response[marketId], timestamp)
        return result

    async def fetch_order_book(self, symbol, limit=None, params={}):
        await self.load_markets()
        marketId = self.market_id(symbol)
        request = {
            'symbol': marketId,
        }
        response = await self.publicGetOrderbooks(self.extend(request, params))
        #
        #     {
        #         "btc-usdt": {
        #             "bids": [
        #                 [8836.4, 1.022],
        #                 [8800, 0.0668],
        #                 [8797.75, 0.2398],
        #             ],
        #             "asks": [
        #                 [8839.35, 1.5334],
        #                 [8852.6, 0.0579],
        #                 [8860.45, 0.1815],
        #             ],
        #             "timestamp": "2020-03-03T02:27:25.147Z"
        #         },
        #         "eth-usdt": {},
        #         # ...
        #     }
        #
        orderbook = self.safe_value(response, marketId)
        timestamp = self.parse8601(self.safe_string(orderbook, 'timestamp'))
        return self.parse_order_book(orderbook, symbol, timestamp)

    async def fetch_ticker(self, symbol, params={}):
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        response = await self.publicGetTicker(self.extend(request, params))
        #
        #     {
        #         open: 8615.55,
        #         close: 8841.05,
        #         high: 8921.1,
        #         low: 8607,
        #         last: 8841.05,
        #         volume: 20.2802,
        #         timestamp: '2020-03-03T03:11:18.964Z'
        #     }
        #
        return self.parse_ticker(response, market)

    async def fetch_tickers(self, symbols=None, params={}):
        await self.load_markets()
        response = await self.publicGetTickers(self.extend(params))
        #
        #     {
        #         "bch-usdt": {
        #             "time": "2020-03-02T04:29:45.011Z",
        #             "open": 341.65,
        #             "close":337.9,
        #             "high":341.65,
        #             "low":337.3,
        #             "last":337.9,
        #             "volume":0.054,
        #             "symbol":"bch-usdt"
        #         },
        #         # ...
        #     }
        #
        return self.parse_tickers(response, symbols)

    def parse_tickers(self, response, symbols=None, params={}):
        result = {}
        keys = list(response.keys())
        for i in range(0, len(keys)):
            key = keys[i]
            ticker = response[key]
            marketId = self.safe_string(ticker, 'symbol', key)
            market = self.safe_market(marketId, None, '-')
            symbol = market['symbol']
            result[symbol] = self.extend(self.parse_ticker(ticker, market), params)
        return self.filter_by_array(result, 'symbol', symbols)

    def parse_ticker(self, ticker, market=None):
        #
        # fetchTicker
        #
        #     {
        #         open: 8615.55,
        #         close: 8841.05,
        #         high: 8921.1,
        #         low: 8607,
        #         last: 8841.05,
        #         volume: 20.2802,
        #         timestamp: '2020-03-03T03:11:18.964Z',
        #     }
        #
        # fetchTickers
        #
        #     {
        #         "time": "2020-03-02T04:29:45.011Z",
        #         "open": 341.65,
        #         "close": 337.9,
        #         "high": 341.65,
        #         "low": 337.3,
        #         "last": 337.9,
        #         "volume": 0.054,
        #         "symbol": "bch-usdt"
        #     }
        #
        marketId = self.safe_string(ticker, 'symbol')
        market = self.safe_market(marketId, market, '-')
        symbol = market['symbol']
        timestamp = self.parse8601(self.safe_string_2(ticker, 'time', 'timestamp'))
        close = self.safe_string(ticker, 'close')
        return self.safe_ticker({
            'symbol': symbol,
            'info': ticker,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'high': self.safe_string(ticker, 'high'),
            'low': self.safe_string(ticker, 'low'),
            'bid': None,
            'bidVolume': None,
            'ask': None,
            'askVolume': None,
            'vwap': None,
            'open': self.safe_string(ticker, 'open'),
            'close': close,
            'last': self.safe_string(ticker, 'last', close),
            'previousClose': None,
            'change': None,
            'percentage': None,
            'average': None,
            'baseVolume': self.safe_string(ticker, 'volume'),
            'quoteVolume': None,
        }, market, False)

    async def fetch_trades(self, symbol, since=None, limit=None, params={}):
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        response = await self.publicGetTrades(self.extend(request, params))
        #
        #     {
        #         "btc-usdt": [
        #             {
        #                 "size": 0.5,
        #                 "price": 8830,
        #                 "side": "buy",
        #                 "timestamp": "2020-03-03T04:44:33.034Z"
        #             },
        #             # ...
        #         ]
        #     }
        #
        trades = self.safe_value(response, market['id'], [])
        return self.parse_trades(trades, market, since, limit)

    def parse_trade(self, trade, market=None):
        #
        # fetchTrades(public)
        #
        #     {
        #         "size": 0.5,
        #         "price": 8830,
        #         "side": "buy",
        #         "timestamp": "2020-03-03T04:44:33.034Z"
        #     }
        #
        # fetchMyTrades(private)
        #  {
        #      "side":"sell",
        #      "symbol":"doge-usdt",
        #      "size":70,
        #      "price":0.147411,
        #      "timestamp":"2022-01-26T17:53:34.650Z",
        #      "order_id":"cba78ecb-4187-4da2-9d2f-c259aa693b5a",
        #      "fee":0.01031877,"fee_coin":"usdt"
        #  }
        #
        marketId = self.safe_string(trade, 'symbol')
        market = self.safe_market(marketId, market, '-')
        symbol = market['symbol']
        datetime = self.safe_string(trade, 'timestamp')
        timestamp = self.parse8601(datetime)
        side = self.safe_string(trade, 'side')
        orderId = self.safe_string(trade, 'order_id')
        priceString = self.safe_string(trade, 'price')
        amountString = self.safe_string(trade, 'size')
        feeCostString = self.safe_string(trade, 'fee')
        fee = None
        if feeCostString is not None:
            fee = {
                'cost': feeCostString,
                'currency': market['quote'],
            }
        return self.safe_trade({
            'info': trade,
            'id': None,
            'timestamp': timestamp,
            'datetime': datetime,
            'symbol': symbol,
            'order': orderId,
            'type': None,
            'side': side,
            'takerOrMaker': None,
            'price': priceString,
            'amount': amountString,
            'cost': None,
            'fee': fee,
        }, market)

    async def fetch_trading_fees(self, params={}):
        await self.load_markets()
        response = await self.publicGetTiers(params)
        #
        #     {
        #         '1': {
        #             id: '1',
        #             name: 'Silver',
        #             icon: '',
        #             description: 'Your crypto journey starts here! Make your first deposit to start trading, and verify your account to level up!',
        #             deposit_limit: '0',
        #             withdrawal_limit: '1000',
        #             fees: {
        #                 maker: {
        #                     'eth-btc': '0.1',
        #                     'ada-usdt': '0.1',
        #                     ...
        #                 },
        #                 taker: {
        #                     'eth-btc': '0.1',
        #                     'ada-usdt': '0.1',
        #                     ...
        #                 }
        #             },
        #             note: '<ul>\n<li>Login and verify email</li>\n</ul>\n',
        #             created_at: '2021-03-22T03:51:39.129Z',
        #             updated_at: '2021-11-01T02:51:56.214Z'
        #         },
        #         ...
        #     }
        #
        firstTier = self.safe_value(response, '1', {})
        fees = self.safe_value(firstTier, 'fees', {})
        makerFees = self.safe_value(fees, 'maker', {})
        takerFees = self.safe_value(fees, 'taker', {})
        result = {}
        for i in range(0, len(self.symbols)):
            symbol = self.symbols[i]
            market = self.market(symbol)
            makerString = self.safe_string(makerFees, market['id'])
            takerString = self.safe_string(takerFees, market['id'])
            result[symbol] = {
                'info': fees,
                'symbol': symbol,
                'maker': self.parse_number(Precise.string_div(makerString, '100')),
                'taker': self.parse_number(Precise.string_div(takerString, '100')),
                'percentage': True,
                'tierBased': True,
            }
        return result

    async def fetch_ohlcv(self, symbol, timeframe='1h', since=None, limit=None, params={}):
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
            'resolution': self.timeframes[timeframe],
        }
        duration = self.parse_timeframe(timeframe)
        if since is None:
            if limit is None:
                raise ArgumentsRequired(self.id + " fetchOHLCV() requires a 'since' or a 'limit' argument")
            else:
                end = self.seconds()
                start = end - duration * limit
                request['to'] = end
                request['from'] = start
        else:
            if limit is None:
                request['from'] = int(since / 1000)
                request['to'] = self.seconds()
            else:
                start = int(since / 1000)
                request['from'] = start
                request['to'] = self.sum(start, duration * limit)
        response = await self.publicGetChart(self.extend(request, params))
        #
        #     [
        #         {
        #             "time":"2020-03-02T20:00:00.000Z",
        #             "close":8872.1,
        #             "high":8872.1,
        #             "low":8858.6,
        #             "open":8858.6,
        #             "symbol":"btc-usdt",
        #             "volume":1.2922
        #         },
        #     ]
        #
        return self.parse_ohlcvs(response, market, timeframe, since, limit)

    def parse_ohlcv(self, response, market=None, timeframe='1h', since=None, limit=None):
        #
        #     {
        #         "time":"2020-03-02T20:00:00.000Z",
        #         "close":8872.1,
        #         "high":8872.1,
        #         "low":8858.6,
        #         "open":8858.6,
        #         "symbol":"btc-usdt",
        #         "volume":1.2922
        #     }
        #
        return [
            self.parse8601(self.safe_string(response, 'time')),
            self.safe_number(response, 'open'),
            self.safe_number(response, 'high'),
            self.safe_number(response, 'low'),
            self.safe_number(response, 'close'),
            self.safe_number(response, 'volume'),
        ]

    def parse_balance(self, response):
        timestamp = self.parse8601(self.safe_string(response, 'updated_at'))
        result = {
            'info': response,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
        }
        currencyIds = list(self.currencies_by_id.keys())
        for i in range(0, len(currencyIds)):
            currencyId = currencyIds[i]
            code = self.safe_currency_code(currencyId)
            account = self.account()
            account['free'] = self.safe_string(response, currencyId + '_available')
            account['total'] = self.safe_string(response, currencyId + '_balance')
            result[code] = account
        return self.safe_balance(result)

    async def fetch_balance(self, params={}):
        await self.load_markets()
        response = await self.privateGetUserBalance(params)
        #
        #     {
        #         "updated_at": "2020-03-02T22:27:38.428Z",
        #         "btc_balance": 0,
        #         "btc_pending": 0,
        #         "btc_available": 0,
        #         "eth_balance": 0,
        #         "eth_pending": 0,
        #         "eth_available": 0,
        #         # ...
        #     }
        #
        return self.parse_balance(response)

    async def fetch_open_order(self, id, symbol=None, params={}):
        await self.load_markets()
        request = {
            'order_id': id,
        }
        response = await self.privateGetOrder(self.extend(request, params))
        #
        #     {
        #         "id": "string",
        #         "side": "sell",
        #         "symbol": "xht-usdt",
        #         "size": 0.1,
        #         "filled": 0,
        #         "stop": null,
        #         "fee": 0,
        #         "fee_coin": "usdt",
        #         "type": "limit",
        #         "price": 1.09,
        #         "status": "new",
        #         "created_by": 116,
        #         "created_at": "2021-02-17T02:32:38.910Z",
        #         "updated_at": "2021-02-17T02:32:38.910Z",
        #         "User": {
        #             "id": 116,
        #             "email": "fight@club.com",
        #             "username": "narrator",
        #             "exchange_id": 176
        #         }
        #     }
        #
        return self.parse_order(response)

    async def fetch_open_orders(self, symbol=None, since=None, limit=None, params={}):
        request = {
            'open': True,
        }
        return await self.fetch_orders(symbol, since, limit, self.extend(request, params))

    async def fetch_closed_orders(self, symbol=None, since=None, limit=None, params={}):
        request = {
            'open': False,
        }
        return await self.fetch_orders(symbol, since, limit, self.extend(request, params))

    async def fetch_order(self, id, symbol=None, params={}):
        await self.load_markets()
        request = {
            'order_id': id,
        }
        response = await self.privateGetOrder(self.extend(request, params))
        #             {
        #                 "id": "string",
        #                 "side": "sell",
        #                 "symbol": "xht-usdt",
        #                 "size": 0.1,
        #                 "filled": 0,
        #                 "stop": null,
        #                 "fee": 0,
        #                 "fee_coin": "usdt",
        #                 "type": "limit",
        #                 "price": 1.09,
        #                 "status": "new",
        #                 "created_by": 116,
        #                 "created_at": "2021-02-17T02:32:38.910Z",
        #                 "updated_at": "2021-02-17T02:32:38.910Z",
        #                 "User": {
        #                     "id": 116,
        #                     "email": "fight@club.com",
        #                     "username": "narrator",
        #                     "exchange_id": 176
        #                 }
        #             }
        order = response
        if order is None:
            raise OrderNotFound(self.id + ' fetchOrder() could not find order id ' + id)
        return self.parse_order(order)

    async def fetch_orders(self, symbol=None, since=None, limit=None, params={}):
        await self.load_markets()
        market = None
        request = {
            # 'symbol': market['id'],
            # 'side': 'buy',  # 'sell'
            # 'status': 'new',  # 'filled', 'pfilled', 'canceled'
            # 'open': True,
            # 'limit': limit,  # default 50, max 100
            # 'page': 1,
            # 'order_by': 'created_at',  # id, ...
            # 'order': 'asc',  # 'desc'
            # 'start_date': self.iso8601(since),
            # 'end_date': self.iso8601(self.milliseconds()),
        }
        if symbol is not None:
            market = self.market(symbol)
            request['symbol'] = market['id']
        if since is not None:
            request['start_date'] = self.iso8601(since)
        if limit is not None:
            request['limit'] = limit  # default 50, max 100
        response = await self.privateGetOrders(self.extend(request, params))
        #
        #     {
        #         "count": 1,
        #         "data": [
        #             {
        #                 "id": "string",
        #                 "side": "sell",
        #                 "symbol": "xht-usdt",
        #                 "size": 0.1,
        #                 "filled": 0,
        #                 "stop": null,
        #                 "fee": 0,
        #                 "fee_coin": "usdt",
        #                 "type": "limit",
        #                 "price": 1.09,
        #                 "status": "new",
        #                 "created_by": 116,
        #                 "created_at": "2021-02-17T02:32:38.910Z",
        #                 "updated_at": "2021-02-17T02:32:38.910Z",
        #                 "User": {
        #                     "id": 116,
        #                     "email": "fight@club.com",
        #                     "username": "narrator",
        #                     "exchange_id": 176
        #                 }
        #             }
        #         ]
        #     }
        #
        data = self.safe_value(response, 'data', [])
        return self.parse_orders(data, market, since, limit)

    def parse_order_status(self, status):
        statuses = {
            'new': 'open',
            'pfilled': 'open',
            'filled': 'closed',
            'canceled': 'canceled',
        }
        return self.safe_string(statuses, status, status)

    def parse_order(self, order, market=None):
        #
        # createOrder, fetchOpenOrder, fetchOpenOrders
        #
        #     {
        #         "id": "string",
        #         "side": "sell",
        #         "symbol": "xht-usdt",
        #         "size": 0.1,
        #         "filled": 0,
        #         "stop": null,
        #         "fee": 0,
        #         "fee_coin": "usdt",
        #         "type": "limit",
        #         "price": 1.09,
        #         "status": "new",
        #         "created_by": 116,
        #         "created_at": "2021-02-17T02:32:38.910Z",
        #         "updated_at": "2021-02-17T02:32:38.910Z",
        #         "User": {
        #             "id": 116,
        #             "email": "fight@club.com",
        #             "username": "narrator",
        #             "exchange_id": 176
        #         },
        #         "fee_structure": {
        #             "maker": 0.2,
        #             "taker": 0.2
        #         },
        #     }
        #
        marketId = self.safe_string(order, 'symbol')
        symbol = self.safe_symbol(marketId, market, '-')
        id = self.safe_string(order, 'id')
        timestamp = self.parse8601(self.safe_string(order, 'created_at'))
        type = self.safe_string(order, 'type')
        side = self.safe_string(order, 'side')
        price = self.safe_string(order, 'price')
        amount = self.safe_string(order, 'size')
        filled = self.safe_string(order, 'filled')
        status = self.parse_order_status(self.safe_string(order, 'status'))
        return self.safe_order({
            'id': id,
            'clientOrderId': None,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'lastTradeTimestamp': None,
            'status': status,
            'symbol': symbol,
            'type': type,
            'timeInForce': None,
            'postOnly': None,
            'side': side,
            'price': price,
            'stopPrice': None,
            'amount': amount,
            'filled': filled,
            'remaining': None,
            'cost': None,
            'trades': None,
            'fee': None,
            'info': order,
            'average': None,
        }, market)

    async def create_order(self, symbol, type, side, amount, price=None, params={}):
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
            'side': side,
            'size': self.normalize_number_if_needed(amount),
            'type': type,
            # 'stop': float(self.price_to_precision(symbol, stopPrice)),
            # 'meta': {},  # other options such as post_only
        }
        if type != 'market':
            convertedPrice = float(self.price_to_precision(symbol, price))
            request['price'] = self.normalize_number_if_needed(convertedPrice)
        stopPrice = self.safe_number_2(params, 'stopPrice', 'stop')
        if stopPrice is not None:
            request['stop'] = self.normalize_number_if_needed(float(self.price_to_precision(symbol, stopPrice)))
            params = self.omit(params, ['stopPrice', 'stop'])
        response = await self.privatePostOrder(self.extend(request, params))
        #
        #     {
        #         "fee": 0,
        #         "meta": {},
        #         "symbol": "xht-usdt",
        #         "side": "sell",
        #         "size": 0.1,
        #         "type": "limit",
        #         "price": 1,
        #         "fee_structure": {
        #             "maker": 0.2,
        #             "taker": 0.2
        #         },
        #         "fee_coin": "usdt",
        #         "id": "string",
        #         "created_by": 116,
        #         "filled": 0,
        #         "status": "new",
        #         "updated_at": "2021-02-17T03:03:19.231Z",
        #         "created_at": "2021-02-17T03:03:19.231Z",
        #         "stop": null
        #     }
        #
        return self.parse_order(response, market)

    async def cancel_order(self, id, symbol=None, params={}):
        await self.load_markets()
        request = {
            'order_id': id,
        }
        response = await self.privateDeleteOrder(self.extend(request, params))
        #
        #     {
        #         "title": "string",
        #         "symbol": "xht-usdt",
        #         "side": "sell",
        #         "size": 1,
        #         "type": "limit",
        #         "price": 0.1,
        #         "id": "string",
        #         "created_by": 34,
        #         "filled": 0
        #     }
        #
        return self.parse_order(response)

    async def cancel_all_orders(self, symbol=None, params={}):
        if symbol is None:
            raise ArgumentsRequired(self.id + " cancelAllOrders() requires a 'symbol' argument")
        await self.load_markets()
        request = {}
        market = None
        market = self.market(symbol)
        request['symbol'] = market['id']
        response = await self.privateDeleteOrderAll(self.extend(request, params))
        #
        #     [
        #         {
        #             "title": "string",
        #             "symbol": "xht-usdt",
        #             "side": "sell",
        #             "size": 1,
        #             "type": "limit",
        #             "price": 0.1,
        #             "id": "string",
        #             "created_by": 34,
        #             "filled": 0
        #         }
        #     ]
        #
        return self.parse_orders(response, market)

    async def fetch_my_trades(self, symbol=None, since=None, limit=None, params={}):
        await self.load_markets()
        request = {
            # 'symbol': market['id'],
            # 'limit': 50,  # default 50, max 100
            # 'page': 1,  # page of data to retrieve
            # 'order_by': 'timestamp',  # field to order data
            # 'order': 'asc',  # asc or desc
            # 'start_date': 123,  # starting date of queried data
            # 'end_date': 321,  # ending date of queried data
        }
        market = None
        if symbol is not None:
            market = self.market(symbol)
            request['symbol'] = market['id']
        if limit is not None:
            request['limit'] = limit  # default 50, max 100
        if since is not None:
            request['start_date'] = self.iso8601(since)
        response = await self.privateGetUserTrades(self.extend(request, params))
        #
        #     {
        #         "count": 1,
        #         "data": [
        #             {
        #                 "side": "buy",
        #                 "symbol": "eth-usdt",
        #                 "size": 0.086,
        #                 "price": 226.19,
        #                 "timestamp": "2020-03-03T08:03:55.459Z",
        #                 "fee": 0.1
        #             }
        #         ]
        #     }
        #
        data = self.safe_value(response, 'data', [])
        return self.parse_trades(data, market, since, limit)

    def parse_deposit_address(self, depositAddress, currency=None):
        #
        #     {
        #         "currency":"usdt",
        #         "address":"TECLD9XBH31XpyykdHU3uEAeUK7E6Lrmik",
        #         "network":"trx",
        #         "standard":null,
        #         "is_valid":true,
        #         "created_at":"2021-05-12T02:43:05.446Z"
        #     }
        #
        address = self.safe_string(depositAddress, 'address')
        tag = None
        if address is not None:
            parts = address.split(':')
            address = self.safe_string(parts, 0)
            tag = self.safe_string(parts, 1)
        self.check_address(address)
        currencyId = self.safe_string(depositAddress, 'currency')
        currency = self.safe_currency(currencyId, currency)
        network = self.safe_string(depositAddress, 'network')
        return {
            'currency': currency['code'],
            'address': address,
            'tag': tag,
            'network': network,
            'info': depositAddress,
        }

    async def fetch_deposit_addresses(self, codes=None, params={}):
        await self.load_markets()
        network = self.safe_string(params, 'network')
        params = self.omit(params, 'network')
        response = await self.privateGetUser(params)
        #
        #     {
        #         "id":620,
        #         "email":"igor.kroitor@gmail.com",
        #         "full_name":"",
        #         "gender":false,
        #         "nationality":"",
        #         "dob":null,
        #         "phone_number":"",
        #         "address":{"city":"","address":"","country":"","postal_code":""},
        #         "id_data":{"note":"","type":"","number":"","status":0,"issued_date":"","expiration_date":""},
        #         "bank_account":[],
        #         "crypto_wallet":{},
        #         "verification_level":1,
        #         "email_verified":true,
        #         "otp_enabled":true,
        #         "activated":true,
        #         "username":"igor.kroitor",
        #         "affiliation_code":"QSWA6G",
        #         "settings":{
        #             "chat":{"set_username":false},
        #             "risk":{"popup_warning":false,"order_portfolio_percentage":20},
        #             "audio":{"public_trade":false,"order_completed":true,"order_partially_completed":true},
        #             "language":"en",
        #             "interface":{"theme":"white","order_book_levels":10},
        #             "notification":{"popup_order_completed":true,"popup_order_confirmation":true,"popup_order_partially_filled":true}
        #         },
        #         "affiliation_rate":0,
        #         "network_id":10620,
        #         "discount":0,
        #         "created_at":"2021-03-24T02:37:57.379Z",
        #         "updated_at":"2021-03-24T02:37:57.379Z",
        #         "balance":{
        #             "btc_balance":0,
        #             "btc_available":0,
        #             "eth_balance":0.000914,
        #             "eth_available":0.000914,
        #             "updated_at":"2020-03-04T04:03:27.174Z
        #         "},
        #         "wallet":[
        #             {"currency":"usdt","address":"TECLD9XBH31XpyykdHU3uEAeUK7E6Lrmik","network":"trx","standard":null,"is_valid":true,"created_at":"2021-05-12T02:43:05.446Z"},
        #             {"currency":"xrp","address":"rGcSzmuRx8qngPRnrvpCKkP9V4njeCPGCv:286741597","network":"xrp","standard":null,"is_valid":true,"created_at":"2021-05-12T02:49:01.273Z"}
        #         ]
        #     }
        #
        wallet = self.safe_value(response, 'wallet', [])
        addresses = wallet if (network is None) else self.filter_by(wallet, 'network', network)
        return self.parse_deposit_addresses(addresses, codes)

    async def fetch_deposits(self, code=None, since=None, limit=None, params={}):
        await self.load_markets()
        request = {
            # 'currency': currency['id'],
            # 'limit': 50,  # default 50, max 100
            # 'page': 1,  # page of data to retrieve
            # 'order_by': 'timestamp',  # field to order data
            # 'order': 'asc',  # asc or desc
            # 'start_date': 123,  # starting date of queried data
            # 'end_date': 321,  # ending date of queried data
        }
        currency = None
        if code is not None:
            currency = self.currency(code)
            request['currency'] = currency['id']
        if limit is not None:
            request['limit'] = limit  # default 50, max 100
        if since is not None:
            request['start_date'] = self.iso8601(since)
        response = await self.privateGetUserDeposits(self.extend(request, params))
        #
        #     {
        #         "count": 1,
        #         "data": [
        #             {
        #                 "id": 539,
        #                 "amount": 20,
        #                 "fee": 0,
        #                 "address": "0x5c0cc98270d7089408fcbcc8e2131287f5be2306",
        #                 "transaction_id": "0xd4006327a5ec2c41adbdcf566eaaba6597c3d45906abe78ea1a4a022647c2e28",
        #                 "status": True,
        #                 "dismissed": False,
        #                 "rejected": False,
        #                 "description": "",
        #                 "type": "deposit",
        #                 "currency": "usdt",
        #                 "created_at": "2020-03-03T07:56:36.198Z",
        #                 "updated_at": "2020-03-03T08:00:05.674Z",
        #                 "user_id": 620
        #             }
        #         ]
        #     }
        #
        data = self.safe_value(response, 'data', [])
        return self.parse_transactions(data, currency, since, limit)

    async def fetch_withdrawals(self, code=None, since=None, limit=None, params={}):
        await self.load_markets()
        request = {
            # 'currency': currency['id'],
            # 'limit': 50,  # default 50, max 100
            # 'page': 1,  # page of data to retrieve
            # 'order_by': 'timestamp',  # field to order data
            # 'order': 'asc',  # asc or desc
            # 'start_date': 123,  # starting date of queried data
            # 'end_date': 321,  # ending date of queried data
        }
        currency = None
        if code is not None:
            currency = self.currency(code)
            request['currency'] = currency['id']
        if limit is not None:
            request['limit'] = limit  # default 50, max 100
        if since is not None:
            request['start_date'] = self.iso8601(since)
        response = await self.privateGetUserWithdrawals(self.extend(request, params))
        #
        #     {
        #         "count": 1,
        #         "data": [
        #             {
        #                 "id": 539,
        #                 "amount": 20,
        #                 "fee": 0,
        #                 "address": "0x5c0cc98270d7089408fcbcc8e2131287f5be2306",
        #                 "transaction_id": "0xd4006327a5ec2c41adbdcf566eaaba6597c3d45906abe78ea1a4a022647c2e28",
        #                 "status": True,
        #                 "dismissed": False,
        #                 "rejected": False,
        #                 "description": "",
        #                 "type": "withdrawal",
        #                 "currency": "usdt",
        #                 "created_at": "2020-03-03T07:56:36.198Z",
        #                 "updated_at": "2020-03-03T08:00:05.674Z",
        #                 "user_id": 620
        #             }
        #         ]
        #     }
        #
        data = self.safe_value(response, 'data', [])
        return self.parse_transactions(data, currency, since, limit)

    def parse_transaction(self, transaction, currency=None):
        #
        # fetchWithdrawals, fetchDeposits
        #
        #     {
        #         "id": 539,
        #         "amount": 20,
        #         "fee": 0,
        #         "address": "0x5c0cc98270d7089408fcbcc8e2131287f5be2306",
        #         "transaction_id": "0xd4006327a5ec2c41adbdcf566eaaba6597c3d45906abe78ea1a4a022647c2e28",
        #         "status": True,
        #         "dismissed": False,
        #         "rejected": False,
        #         "description": "",
        #         "type": "withdrawal",
        #         "currency": "usdt",
        #         "created_at": "2020-03-03T07:56:36.198Z",
        #         "updated_at": "2020-03-03T08:00:05.674Z",
        #         "user_id": 620
        #     }
        #
        # withdraw
        #
        #     {
        #         message: 'Withdrawal request is in the queue and will be processed.',
        #         transaction_id: '1d1683c3-576a-4d53-8ff5-27c93fd9758a',
        #         amount: 1,
        #         currency: 'xht',
        #         fee: 0,
        #         fee_coin: 'xht'
        #     }
        #
        id = self.safe_string(transaction, 'id')
        txid = self.safe_string(transaction, 'transaction_id')
        timestamp = self.parse8601(self.safe_string(transaction, 'created_at'))
        updated = self.parse8601(self.safe_string(transaction, 'updated_at'))
        type = self.safe_string(transaction, 'type')
        amount = self.safe_number(transaction, 'amount')
        address = self.safe_string(transaction, 'address')
        addressTo = None
        addressFrom = None
        tag = None
        tagTo = None
        tagFrom = None
        if address is not None:
            parts = address.split(':')
            address = self.safe_string(parts, 0)
            tag = self.safe_string(parts, 1)
            addressTo = address
            tagTo = tag
        currencyId = self.safe_string(transaction, 'currency')
        currency = self.safe_currency(currencyId, currency)
        status = self.safe_value(transaction, 'status')
        dismissed = self.safe_value(transaction, 'dismissed')
        rejected = self.safe_value(transaction, 'rejected')
        if status:
            status = 'ok'
        elif dismissed:
            status = 'canceled'
        elif rejected:
            status = 'failed'
        else:
            status = 'pending'
        feeCurrencyId = self.safe_string(transaction, 'fee_coin')
        feeCurrencyCode = self.safe_currency_code(feeCurrencyId, currency)
        fee = {
            'currency': feeCurrencyCode,
            'cost': self.safe_number(transaction, 'fee'),
        }
        return {
            'info': transaction,
            'id': id,
            'txid': txid,
            'timestamp': timestamp,
            'datetime': self.iso8601(timestamp),
            'network': None,
            'addressFrom': addressFrom,
            'address': address,
            'addressTo': addressTo,
            'tagFrom': tagFrom,
            'tag': tag,
            'tagTo': tagTo,
            'type': type,
            'amount': amount,
            'currency': currency['code'],
            'status': status,
            'updated': updated,
            'fee': fee,
        }

    async def withdraw(self, code, amount, address, tag=None, params={}):
        tag, params = self.handle_withdraw_tag_and_params(tag, params)
        self.check_address(address)
        await self.load_markets()
        currency = self.currency(code)
        if tag is not None:
            address += ':' + tag
        request = {
            'currency': currency['id'],
            'amount': amount,
            'address': address,
        }
        network = self.safe_string(params, 'network')
        if network is not None:
            request['network'] = network
        response = await self.privatePostUserWithdrawal(self.extend(request, params))
        #
        #     {
        #         message: 'Withdrawal request is in the queue and will be processed.',
        #         transaction_id: '1d1683c3-576a-4d53-8ff5-27c93fd9758a',
        #         amount: 1,
        #         currency: 'xht',
        #         fee: 0,
        #         fee_coin: 'xht'
        #     }
        #
        return self.parse_transaction(response, currency)

    def normalize_number_if_needed(self, number):
        if number % 1 == 0:
            number = int(number)
        return number

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        query = self.omit(params, self.extract_params(path))
        path = '/' + self.version + '/' + self.implode_params(path, params)
        if (method == 'GET') or (method == 'DELETE'):
            if query:
                path += '?' + self.urlencode(query)
        url = self.urls['api']['rest'] + path
        if api == 'private':
            self.check_required_credentials()
            defaultExpires = self.safe_integer_2(self.options, 'api-expires', 'expires', int(self.timeout / 1000))
            expires = self.sum(self.seconds(), defaultExpires)
            expiresString = str(expires)
            auth = method + path + expiresString
            headers = {
                'api-key': self.apiKey,
                'api-expires': expiresString,
            }
            if method == 'POST':
                headers['Content-type'] = 'application/json'
                if query:
                    body = self.json(query)
                    auth += body
            signature = self.hmac(self.encode(auth), self.encode(self.secret))
            headers['api-signature'] = signature
        return {'url': url, 'method': method, 'body': body, 'headers': headers}

    def handle_errors(self, code, reason, url, method, headers, body, response, requestHeaders, requestBody):
        if response is None:
            return
        if (code >= 400) and (code <= 503):
            #
            #  {"message": "Invalid token"}
            #
            feedback = self.id + ' ' + body
            message = self.safe_string(response, 'message')
            self.throw_broadly_matched_exception(self.exceptions['broad'], message, feedback)
            status = str(code)
            self.throw_exactly_matched_exception(self.exceptions['exact'], status, feedback)
