#cheese

import os
import json

from Cheese.resourceManager import ResMan

"""
File generated by Cheese Framework

class that stores Cheese Application settings
"""

class Settings:

    settings = {}
    adminSettings = {}

    # load settings
    @staticmethod 
    def loadSettings():
        Settings.settings = Settings.loadJson()
        for key in Settings.settings.keys():
            setattr(Settings, key, Settings.settings[key])

        Settings.activeLicense = "None"

        with open(os.path.join(ResMan.root(), "adminSettings.json"), "r") as f:
            Settings.adminSettings = json.loads(f.read())

    @staticmethod
    def loadJson():
        with open(os.path.join(ResMan.root(), "appSettings.json"), "r") as f:
            ret = json.loads(f.read())
        return ret

    @staticmethod
    def saveJson(jsonConf):
        with open(os.path.join(ResMan.root(), "appSettings.json"), "w") as f:
            f.write(json.dumps(jsonConf))

    @staticmethod
    def loadSecrets(secrets):
        errors = []
        for key in Settings.__dict__:
            value = str(getattr(Settings, key))
            if (not value.startswith("$")): continue

            if (value[1:] not in secrets.keys()):
                errors.append((key, value))
            else:
                setattr(Settings, key, secrets[key])

        if (len(errors) > 0):
            raise KeyError(*errors)
