from mpi4py import MPI

comm = MPI.COMM_WORLD
rank_in_world = comm.Get_rank()

size_ = comm.Get_size()
master = 0
m      = 8

a = [0]*m

if rank_in_world == 1:
    a[:] = 1
if rank_in_world == 2:
    a[:] = 2

key = rank_in_world
if rank_in_world == 1:
    key = -1
if rank_in_world == 2:
    key = -1

two   = 2
color = rank_in_world % two

newcomm = comm.Split(color, key)

# Broadcast of the message by the rank process master of
# each communicator to the processes of its group
newcomm.bcast(a, master)

print("> processor ", rank_in_world, " has a = ", a)

# Destruction of the communicators
newcomm.Free()
