/**
 * Constant for the "default" render location.
 *
 * All layout components (see {@link AbstractLayout}) must
 * support this render location.
 *
 * @type {string}
 */
export const RENDER_LOCATION_DEFAULT = 'default'

/**
 * Constant for the "left" render location.
 *
 * @type {string}
 */
export const RENDER_LOCATION_LEFT = 'left'

/**
 * Constant for the "right" render location.
 *
 * @type {string}
 */
export const RENDER_LOCATION_RIGHT = 'right'

/**
 * Constant for the "top" render location.
 *
 * @type {string}
 */
export const RENDER_LOCATION_TOP = 'top'

/**
 * Constant for the "center" render location.
 *
 * @type {string}
 */
export const RENDER_LOCATION_CENTER = 'center'

/**
 * Constant for the "bottom" render location.
 *
 * @type {string}
 */
export const RENDER_LOCATION_BOTTOM = 'bottom'

/**
 * Constant for single select selectMode for {@link AbstractFilterList}.
 *
 * @type {string}
 */
export const SINGLESELECT = 'single'

/**
 * Constant for multi-select selectMode for {@link AbstractFilterList}.
 *
 * @type {string}
 */
export const MULTISELECT = 'multi'

/**
 * Constant the "expandable" component group.
 *
 * Intended for the use case where you have expand
 * something, such as a search filter, that expands
 * the entire body in a floating panel to show results.
 *
 * @type {string}
 */
export const COMPONENT_GROUP_EXPANDABLE = 'expandable'

/**
 * Constant the "advanced" component group.
 *
 * Intended for _Show advanced filters_ / _Show all filters_ and
 * similar use cases.
 *
 * @type {string}
 */
export const COMPONENT_GROUP_ADVANCED = 'advanced'

// export const KEYBOARD_NAVIGATION_GROUP_KEY_UP_DOWN = 'key_up_down'
