# ESP32-RK3588 硬件连接指南

## 硬件清单

- RK3588开发板 (Rock 5B Plus)
- ESP32多功能扩展板 (带ADC/SPI/I2C接口)
- USB数据线 (用于连接ESP32和RK3588)
- 温度传感器 (模拟输出)
- 湿度传感器 (模拟输出)
- 继电器模块
- LED指示灯
- 按钮开关
- 杜邦线

## ESP32扩展板接口说明

根据您的ESP32扩展板，有以下接口可用：

### ADC接口区域 (自选做ADC)
- 多个ADC通道可用于连接模拟传感器
- 支持0-3.3V模拟信号输入

### SPI接口区域 (自选做SPI) 
- 可连接SPI设备如显示屏、存储器等
- 标准SPI引脚：MOSI、MISO、SCK、CS

### I2C接口区域 (自选做IIC)
- 可连接I2C设备如传感器模块、OLED显示屏等
- 标准I2C引脚：SDA、SCL

### GPIO接口
- 多个数字GPIO引脚可用于LED、继电器、按钮等

## 连接图

```
┌─────────────────┐                  ┌─────────────────────────────┐
│                 │                  │      ESP32扩展板             │
│     RK3588      │◄─── USB线 ─────►│                             │
│  (Rock 5B Plus) │                  │  ┌─────────────────────────┐ │
│                 │                  │  │      自选做ADC          │ │
└─────────────────┘                  │  │  ◄──── 温度传感器       │ │
                                     │  │  ◄──── 湿度传感器       │ │
                                     │  └─────────────────────────┘ │
                                     │                             │
                                     │  ┌─────────────────────────┐ │
                                     │  │      GPIO区域           │ │
                                     │  │  ────► LED指示灯        │ │
                                     │  │  ────► 继电器模块       │ │
                                     │  │  ◄──── 按钮开关         │ │
                                     │  └─────────────────────────┘ │
                                     │                             │
                                     │  ┌─────────────────────────┐ │
                                     │  │      自选做IIC          │ │
                                     │  │  (预留扩展)             │ │
                                     │  └─────────────────────────┘ │
                                     └─────────────────────────────┘
```

## 连接步骤

### 1. ESP32扩展板连接

#### ADC接口连接 (自选做ADC区域)
1. **温度传感器**:
   - 使用ADC接口中的任一通道 (建议使用标注的ADC引脚)
   - VCC连接到3.3V
   - GND连接到GND
   - 信号输出连接到选定的ADC引脚

2. **湿度传感器**:
   - 使用ADC接口中的另一通道
   - VCC连接到3.3V
   - GND连接到GND
   - 信号输出连接到选定的ADC引脚

#### GPIO接口连接
3. **LED指示灯**:
   - 使用GPIO区域的任一数字引脚
   - 正极通过220欧姆电阻连接到选定GPIO
   - 负极连接到GND

4. **继电器模块**:
   - 使用GPIO区域的任一数字引脚
   - VCC连接到5V (如果继电器需要5V) 或 3.3V
   - GND连接到GND
   - 信号输入连接到选定GPIO

5. **按钮开关**:
   - 使用GPIO区域的任一数字引脚
   - 一端连接到选定GPIO
   - 另一端连接到GND
   - (代码中启用内部上拉电阻)

#### I2C接口 (自选做IIC区域) - 预留扩展
- 可连接I2C传感器模块
- 如温湿度传感器模块 (DHT22, SHT30等)
- OLED显示屏等

### 2. ESP32与RK3588连接

1. 使用USB数据线将ESP32连接到RK3588的USB端口
2. 在RK3588上，ESP32将被识别为串口设备 `/dev/ttyUSB0`

## 硬件测试

### 1. 检查连接

在RK3588上运行以下命令检查ESP32是否被正确识别:

```bash
ls -la /dev/ttyUSB*
```

如果看到类似 `/dev/ttyUSB0` 的输出，则表示ESP32已被识别。

### 2. 设置权限

确保当前用户有权限访问串口设备:

```bash
sudo chmod 666 /dev/ttyUSB0
```

### 3. 测试通信

使用串口测试工具测试与ESP32的通信:

```bash
cd esp32-rk3588-sensor-system/rk3588_controller/tests
python3 serial_test.py
```

如果一切正常，您应该能看到ESP32的响应。

## 故障排除

### 1. 找不到串口设备

- 检查USB连接是否牢固
- 尝试使用不同的USB端口
- 检查ESP32是否通电

### 2. 无法通信

- 确认波特率设置为115200
- 检查串口权限
- 重启ESP32

### 3. 传感器读数异常

- 检查传感器连接
- 验证ADC引脚配置
- 检查电源电压