/*! 
* DevExtreme (Visualization Core Library)
* Version: 14.1.7
* Build date: Sep 22, 2014
*
* Copyright (c) 2012 - 2014 Developer Express Inc. ALL RIGHTS RESERVED
* EULA: https://www.devexpress.com/Support/EULAs/DevExtreme.xml
*/
"use strict";if(!DevExpress.MOD_VIZ_CORE){if(!window.DevExpress)throw Error("Required module is not referenced: core");(function(n){n.viz={}})(DevExpress),function(n){n.viz.core={}}(DevExpress),function(n){n.viz.core.errorsWarnings={E2001:"Invalid data source",E2002:"Axis type and data type are incompatible",E2003:'"{0}" data source field contains data of unsupported type',E2004:'"{0}" data source field is inconsistent',E2101:"Unknown series type was specified: {0}",E2102:"Ambiguity occurred between two value axes with the same name",E2103:'"{0}" option must be a function',E2104:"Invalid logarithm base",E2105:'Invalid value of a "{0}"',E2106:"Invalid visible range",E2201:"Invalid type of data source field",E2202:"Invalid scale {0} value",E2203:'The "{0}" field of the "selectedRange" configuration object is not valid',W2001:"{0} cannot be drawn because its container is invisible",W2002:"The {0} data field is absent",W2003:"Tick interval is too small",W2101:'"{0}" pane does not exist; "{1}" pane is used instead',W2102:'Value axis with the "{0}" name was created automatically',W2103:"Chart title was hidden due to container size",W2104:"Legend was hidden due to container size",W2105:'Title of "{0}" axis was hidden due to container size',W2106:'Labels of "{0}" axis were hidden due to container size',W2301:"Invalid value range"}}(DevExpress),function(n,t,i){var r=t.utils,f=Math,s=f.ceil,o=f.floor,e=f.abs,h=f.round,u=t.viz.core,c=2e3;u.outOfScreen={x:-1e3,y:-1e3},u.tickIntervalCalculator={_defaultNumberMultipliers:[1,2,3,5],_defaultGridSpacingFactor:30,_getCommonTickInterval:function(n,t){for(var r=0,f=!1,i,u=1;!f;u*=10)for(i=0;i<t.length;i++)if(r=t[i]*u,n<=r){f=!0;break}return r},_getNumericTickInterval:function(n,t){var f,i=0,e,o=!1,u;if(n>1)i=this._getCommonTickInterval(n,t);else if(n>0)for(i=1,f=.1;!o;f/=10)for(u=t.length-1;u>=0;u--){if(e=t[u]*f,n>e){o=!0;break}i=e}return r.adjustValue(i)},_getLogarithmicTickInterval:function(n,t){var i=0;return n!==0&&(i=this._getCommonTickInterval(n,t)),r.adjustValue(i)},_getDateTimeTickInterval:function(n,t){var e={millisecond:[1,2,5,10,25,100,250,300,500],second:[1,2,3,5,10,15,20,30],minute:[1,2,3,5,10,15,20,30],hour:[1,2,3,4,6,8,12],day:[1,2,3,5,7,10,14],month:[1,2,3,6]},h={},o,u,f,s,i;if(n>0&&n<1)return{milliseconds:1};if(n===0)return 0;for(u in e)if(e.hasOwnProperty(u))for(f=e[u],i=0;i<f.length;i++)if(n<=r.convertDateUnitToMilliseconds(u,f[i]))return h[u+"s"]=f[i],h;for(o=1;;o*=10)for(i=0;i<t.length;i++)if(s=o*t[i],n<=r.convertDateUnitToMilliseconds("year",s))return{years:s};return null},getTickInterval:function(n){var t=this,f=n.gridSpacingFactor||t._defaultGridSpacingFactor,i=n.numberMultipliers||t._defaultNumberMultipliers,e=n.businessDelta,r=n.screenDelta,u=r>0&&f<r?f*e/r:0;if(n.axisType==="logarithmic")return t._getLogarithmicTickInterval(u,i);switch(n.dataType){case"numeric":return t._getNumericTickInterval(u,i);case"datetime":return t._getDateTimeTickInterval(u,i)}return null}},u.minorTickIntervalCalculator={_defaultNumberMultipliers:[2,4,5,8,10],_defaultGridSpacingFactor:15,_getDateTimeTickInterval:function(n,t,i){for(var f,u=i.length-1;u>=0;u--)if(f=o(n/i[u]),t<=f)return r.convertMillisecondsToDateUnits(f);return 0},_getCommonTickInterval:function(n,t,i){for(var f,u=i.length-1;u>=0;u--)if(f=n/i[u],t<=f)return r.adjustValue(f);return 0},getTickInterval:function(n){var t=this,e=r.isDefined(n.gridSpacingFactor)?n.gridSpacingFactor:t._defaultGridSpacingFactor,u=n.numberMultipliers||t._defaultNumberMultipliers,i=n.businessDelta,f=e*i/n.screenDelta;if(n.axisType==="logarithmic")return t._getCommonTickInterval(i,f,u);switch(n.dataType){case"numeric":return t._getCommonTickInterval(i,f,u);case"datetime":return t._getDateTimeTickInterval(i,f,u)}return 0}},u.tickProvider={_appendFakeSVGElement:function(t,i,r){var f=n.extend({},r.textOptions,{rotate:0});return r.renderer.createText(i,u.outOfScreen.x+(r.translator.translate(t)||0),u.outOfScreen.y,f).append()},_getDistanceByAngle:function(n,t){return n/e(f.sin(t*(f.PI/180)))},_areDisplayValuesValid:function(n,t,i){var f=this,c=f._getTextFunc(i),l=i.textOptions&&r.isNumber(i.textOptions.rotate)?i.textOptions.rotate:0,a=f._appendFakeSVGElement(n,c(n),i),v=f._appendFakeSVGElement(t,c(t),i),u=a.getBBox(),o=v.getBBox(),s,h=i.translator;return s=l!==0?f._getDistanceByAngle(u.height,l)<=e(o.x-u.x):i.isHorizontal?h.getBusinessRange().invert?o.x+o.width<u.x:u.x+u.width<o.x:e(h.translate(n)-h.translate(t))>u.height,a.remove(),v.remove(),s},_removeInvalidDatesWithUnitBegining:function(n,t){n.length<=1||!t.setTicksAtUnitBeginning||!r.isDate(t.min)||this._areDisplayValuesValid(n[0],n[1],t)||n.splice(1,1)},_getValueSize:function(n,t){var e=this,i,o=t.textOptions?t.textOptions.rotate:0,h,u,c,l=e._getTextFunc(t),f;if(n.length===0)return 0;if(t.isRotate=r.isNumber(o)&&o!==0,t.isRotate||!t.isHorizontal)i=l(n[0]);else{for(i=[],f=0;f<n.length;f++)i.push(l(n[f]));i=i.join("\n")}return h=e._appendFakeSVGElement(i,i,t),u=h.getBBox(),c=t.isRotate?e._getDistanceByAngle(u.height,o):t.isHorizontal?u.width:u.height,h.remove(),s(c)},_adjustNumericTickValue:function(n,t,i){return r.isExponential(n)?r.adjustValue(n):r.applyPrecisionByMinDelta(i,t,n)},_generateStartTick:function(n,t){var e=this,c=0,h=t.min-t.max<0,i=t.min,s=r.isDate(t.min),u=s?r.convertDateTickIntervalToMilliseconds(n):n,f;for(t.axisType==="logarithmic"?i=r.raiseTo(o(r.adjustValue(r.getLog(t.min,t.base))/u*u),t.base):(i=o(t.min/u)*u,i=s?new Date(i):e._adjustNumericTickValue(i,u,t.min));h===i-t.min<0&&i!==t.min;)if(f=e._nextTick(i,n,t),f!==i)i=f;else return f;return i},_nextTick:function(n,t,i){var u,e,o=this;return i.axisType==="logarithmic"?(e=r.addInterval(r.adjustValue(r.getLog(n,i.base)),t,i.min>i.max),u=r.raiseTo(e,i.base),u=o._adjustNumericTickValue(u,t,f.min(i.min,i.max))):(u=r.addInterval(n,t,i.min>i.max),i.dataType==="numeric"&&(u=o._adjustNumericTickValue(u,t,i.min)),i.dataType==="datetime"&&i.setTicksAtUnitBeginning&&r.correctDateWithUnitBeginning(u,t)),u},_addMinorTicks:function(t,i,f,o,c){var d=this,v,w=o.dataType,y,l=[],b=0,p=o.minorTickCount+1,k,a;for(o.min=t,o.max=i,r.isDefined(o.tickInterval)||(o.businessDelta=y=e(o.max-o.min),o.screenDelta=y*o.deltaCoef,r.isDefined(o.minorTickCount)?((!f.majorTicks.autoArrangementStep||f.majorTicks.autoArrangementStep<=1)&&(k=o.minorTickCount+1,b=w==="datetime"?r.convertDateTickIntervalToMilliseconds(f.majorTickInterval):f.majorTickInterval,p=h(y/b*k)||1),a=w==="datetime"?r.convertMillisecondsToDateUnits(y/p):y/p,n.isNumeric(a)&&(a=r.adjustValue(a))):r.isDate(t)&&(a=u.minorTickIntervalCalculator.getTickInterval(o))),o=n.extend(!0,{},o,{tickInterval:a}),l=d.getTicks(o),c&&l.reverse(),l.length>0&&s(e(i-l[l.length-1])*o.deltaCoef)<2&&l.pop(),v=0;v<l.length;v++)f.minorTicks.push(l[v]),f.fullTicks.push(l[v])},_addLeftBoudedTicks:function(n,t,i){r.isDefined(t)&&n.majorTicks[0].valueOf()!==t.valueOf()&&(i.addMinMax.max=!0,this._addMinorTicks(n.majorTicks[0],t,n,i,!0),i.addMinMax.max=!1,i.showCustomBoundaryTicks&&(n.minorTicks.length>0&&n.minorTicks[0].valueOf()===t.valueOf()&&n.minorTicks.shift(t),n.customBoundaryTicks.push(t),n.fullTicks.unshift(t)))},_addRightBoudedTicks:function(n,t,i){var u=n.majorTicks[n.majorTicks.length-1];n.fullTicks.push(u),r.isDefined(t)&&u.valueOf()!==t.valueOf()&&(i.addMinMax.min=!1,i.addMinMax.max=!0,this._addMinorTicks(u,t,n,i),i.showCustomBoundaryTicks&&(n.minorTicks.length>0&&n.minorTicks[n.minorTicks.length-1].valueOf()===t.valueOf()&&n.minorTicks.pop(t),n.customBoundaryTicks.push(t),n.fullTicks.push(t)))},_correctBoundedTicks:function(t,i,r,u){u=n.extend({},{min:!0,max:!0},u),r.length>0&&(u.min||r[0].valueOf()!==t.valueOf()||r.shift(),u.max&&r[r.length-1].valueOf()===i.valueOf()||r.pop())},_initializeMinorTicksOptions:function(t,f,e,o,s){var h=this,c,l=r.isDefined(s.minorTickCount);n.extend(!0,s,{addMinMax:{min:!1,max:!1},deltaCoef:h._getDeltaCoef(e,f,t,s.axisType,s.base)},s),s.numberMultipliers=l?[s.minorTickCount+1]:s.numberMultipliers,s.gridSpacingFactor=l?0:s.gridSpacingFactor,!l&&o.majorTicks.length>1&&(s.businessDelta=c=h._getBusinessDelta(s.axisType,o.majorTicks[0],o.majorTicks[1],s.base),h.needTickIntervalCalculation(c,o.minorTickInterval,s.incidentOccured)&&(s.screenDelta=c*s.deltaCoef,o.minorTickInterval=u.minorTickIntervalCalculator.getTickInterval(s),s.tickInterval=r.isNumber(t)?o.minorTickInterval:i))},_getDataType:function(n){return r.isDate(n)?"datetime":"numeric"},_getBusinessDelta:function(n,t,i,u){return n==="logarithmic"?h(e(r.getLog(t,u)-r.getLog(i,u))):e(t-i)},_getDeltaCoef:function(n,t,i,r,u){return n/this._getBusinessDelta(r,i,t,u)},_initializeMajorTicksOptions:function(t,i,f,e,o){var s;o.screenDelta=f,n.extend(!0,o,{min:t,max:i,screenDelta:f,isHorizontal:!0}),r.isDefined(t)&&r.isDefined(i)&&(o.businessDelta=s=this._getBusinessDelta(o.axisType,t,i,o.base),this.needTickIntervalCalculation(s,e.majorTickInterval,o.incidentOccured)&&(o.isStartTickGenerated=!0,e.majorTickInterval=u.tickIntervalCalculator.getTickInterval(o),o.tickInterval=e.majorTickInterval))},_getTextFunc:function(n){return n.getText||function(n){return n.toString()}},_generateTicks:function(t){var s=this,f=[],e,c=t.max-t.min>0,l,a,o,h=t.isStartTickGenerated,v,y=t.useTicksAutoArrangement;if(t.dataType=t.dataType||s._getDataType(t.min),t.businessDelta=v=s._getBusinessDelta(t.axisType,t.min,t.max,t.base),!r.isDefined(t.min)||!r.isDefined(t.max)||isNaN(t.min)||isNaN(t.max))f=t.isHorizontal?["canvas_position_left","canvas_position_center","canvas_position_right"]:["canvas_position_bottom","canvas_position_middle","canvas_position_top"],y=!1,f.hideLabels=!0;else{if(o=n.isNumeric(t.min)&&n.isNumeric(t.max)&&!n.isNumeric(t.tickInterval)?i:t.tickInterval,this.needTickIntervalCalculation(v,o,t.incidentOccured)&&(h=r.isDefined(h)?h:!0,o=u.tickIntervalCalculator.getTickInterval(t)),f.tickInterval=o,o&&o.valueOf()!==0&&t.min.valueOf()!==t.max.valueOf()){e=h?s._generateStartTick(o,t):t.min;do{if(f.push(e),e=s._nextTick(e,o,t),f[f.length-1].valueOf()===e.valueOf())break;l=e-t.min>0,a=t.max-e>0}while(c===l&&c===a);f.push(e),s._correctBoundedTicks(t.min,t.max,f,t.addMinMax)}t.min.valueOf()===t.max.valueOf()&&(e=t.min,f.push(e))}return f},_getAutoArrangementStep:function(n,t){var u=this,i,r=t.isHorizontal?t.textSpacing:0;return t.getCustomAutoArrangementStep?t.getCustomAutoArrangementStep(n,t):t.maxDisplayValueSize>0?(i=o((t.screenDelta+t.textSpacing)/(t.maxDisplayValueSize+r)),s((t.ticksCount||n.length)/i)):1},_getAutoArrangementTicks:function(n,t,i){var f=this,r=n,u;if(i>1){for(r=[],u=0;u<n.length;u+=i)r.push(n[u]);r.tickInterval=n.tickInterval*i}return r},isOverlappedTicks:function(n,t){return t.maxDisplayValueSize=this._getValueSize(n,t),this._getAutoArrangementStep(n,t)>1},getCorrectedTicks:function(n,t){var i=Math.ceil(u.tickIntervalCalculator.getTickInterval({screenDelta:t.screenDelta*4,businessDelta:n.length,gridSpacingFactor:t.gridSpacingFactor,numberMultipliers:t.numberMultipliers,dataType:"numeric"}))||n.length;return this._getAutoArrangementTicks(n,t,i)},needTickIntervalCalculation:function(n,t,i){var u;if(r.isDefined(t)){if(!r.isNumber(t)&&(u=new Date,t=r.addInterval(u,t)-u,!t))return!0;if(r.isNumber(t))if(t>0&&n/t>c)i&&i("W2003");else return!1}return!0},getTickIntervals:function(n,t,i,u,f,e){var s=this,h,e=e||{},o={majorTickInterval:u.tickInterval,minorTickInterval:f.tickInterval,majorTicks:[]};return u.base=f.base=e.base,u.axisType=f.axisType=e.axisType,u.dataType=f.dataType=e.dataType,s._initializeMajorTicksOptions(n,t,i,o,u),r.isDefined(n)&&r.isDefined(t)&&(o.majorTicks.push(n),o.majorTicks.push(s._nextTick(n,o.majorTickInterval,{min:n,max:t,setTicksAtUnitBeginning:u.setTicksAtUnitBeginning,dataType:e.dataType,axisType:e.axisType,base:e.base})),s._initializeMinorTicksOptions(n,t,i,o,f)),o},getFullTicks:function(n,t,i,u,f,e){var s=this,h,e=e||{},o={customBoundaryTicks:[],fullTicks:[],majorTickInterval:u.tickInterval,majorTicks:[],minorTickInterval:f.tickInterval,minorTicks:[]};if(u.base=f.base=e.base,u.axisType=f.axisType=e.axisType,u.dataType=f.dataType=e.dataType||s._getDataType(n),s._initializeMajorTicksOptions(n,t,i,o,u),o.majorTicks=s.getTicks(u),r.isDefined(n)&&r.isDefined(t)&&o.majorTicks.length>0){for(o.majorTicks.autoArrangementStep&&o.majorTicks.autoArrangementStep>1&&!r.isDefined(f.tickInterval)&&!r.isDefined(f.minorTickCount)&&(f.tickInterval=o.minorTickInterval=u.tickInterval),s._initializeMinorTicksOptions(n,t,i,o,f),s._addLeftBoudedTicks(o,n,f),h=0;h<o.majorTicks.length-1;h++)o.fullTicks.push(o.majorTicks[h]),s._addMinorTicks(o.majorTicks[h],o.majorTicks[h+1],o,f);s._addRightBoudedTicks(o,t,f)}return o},getTicks:function(t){var u=this,f,e,i=t.customTicks?t.customTicks:u._generateTicks(t);return t.useTicksAutoArrangement&&(t.maxDisplayValueSize=u._getValueSize(i,t),f=u._getAutoArrangementStep(i,t),f>1&&(r.isDefined(t.tickInterval)||r.isDefined(t.customTicks)?(r.isDefined(t.customTicks)&&(i.tickInterval=t.tickInterval),i=u._getAutoArrangementTicks(i,t,f)):i=u._generateTicks(n.extend({},t,{gridSpacingFactor:t.maxDisplayValueSize})),i.autoArrangementStep=f),u._removeInvalidDatesWithUnitBegining(i,t)),i}}}(jQuery,DevExpress),function(n,t){var r=t.utils,f=r.isDefined,e=r.getPower,u=Math.round;t.viz.core.numericTranslatorFunctions={translate:function(n){var i=this,t=i._canvasOptions,r=t.rangeDoubleError,e=i.translateSpecialCase(n);return f(e)?e:isNaN(n)||n.valueOf()+r<t.rangeMin||n.valueOf()-r>t.rangeMax?null:u(i._calculateProjection((n-t.rangeMinVisible)*t.ratioOfCanvasRange))},untranslate:function(n){var t=this._canvasOptions,i=t.startPoint;return n<i||n>t.endPoint?null:this._calculateUnProjection((n-i)/t.ratioOfCanvasRange)},getInterval:function(){return u(this._canvasOptions.ratioOfCanvasRange*(this._businessRange.interval||Math.abs(this._canvasOptions.rangeMax-this._canvasOptions.rangeMin)))}}}(jQuery,DevExpress),function(n,t){var u=t.viz.core,r=u.numericTranslatorFunctions;u.datetimeTranslatorFunctions={translate:r.translate,untranslate:function(n){var t=r.untranslate.call(this,n);return t===null?t:new Date(t)},getInterval:r.getInterval}}(jQuery,DevExpress),function(n,t){function f(n){return r(r(n*10)/10)}var u=t.utils.isDefined,r=Math.round;t.viz.core.categoryTranslatorFunctions={translate:function(n){var t=this,f=t._canvasOptions,i=t._categoriesToPoints[n],e,o=t.translateSpecialCase(n);return u(o)?o:i?(e=t._businessRange.stick?i.index:i.index+.5,r(f.startPoint+f.interval*e)):0},untranslate:function(n){var i=this,r=i._canvasOptions,u=r.startPoint,e=i._categories.length,t=0;return n<u||n>r.endPoint?null:(t=f((n-u)/r.interval+(i._businessRange.stick?.5:0)-.5),e===t&&t--,r.invert&&(t=e-t-1),i._categories[t])},getInterval:function(){return this._canvasOptions.interval}}}(jQuery,DevExpress),function(n,t){var f=t.viz.core,r=f.numericTranslatorFunctions,u=t.utils,e=u.raiseTo,o=u.getLog;f.logarithmicTranslatorFunctions={translate:function(n){var t=this,i=t.translateSpecialCase(n);return u.isDefined(i)?i:r.translate.call(t,o(n,t._businessRange.base))},untranslate:function(n){var t=r.untranslate.call(this,n);return t===null?t:e(t,this._businessRange.base)},getInterval:r.getInterval}}(jQuery,DevExpress),function(n){function r(){this.setDomain(arguments[0],arguments[1]).setCodomain(arguments[2],arguments[3])}var i=Number;r.prototype={constructor:r,setDomain:function(n,t){var r=this;return r._domain1=i(n),r._domain2=i(t),r._domainDelta=r._domain2-r._domain1,r},setCodomain:function(n,t){var r=this;return r._codomain1=i(n),r._codomain2=i(t),r._codomainDelta=r._codomain2-r._codomain1,r},getDomain:function(){return[this._domain1,this._domain2]},getCodomain:function(){return[this._codomain1,this._codomain2]},getDomainStart:function(){return this._domain1},getDomainEnd:function(){return this._domain2},getCodomainStart:function(){return this._codomain1},getCodomainEnd:function(){return this._codomain2},getDomainRange:function(){return this._domainDelta},getCodomainRange:function(){return this._codomainDelta},translate:function(n){var t=(i(n)-this._domain1)/this._domainDelta;return 0<=t&&t<=1?this._codomain1+t*this._codomainDelta:NaN},adjust:function(n){var t=(i(n)-this._domain1)/this._domainDelta,r=NaN;return t<0?r=this._domain1:t>1?r=this._domain2:0<=t&&t<=1&&(r=i(n)),r}},n.viz.core.Translator1D=r}(DevExpress),function(n,t){var r=t.viz.core,u=t.utils,e=u.getLog,o=u.getPower,s=u.raiseTo,f=u.isDefined,h=["width","height","left","top","bottom","right"],c=1,l=6e4,a=function(t){return n.each(h,function(n,i){t[i]=parseInt(t[i])||0}),t},p=function(n,t,i){return s(Math.floor(e(n,t))+(i||0),t)},v=function(n,t){for(var u={},r,f=n.length,i=0;i<f;i++)r=n[i],u[r]={name:r,index:t?f-1-i:i};return u},y=function(n){function t(t,i){!f(n[t])&&f(n[i])&&(n[t]=n[i])}return t("minVisible","min"),t("maxVisible","max"),n};r.Translator2D=function(t,i,r){var u=this;u._options=n.extend(u._options||{},r),u._canvas=a(i),u.updateBusinessRange(t)},n.extend(r.Translator2D.prototype,{reinit:function(){var n=this,i=n._businessRange,f=i.categories||[],t={},u=n._prepareCanvasOptions(),e,o;switch(i.axisType){case"logarithmic":t=r.logarithmicTranslatorFunctions;break;case"discrete":t=r.categoryTranslatorFunctions,n._categories=f,o=f.length-(i.stick?1:0),e=o>0?u.canvasLength/o:u.canvasLength,u.interval=e,n._categoriesToPoints=v(f,u.invert);break;default:t=i.dataType==="datetime"?r.datetimeTranslatorFunctions:r.numericTranslatorFunctions}n.translate=t.translate,n.untranslate=t.untranslate,n.getInterval=t.getInterval},_getCanvasBounds:function(n){var t=n.min,i=n.max,r=n.minVisible,o=n.maxVisible,s,h,a=n.base,y=u.isDate(i)||u.isDate(t),v=y?l:c;return f(t)&&f(i)&&t.valueOf()===i.valueOf()&&(s=t.valueOf()-v,h=i.valueOf()+v,y?(t=new Date(s),i=new Date(h)):(t=t!==0?s:0,i=h)),f(r)&&f(o)&&r.valueOf()===o.valueOf()&&(s=r.valueOf()-v,h=o.valueOf()+v,y?(r=s<t.valueOf()?t:new Date(s),o=h>i.valueOf()?i:new Date(h)):(r!==0&&(r=s<t?t:s),o=h>i?i:h)),n.axisType==="logarithmic"&&(o=e(o,a),r=e(r,a),t=e(t,a),i=e(i,a)),{base:a,rangeMin:t,rangeMax:i,rangeMinVisible:r,rangeMaxVisible:o}},_prepareCanvasOptions:function(){var t=this,u,f,e,s,i=t._businessRange,n=t._canvasOptions=t._getCanvasBounds(i),r;return t._options.direction==="horizontal"?(n.startPoint=t._canvas.left,r=t._canvas.width,n.endPoint=t._canvas.width-t._canvas.right,n.invert=i.invert):(n.startPoint=t._canvas.top,r=t._canvas.height,n.endPoint=t._canvas.height-t._canvas.bottom,n.invert=!i.invert),t.canvasLength=n.canvasLength=n.endPoint-n.startPoint,n.rangeDoubleError=Math.pow(10,o(n.rangeMax-n.rangeMin)-o(r)-2),n.ratioOfCanvasRange=n.canvasLength/(n.rangeMaxVisible-n.rangeMinVisible),n},updateBusinessRange:function(n){this._businessRange=y(n),this.reinit()},getBusinessRange:function(){return this._businessRange},getCanvasVisibleArea:function(){return{min:this._canvasOptions.startPoint,max:this._canvasOptions.endPoint}},translateSpecialCase:function(n){var f=this,e=f._canvasOptions,i=e.startPoint,r=e.endPoint,u=f._businessRange,s=u.minVisible,h=u.maxVisible,o,t=null;switch(n){case"canvas_position_default":s<=0&&h>=0?t=f.translate(0):(o=u.invert^(s<=0&&h<=0),t=f._options.direction==="horizontal"?o?r:i:o?i:r);break;case"canvas_position_left":case"canvas_position_top":t=i;break;case"canvas_position_center":case"canvas_position_middle":t=i+e.canvasLength/2;break;case"canvas_position_right":case"canvas_position_bottom":t=r;break;case"canvas_position_start":t=u.invert?r:i;break;case"canvas_position_end":t=u.invert?i:r}return t},_calculateProjection:function(n){var t=this._canvasOptions;return t.invert?t.endPoint-n:t.startPoint+n},_calculateUnProjection:function(n){var t=this._canvasOptions;return t.invert?t.rangeMaxVisible.valueOf()-n:t.rangeMinVisible.valueOf()+n}})}(jQuery,DevExpress),function(n){var i=window.isFinite;n.viz.core.Rectangle=n.Class.inherit({ctor:function(n){var t=this;n=n||{},t.left=Number(n.left)||0,t.right=Number(n.right)||0,t.top=Number(n.top)||0,t.bottom=Number(n.bottom)||0},width:function(){return this.right-this.left},height:function(){return this.bottom-this.top},horizontalMiddle:function(){return(this.left+this.right)/2},verticalMiddle:function(){return(this.top+this.bottom)/2},raw:function(){var n=this;return{left:n.left,top:n.top,right:n.right,bottom:n.bottom}},clone:function(){return new this.constructor(this.raw())},move:function(n,t){var r=this.clone();return i(n)&&i(t)&&(r.left+=Number(n),r.right+=Number(n),r.top+=Number(t),r.bottom+=Number(t)),r},inflate:function(n,t){var r=this.clone();return i(n)&&i(t)&&(r.left-=Number(n),r.right+=Number(n),r.top-=Number(t),r.bottom+=Number(t)),r},scale:function(n){var t=this;return n>0?t.inflate(t.width()*(n-1)/2,t.height()*(n-1)/2):t.clone()}})}(DevExpress),function(n,t,i){var r=t.viz,u=r.core,e=0,f=function(n){for(var i=r.themes,t=0;t<i.length;t++)if(i[t].name===n)return t;return-1};u.findTheme=function(n){var t=f(n),i=r.themes;return t<0&&(t=e),i[t]},u.currentTheme=function(n,t,u){var o=-1,s=r.themes;if(n===i)return s[e].name;u&&t&&(o=f(n+":"+u+"-"+t)),o<0&&u&&(o=f(n+":"+u)),t&&o<0&&(o=f(n+"-"+t)),o<0&&(o=f(n)),e=o>=0?o:0},u.registerTheme=function(t,i){var f,e,o=r.themes;t&&t.name&&u.findTheme(t.name)&&(f=u.findTheme(i),f?(e=n.extend(!0,{},f,t),o.push(e)):o.push(t))}}(jQuery,DevExpress),function(n,t,i){function a(n){if(n===i)return s;n=String(n).toLowerCase(),s=n in r?n:"default"}function h(n,t){var i,f;if(u(n))i=n;else{if(t=t||{},f=t.type||"simpleSet",l(n)){var o=n.toLowerCase(),h=r[o],c=t.theme&&r[o+"_"+e(t.theme).toLowerCase()];i=c&&c[f]||h&&h[f]}i||(i=r[s][f])}return i?i.slice(0):null}function v(n,t,f){var s={},h;u(t)?s.simpleSet=t.slice(0):t&&(s.simpleSet=u(t.simpleSet)?t.simpleSet.slice(0):i,s.indicatingSet=u(t.indicatingSet)?t.indicatingSet.slice(0):i,s.gradientSet=u(t.gradientSet)?t.gradientSet.slice(0):i),(s.simpleSet||s.indicatingSet||s.gradientSet)&&(h=e(n).toLowerCase(),f&&(h=h+"_"+e(f).toLowerCase()),o(r[h]=r[h]||{},s))}function y(n){var t=0;this.next=function(){var i=n[t++];return t==n.length&&this.reset(),i},this.reset=function(){t=0}}function c(n,t){t=t||{},this._originalPalette=h(n,t);var i=t?t.stepHighlight||0:0;this._paletteSteps=new y([0,i,-i]),this._resetPalette()}function p(n,t){var i=new f(n).alter(t),r=w(i);return(r>200||r<55)&&(i=new f(n).alter(-t/2)),i.toHex()}function w(n){return n.r*.3+n.g*.59+n.b*.11}function b(n,t){var i=h(n,{type:"gradientSet"});i=t>0?k(i[0],i[1],t):[],this.getColor=function(n){return i[n]||null}}function k(n,t,i){var e=new f(n),o=new f(t);if(i===1)return[e.blend(o,.5).toHex()];var u=[],h=1/(i-1),r,s=i;for(u.push(0),r=1;r<s-1;++r)u.push(h*r);for(u.push(1),r=0;r<s;++r)u[r]=e.blend(o,u[r]).toHex();return u}var e=window.String,f=n.Color,u=n.utils.isArray,l=n.utils.isString,o=t.extend,r={"default":{simpleSet:["#5f8b95","#ba4d51","#af8a53","#955f71","#859666","#7e688c"],indicatingSet:["#a3b97c","#e1b676","#ec7f83"],gradientSet:["#5f8b95","#ba4d51"]},"harmony light":{simpleSet:["#fcb65e","#679ec5","#ad79ce","#7abd5c","#e18e92","#b6d623","#b7abea","#85dbd5"],indicatingSet:["#b6d623","#fcb65e","#e18e92"],gradientSet:["#7abd5c","#fcb65e"]},"soft pastel":{simpleSet:["#60a69f","#78b6d9","#6682bb","#a37182","#eeba69","#90ba58","#456c68","#7565a4"],indicatingSet:["#90ba58","#eeba69","#a37182"],gradientSet:["#78b6d9","#eeba69"]},pastel:{simpleSet:["#bb7862","#70b3a1","#bb626a","#057d85","#ab394b","#dac599","#153459","#b1d2c6"],indicatingSet:["#70b3a1","#dac599","#bb626a"],gradientSet:["#bb7862","#70b3a1"]},bright:{simpleSet:["#70c92f","#f8ca00","#bd1550","#e97f02","#9d419c","#7e4452","#9ab57e","#36a3a6"],indicatingSet:["#70c92f","#f8ca00","#bd1550"],gradientSet:["#e97f02","#f8ca00"]},soft:{simpleSet:["#cbc87b","#9ab57e","#e55253","#7e4452","#e8c267","#565077","#6babac","#ad6082"],indicatingSet:["#9ab57e","#e8c267","#e55253"],gradientSet:["#9ab57e","#e8c267"]},ocean:{simpleSet:["#75c099","#acc371","#378a8a","#5fa26a","#064970","#38c5d2","#00a7c6","#6f84bb"],indicatingSet:["#c8e394","#7bc59d","#397c8b"],gradientSet:["#acc371","#38c5d2"]},vintage:{simpleSet:["#dea484","#efc59c","#cb715e","#eb9692","#a85c4c","#f2c0b5","#c96374","#dd956c"],indicatingSet:["#ffe5c6","#f4bb9d","#e57660"],gradientSet:["#efc59c","#cb715e"]},violet:{simpleSet:["#d1a1d1","#eeacc5","#7b5685","#7e7cad","#a13d73","#5b41ab","#e287e2","#689cc1"],indicatingSet:["#d8e2f6","#d0b2da","#d56a8a"],gradientSet:["#eeacc5","#7b5685"]}},s="default";o(c.prototype,{dispose:function(){return this._originalPalette=this._palette=this._paletteSteps=null,this},getNextColor:function(){var n=this;return n._currentColor>=n._palette.length&&n._resetPalette(),n._palette[n._currentColor++]},_resetPalette:function(){var n=this,r,t;if(n._currentColor=0,r=n._paletteSteps.next(),t=n._originalPalette,r)for(var u=n._palette=[],i=0,f=t.length;i<f;++i)u[i]=p(t[i],r);else n._palette=t.slice(0)},reset:function(){return this._paletteSteps.reset(),this._resetPalette(),this}}),o(n.viz.core,{registerPalette:v,getPalette:h,Palette:c,GradientPalette:b,currentPalette:a})}(DevExpress,jQuery),function(n,t){var u=n.utils.isString,f=n.viz.core.findTheme,r=t.extend,e=t.each;n.viz.core.BaseThemeManager=n.Class.inherit({dispose:function(){return this._theme=this._font=null,this},setTheme:function(n){n=n||{};var t=this,i=f(u(n)?n:n.name);return t._themeName=i.name,t._font=r({},i.font,n.font),t._themeSection&&e(t._themeSection.split("."),function(n,u){i=r(!0,{},i[u],t._IE8?i[u+"IE8"]:{})}),t._theme=r(!0,{},i,u(n)?{}:n),t._initializeTheme(),t},theme:function(){return this._theme},themeName:function(){return this._themeName},_initializeTheme:function(){},_initializeFont:function(n){r(n,this._font,r({},n))}})}(DevExpress,jQuery),function(n){var i=Math.min;n.viz.core.TextCloud=n.Class.inherit(function(){var t={horMargin:8,verMargin:4,tailLength:10},n={};return n["right-bottom"]=n.rb=[0,-1,-1,0,0,1,1,0],n["bottom-right"]=n.br=[-1,0,0,-1,1,0,0,1],n["left-bottom"]=n.lb=[0,-1,1,0,0,1,-1,0],n["bottom-left"]=n.bl=[1,0,0,-1,-1,0,0,1],n["left-top"]=n.lt=[0,1,1,0,0,-1,-1,0],n["top-left"]=n.tl=[1,0,0,1,-1,0,0,-1],n["right-top"]=n.rt=[0,1,-1,0,0,-1,1,0],n["top-right"]=n.tr=[-1,0,0,1,1,0,0,-1],{setup:function(r){var e=this,f=$.extend({},t,r),h=f.x,c=f.y,u=n[f.type],o=f.textWidth+2*f.horMargin,s=f.textHeight+2*f.verMargin,l=f.tailLength,a=l,v=h,y=c;return u[0]&1?a=i(a,s/3):l=i(l,o/3),e._points=[h,c,h+=u[0]*(o+l),c+=u[1]*(s+a),h+=u[2]*o,c+=u[3]*s,h+=u[4]*o,c+=u[5]*s,h+=u[6]*(o-l),c+=u[7]*(s-a)],e._cx=v+u[0]*l+(u[0]+u[2])*o/2,e._cy=y+u[1]*a+(u[1]+u[3])*s/2,e._cloudWidth=o,e._cloudHeight=s,e._tailLength=f.tailLength,e},points:function(){return this._points.slice(0)},cx:function(){return this._cx},cy:function(){return this._cy},width:function(){return this._cloudWidth},height:function(){return this._cloudHeight},tailLength:function(){return this._tailLength}}}())}(DevExpress),function(n,t){var r=t.viz,u=r.core,f=t.Class,i=t.utils.isDefined,e=f.inherit({ctor:function(t){t=t||{},this._incidentOccured=n.isFunction(t.incidentOccured)?t.incidentOccured:n.noop},correctValueType:function(n){return n==="numeric"||n==="datetime"||n==="string"?n:""},_parsers:{string:function(n){return i(n)?""+n:n},numeric:function(n){if(!i(n))return n;var t=Number(n);return isNaN(t)&&(t=undefined),t},datetime:function(n){if(!i(n))return n;var t,r=Number(n);return t=isNaN(r)?new Date(n):new Date(r),isNaN(Number(t))&&(t=undefined),t}},getParser:function(t,i){var u=this,r,f="valueType is unknown.";return i&&(f='The type specified as the "valueType" field of the '+i+" configuration object is unknown."),t=u.correctValueType(t),r=u._parsers[t],r||this._incidentOccured.call(null,f),r||n.noop}});u.ParseUtils=e}(jQuery,DevExpress),function(n,t){var r=t.viz.core,i=Math;r.utils={decreaseGaps:function(t,r,u){var f,e,o;do f=n.map(r,function(n){return t[n]?t[n]:null}),o=i.ceil(u/f.length),f.push(o),e=i.min.apply(null,f),n.each(r,function(n,i){t[i]&&(t[i]-=e,u-=e)});while(u>0&&f.length>1);return u}}}(jQuery,DevExpress),function(n,t){var u=t.viz,f=u.core,e={easing:"linear",duration:150},i={x:-1e4,y:-1e4},r=function(n,t,i,r){var u=n.animation;u&&(u.options.complete=null,u.stop()),i?n.animate(t,{complete:r}):(n.applySettings(t),r&&r())};f.LoadIndicator=t.Class.inherit({ctor:function(t,i){var r=this;r._$widgetContainer=n(i),r._$container=n("<div>",{css:{position:"relative",height:0,padding:0,margin:0,border:0}}).appendTo(r._$widgetContainer),r._updateContainer(),r.applyOptions(t),r._endLoadingCompleteHandler=function(){r._endLoad=!1,r._externalComplete&&r._externalComplete(),r._externalComplete=null,r._onCompleteAction&&r[r._onCompleteAction](),r._onCompleteAction=null},r._$container.hide()},_updateRenderer:function(n,t,i){return this._renderer?this._renderer.recreateCanvas(n,t):this._$container.get(0)&&(this._renderer=new u.renderers.Renderer({width:n,height:t,animation:e}),this._renderer.draw(this._$container[0])),this._renderer&&this._renderer.getRoot().applySettings({style:{position:"absolute",top:i,left:0}}),this._renderer},applyOptions:function(n,t,i){var r=this._pane;r&&n&&(r.rect.applySettings({fill:n.backgroundColor}),r.text.applySettings({font:n.font,text:n.text})),this.isShown&&(t||i)&&this._updateContainer(t,i)},_draw:function(){var n,t=this._renderer;t&&(n=this._pane={},n.rect=t.createRect(0,0,0,0,0,{opacity:0}).append(),n.text=t.createText("",0,0,{align:"center",translateX:i.x,translateY:i.y}).append())},_updateContainer:function(n,t){var i=this,r=i._$widgetContainer,u;n=n||r.width(),t=t||r.height(),u=r.get(0)?r.offset().top-i._$container.offset().top:-t,i._updateRenderer(n,t,u),i._pane?(i._pane.rect.applySettings({width:n,height:t}),i._pane.text.move(n/2,t/2)):i._draw()},dispose:function(){this._$widgetContainer=null,this._$container.remove().detach(),this._$container=null,this._renderer.dispose(),this._renderer=null,this._pane=null},toForeground:function(){this._$container.appendTo(this._$widgetContainer)},show:function(n,t){if(this._endLoad){this._onCompleteAction="show";return}this._$container.show(),this._updateContainer(n,t),r(this._pane.rect,{opacity:.85},!0),this.isShown=!0},endLoading:function(n,t){(this._externalComplete=n,this._endLoad)||(this.isShown?(this._endLoad=!0,r(this._pane.rect,{opacity:1},!t,this._endLoadingCompleteHandler)):n&&n())},hide:function(){var n=this;if(this._endLoad){this._onCompleteAction="hide";return}this.isShown&&(this._pane.text.move(i.x,i.y),r(n._pane.rect,{opacity:0},!0,function(){n._$container.hide()}),this.isShown=!1)}})}(jQuery,DevExpress),function(n,t,i){var r=20,o=10,v=t.formatHelper,y=15,l=Math.max,p=Math.round,a=t.utils.isFunction,u=t.utils.isDefined,h=n.extend,w={argument:["argumentFormat","argumentPrecision"],percent:["percent","percentPrecision"],value:["format","precision"]},s={visibility:"visible"},c={visibility:"hidden"},f="left",e="right";t.viz.core.Tooltip=t.Class.inherit({ctor:function(t,i,r){this._state={},this._options={},this._renderer=r,this._group=i,this._cloud=r.createArea(),this._textGroup=r.createGroup(),n.isEmptyObject(t)||this.update(t),this._createTextContent()},dispose:function(){return this._shadow.dispose(),this._shadow=null,this._cloud=null,this._text=null,this._group=null,this._options=null,this._renderer=null,this._tooltipTextArray=null,this._textGroup=null,this},update:function(n){n=n||{};var t=this,u=t._group,r=n.shadow||{},f=t._shadow=t._shadow||t._renderer.createFilter("shadow").applySettings({width:"200%",height:"200%",color:r.color,opacity:r.opacity,dx:r.offsetX,dy:r.offsetY,blur:r.blur,x:"-50%",y:"-50%"}),i=n.border,e=h({opacity:n.opacity,filter:f.append().ref},i&&i.visible?{strokeWidth:i.width,stroke:i.color,strokeOpacity:i.opacity,dashStyle:i.dashStyle}:{strokeWidth:null,stroke:null}),o=h({},{align:"center",font:n.font},n.text);return t._options=n,t.setSize(n.canvasWidth,n.canvasHeight),t._customizeTooltip=a(n.customizeTooltip)?n.customizeTooltip:null,!t._customizeTooltip&&a(n.customizeText)&&(t._customizeTooltip=function(){return{text:n.customizeText.apply(this,arguments)}}),t._cloud.applySettings(e).append(u),t._text&&n.font&&t._text.applySettings({font:{size:n.font.size}}),t._textGroup.applySettings(o).append(u),t.hide(),t},formatValue:function(n,t){var i=w[t||"value"],r=i[0]in this._options?this._options[i[0]]:t;return v.format(n,r,this._options[i[1]]||0)},prepare:function(t,i,r){var e,f;return this._state=this._state||{},r=r||"valueText",e=t[r]||"",h(this._state,i),this._customizeTooltip?(f=this._customizeTooltip.call(t,t),f=n.isPlainObject(f)?f:{},"text"in f?this._state.text=u(f.text)?String(f.text):"":(n.isArray(e)&&(this._options._justify=!0,this._createTextContent(),e=e.join("<br/>")),this._state.text=e),this._state.color=f.color||this._options.color):(this._state.text=e,this._state.color=this._options.color),this._options._justify&&(this._state.text=this._state.text.split("<br/>")),this._state.visibility!=s||!this._state.text||this.show(),!!this._state.text},enabled:function(){return!!this._options.enabled},formatColorTooltip:function(n){return n._customizeTooltip&&n._customizeTooltip.call(this,this)},_getData:function(){var n=this,o=n._state.x,c=n._state.y,w=o,l=c,b="center",v=[],a=n._state.textBBox,s=n._options,y=s.paddingLeftRight,d=s.paddingTopBottom,h=s.arrowLength>0?s.arrowLength:0,p=s.cloudHorizontalPosition,k=s.cloudVerticalPosition,g=p!==i&&p!==null,nt=k!==i&&k!==null,r=a.width+y*2,t=a.height+d*2,u;return u=n._checkWidthText(r,t),u&&(n._state.textBBox=a=u.bbox,r=u.cloudWidth,t=u.cloudHeight,y=u.paddingLeftRight,d=u.paddingTopBottom),(g?p===e:r/2>o)?(v=n._setArrowLeft(r,t,h,o,c),b=f,w+=y):(g?p===f:o+r/2>n._canvasWidth)?(v=n._setArrowRight(r,t,h,o,c),b=e,w-=y):v=n._setArrowCenter(r,t,h,o,c),(nt?k==="top":t+h<c)?(l-=h+t/2-a.height/2+n._state.offset,n.tooltipInverted=!1):(l+=h+t/2+a.height/2+n._state.offset,n.tooltipInverted=!0),l=n._correctYTextContent(l),{points:v,text:{x:w,y:l,align:b}}},_updateTextContent:function(){this._options._justify?(this._textGroup.clear(),this._calculateTextContent(),this._locateTextContent(0,0,"center")):this._text.updateText(this._state.text),this._state.textBBox=this._textGroup.getBBox()},_correctYTextContent:function(n){var t;return this._options._justify?(this._locateTextContent(0,n,"center"),t=this._textGroup.getBBox()):(this._text.applySettings({y:n}),t=this._text.getBBox()),n-(t.y+t.height-n)},_adjustTextContent:function(n){this._options._justify?this._locateTextContent(n.text.x,n.text.y,n.text.align):this._text.applySettings({x:n.text.x,y:n.text.y,align:n.text.align})},_updateTooltip:function(){var n=this,t,r,i;r=n._getData(),n._cloud.applySettings({points:r.points,fill:n._state.color,"class":n._state.className}),n._adjustTextContent(r),t=n._group.getBBox(),t.y+t.height>n._canvasHeight?(i=(n._canvasHeight-t.y)/t.height,n._group.applySettings({scale:i,translateX:n._state.x*(1-i),translateY:n._state.y*(1-i)})):n._group.applySettings({scale:1,translateX:0,translateY:0})},_createTextContent:function(){var n=this,t=n._options,r;n._textGroup.clear(),n._text=null,t._justify||(r=t.font&&t.font.size,n._text=n._renderer.createText(i,0,0,{font:{size:r}}).append(n._textGroup))},_getTextContentParams:function(){var n=this,t,r,i,u=n._state.text,e=u.length,f={width:[],height:[]};for(n._tooltipTextArray=[],t=0;t<e;t++)r=n._renderer.createText(u[t],0,0,{}).append(this._textGroup),n._tooltipTextArray.push(r),i=r.getBBox(),f.width.push(i.width);return n._lineHeight=-2*i.y-i.height,f},_locateTextContent:function(n,t,i){var o=this,s=o._tooltipTextArray,c=o._textContentWidth,a=o._options.lineSpacing,v=(a>0?a:0)+o._lineHeight,r,l,u,h=o._options._rtl;for(r=i===f?n:i===e?n-c:p(n-c/2),l=r+c,u=s.length-1;u>=0;u-=2)s[u].applySettings({x:h?r:l,y:t,align:h?f:e}),s[u-1]&&s[u-1].applySettings({x:h?l:r,y:t,align:h?e:f}),t-=v},_calculateTextContent:function(){for(var i=this,f=i._state.text,e=f.length,r,u=[],t=i._getTextContentParams(),n=0;n<e;n+=2)r=t.width[n+1]?t.width[n]+y+t.width[n+1]:t.width[n],u.push(r);i._textContentWidth=l.apply(null,u)},setSize:function(n,t){return this._canvasWidth=u(n)?n:this._canvasWidth,this._canvasHeight=u(t)?t:this._canvasHeight,this},getBBox:function(){var r=this,t=r._options,u=t.paddingLeftRight||0,f=t.paddingTopBottom||0,i=t.border.visible&&t.border.width||0,n=r._textGroup.getBBox();return n.isEmpty?n:{x:n.x-u-i/2-o,y:n.y-f-i/2-o,height:n.height+2*f+i+o*2,width:n.width+2*u+i+o*2,isEmpty:!1}},show:function(){return this._state.visibility=s,this._updateTextContent(),this.move(this._state.x,this._state.y,this._state.offset),this._cloud.applySettings(s),this._textGroup.applySettings(s),this},hide:function(){return this._state.visibility=c,this._cloud.applySettings(c),this._textGroup.applySettings(c),this},move:function(n,t,i){return this._state.x=u(n)?n:this._state.x||0,this._state.y=u(t)?t:this._state.y||0,this._state.offset=u(i)?i:this._state.offset||0,this._updateTooltip(),this},_setArrowCenter:function(n,t,u,f,e){var s=this,h=s._options.cloudVerticalPosition,tt=h!==i&&h!==null,o=!(tt?h==="top":t+u<e),v=f,c=o?e+s._state.offset:e-s._state.offset,y=v+r/2,p=o?c+u:c-u,w=y+n/2-r/2,l=p,b=w,k=o?l+t:l-t,d=b-n,a=k,g=d,nt=o?a-t:a+t,it=g+n/2-r/2,rt=nt;return[v,c,y,p,w,l,b,k,d,a,g,nt,it,rt]},_setArrowLeft:function(n,t,u,f,e){var s=this,h=s._options.cloudVerticalPosition,g=h!==i&&h!==null,o=!(g?h==="top":t+u<e),v=f,c=o?e+s._state.offset:e-s._state.offset,y=v+r,p=o?c+u:c-u,w=y+n-r,l=p,b=w,k=o?l+t:l-t,d=b-n,a=k,nt=d,tt=o?a-t-u:a+t+u;return[v,c,y,p,w,l,b,k,d,a,nt,tt]},_setArrowRight:function(n,t,u,f,e){var s=this,h=s._options.cloudVerticalPosition,g=h!==i&&h!==null,o=!(g?h==="top":t+u<e),v=f,c=o?e+s._state.offset:e-s._state.offset,y=v,p=o?c+u+t:c-u-t,w=y-n,l=p,b=w,k=o?l-t:l+t,d=b+n-r,a=k,nt=d+r,tt=o?a-u:a+u;return[v,c,y,p,w,l,b,k,d,a,nt,tt]},_checkWidthText:function(n,t){if(!this._options._justify){var i=this._state.x,r=this._state.text,u,o=this._options.paddingLeftRight,s=this._options.paddingTopBottom,h,a,c,f,e=this._state.textBBox;if(n<i||i+n<this._canvasWidth||n/2<i&&i+n/2<this._canvasWidth)return!1;if(r.indexOf("<br/>")===-1&&r.indexOf(" ")!==-1){for(a=l(i,this._canvasWidth-i,2*Math.min(i,this._canvasWidth-i)),h=r.length*a/e.width,u=r.substr(0,~~h).lastIndexOf(" "),u===-1&&(u=r.substr(0).indexOf(" ")),c=r.substr(u+1).length,this._state.text=r.substr(0,u)+"<br/>";h<=c;)if(f=r.substr(u+1,~~h).lastIndexOf(" "),f===-1&&(f=r.substr(u+1).indexOf(" ")),f!==-1)this._state.text+=r.substr(u+1,f)+"<br/>",c=r.substr(u+1+f).length,u+=f+1;else break;this._state.text+=r.substr(u+1),this._text.updateText(this._state.text),e=this._text.getBBox(),n=e.width+o*2,t=e.height+s*2}return n>i&&i+n>this._canvasWidth&&(n/2>i||i+n/2>this._canvasWidth)&&(o=5,s=5,n=e.width+2*o,t=e.height+2*s),{bbox:e,cloudWidth:n,cloudHeight:t,paddingTopBottom:s,paddingLeftRight:o}}}})}(jQuery,DevExpress),function(n,t){function d(n,i,r,e){if(i){var o=i[r].hatching.direction,s,h=i[r].fill;return e=h===f?e:h,o=!o||o===f?u:o,s=t.extend({},i[r].hatching,{direction:o,step:nt,width:g}),n.createPattern(e,s).append().id}}var h=10,y=Math,r=y.round,c=y.ceil,p=y.floor,l="center",u="right",e="left",a="top",s="bottom",v="horizontal",w="vertical",b="inside",k="outside",f="none",o=DevExpress.viz.core.utils.decreaseGaps,g=2,nt=5;n.viz.core.Legend=n.Class.inherit({ctor:function(n,t,i,r){var u=this;u._renderer=i,u._legendGroup=r,u._markersPatternsIds=[],u._data=n,u._init(t)},_init:function(n){if(n){var i=this,r;i._parseMargins(n),i._parseAlignments(n),n.orientation=(n.orientation||"").toLowerCase(),n.orientation!==w&&n.orientation!==v&&(n.horizontalAlignment===l&&(n.orientation=v),(n.horizontalAlignment===u||n.horizontalAlignment===e)&&(n.orientation=w)),n.itemTextPosition=n.itemTextPosition?n.itemTextPosition:n.orientation===v?s:u,n.position=(n.position||"").toLowerCase(),n.position!==k&&n.position!==b&&(n.position=k),n.hoverMode=(n.hoverMode||"").toLowerCase(),n.customizeText=t.isFunction(n.customizeText)?n.customizeText:function(){return this.seriesName},i._options=n,i._trackerGroup||(i._trackerGroup=i._renderer.createGroup({"class":"dxc-legend-trackers",stroke:f,fill:"grey",opacity:.0001}))}},_parseMargins:function(n){n.margin>=0?(n.margin=Number(n.margin),n.margin={top:n.margin,bottom:n.margin,left:n.margin,right:n.margin}):n.margin={top:n.margin.top>=0?Number(n.margin.top):h,bottom:n.margin.bottom>=0?Number(n.margin.bottom):h,left:n.margin.left>=0?Number(n.margin.left):h,right:n.margin.right>=0?Number(n.margin.right):h}},_parseAlignments:function(n){n.horizontalAlignment=(n.horizontalAlignment||"").toLowerCase(),n.horizontalAlignment!==l&&n.horizontalAlignment!==u&&n.horizontalAlignment!==e&&(n.horizontalAlignment=u),n.verticalAlignment=(n.verticalAlignment||"").toLowerCase(),n.verticalAlignment!==a&&n.verticalAlignment!==s&&(n.horizontalAlignment===l&&(n.verticalAlignment=s),(n.horizontalAlignment===u||n.horizontalAlignment===e)&&(n.verticalAlignment=a))},update:function(n,t){return this._data=n,this.boundingRect={width:0,height:0,x:0,y:0},this._init(t),this},setSize:function(n){return this._size=n,this},draw:function(){if(!this._options)return this;var n=this,s=n._renderer,h=n._options,i=n._data,r=i.length,l=[],t,a,c,u,v=[],y,p=new Array(r),e,o=h.border,b=o.visible&&o.width&&o.color&&o.color!==f,w=new Array(r);if(!(h.visible&&i&&r))return n._disposeTrackers(),n;for(n._cleanLegendGroups(),y=n._insideLegendGroup=s.createGroup().append(n._legendGroup),n._createBackground(b),t=0;t<r;t++)u=s.createGroup({"class":"dxc-item"}).append(y),c=n._createMarker(i[t],u,t),e=i[t].id,a=n._createLabel(i[t],e,u),p[t]=e,n._locateLabelAndMarker(a,c),w[t]=c,v.push({rect:s.createRect(0,0,0,0,0,{stroke:f,fill:"grey",opacity:.0001,inh:!0}),id:e}),l.push(u);return n._seriesGroups=l,n._trackers=v,n.drawTrackers(),n._markers=w,n._markersId=p,n._locateElements(h),n},_locateElements:function(n){var t=this,i=n.border,r=i.visible&&i.width&&i.color&&i.color!==f;t._moveInInitialValues(),t._locateRowsColumns(t._seriesGroups,t._trackers,t._data.length,t._background,n),t._background&&t._adjustBackgroundSettings(t._background,r,n),t._setBoundingRect(n)},_moveInInitialValues:function(){var n=this;n._legendGroup&&n._legendGroup.move(0,0),n._trackerGroup&&n._trackerGroup.move(0,0),n._background&&n._background.applySettings({x:0,y:0,width:0,height:0})},_applyMarkerOptions:function(n,t){n&&n.applySettings(t)},applySelected:function(n){var t=this._getIndexById(n);return t!==null&&this._applyMarkerOptions(this._markers[t],{fill:this._markersPatternsIds[t].selectedPatternId}),this},applyHover:function(n){var t=this._getIndexById(n);return t!==null&&this._applyMarkerOptions(this._markers[t],{fill:this._markersPatternsIds[t].hoverPatternId}),this},resetItem:function(n){var t=this._getIndexById(n);t!==null&&this._applyMarkerOptions(this._markers[t],{fill:this._data[t].color||this._data[t].states.normal.fill})},_getIndexById:function(n){for(var i=this._markersId,r=i.length,t=0;t<r;t++)if(i[t]===n)return t;return null},drawTrackers:function(){if(this._options.visible&&this._insideLegendGroup){var n=this,i=n._trackerGroup.append(n._legendGroup);return t.each(n._trackers||[],function(t,r){var u=r.rect;u.data({itemIndex:r.id,mode:n._options.hoverMode}),u.append(i)}),n}},_disposeTrackers:function(){var n=this;t.each(n._trackers||[],function(n,t){t.rect.removeData()}),n._trackers=null},_createMarker:function(n,t,i){var r=this,u=r._renderer,s=r._markersPatternsIds,f=r._options.markerSize,e=n.states,o;return o=u.createRect(0,0,f,f,0,{fill:n.color}).append(t),s[i]={hoverPatternId:d(u,e,"hover",n.color),selectedPatternId:d(u,e,"selection",n.color)},o},_createLabel:function(n,t,i){var r=this,u=r._options,f=u.itemTextPosition,c=f===a||f===s?l:e,o,h,v={seriesName:n.text,seriesNumber:t,seriesColor:n.color};return o=r._formatLabel.call(v,u),h=r._renderer.createText(o,0,0,{font:u.font,align:c}).append(i)},_cleanLegendGroups:function(){var n=this,t=n._trackerGroup,i=n._legendGroup;i&&(i.clear(),n._insideLegendGroup&&n._insideLegendGroup.dispose(),n._insideLegendGroup=null),t&&t.clear()},_createBackground:function(n){var t=this,i=t._options,r=i.position===b,u=i.backgroundColor,e=u||(r?i.containerBackgroundColor:f);(r||u||n)&&(t._background=t._renderer.createRect(0,0,0,0,0,{fill:e,"class":"dxc-border"}).append(t._insideLegendGroup))},_formatLabel:function(n){return n.customizeText.call(this,this)},_locateLabelAndMarker:function(n,t){var c=this,l=7,k=4,d=2,f=0,o=0,v,y,i=n.getBBox(),h=c._options.markerSize,p=h,w=p/2-(i.y+i.height/2),b=h/2-(i.x+i.width/2);switch(c._options.itemTextPosition){case e:o=r(w),v=i.width+l;break;case u:f=h+l,o=r(w);break;case a:f=r(b),y=k;break;case s:f=r(b),o=p+d-i.y}n.applySettings({x:f,y:o}),t.applySettings({x:v,y:y})},_locateRowsColumns:function(n,t,i,r,u){function k(n,t){return(n>t||n<1)&&(n=t),n}var o=this,d=u.itemTextPosition,v=o._size,s,l=o._getRowsColumns(i),f=l.rows,e=l.columns,h=u.margin,g=r?u.paddingLeftRight:0,nt=r?u.paddingTopBottom:0,y=v.width-h.left-h.right-2*g,w=v.height-h.top-h.bottom-2*nt,b,tt,a=function(i,r){b=o._getDataRowsColumns(n,r,i),o._moveItems(b,n,d,t,u)};a(f,e),s=o._insideLegendGroup?o._insideLegendGroup.getBBox():{},l.autoEdit&&(f===1?s.width>y&&e>1&&(e=p(e*y/s.width)||1,e=k(e,i),f=c(i/e),a(f,e)):e===1&&s.height>w&&f>1&&(f=p(f*w/s.height)||1,f=k(f,i),e=c(i/f),a(f,e))),o._rowsCountDrawed=f,o._columnsCountDrawed=e},_moveItems:function(n,t,i,r,f){var tt=this,w,v,k,d,y,p,o,s=0,h=0,c,l=f.columnItemSpacing,a=f.rowItemSpacing,it=f.equalColumnWidth,rt=tt._renderer,g=[],nt=0,b=0;for(k=n.rows,d=n.cols,b=n.maxHeightRow,nt=n.maxWidthColumn,g=n.maxWidthPerColumn,w=0;w<k;w++){for(v=0;v<d;v++){if(y=k<d?w*d+v:w+v*k,p=t[y],!p)break;o=p.getBBox(),c=it?nt:g[v],i===u?(p.move(s-o.x,h),r[y].rect.applySettings({x:s-l/2,y:h+o.y-a/2,height:b+a,width:c+l})):i===e?(p.move(o.x+c-o.width+s-l/2,h),r[y].rect.applySettings({x:o.x+c-o.width+s-l/2,y:h+o.y-a/2,height:b+a,width:c+l})):(p.move(s-o.x-o.width/2+c/2,h),r[y].rect.applySettings({x:s-l/2,y:h+o.y-a/2,height:b+a,width:c+l})),s=s+c+l}h=h+b+a,s=0}},_getDataRowsColumns:function(n,t,i){for(var c=this,u,l=c._options,a=l.equalColumnWidth,v=c.series||{},e=[],s=0,h=0,o,f,r=0;r<t;r++)e[r]=0;for(r=0;r<i;r++)for(u=0;u<t;u++){if(o=i<t?n[r*t+u]:n[r+u*i],!o)break;f=o.getBBox(),h<f.height&&(h=f.height),a?s<f.width&&(s=f.width):e[u]<f.width&&(e[u]=f.width)}return{rows:i,cols:t,maxWidthPerColumn:e,maxWidthColumn:s,maxHeightRow:h}},_getRowsColumns:function(n){var s=this,r=s._options,u=r.orientation===v,t=r.rowCount,f=c(n/t),i=r.columnCount,e=c(n/i),o;return i&&!t?t=e:!i&&t?i=f:i&&t?u&&i<f?i=f:!u&&t<e&&(t=e):(o=!0,u?(t=1,i=n):(i=1,t=n)),{rows:t,columns:i,autoEdit:o}},_adjustBackgroundSettings:function(n,t,i){var o=this,f=i.border,e=o._insideLegendGroup.getBBox(),u={x:r(e.x-i.paddingLeftRight),y:r(e.y-i.paddingTopBottom),width:r(e.width)+2*i.paddingLeftRight,height:r(e.height)+2*i.paddingTopBottom,opacity:i.backgroundOpacity};t&&(u.strokeWidth=f.width,u.stroke=f.color,u.strokeOpacity=f.opacity,u.dashStyle=f.dashStyle,u.rx=f.cornerRadius||0,u.ry=f.cornerRadius||0),n.applySettings(u)},_setBoundingRect:function(n){var r=this,t,i=n.margin;r._insideLegendGroup&&(t=r._insideLegendGroup.getBBox(),t.height+=i.top+i.bottom,t.width+=i.left+i.right,t.x-=i.left,t.y-=i.top,r.boundingRect=t)},changeSize:function(n){var i=this,r=t.extend(!0,{},i._options),u=r.margin;n.height>=0&&(n.height=o(u,["top","bottom"],n.height),r.border.visible&&(n.height=2*o(r,["paddingTopBottom"],n.height/2)),i._rowsCountDrawed-1&&(n.height=(i._rowsCountDrawed-1)*o(r,["rowItemSpacing"],n.height/(i._rowsCountDrawed-1)))),n.width>=0&&(n.width=o(u,["left","right"],n.width),r.border.visible&&(n.width=2*o(r,["paddingLeftRight"],n.width/2)),i._columnsCountDrawed-1&&(n.width=(i._columnsCountDrawed-1)*o(r,["columnItemSpacing"],n.width/(i._columnsCountDrawed-1)))),i._insideLegendGroup&&(n.height>0||n.width>0?(i._options._incidentOccured("W2104"),i._insideLegendGroup.remove(),i._insideLegendGroup=null,i._trackerGroup&&i._trackerGroup.clear()):i._locateElements(r))},getTrackerGroup:function(){return this._trackerGroup},getActionCallback:function(n){var i=this;return i._options.visible?function(t){var u=n.type,f=u?!0:!1,r=u||n.series.type;(f||r==="pie"||r==="doughnut"||r==="donut")&&i[t]&&i[t](n.index)}:t.noop},getLayoutOptions:function(){var n=this._options,t=this._insideLegendGroup?this.boundingRect:{width:0,height:0,x:0,y:0};return n?(t.verticalAlignment=n.verticalAlignment,t.horizontalAlignment=n.horizontalAlignment,t.cutLayoutSide=n.orientation==="horizontal"?n.verticalAlignment:n.horizontalAlignment==="center"?n.verticalAlignment:n.horizontalAlignment,t):null},shift:function(n,t){var i=this,r={},u=i.getLayoutOptions();r.translateX=n-u.x,r.translateY=t-u.y,i._insideLegendGroup&&i._insideLegendGroup.applySettings(r),i._trackerGroup&&i._trackerGroup.applySettings(r)},getPosition:function(){return this._options.position},dispose:function(){var n=this;return n._disposeTrackers(),n._legendGroup=null,n._trackerGroup=null,n._insideLegendGroup=null,n._renderer=null,n._options=null,n._data=null,n}})}(DevExpress,jQuery),function(n,t,i){var k=t.viz.core,s=t.utils,f=s.isDefined,a=s.isDate,h=s.getLog,d=s.raiseTo,rt=1,ut=6e4,r="min",u="max",e="minVisible",o="maxVisible",g="minValueMargin",nt="maxValueMargin",c="categories",v="keepValueMargins",p="base",w="axisType",b=function(n,t,i){return d(Math.floor(h(n,t))+(i||0),t)},l=function(n,t){return t<n},y=function(n,t){return t>n},tt=function(n,t,i,r){var u=f(t);f(n)?u&&r(n,t)&&i(t):u&&i(t)},it=function(n,t,i,r,u){return n=n.valueOf()+r*i*t,u?new Date(n):n};k.Range=function(t){t&&n.extend(this,t)},n.extend(k.Range.prototype,{dispose:function(){this[c]=null},addRange:function(n){var t=this,d=t[c],ot,h=n[c],a,it,ft,ut,et=function(i){var r=i+"Priority",u=(t[r]||0)-(n[r]||0);((t[i]||0)<n[i]&&u===0||u<0)&&(t[i]=n[i],t[r]=n[r])},b=function(i,r){tt(t[i],n[i],function(n){t[i]=n},r)},rt=function(n,i,r){tt(t[n],t[i],function(i){f(t[n])&&(t[n]=i)},r)},k=function(i){t[i]=t[i]||n[i]};if(s.isDefined(n.stick)&&(t.stick=n.stick),k("invert"),k(w),k("dataType"),k(v),t[w]==="logarithmic"?k(p):t[p]=i,b(r,l),b(u,y),b(e,l),b(o,y),b("interval",l),et(g),et(nt),rt(r,e,l),rt(r,o,l),rt(u,o,y),rt(u,e,y),d===i)t[c]=h;else if(ft=d.length,h&&h.length)for(a=0;a<h.length;a++){for(it=0,ut=!1;it<ft;it++)if(d[it].valueOf()===h[a].valueOf()){ut=!0;break}ut||d.push(h[a])}return this},isDefined:function(){return f(this[r])&&f(this[u])||f(this[c])},setStubData:function(n){var t=this,i=(new Date).getYear()-1,f=n==="datetime",e=t.axisType==="discrete";return e?t.categories=["0","1","2"]:(t[r]=f?new Date(i,0,1):0,t[u]=f?new Date(i,11,31):10),t.stubData=!0,t},applyValueMargins:function(){var n=this,t=n[p],i=a(n[u])||a(n[r]),s=function(t,r,u){var e=n[t],o=n[r],s=n[g],h=n[nt],c=!1,l=!1;!u||i||n[v]||(e<=0&&o<=0&&h>o/(e-o)&&(n[r]=0,l=!0),e>=0&&o>=0&&s>e/(o-e)&&(n[t]=0,c=!0)),f(o)&&!l&&h&&(n[r]=it(o,h,u,1,i)),f(e)&&!c&&s&&(n[t]=it(e,s,u,-1,i))},c=function(t,i){n[t]=f(n[t])?n[t]:n[i]},l=function(i){if(f(n[i])){var r=b(n[i],t);h(n[i]/r,t)<.1&&n.alwaysCorrectMin&&!n[v]?n[i]=b(n[i],t,-1):n.alwaysCorrectMin&&!n[v]?n[i]=r:h(n[i]/r,t)<.5&&(n[i]=r)}},y=function(i){if(f(n[i])){var r=b(n[i],t);h(n[i]/r,t)>.5&&(n[i]=d(Math.ceil(h(n[i],t)),t))}},k=function(t,i,r){(!f(n[t])||r)&&(n[t]=n[i])};return n[w]==="logarithmic"&&n[r]!==n[u]?(l(r),y(u),n.isValueRange&&n[e]!==n[o]&&(l(e),y(o)),k(e,r,n[e]<n[r]),k(o,u,n[o]>n[u])):(c(e,r),c(o,u),s(r,u,n[u]-n[r]),s(e,o,n[o]-n[e])),this},correctValueZeroLevel:function(){function t(t,i){n[t]<0&&n[i]<0&&(n[i]=0),n[t]>0&&n[i]>0&&(n[t]=0)}var n=this;return a(n[u])||a(n[r])?n:(t(r,u),t(e,o),n)}})}(jQuery,DevExpress),function(n){n.viz.core.series=n.viz.core.series||{},n.viz.core.series.helpers=n.viz.core.series.helpers||{},n.viz.core.series.helpers.consts={events:{mouseover:"mouseover",mouseout:"mouseout",mousemove:"mousemove",touchstart:"touchstart",touchmove:"touchmove",touchend:"touchend",mousedown:"mousedown",mouseup:"mouseup",click:"click",selectSeries:"selectseries",deselectSeries:"deselectseries",selectPoint:"selectpoint",deselectPoint:"deselectpoint",showPointTooltip:"showpointtooltip",hidePointTooltip:"hidepointtooltip"},states:{hover:"hover",normal:"normal",selected:"selected",normalMark:0,hoverMark:1,selectedMark:2},animations:{showDuration:{duration:400},hideGroup:{opacity:.0001},showGroup:{opacity:1}}}}(DevExpress),function(n,t){var e=t.utils,r=Math.round,u=Math.abs,f=Math.pow;t.viz.core.series.helpers.SeriesFamily=t.Class.inherit(function(){var y=function(t){var i=this,r=n.noop;n.extend(i,t),i.type=i.type.toLowerCase(),i.series=[];switch(i.type){case"bar":i.adjustSeriesDimensions=c,i.adjustSeriesValues=r,i.updateSeriesValues=d;break;case"rangebar":i.adjustSeriesDimensions=c,i.adjustSeriesValues=r,i.updateSeriesValues=r;break;case"fullstackedbar":i.fullStacked=!0,i.adjustSeriesDimensions=l,i.adjustSeriesValues=o,i.updateSeriesValues=v;break;case"stackedbar":i.adjustSeriesDimensions=l,i.adjustSeriesValues=o,i.updateSeriesValues=v;break;case"fullstackedarea":case"fullstackedline":i.fullStacked=!0,i.adjustSeriesDimensions=r,i.adjustSeriesValues=o,i.updateSeriesValues=r;break;case"stackedarea":case"stackedline":i.adjustSeriesDimensions=r,i.adjustSeriesValues=o,i.updateSeriesValues=r;break;case"candlestick":case"stock":i.adjustSeriesDimensions=g,i.adjustSeriesValues=r,i.updateSeriesValues=r;break;case"bubble":i.adjustSeriesDimensions=nt,i.adjustSeriesValues=r,i.updateSeriesValues=r;break;default:i.adjustSeriesDimensions=r,i.adjustSeriesValues=r,i.updateSeriesValues=r}},p=function(){this.series=null,this.translators=null},w=function(t){var u=this,r,i;for(n.isArray(t)||(t=[t]),i=0;i<t.length;i++)r=t[i],r.type.toLowerCase()===u.type&&u.series.push(r)},s=function(t,i,u,f,e){var o,s,g,c,h,a,d,nt,p,l,w={},v={},b,y,k;if(f)for(s=f.width&&f.width<0?0:f.width,o=f.spacing&&f.spacing<0?0:f.spacing,s&&!o?u>1?(o=r((i*.7-s*u)/(u-1)),o<1&&(o=1)):o=0:o&&!s?(s=r((i*.7-o*(u-1))/u),s<2&&(s=2)):o||s||(u>1?(o=r(i*.7/u*.2),o<1&&(o=1)):o=0,s=r((i*.7-o*(u-1))/u),s<2&&(s=2)),s*u+o*(u-1)>i&&(o=r((i*.7-s*u)/(u-1)),o<1&&(o=1,g=r((i*.7-o*(u-1))/u))),c=u/2,a=0;a<t.length;a++)h=e(a),nt=t[a].getPoints(),p=(h-c+.5)*(g||s)-(c-h-.5)*o,n.each(nt,function(n,t){t.correctCoordinates({width:s,offset:p})});else{n.each(t,function(n,t){l=t.getStackName&&t.getStackName(),l=l||n.toString(),v[l]||(v[l]=[]),v[l].push(t)}),n.each(t,function(t,i){n.each(i.getPoints(),function(n,t){var i=t.argument;w.hasOwnProperty(i)||(w[i.valueOf()]=1)})});for(k in w)w.hasOwnProperty(k)&&(b=[],n.each(v,function(t,i){n.each(i,function(n,i){return d=i.getPointByArg(k),d&&d.value?(b.push(t),!1):void 0})}),y=b.length,o=r(i*.7/y*.2),o<1&&(o=1),s=r((i*.7-o*(y-1))/y),s<2&&(s=2),c=y/2,n.each(v,function(t,i){(h=n.inArray(t,b),h!==-1)&&(p=(h-c+.5)*s-(c-h-.5)*o,n.each(i,function(n,t){var i=t.getPointByArg(k);i&&i.value&&i.correctCoordinates({width:s,offset:p})}))}))}},i=function(t){return n.map(t.series,function(n){return n.isVisible()?n:null})},c=function(n){var t=this,u=t.equalBarWidth,r=i(t);s(r,h(t,n),r.length,u,function(n){return n})},l=function(t){var r=this,c,u=i(r),f={},e=0,o=r.equalBarWidth;n.each(u,function(){var n=this.getStackName();f.hasOwnProperty(n)||(f[n]=e++)}),s(u,h(r,t),e,o,function(n){return f[u[n].getStackName()]})},o=function(){var r=this,u=i(r),t={positive:{},negative:{}};n.each(u,function(i,r){var u=r.getPoints();n.each(u,function(n,i){var o=i.initialValue,e=i.argument,s=r.getStackName?r.getStackName():"default",h=o>=0?"positive":"negative",f;t[h][s]=t[h][s]||{},f=t[h][s],f[e.valueOf()]?(u[n].correctValue(f[e.valueOf()]),f[e.valueOf()]+=o):(f[e.valueOf()]=o,u[n].resetCorrection())})}),b(u,t,r.fullStacked)},b=function(t,i,r){n.each(t,function(t,u){var f=u.getPoints();n.each(f,function(n,t){var h=t.value,e=u.getStackName?u.getStackName():"default",o=h>=0?"positive":"negative",s;i[o][e]=i[o][e]||{},s=i[o][e],f[n].setPercentValue(s[t.argument.valueOf()],r)})})},a=function(n,t,i){var e=n.rotated,r=e?t.x:t.y,f=r.getCanvasVisibleArea();if(i)return u(r.untranslate(f.min)-r.untranslate(f.min+i))},v=function(t){var r=this,o=i(r),f={positive:{},negative:{}};n.each(o,function(i,o){var s=o.getPoints(),h=o.getOptions().minBarSize;n.each(s,function(n,i){var y=i.value,p=i.minValue,w=i.argument,c,b,l,k=o.getStackName?o.getStackName():"default",d=y>=0?"positive":"negative",v;l=a(r,t,h),v=f[d][k]=f[d][k]||{},v[w.valueOf()]?(p=e.isNumber(p)?p:0,b=u(p-y),c=l&&b<l?l:y-p,s[n].minValue=v[w.valueOf()],s[n].value=v[w.valueOf()]+c,v[w.valueOf()]+=c):(b=y,c=l&&b<l?l:y,s[n].value=c,v[w.valueOf()]=c)})}),r.fullStacked&&k(o,f)},k=function(i,r){n.each(i,function(i,u){var e=u.getStackName?u.getStackName():"default",f=u.getPoints();n.each(f,function(n,i){var h=i.value,s=i.argument,u=h>=0?"positive":"negative",o;r[u][e]=r[u][e]||{},o=r[u][e],f[n].value=f[n].value/o[s.valueOf()]||0,t.utils.isNumber(f[n].minValue)&&(f[n].minValue=f[n].minValue/o[s.valueOf()]||0)})})},d=function(t){var i=this;n.each(i.series,function(r,f){var e=f.getPoints(),o=f.getOptions().minBarSize;n.each(e,function(n,r){var s=r.value,h,c,f;f=a(i,t,o),c=u(s),h=f&&c<f?s>=0?f:-f:s,e[n].value=h})})},g=function(n){var t=this,r=i(t);s(r,h(t,n),r.length,!0,function(n){return n})},h=function(n,t){var i=n.rotated?t.y:t.x;return n.interval=i.getInterval()},nt=function(t){for(var s=this,c=i(s),l,v=t.x.getCanvasVisibleArea(),y=t.y.getCanvasVisibleArea(),p=Math.min(v.max-v.min,y.max-y.min),w=f(s.minBubbleSize,2),nt=f(p*s.maxBubbleSize,2),tt=(p*s.maxBubbleSize+s.minBubbleSize)/2,e=Infinity,h=0,a,b,k,d,g,o=0;o<c.length;o++)l=c[o].getPoints(),n.each(l,function(n,t){h=h>t.size?h:t.size,e=e<t.size?e:t.size});for(d=h-e,g=u(nt-w),e=e<0?0:e,o=0;o<c.length;o++)l=c[o].getPoints(),n.each(l,function(n,t){h===e?a=r(tt):(k=u(t.size-e)/d,b=g*k+w,a=r(Math.sqrt(b))),t.correctCoordinates(a)})};return{ctor:y,dispose:p,add:w}}())}(jQuery,DevExpress),function(n,t){var u=t.viz,s=t.utils,w=s.isDefined,i=n.each,o=n.extend,v=n.isEmptyObject,e=n.Event,l=n.noop,h=2,c=1,b="none",r="includepoints",k="excludepoints",f="allseriespoints",y="applySelected",a="applyHover",p=function(){return{arg:{},val:{}}};u.core.series.mixins={chart:{},pieChart:{}},u.core.series.Series=t.Class.inherit({ctor:function(n,t){this.fullState=0,this._renderer=n,this._group=n.createGroup({"class":"dxc-series"}),this.updateOptions(t)},update:function(n,t){this.updateOptions(t),this.updateData(n)},_createLegendState:function(n,t){return{fill:n.color||t,hatching:n.hatching}},getLegendStyles:function(){return this._styles.legendStyles},_createStyles:function(n){var t=n.mainSeriesColor,i=this._getSpecialColor(t);this._styles={normal:this._parseStyle(n,t,t),hover:this._parseStyle(n.hoverStyle||{},i,t),selection:this._parseStyle(n.selectionStyle||{},i,t),legendStyles:{normal:this._createLegendState(n,t),hover:this._createLegendState(n.hoverStyle||{},i),selection:this._createLegendState(n.selectionStyle||{},i)}}},setAdjustSeriesLabels:function(n){i(this._points||[],function(t,i){i.setAdjustSeriesLabels(n)})},setClippingParams:function(n,t){this._paneClipRectID=n,this._forceClipping=t},getTagField:function(){return this._options.tagField||"tag"},getValueFields:l,getArgumentField:l,getPoints:function(){return this._points},_createPoint:function(n,t,i){if(n.index=i,this._checkData(n)){var r=t[i],f=this._customizePoint(n)||this._getCreatingPointOptions();return r?r.update(n,f):(r=u.core.CoreFactory.createPoint(n,f),t.push(r)),this.pointsByArgument[r.argument.valueOf()]=this.pointsByArgument[r.argument.valueOf()]||r,!0}},getRangeData:function(n,t){return this._visible?o(!0,{},this._getRangeData(n,t)):p()},_deleteElementsGroup:function(){this._elementsGroup&&(this._elementsGroup.detach(),this._elementsGroup=null)},_deleteBordersGroup:function(){this._bordersGroup&&(this._bordersGroup.detach(),this._bordersGroup=null)},_saveOldAnimationMethods:function(){this._oldClearingAnimation=this._clearingAnimation,this._oldUpdateElement=this._updateElement},_deleteOldAnimationMethods:function(){this._oldClearingAnimation=null,this._oldUpdateElement=null},updateOptions:function(n){var t=this,i=n.widgetType,r=t.type,u=n.type;if(t.type=u&&u.toString().toLowerCase(),!t._checkType(i)){t.dispose(),t.isUpdated=!1;return}r!==t.type&&(t._firstDrawing=!0,t._saveOldAnimationMethods(),t._resetType(r,i),t._setType(t.type,i)),t._options=n,t._pointOptions=null,t._deletePatterns(),t._patterns=[],t.name=n.name,t.pane=n.pane,t.axis=n.axis,t.tag=n.tag,t._createStyles(n),t._updateOptions(n),t._visible=n.visible,t.isUpdated=!0},_disposePoints:function(t){n.each(t||[],function(n,t){t.dispose()})},_correctPointsLength:function(n,t){this._disposePoints(this._oldPoints),this._oldPoints=t.splice(n,t.length)},_getTicksForAggregation:function(n,t,i,r){return u.core.tickProvider.getTicks({min:n,max:t,screenDelta:i,gridSpacingFactor:r})},updateDataType:function(n){var t=this;t.argumentType=n.argumentType,t.valueType=n.valueType,t.argumentAxisType=n.argumentAxisType,t.valueAxisType=n.valueAxisType},getValueCategories:function(){return this._options.valueCategories||[]},getOptions:function(){return this._options},getArgumentCategories:function(){return this._options.argumentCategories||[]},updateData:function(n){var t=this,r,u=0,e=t._options,f;t.pointsByArgument={},r=t._originalPoints||[],t._rangeData=p(),n&&n.length&&(t._canRenderCompleteHandle=!0),t._beginUpdateData(),i(n,function(n,i){f=t._getPointData(i,e),t._createPoint(f,r,u)&&(t._processRange(r[u],u>0?r[u-1]:null),u++)}),t._points=t._originalPoints=r,t._correctPointsLength(u,r),t._endUpdateData()},getTeamplatedFields:function(){var n=this,t=n.getValueFields(),r=[];return t.push(n.getTagField()),i(t,function(t,i){var u={};u.teamplateField=i+n.name,u.originalField=i,r.push(u)}),r},resamplePoints:function(n,t,r){var u=this,o=u.getAllPoints(),l=u._options.rotated?n.y:n.x,f,e,c,h;o.length&&(i(o,function(n,i){f=i.argument-t<=0?n:f,e||(e=i.argument-r>0?n:null)}),f=f?f:1,e=s.isDefined(e)?e:o.length-1,t=o[f-1].argument,r=o[e].argument,c=u._getPointSize(),h=u.argumentAxisType!=="discrete"&&u.valueAxisType!=="discrete"?u._getTicksForAggregation(t,r,l.canvasLength,c):l.canvasLength/c,u._points=u._resample(h,h.tickInterval))},_removeOldSegments:function(n){var t=this;i(t._graphics.splice(n,t._graphics.length)||[],function(n,i){t._removeElement(i)}),t._trackers&&i(t._trackers.splice(n,t._trackers.length)||[],function(n,t){t.remove()})},draw:function(n,t,i,r){var u=this,f;u._oldClearingAnimation&&t&&u._firstDrawing?(f=function(){u._draw(n,!0,i)},u._oldClearingAnimation(n,f)):u._draw(n,t,i,r)},_clearSeries:function(){this._deleteElementsGroup(),this._deleteBordersGroup(),this._deleteTrackers(),this._graphics=[],this._trackers=[]},_draw:function(n,t,r,u){var f=this,h=f._points||[],e=[],s=0,o=f._firstDrawing,c,l;if(f._graphics=f._graphics||[],f._graphics=f._graphics||[],f._prepareSeriesToDrawing(),f._visible)f._group.append(f._options.seriesGroup);else{t=!1,this._group.detach();return}f.translators=n,f._createGroups(t,undefined,o),f._segments=[],c=f._markersGroup,l=f._labelsGroup,f._drawedPoints=[],f._firstDrawing=h.length?!1:!0,i(this._patterns||[],function(n,t){t.append()}),i(h,function(i,r){r.translate(n),r.hasValue()?(f._drawPoint(r,c,l,t,o),e.push(r)):e.length&&(f._drawSegment(e,t,s++),e=[])}),e.length&&f._drawSegment(e,t,s++),f._removeOldSegments(s),f._defaultSegments=f._generateDefaultSegments(),f._adjustLabels(o),r&&f.hideLabels(),t&&f._animate(o),f.isSelected()?f._changeStyle(u,y):this.isHovered()&&this._changeStyle(u,a)},drawTrackers:function(){var n=this,t=n._trackers=n._trackers||[],r=n._trackersGroup=n._trackersGroup||n._renderer.createGroup(),u=n._markerTrackerGroup=n._markerTrackerGroup||n._renderer.createGroup();if(n.isVisible())r.append(n._options.trackersGroup),u.append(n._options.markerTrackerGroup);else{r.detach(),u.detach();return}i(n._segments||[],function(i,u){t[i]?n._updateTrackerElement(u,t[i]):(t[i]=n._drawTrackerElement(u).append(r),t[i].data({series:n}))}),i(n.getVisiblePoints(),function(t,i){i.drawTracker(n._renderer,u)}),n._applyTrackersClippings()},_checkType:function(n){return!!u.core.series.mixins[n][this.type]},_resetType:function(n,t){var r=this;n&&i(u.core.series.mixins[t][n],function(n){delete r[n]})},_setType:function(n,t){var r=this;i(u.core.series.mixins[t][n],function(n,t){r[n]=t})},_setSelectedState:function(n,t,i){this.lastSelectionMode=t=(t||this._options.selectionMode).toLowerCase(),n&&!this.isSelected()?(this.fullState=this.fullState|h,this._changeStyle(i,y)):!n&&this.isSelected()&&(this.fullState=this.fullState&~h,this.isHovered()?this._changeStyle(i,a):this._changeStyle(i,"resetItem"))},_setHoverState:function(n,t,i){this.lastHoverMode=t=(t||this._options.hoverMode).toLowerCase(),n&&!this.isHovered()?(this.fullState=this.fullState|c,this.isSelected()||this._changeStyle(i,a)):!n&&this.isHovered()&&(this.fullState=this.fullState&~c,this.isSelected()||this._changeStyle(i,"resetItem"))},setHoverState:function(n,t){this._setHoverState(!0,n,t)},releaseHoverState:function(n,t){this._setHoverState(!1,n,t)},setSelectedState:function(n,t){this._setSelectedState(!0,n,t)},releaseSelectedState:function(n,t){this._setSelectedState(!1,n,t)},isFullStackedSeries:function(){return this.type.indexOf("fullstacked")===0},isStackedSeries:function(){return this.type.indexOf("stacked")===0},isFinancialSeries:function(){return this.type==="stock"||this.type==="candlestick"},_changeStyle:function(n,t){var u=this._calcStyle(),e;u.mode!==b&&(n&&n(t),(u.mode===r||u.mode===f)&&(e=u.pointStyle,i(this._points||[],function(n,t){t.isSelected()||t.applyStyle(e)})),this._applyStyle(u.series))},_calcStyle:function(){var t=this._styles,i=!1,n;switch(this.fullState&3){case 0:n={pointStyle:"normal",mode:r,series:t.normal};break;case 1:n={pointStyle:"hover",mode:this.lastHoverMode,series:t.hover};break;case 2:n={pointStyle:"selection",mode:this.lastSelectionMode,series:t.selection};break;case 3:i=this.lastSelectionMode===k&&(this.lastHoverMode===r||this.lastHoverMode===f),n={pointStyle:i?"normal":"selection",mode:i?r:this.lastSelectionMode,series:t.selection}}return n},_getMainAxisName:function(){return this._options.rotated?"X":"Y"},areLabelsVisible:function(){return!w(this._options.maxLabelCount)||this._points.length<=this._options.maxLabelCount},getLabelVisibility:function(){return this.areLabelsVisible()&&this._options.label&&this._options.label.visible},_customizePoint:function(n){var t=this,l=t._options,s=t._options.customizePoint,i,u,r,f,h=t._options.customizeLabel,e,c;return h&&h.call&&(i=o({seriesName:t.name,series:t},n),r=h.call(i,i),e=r&&!v(r),r=e?o(!0,{},l.label,r):null),s&&s.call&&(i=i||o({seriesName:t.name,series:t},n),f=s.call(i,i),c=f&&!v(f)),(e||c)&&(u=t._parsePointOptions(t._preparePointOptions(f),r||l.label),u.styles.useLabelCustomOptions=e,u.styles.usePointCustomOptions=c),u},_getLabelOptions:function(t,i){var r=t||{},u=r.font||{},f=r.border||{},e=r.connector||{},o={align:r.alignment,font:{color:r.backgroundColor==="none"&&u.color.toLowerCase()==="#ffffff"&&r.position!=="inside"?i:u.color,family:u.family,weight:u.weight,size:u.size,opacity:u.opacity},style:r.style},s={fill:r.backgroundColor||i,strokeWidth:f.visible?f.width||0:0,stroke:f.visible&&f.width?f.color:"none",dashStyle:f.dashStyle},h={stroke:e.visible&&e.width?e.color||i:"none",strokeWidth:e.visible?e.width||0:0};return{format:r.format,argumentFormat:r.argumentFormat,precision:r.precision,argumentPrecision:r.argumentPrecision,percentPrecision:r.percentPrecision,customizeText:n.isFunction(r.customizeText)?r.customizeText:undefined,attributes:o,visible:u.size!==0?r.visible:!1,showForZeroValues:r.showForZeroValues,horizontalOffset:r.horizontalOffset,verticalOffset:r.verticalOffset,radialOffset:r.radialOffset,background:s,position:r.position,connector:h,rotationAngle:r.rotationAngle,resolveLabelsOverlapping:this._options.resolveLabelsOverlapping}},show:function(){this._visible||(this._visible=!0,this.hidePointTooltip(),this._options.visibilityChanged())},hide:function(){this._visible&&(this._visible=!1,this.hidePointTooltip(),this._options.visibilityChanged())},hideLabels:function(){i(this._points,function(n,t){t._label.hide()})},_parsePointOptions:function(n,t){var i=this._options,u=this._createPointStyles(n),r;return r=o(!0,{},n,{type:i.type,tag:this.tag,rotated:i.rotated,series:this,styles:u,visibilityChanged:i.visibilityChanged}),r.label=this._getLabelOptions(t,u.normal.fill),r},_resample:function(t,r){var u=this,e=[],h,f=0,o=0,s=u.getAllPoints(),c;return u.argumentAxisType==="discrete"||u.valueAxisType==="discrete"?(r=s.length/t,h=n.map(s,function(n,t){return Math.floor(f)<=t?(f+=r,n):(n.setInvisibility(),null)})):(u._aggregatedPoints=u._aggregatedPoints||[],i(s,function(n,i){switch(u._isInInterval(i.argument,t,f,r)){case!0:e.push(i);break;case"nextInterval":for(var s=u._fusionPoints(e,t[f],f);u._isInInterval(i.argument,t,f,r)==="nextInterval";)f++;e=[],u._isInInterval(i.argument,t,f,r)===!0&&e.push(i),u._createPoint(s,u._aggregatedPoints,o)&&o++}}),e.length&&(c=u._fusionPoints(e,t[f],f),u._createPoint(c,u._aggregatedPoints,o)&&o++),u._correctPointsLength(o,u._aggregatedPoints),u._endUpdateData(),u._aggregatedPoints)},_isInInterval:function(t,i,r,u){var f=i[r],o=i[r+1],e;return(u=n.isNumeric(u)?u:s.convertDateTickIntervalToMilliseconds(u),e=s.isDate(f)?new Date(f.getTime()+u):f+u,t>=f&&t<e)?!0:t<f||o===undefined?!1:"nextInterval"},canRenderCompleteHandle:function(){var n=this._canRenderCompleteHandle;return delete this._canRenderCompleteHandle,!!n},isHovered:function(){return!!(this.fullState&1)},isSelected:function(){return!!(this.fullState&2)},isVisible:function(){return this._visible},getAllPoints:function(){return(this._originalPoints||[]).slice()},getPointByPos:function(n){return(this._points||[])[n]},getVisiblePoints:function(){return(this._drawedPoints||[]).slice()},setPointHoverState:function(n,t){n.fullState=n.fullState|c,this.isSelected()&&(this.lastSelectionMode===f||this.lastSelectionMode===r)||n.isSelected()||(n.applyStyle("hover"),t&&t("applyHover"))},releasePointHoverState:function(n,t){n.fullState=n.fullState&~c,this.isSelected()&&(this.lastSelectionMode===f||this.lastSelectionMode===r)||n.isSelected()||this.isHovered()&&(this.lastHoverMode===f||this.lastHoverMode===r)||(n.applyStyle("normal"),t&&t("resetItem"))},setPointSelectedState:function(n,t){n.fullState=n.fullState|h,n.applyStyle("selection"),t&&t("applySelected")},releasePointSelectedState:function(n,t){n.fullState=n.fullState&~h,this.isHovered()&&(this.lastHoverMode===f||this.lastHoverMode===r)||n.isHovered()?(n.applyStyle("hover"),t&&t("applyHover")):this.isSelected()&&(this.lastSelectionMode===f||this.lastSelectionMode===r)?(n.applyStyle("selection"),t&&t("applySelected")):(n.applyStyle("normal"),t&&t("resetItem"))},selectPoint:function(n){this._options.seriesGroup&&this._options.seriesGroup.trigger(new e("selectpoint"),n)},deselectPoint:function(n){this._options.seriesGroup&&this._options.seriesGroup.trigger(new e("deselectpoint"),n)},showPointTooltip:function(n){this._options.seriesGroup&&this._options.seriesGroup.trigger(new e("showpointtooltip"),n)},hidePointTooltip:function(n){this._options.seriesGroup&&this._options.seriesGroup.trigger(new e("hidepointtooltip"),n)},select:function(){this._options.seriesGroup&&this._options.seriesGroup.trigger(new e("selectseries",{target:this}),this._options.selectionMode),this._group.toForeground(),this._trackersGroup&&this._trackersGroup.toBackground()},clearSelection:function(){this._options.seriesGroup&&this._options.seriesGroup.trigger(new e("deselectseries",{target:this}),this._options.selectionMode)},getPointByArg:function(n){return this.pointsByArgument[n.valueOf()]||null},_deletePoints:function(){this._disposePoints(this._originalPoints),this._disposePoints(this._aggregatedPoints),this._disposePoints(this._oldPoints),this._points=null,this._oldPoints=null,this._aggregatedPoints=null,this._originalPoints=null,this._drawedPoint=null},_deletePatterns:function(){i(this._patterns||[],function(n,t){t&&t.dispose()}),this._patterns=null},_deleteTrackers:function(){var n=this;i(n._trackers||[],function(n,t){t.remove()}),n._trackersGroup&&n._trackersGroup.detach(),n._markerTrackerGroup&&n._markerTrackerGroup.detach(),n._trackers=n._trackersGroup=n._markerTrackerGroup=null},dispose:function(){this._deletePoints(),this._group.detach(),this._labelsGroup&&this._labelsGroup.detach(),this._deletePatterns(),this._deleteTrackers(),this._group=null,this._markersGroup=null,this._elementsGroup=null,this._bordersGroup=null,this._labelsGroup=null,this._graphics=null,this._rangeData=null,this._renderer=null,this.translators=null,this._styles=null,this._options=null,this._pointOptions=null,this._drawedPoints=null,this._aggregatedPoints=null,this.pointsByArgument=null,this._segments=null},correctPosition:l,getColor:function(){return this.getLegendStyles().normal.fill},getStackName:function(){return this.type==="stackedbar"||this.type==="fullstackedbar"?this._stackName:null}})}(jQuery,DevExpress),function(n){var y=Math,w=y.abs,d=y.min,o=n.each,b=n.isEmptyObject,i=DevExpress.utils.isDefined,p=15,k=20,s=20,h=.3,c="categories",l="interval",a="minValueMargin",v="maxValueMargin",u="min",r="max",f="minVisible",e="maxVisible";DevExpress.viz.core.series.helpers.rangeDataCalculator=function(){var nt=function(n,t,r,u){var f=n[t],e=n[r];n[t]=u<f||!i(f)?u:n[t],n[r]=u>e||!i(e)?u:n[r]},et=function(n,t,i,r,u){var f=t[r],e=t[u],o=t.argument,s=i&&i[r],h=i&&i[u],c=i&&i.argument;t.hasValue()&&ot(n,f,e,s,h),d(n,"arg",o,c)},d=function(n,t,r,u,f){var h=t==="arg"?"argument":"value",e=n._rangeData[t],s=e[l],o;n[h+"AxisType"]==="discrete"?(e[c]=e[c]||[],e[c].push(r)):(nt(e,"min","max",r),t==="arg"&&(o=i(u)?w(f?f(r,u):r-u):o,e[l]=i(o)&&(o<s||!i(s))?o:s))},t=function(n,t){var r=n._rangeData.val,u=n.valueAxisType==="discrete";u?(r.visibleCategories=r.visibleCategories||[],r.visibleCategories.push(t)):((t<r.minVisible||!i(r.minVisible))&&(r.minVisible=t),(t>r.maxVisible||!i(r.maxVisible))&&(r.maxVisible=t))},ot=function(n,t,i){var o=n._rangeData.val,s,h=o[l];n.valueAxisType==="discrete"?(o.categories=o.categories||[],o.categories.push(t,i)):(nt(o,u,r,t),nt(o,u,r,i))},g=function(t){var i={};return n.map(t,function(n){var t=i[n]?null:n;return i[n]=!0,t})},tt=function(n,t){var i=n._rangeData.arg,r,u;r=t.minArg<t.maxArg?t.minArg:t.maxArg,u=t.maxArg>t.minArg?t.maxArg:t.minArg,i.min=r<i.min?r:i.min,i.max=u>i.max?u:i.max,i.minVisible=r,i.maxVisible=u},it=function(n,t){var r,u;i(t.minVal)&&i(t.maxVal)&&(r=t.minVal<t.maxVal?t.minVal:t.maxVal,u=t.maxVal>t.minVal?t.maxVal:t.minVal),i(t.minVal)&&(n._rangeData.val.min=r<n._rangeData.val.min?r:n._rangeData.val.min,n._rangeData.val.minVisible=r),i(t.maxVal)&&(n._rangeData.val.max=u>n._rangeData.val.max?u:n._rangeData.val.max,n._rangeData.val.maxVisible=u)},st=function(n,r){var s=r.adjustOnZoom,u=n._points||[],f,e=!1;o(u,function(i,r){var h=r.argument,o=i>0?u[i-1]:null;s&&h>=n._rangeData.arg.minVisible&&h<=n._rangeData.arg.maxVisible&&(e||(o&&o.hasValue()&&t(n,o.value),e=!0),r.hasValue()&&t(n,r.value),f=i)}),i(f)&&f<u.length-1&&u[f+1].hasValue()&&t(n,u[f+1].value),it(n,r)},ht=function(n,r,u,f){var c=r.adjustOnZoom,e=n._points||[],s,h=!1;o(e,function(i,r){var l=r.argument,o=i>0?e[i-1]:null;c&&l>=n._rangeData.arg.minVisible&&l<=n._rangeData.arg.maxVisible&&(h||(o&&o.hasValue()&&(t(n,o[u]),t(n,o[f])),h=!0),r.hasValue()&&(t(n,r[u]),t(n,r[f])),s=i)}),i(s)&&s<e.length-1&&e[s+1].hasValue()&&t(n,e[s+1].value),it(n,r)},rt=function(n,t){var r=n._rangeData,i=n._points||[],u=n.argumentAxisType==="discrete";delete r.arg.interval,o(i,function(r,f){var o=f.argument,e=r>0?i[r-1]:null,s=e&&e.argument;u||d(n,"arg",o,s,t)})},ut=function(n){var t=n._rangeData,i=n._getMainAxisName(),r=i==="X"?"Y":"X";t.arg.categories&&(t.arg.categories=g(t.arg.categories)),t.val.categories&&(t.val.categories=g(t.val.categories)),t.arg.visibleCategories&&(t.arg.visibleCategories=g(t.arg.visibleCategories)),t.val.visibleCategories&&(t.val.visibleCategories=g(t.val.visibleCategories)),t.arg.axisType=n.argumentAxisType,t.arg.dataType=n.argumentType,t.val.axisType=n.valueAxisType,t.val.dataType=n.valueType,t.val.isValueRange=!0},y=function(n,t,i,r){n[t]=i,n[t+"Priority"]=r},ft=function(n,t,i){t===0&&y(n,i,0,k)},ct=function(n,t){var i=n._rangeData.val,o=i[f],s=i[e];t=t||{},i&&(i.alwaysCorrectMin=!0,n._rangeData.arg.keepValueMargins=!0,n.valueAxisType!=="logarithmic"&&n.valueType!=="datetime"&&n.getOptions().showZero!==!1&&(i[f]=o>(t.minVal||0)?t.minVal||0:o,i[e]=s<(t.maxVal||0)?t.maxVal||0:s,i[u]=i[u]>0?0:i[u],ft(i,i[u],a),i[r]=i[r]<0?0:i[r],(i[r]===0||i[r]>0&&i[u]<0)&&(i[a]=i[v],i[a+"Priority"]=i[v+"Priority"]),ft(i,i[r],v)))},lt=function(n){var t=n._rangeData.val,i=b(t);y(t,"minValueMargin",0,p),y(t,"maxValueMargin",0,p),i||(t.min=0)},at=function(n,t,i){var r=t.value,u=t.argument,f=i&&i.value,e=i&&i.argument;t.hasValue()&&d(n,"val",r,f),d(n,"arg",u,e)},vt=function(n){var t=n.getOptions().label;n.areLabelsVisible()&&t&&t.visible&&t.position!=="inside"&&y(n._rangeData.val,"maxValueMargin",h,s)},yt=function(n){var t=n._rangeData.val;n.areLabelsVisible()&&n._options.label.visible&&n._options.label.position!=="inside"&&(y(t,"maxValueMargin",h,s),y(t,"minValueMargin",h,s))},pt=function(n,t,r){var u=n._rangeData.val;n.argumentAxisType!=="discrete"&&t&&i(t.minArg)&&i(t.maxArg)?(u[f]=t.minVal,u[e]=t.maxVal,tt(n,t),st(n,t)):!t&&r&&rt(n,r),ut(n)},wt=function(n,t,r,u,o){var s=n._rangeData.val;n.argumentAxisType!=="discrete"&&t&&i(t.minArg)&&i(t.maxArg)?(s[f]=t.minVal,s[e]=t.maxVal,tt(n,t),ht(n,t,u,o)):!t&&r&&rt(n),ut(n)};return{processRange:at,calculateRangeData:pt,calculateTwoValuesRangeData:wt,addLabelPaddings:vt,addRangeSeriesLabelPaddings:yt,processFullStackedRange:lt,calculateRangeMinValue:ct,processTwoValues:et}}}(jQuery,DevExpress),function(n,t){var o=t.viz,u=o.core.series,r=u.helpers.rangeDataCalculator(),s=n.each,f=n.extend,h=n.map,i=n.noop,e=t.utils.isDefined,c=Math.floor,l=2,a=20,v=400;u.mixins.chart.scatter={_defaultDuration:v,_defaultTrackerWidth:a,_applyStyle:i,_adjustLabels:i,_updateOptions:i,_parseStyle:i,_prepareSegment:i,_drawSegment:i,_generateDefaultSegments:i,_prepareSeriesToDrawing:function(){this._deleteOldAnimationMethods(),this._firstDrawing&&this._clearSeries(),this._disposePoints(this._oldPoints),this._oldPoints=null},_applyTrackersClippings:function(){this._markerTrackerGroup.applySettings({clipId:this._forceClipping?this._paneClipRectID:null})},updateTeamplateFieldNames:function(){var n=this,t=n._options;t.valueField=n.getValueFields()[0]+n.name,t.tagField=n.getTagField()+n.name},_applyElementsClipRect:function(n){n.clipId=this._paneClipRectID},_applyMarkerClipRect:function(n){n.clipId=this._forceClipping?this._paneClipRectID:null},_createGroup:function(n,t,i,r){var u=t[n];u?u.applySettings(r):t[n]=u=this._renderer.createGroup(r),u.append(i)},_applyClearingSettings:function(n){n.opacity=null,n.scale=null,this._options.rotated?n.translateX=null:n.translateY=null},_createMarkerGroup:function(){var n=this._getPointOptions().styles.normal;n["class"]="dxc-markers",n.opacity=1,this._applyMarkerClipRect(n),this._createGroup("_markersGroup",this,this._group,n)},_createLabelGroup:function(){var n={"class":"dxc-labels",visibility:this.getLabelVisibility()?"visible":"hidden"};this._applyElementsClipRect(n),this._applyClearingSettings(n),this._createGroup("_labelsGroup",this,this._options.labelsGroup,n)},_createGroups:function(n){this._createMarkerGroup(),this._createLabelGroup(),n&&this._labelsGroup&&this._labelsGroup.applySettings({opacity:.001})},_getCreatingPointOptions:function(){if(!this._predefinedPointOptions){var n=this._getPointOptions(),i=n.styles&&n.styles.normal&&n.styles.normal.r,r=n.styles&&n.styles.normal&&n.styles.normal.strokeWidth,t=f(!0,{},n);t.styles=t.styles||{},t.styles.normal={r:i,strokeWidth:r},this._predefinedPointOptions=t}return this._predefinedPointOptions},_getSpecialColor:function(n){return n},_getPointOptions:function(){return this._pointOptions||(this._pointOptions=this._parsePointOptions(this._preparePointOptions(),this._options.label))},_preparePointOptions:function(n){return n?f(!0,{},this._options.point,n):this._options.point},_parsePointStyle:function(n,t,i){var r=n.border||{};return{fill:n.color||t,stroke:r.color||i,strokeWidth:r.visible?r.width:0,r:n.size/2+(r.visible&&n.size!==0?~~(r.width/2)||0:0)}},_createPointStyles:function(n){var t=n.color||this._options.mainSeriesColor,i=this._options.containerBackgroundColor,r=this._parsePointStyle(n,t,t);return r.visibility=n.visible?"visible":"hidden",{normal:r,hover:this._parsePointStyle(n.hoverStyle,i,t),selection:this._parsePointStyle(n.selectionStyle,i,t)}},_checkData:function(n){return e(n.argument)&&n.value!==undefined},_processRange:function(n,t){r.processRange(this,n,t)},_getRangeData:function(n,t){return r.calculateRangeData(this,n,t),r.addLabelPaddings(this),this._rangeData},_getPointData:function(n,t){var i=t.argumentField||"arg",r=t.valueField||"val",u=t.tagField||"tag";return{value:n[r],argument:n[i],tag:n[u]}},_drawPoint:function(n,t,i,r,u){n.isInVisibleArea()?(n.clearVisibility(),n.draw(this._renderer,t,i,r,u),this._drawedPoints.push(n)):n.setInvisibility()},_clearingAnimation:function(n,t){var i=this,r={opacity:.001},u={duration:i._defaultDuration,partitionDuration:.5};i._labelsGroup&&i._labelsGroup.animate(r,u,function(){i._markersGroup&&i._markersGroup.animate(r,u,t)})},_animate:function(){var t=this,r=t._drawedPoints.length-1,u=function(){t._labelsGroup&&t._labelsGroup.animate({opacity:1},{duration:t._defaultDuration})},i;s(t._drawedPoints||[],function(n,t){i={translate:{x:t.x,y:t.y}},t.animate(n===r?u:undefined,i)})},_getPointSize:function(){return this._options.point.visible?this._options.point.size:l},_calcMedianValue:function(n,t){var r,i;return i=h(n,function(n){return n[t]}),i.sort(function(n,t){return n-t}),r=i[c(i.length/2)],e(r)?r:null},_fusionPoints:function(n,t,i){var r=this._calcMedianValue(n,"value");return{value:r,argument:t,tag:null,index:i,seriesName:this.name}},_endUpdateData:function(){delete this._predefinedPointOptions},getArgumentField:function(){return this._options.argumentField||"arg"},getValueFields:function(){return[this._options.valueField||"val"]},_beginUpdateData:n.noop}}(jQuery,DevExpress),function(n,t){var e=t.viz,i=e.core.series.mixins.chart,o=t.utils,f=i.scatter,r=n.extend,s=n.map,u=n.each;i.line=r({},f,{_createElementsGroup:function(n){var t=r({"class":"dxc-elements"},n);this._applyElementsClipRect(t),this._createGroup("_elementsGroup",this,this._group,t)},_createBordersGroup:function(n){var t=r({"class":"dxc-borders"},n);this._applyElementsClipRect(t),this._createGroup("_bordersGroup",this,this._group,t)},_applyTrackersClippings:function(){f._applyTrackersClippings.call(this),this._trackersGroup.applySettings({clipId:this._paneClipRectID})},_createGroups:function(n,t){var t=t||this._styles.normal;this._createElementsGroup(t.elements),this._areBordersVisible()&&this._createBordersGroup(t.border),f._createGroups.call(this,n,{}),n&&this._markersGroup&&this._markersGroup.applySettings({opacity:.001})},_areBordersVisible:function(){return!1},_getDefaultSegment:function(n){return{line:s(n.line||[],function(n){return n.getDefaultCoords()})}},_prepareSegment:function(n){return{line:n}},_parseLineOptions:function(n,t){return{stroke:n.color||t,strokeWidth:n.width,dashStyle:n.dashStyle||"solid"}},_parseStyle:function(n,t){return{elements:this._parseLineOptions(n,t)}},_applyStyle:function(n){this._elementsGroup&&this._elementsGroup.applySettings(n.elements),u(this._graphics||[],function(t,i){i.line&&i.line.applySettings({strokeWidth:n.elements.strokeWidth})})},_drawElement:function(n,t){return{line:this._createMainElement(n.line,{strokeWidth:this._styles.normal.elements.strokeWidth}).append(t)}},_removeElement:function(n){n.line.remove()},_generateDefaultSegments:function(){var n=this,t=[];return u(n._segments||[],function(i,r){t.push(n._getDefaultSegment(r))}),t},_updateElement:function(n,t,i,r,u){var f={points:t.line};i?n.line.animate(f,r,u):n.line.applySettings(f)},_clearingAnimation:function(n,t){var i=this,e=i._graphics.length-1,r={opacity:.001},f={duration:i._defaultDuration,partitionDuration:.5};i._labelsGroup&&i._labelsGroup.animate(r,f,function(){i._markersGroup&&i._markersGroup.animate(r,f,function(){u(i._defaultSegments||[],function(n,r){i._oldUpdateElement(i._graphics[n],r,!0,{partitionDuration:.5},n===e?t:undefined)})})})},_animate:function(){var n=this,t=n._graphics.length-1;u(n._graphics||[],function(i,r){n._updateElement(r,n._segments[i],!0,{complete:i===t?function(){n._labelsGroup&&n._labelsGroup.animate({opacity:1},{duration:n._defaultDuration}),n._markersGroup&&n._markersGroup.animate({opacity:1},{duration:n._defaultDuration})}:undefined})})},_drawPoint:function(n,t,i){f._drawPoint.call(this,n,t,i)},_createMainElement:function(n,t){return this._renderer.createPath(n,t)},_drawSegment:function(n,t,i){var r=this._prepareSegment(n,this._options.rotated);this._segments.push(r),this._graphics[i]?t||this._updateElement(this._graphics[i],r):this._graphics[i]=this._drawElement(t?this._getDefaultSegment(r):r,this._elementsGroup)},_getTrackerSettings:function(){return{strokeWidth:this._styles.normal.elements.strokeWidth>this._defaultTrackerWidth?this._styles.normal.elements.strokeWidth:this._defaultTrackerWidth,fill:"none"}},_getMainPointsFromSegment:function(n){return n.line},_drawTrackerElement:function(n){return this._createMainElement(this._getMainPointsFromSegment(n),this._getTrackerSettings(n))},_updateTrackerElement:function(n,t){var i=this._getTrackerSettings(n);i.points=this._getMainPointsFromSegment(n),t.applySettings(i)}}),i.stepline=r({},i.line,{_calculateStepLinePoints:function(n){var t=[];return u(n,function(n,i){var r,u;if(!n){t.push(i);return}r=t[t.length-1].y,r!==i.y&&(u=o.clone(i),u.y=r,t.push(u)),t.push(i)}),t},_prepareSegment:function(n){return i.line._prepareSegment(this._calculateStepLinePoints(n))}}),i.stackedline=r({},i.line,{}),i.fullstackedline=r({},i.line,{_getRangeData:function(n,t){var i=e.core.series.helpers.rangeDataCalculator();return i.calculateRangeData(this,n,t),i.addLabelPaddings(this),i.processFullStackedRange(this),this._rangeData}}),i.spline=r({},i.line,{_calculateBezierPoints:function(n,t){var i=[],r=n,f=function(n,t,i){return n>t&&i>n||n<t&&i<n?n:i},e=function(n,t,i){var r=o.clone(n);return r.x=t,r.y=i,r};return r.length!==1?u(r,function(n,u){var a,v,y,p,h,c,o,s,b,k,d,g,st,l=.5,ft,et,ot,it,rt,ut,nt,tt,w;if(!n){i.push(u),i.push(u);return}if(h=r[n-1],n<r.length-1)c=r[n+1],o=u.x,s=u.y,b=h.x,k=c.x,d=h.y,g=c.y,ft=!!(!t&&(s<=h.y&&s<=c.y||s>=h.y&&s>=c.y)||t&&(o<=h.x&&o<=c.x||o>=h.x&&o>=c.x)),ft?t?(y=a=o,p=(s+c.y)/2,v=(s+h.y)/2):(p=v=s,y=(o+c.x)/2,a=(o+h.x)/2):(it=g-d,rt=b-k,ut=d*k-b*g,t?(tt=s,nt=-1*(rt*tt+ut)/it,w=nt-o||0,b-=w,k-=w):(nt=o,tt=-1*(it*nt+ut)/rt,w=tt-s||0,d-=w,g-=w),y=(o+l*k)/(1+l),p=(s+l*g)/(1+l),a=(o+l*b)/(1+l),v=(s+l*d)/(1+l)),t?(a=f(h.x,o,a),y=f(c.x,o,y)):(v=f(h.y,s,v),p=f(c.y,s,p)),et=e(u,a,v),ot=e(u,y,p),i.push(et,u,ot);else{i.push(u,u);return}}):i.push(r[0]),i},_prepareSegment:function(n,t){return i.line._prepareSegment(this._calculateBezierPoints(n,t))},_createMainElement:function(n,t){return this._renderer.createBezierPath(n,t)}})}(jQuery,DevExpress),function(n,t){var f=t.viz,o=t.utils,i=f.core.series.mixins.chart,r=i.line,e=n.map,u=n.extend,s=20;i.area=u({},r,{_createBorderElement:r._createMainElement,_processSinglePointsAreaSegment:function(n,t){if(n.length==1){var i=n[0],r=o.clone(i),u=t?"y":"x";return r[u]+=1,[i,r]}return n},_prepareSegment:function(n,t){var i=this._processSinglePointsAreaSegment(n,t);return{line:i,area:e(i,function(n){return n.getCoords()}).concat(e(i.slice().reverse(),function(n){return n.getCoords(!0)})),singlePointSegment:i!==n}},_getSpecialColor:function(n){return this._options._IE8?new t.Color(n).highlight(s):n},_getRangeData:function(n,t){var i=f.core.series.helpers.rangeDataCalculator();return i.calculateRangeData(this,n,t),i.addLabelPaddings(this),i.calculateRangeMinValue(this,n),this._rangeData},_getDefaultSegment:function(n){var t=r._getDefaultSegment(n);return t.area=t.line.concat(t.line.slice().reverse()),t},_updateElement:function(n,t,i,r,u){var e={points:t.line},o={points:t.area},f=n.line;i?(f&&f.animate(e,r),n.area.animate(o,r,u)):(f&&f.applySettings(e),n.area.applySettings(o))},_removeElement:function(n){n.line&&n.line.remove(),n.area.remove()},_drawElement:function(n){return{line:this._bordersGroup&&this._createBorderElement(n.line,{strokeWidth:this._styles.normal.border.strokeWidth}).append(this._bordersGroup),area:this._createMainElement(n.area).append(this._elementsGroup)}},_applyStyle:function(t){this._elementsGroup&&this._elementsGroup.applySettings(t.elements),this._bordersGroup&&this._bordersGroup.applySettings(t.border),n.each(this._graphics||[],function(n,i){i.line&&i.line.applySettings({strokeWidth:t.border.strokeWidth})})},_createPattern:function(n,t){if(t){var i=this._renderer.createPattern(n,t);return this._patterns.push(i),i.id}return n},_parseStyle:function(n,t,i){var f=n.border||{},u=r._parseLineOptions(f,i);return u.strokeWidth=f.visible?u.strokeWidth:0,{border:u,elements:{stroke:"none",fill:this._createPattern(n.color||t,n.hatching),opacity:n.opacity}}},_areBordersVisible:function(){var n=this._options;return n.border.visible||n.hoverStyle.border.visible||n.selectionStyle.border.visible},_createMainElement:function(n,t){return this._renderer.createArea(n,t)},_getTrackerSettings:function(n){return{strokeWidth:n.singlePointSegment?this._defaultTrackerWidth:0}},_getMainPointsFromSegment:function(n){return n.area}}),i.steparea=u({},i.area,{_prepareSegment:function(n,t){return n=i.area._processSinglePointsAreaSegment(n,t),i.area._prepareSegment.call(this,i.stepline._calculateStepLinePoints(n))}}),i.splinearea=u({},i.area,{_areaPointsToSplineAreaPoints:function(n){var t=n[n.length/2-1],i=n[n.length/2];n.splice(n.length/2,0,{x:t.x,y:t.y},{x:i.x,y:i.y})},_prepareSegment:function(n,t){var u=i.area,f=u._processSinglePointsAreaSegment(n,t),r=u._prepareSegment.call(this,i.spline._calculateBezierPoints(f,t));return this._areaPointsToSplineAreaPoints(r.area),r.singlePointSegment=f!==n,r},_getDefaultSegment:function(n){var t=i.area._getDefaultSegment(n);return this._areaPointsToSplineAreaPoints(t.area),t},_createMainElement:function(n,t){return this._renderer.createBezierArea(n,t)},_createBorderElement:i.spline._createMainElement})}(jQuery,DevExpress),function(n,t){var e=t.viz,r=e.core.series.mixins.chart,i=r.scatter,u=r.area,f=n.extend,o=n.each,s=3;r.bar=f({},i,{_getSpecialColor:u._getSpecialColor,_createPattern:u._createPattern,_updateOptions:function(n){this._stackName="axis_"+(n.axis||"default")+"_stack_"+(n.stack||"default")},_getRangeData:function(){var i=u._getRangeData.apply(this,arguments);return i.arg.stick=!1,i},_parsePointStyle:function(n,t,r){var f=this._createPattern(n.color||t,n.hatching),u=i._parsePointStyle.call(this,n,f,r);return u.fill=f,delete u.r,u},_applyMarkerClipRect:function(n){n.clipId=null},_applyTrackersClippings:function(){this._markerTrackerGroup.applySettings({clipId:this._paneClipRectID})},_clearingAnimation:function(n,t){var i=this,r;r=i._options.rotated?{scale:{x:.001,y:1},translate:{x:n.x.translate("canvas_position_default")}}:{scale:{x:1,y:.001},translate:{y:n.y.translate("canvas_position_default")}},i._labelsGroup&&i._labelsGroup.animate({opacity:.001},{duration:i._defaultDuration,partitionDuration:.5},function(){i._markersGroup.animate(r,{partitionDuration:.5},function(){i._markersGroup.applySettings({scale:null,translateX:0,translateY:0}),t()})})},_createGroups:function(n,t,r){var u={};i._createGroups.apply(this,arguments),n&&r?u=this._options.rotated?{scale:{x:.001,y:1},translateX:this.translators.x.translate("canvas_position_default")}:{scale:{x:1,y:.001},translateY:this.translators.y.translate("canvas_position_default")}:n||(u={scale:{x:1,y:1},translateX:0,translateY:0}),this._markersGroup.applySettings(u)},_drawPoint:function(n,t,r,u,f){i._drawPoint.call(this,n,t,r,u&&!f)},_getMainColor:function(){return this._options.mainSeriesColor},_createPointStyles:function(n){var t=n.color||this._getMainColor(),i=this._getSpecialColor(t);return{normal:this._parsePointStyle(n,t,t),hover:this._parsePointStyle(n.hoverStyle||{},i,t),selection:this._parsePointStyle(n.selectionStyle||{},i,t)}},_preparePointOptions:function(n){return n?f(!0,{},this._options,n):this._options},_animate:function(n){var t=this,i=function(){t._labelsGroup&&t._labelsGroup.animate({opacity:1},{duration:t._defaultDuration})},r;t._markersGroup.animate({scale:{x:1,y:1},translate:{y:0,x:0}},undefined,i),n||(r=t._drawedPoints.length-1,o(this._drawedPoints||[],function(n,t){t.animate(n===r?i:undefined,{x:t.x,y:t.y,height:t.height,width:t.width})}))},_getPointSize:function(){return s}})}(jQuery,DevExpress),function(n,t){var f=t.viz,i=f.core.series.mixins.chart,e=n.extend,s=t.utils.isDefined,h=n.map,u=f.core.series.helpers.rangeDataCalculator(),r=i.area,o={_checkData:function(n){return s(n.argument)&&n.value!==undefined&&n.minValue!==undefined},updateTeamplateFieldNames:function(){var n=this,t=n._options,r=n.getValueFields(),i=n.name;t.rangeValue1Field=r[0]+i,t.rangeValue2Field=r[1]+i,t.tagField=n.getTagField()+i},_processRange:function(n,t){u.processTwoValues(this,n,t,"value","minValue")},_getRangeData:function(n,t){return u.calculateTwoValuesRangeData(this,n,t,"value","minValue"),u.addRangeSeriesLabelPaddings(this),this._rangeData},_getPointData:function(n,t){var i=t.argumentField||"arg",r=t.tagField||"tag",u=t.rangeValue1Field||"val1",f=t.rangeValue2Field||"val2";return{tag:n[r],minValue:n[u],value:n[f],argument:n[i]}},_fusionPoints:function(n,t){var e=i.scatter,u=e._calcMedianValue.call(this,n,"value"),f=e._calcMedianValue.call(this,n,"minValue"),o;return(u===null||f===null)&&(u=f=null),o={minValue:f,value:u,argument:t,tag:null}},getValueFields:function(){return[this._options.rangeValue1Field||"val1",this._options.rangeValue2Field||"val2"]}};i.rangebar=e({},i.bar,o),i.rangearea=e({},r,{_drawPoint:function(n,t,i,r){n.isInVisibleArea()?(n.clearVisibility(),n.draw(this._renderer,t,i,r),this._drawedPoints.push(n),n.visibleTopMarker||n.hideMarker("top"),n.visibleBottomMarker||n.hideMarker("bottom")):n.setInvisibility()},_prepareSegment:function(t,i){var r=this._processSinglePointsAreaSegment(t,i),u=n.map(r,function(n){return n.getCoords(!0)});return{line:r,bottomLine:u,area:n.map(r,function(n){return n.getCoords()}).concat(u.slice().reverse()),singlePointSegment:r!==t}},_getDefaultSegment:function(n){var t=r._getDefaultSegment.call(this,n);return t.bottomLine=t.line,t},_removeElement:function(n){r._removeElement.call(this,n),n.bottomLine&&n.bottomLine.remove()},_drawElement:function(n,t){var i=r._drawElement.call(this,n,t);return i.bottomLine=this._bordersGroup&&this._createBorderElement(n.bottomLine,{strokeWidth:this._styles.normal.border.strokeWidth}).append(this._bordersGroup),i},_applyStyle:function(t){this._elementsGroup&&this._elementsGroup.applySettings(t.elements),this._bordersGroup&&this._bordersGroup.applySettings(t.border),n.each(this._graphics||[],function(n,i){i.line&&i.line.applySettings({strokeWidth:t.border.strokeWidth}),i.bottomLine&&i.bottomLine.applySettings({strokeWidth:t.border.strokeWidth})})},_updateElement:function(n,t,i,u,f){r._updateElement.call(this,n,t,i,u,f);var o={points:t.bottomLine},e=n.bottomLine;e&&(i?e.animate(o,u):e.applySettings(o))}},o)}(jQuery,DevExpress),function(n,t){var s=t.viz,u=s.core.series.mixins.chart,r=u.scatter,i=u.bar,e=t.utils.isDefined,f=n.extend,o=n.each;u.bubble=f({},r,{_applyTrackersClippings:i._applyTrackersClippings,_getMainColor:i._getMainColor,_createPointStyles:i._createPointStyles,_createPattern:i._createPattern,_preparePointOptions:i._preparePointOptions,_getSpecialColor:i._getSpecialColor,_applyMarkerClipRect:u.line._applyElementsClipRect,_parsePointStyle:function(n,t,i){var f=this._createPattern(n.color||t,n.hatching),u=r._parsePointStyle.call(this,n,f,i);return u.fill=f,u.opacity=n.opacity,delete u.r,u},_createMarkerGroup:function(){var n=this._getPointOptions().styles.normal,t;n["class"]="dxc-markers",this._applyMarkerClipRect(n),t=f({},n),delete t.opacity,this._createGroup("_markersGroup",this,this._group,t)},_getCreatingPointOptions:function(){if(!this._predefinedPointOptions){var i,n=this._getPointOptions(),r=n.styles&&n.styles.normal&&n.styles.normal.strokeWidth,u=n.styles&&n.styles.normal&&n.styles.normal.r,e=n.styles&&n.styles.normal&&n.styles.normal.opacity,t=f(!0,{},n);t.styles=i=t.styles||{},i.normal={strokeWidth:r,r:u,opacity:e},this._predefinedPointOptions=t}return this._predefinedPointOptions},_checkData:function(n){return e(n.argument)&&e(n.size)&&n.value!==undefined},_getPointData:function(n,t){var i=r._getPointData.call(this,n,t),u=t.sizeField||"size";return i.size=n[u],i},_fusionPoints:function(n,t){var u=r._calcMedianValue.call(this,n,"value"),f=r._calcMedianValue.call(this,n,"size");return{size:f,value:u,argument:t,tag:null}},getValueFields:function(){return[this._options.valueField||"val",this._options.sizeField||"size"]},updateTeamplateFieldNames:function(){var n=this,t=n._options,r=n.getValueFields(),i=n.name;t.valueField=r[0]+i,t.sizeField=r[1]+i,t.tagField=n.getTagField()+i},_clearingAnimation:function(n,t){var i=this,u={r:0},r=.5,f=i._drawedPoints.length-1;i._labelsGroup&&i._labelsGroup.animate({opacity:.001},{duration:i._defaultDuration,partitionDuration:r},function(){o(i._drawedPoints||[],function(n,i){i.animate(n===f?t:undefined,u,r)})})},_animate:function(){var t=this,i=t._drawedPoints.length-1,r=function(){t._labelsGroup&&t._labelsGroup.animate({opacity:1},{duration:t._defaultDuration})};o(t._drawedPoints||[],function(n,t){t.animate(n===i?r:undefined,{r:t.bubbleSize,translate:{x:t.x,y:t.y}})})}})}(jQuery,DevExpress),function(n,t){var h=t.viz,e=h.core.series.mixins,u=e.pieChart,c=t.utils,f=e.chart.scatter,o=e.chart.bar,l=n.extend,i=n.each,r=n.noop,s=n.map,a=isFinite,v=Math.max;u.pie=l({},o,{_createLabelGroup:f._createLabelGroup,_createGroups:f._createGroups,_drawPoint:function(n){f._drawPoint.apply(this,arguments),n.isVisible()||n.setInvisibility()},_applyTrackersClippings:r,_processRange:r,_applyElementsClipRect:r,_updateDataType:r,getColor:r,_prepareSeriesToDrawing:r,_endUpdateData:f._prepareSeriesToDrawing,resetLabelEllipsis:function(){i(this._points||[],function(n,t){t._label.setLabelEllipsis=!1})},_adjustLabels:function(n){var t=this,e=t._options,o=t.canvas,r=t._points||[],u=[],s=[],h=0,f,c,l,a;e.label.position!=="inside"?(i(r,function(n,t){t._label.hasText()&&u.push(t._label.getTextCoords().width)}),u.length&&(f=v.apply(null,u),i(r,function(n,t){t._label.hasText()&&(t._label.updatePosition(f),t._label.setLabelEllipsis=!0)}),t._firstDrawing=!t.redraw&&n,t.redraw=!0)):i(r,function(n,t){t._label.hasText()&&(t._label.setLabelEllipsis=!0,t._label.updatePosition())})},_getCreatingPointOptions:function(){return this._getPointOptions()},_updateOptions:function(n){this.labelSpace=0,this.innerRadius=this.type==="pie"?0:n.innerRadius,this.redraw=!1},_checkData:function(n){var t=o._checkData(n);return this._options.paintNullPoints?t:t&&n.value!==null},_createMarkerGroup:function(){this._markersGroup||(this._markersGroup=this._renderer.createGroup({"class":"dxc-markers"}).append(this._group))},_getMainColor:function(){return this._options.mainSeriesColor()},_getPointOptions:function(){return this._parsePointOptions(this._preparePointOptions(),this._options.label)},_getRangeData:function(){return this._rangeData},_getArrangeTotal:function(n){var t=0;return i(n,function(n,i){i.isVisible()&&(t+=i.initialValue)}),t},_createPointStyles:function(n){var t=n.color||this._getMainColor(),i=this._getSpecialColor(t);return{normal:this._parsePointStyle(n,t,t),hover:this._parsePointStyle(n.hoverStyle,i,t),selection:this._parsePointStyle(n.selectionStyle,i,t),legendStyles:{normal:this._createLegendState(n,t),hover:this._createLegendState(n.hoverStyle,i),selection:this._createLegendState(n.selectionStyle,i)}}},_getArrangeMinShownValue:function(n,t){var r=this._options.minSegmentSize,u=0,f=0;return t=t||n.length,i(n,function(n,i){i.isVisible()&&(i.initialValue<r*t/360?u+=r:f+=i.initialValue)}),u<360?r*f/(360-u):0},_applyArrangeCorrection:function(n,t,r){var u=this._options,s=u.segmentsDirection!=="anticlockwise",h=a(u.startAngle)?c.normalizeAngle(u.startAngle):0,l=u.minSegmentSize,o,f=0,e=0;r===0&&(r=n.length,e=1),i(s?n:n.concat([]).reverse(),function(n,i){var u=i.isVisible()?e||i.initialValue:0,s;l&&i.isVisible()&&u<t&&(s=t),o=u/r,i.correctValue(f,o,e+(s||0)),i.shiftedAngle=h,f=f+(s||u)}),this._rangeData={val:{min:0,max:f}}},arrangePoints:function(){var n=this,r=n._options.minSegmentSize,u,f=0,t,i=n._originalPoints=n._points=s(n._originalPoints||[],function(n){return n.value===null||n.value<0||n.value===0&&!r?(n.dispose(),null):(n.index=f++,n)});t=n._getArrangeTotal(i),r&&(u=this._getArrangeMinShownValue(i,t)),n._applyArrangeCorrection(i,u,t)},correctPosition:function(n){i(this._points,function(t,i){i.correctPosition(n)})},_animate:function(t){var r=this,u=0,e=.2,i=r._points,f=i&&i.length,h=1/(e*(f-1)+1),o=function(){i[u]&&i[u++].animate(u===f?s:undefined,h,c)},c=function(n,t){t>=e&&(this.step=null,o())},s=function(){r._labelsGroup&&r._labelsGroup.animate({opacity:1},{duration:400})};t?o():n.each(i,function(n,t){t.animate(n==f-1?s:undefined)})},getVisiblePoints:function(){return s(this._points,function(n){return n.isVisible()?n:null})},_beginUpdateData:function(){this._deletePatterns(),this._patterns=[]}}),u.doughnut=u.donut=u.pie}(jQuery,DevExpress),function(n,t){var e=t.viz,i=e.core.series.mixins.chart,o=i.scatter,u=i.bar,f=e.core.series.helpers.rangeDataCalculator(),s=t.utils.isDefined,r=n.extend,h=n.each,c=n.noop,l=10;i.stock=r({},o,{_animate:c,_applyMarkerClipRect:i.line._applyElementsClipRect,_applyTrackersClippings:u._applyTrackersClippings,_createPattern:u._createPattern,_preparePointOptions:u._preparePointOptions,_createMarkerGroup:function(){var n=this,t,i=n._getPointOptions().styles,r=i.normal,u=i.positive.normal,f=i.reduction.normal,e=i.reductionPositive.normal,o={"class":"dxc-markers"};n._applyMarkerClipRect(o),r["class"]="default-markers",u["class"]="default-positive-markers",f["class"]="reduction-markers",e["class"]="reduction-positive-markers",n._createGroup("_markersGroup",n,n._group,o),t=n._markersGroup,n._createGroup("defaultMarkersGroup",t,t,r),n._createGroup("reductionMarkersGroup",t,t,f),n._createGroup("defaultPositiveMarkersGroup",t,t,u),n._createGroup("reductionPositiveMarkersGroup",t,t,e)},_createGroups:function(){o._createGroups.call(this,!1)},_clearingAnimation:function(n,t){t()},_getCreatingPointOptions:function(){if(!this._predefinedPointOptions){var n,t=this._getPointOptions(),u=t.styles&&t.styles.normal&&t.styles.normal.strokeWidth,i=r(!0,{},t);i.styles=n=i.styles||{},n.normal=n.positive.normal=n.reduction.normal=n.reductionPositive.normal={strokeWidth:u},this._predefinedPointOptions=i}return this._predefinedPointOptions},_checkData:function(n){return s(n.argument)&&n.highValue!==undefined&&n.lowValue!==undefined&&n.openValue!==undefined&&n.closeValue!==undefined},_processRange:function(n,t){f.processTwoValues(this,n,t,"highValue","lowValue")},_getRangeData:function(n,t){return f.calculateTwoValuesRangeData(this,n,t,"highValue","lowValue"),f.addRangeSeriesLabelPaddings(this),this._rangeData},_getPointData:function(n,t){var r=this,i,h=t.argumentField||"date",c=t.tagField||"tag",f=t.openValueField||"open",e=t.closeValueField||"close",o=t.highValueField||"high",s=t.lowValueField||"low",u;r.level=t.reduction.level;switch((r.level||"").toLowerCase()){case"open":i=f;break;case"high":i=o;break;case"low":i=s;break;default:i=e,r.level="close"}return u=n[i],{argument:n[h],highValue:n[o],lowValue:n[s],closeValue:n[e],openValue:n[f],reductionValue:u,tag:n[c],isReduction:this._checkReduction(u)}},_parsePointStyle:function(n,t,i){return{stroke:n.color||t,strokeWidth:n.width,fill:n.color||i}},updateTeamplateFieldNames:function(){var i=this,n=i._options,r=i.getValueFields(),t=i.name;n.openValueField=r[0]+t,n.highValueField=r[1]+t,n.lowValueField=r[2]+t,n.closeValueField=r[3]+t,n.tagField=i.getTagField()+t},_getDefaultStyle:function(n){var t=n.color||this._options.mainSeriesColor;return{normal:this._parsePointStyle(n,t,t),hover:this._parsePointStyle(n.hoverStyle,t,t),selection:this._parsePointStyle(n.selectionStyle,t,t)}},_getReductionStyle:function(n){var t=n.reduction.color,i=this._parsePointStyle({color:t,width:n.width,hatching:n.hatching},t,t);return{normal:i,hover:this._parsePointStyle(n.hoverStyle,t,t),selection:this._parsePointStyle(n.selectionStyle,t,t)}},_createPointStyles:function(n){var f=this,o=f._options.innerColor,t=f._getDefaultStyle(n),i,e,u;return i=r(!0,{},t),e=f._getReductionStyle(n),u=r(!0,{},e),i.normal.fill=i.hover.fill=i.selection.fill=o,u.normal.fill=u.hover.fill=u.selection.fill=o,t.positive=i,t.reduction=e,t.reductionPositive=u,t},_endUpdateData:function(){delete this.prevLevelValue,delete this._predefinedPointOptions},_checkReduction:function(n){var t=!1;return n!=null&&(s(this.prevLevelValue)&&(t=n<this.prevLevelValue),this.prevLevelValue=n),t},_fusionPoints:function(n,t){var r={},u,e=-Infinity,o=+Infinity,f,s;if(!n.length)return{};h(n,function(n,t){t.hasValue()&&(e=Math.max(e,t.highValue),o=Math.min(o,t.lowValue),f=f!==undefined?f:t.openValue,s=t.closeValue!==undefined?t.closeValue:s)}),r.argument=t,r.openValue=f,r.closeValue=s,r.highValue=e,r.lowValue=o,r.tag=null;switch((this.level||"").toLowerCase()){case"open":u=f;break;case"high":u=e;break;case"low":u=o;break;default:u=s}return r.reductionValue=u,r.isReduction=this._checkReduction(u),r},_getPointSize:function(){return l},getValueFields:function(){var n=this._options;return[n.openValueField||"open",n.highValueField||"high",n.lowValueField||"low",n.closeValueField||"close"]},getArgumentField:function(){return this._options.argumentField||"date"}}),i.candlestick=r({},i.stock,{_parsePointStyle:function(n,t,r){var u=this._createPattern(n.color||r,n.hatching),f=i.stock._parsePointStyle.call(this,n,t,u);return f.fill=u,f}})}(jQuery,DevExpress),function(n,t){var o=t.viz,i=o.core.series.mixins.chart,s=i.area,h=i.bar,c=i.line,u=o.core.series.helpers.rangeDataCalculator(),r=n.extend,l=n.noop,f={_processRange:l,_processStackedRange:function(){var t=this,i;n.each(t.getAllPoints(),function(n,r){u.processRange(t,r,i),i=r})},_getRangeData:function(){return this._processStackedRange(),s._getRangeData.apply(this,arguments)}},e=r({},f,{_getRangeData:function(n,t){return this._processStackedRange(),u.calculateRangeData(this,n,t),u.addLabelPaddings(this),u.processFullStackedRange(this),u.calculateRangeMinValue(this,n),this._rangeData},isFullStackedSeries:function(){return!0}});i.stackedline=r({},c,f,{_getRangeData:function(){return this._processStackedRange(),c._getRangeData.apply(this,arguments)}}),i.fullstackedline=r({},c,e,{_getRangeData:function(n,t){this._processStackedRange();var i=o.core.series.helpers.rangeDataCalculator();return i.calculateRangeData(this,n,t),i.addLabelPaddings(this),i.processFullStackedRange(this),this._rangeData}}),i.stackedbar=r({},h,f,{_getRangeData:function(){return this._processStackedRange(),h._getRangeData.apply(this,arguments)}}),i.fullstackedbar=r({},h,e,{_getRangeData:function(){var i=e._getRangeData.apply(this,arguments);return i.arg.stick=!1,i}}),i.stackedarea=r({},s,f),i.fullstackedarea=r({},s,e)}(jQuery,DevExpress),function(n,t){var r=t.viz,f=r.core.series.helpers.consts.states,e=n.each,s=n.extend,o=t.utils.isDefined,i=n.noop,u={scatter:"symbolPoint",line:"symbolPoint",spline:"symbolPoint",stepline:"symbolPoint",stackedline:"symbolPoint",fullstackedline:"symbolPoint",area:"symbolPoint",splinearea:"symbolPoint",steparea:"symbolPoint",stackedarea:"symbolPoint",fullstackedarea:"symbolPoint",rangearea:"rangeSymbolPoint",bar:"barPoint",stackedbar:"barPoint",fullstackedbar:"barPoint",rangebar:"rangeBarPoint",bubble:"bubblePoint",pie:"piePoint",doughnut:"piePoint",donut:"piePoint",stock:"stockPoint",candlestick:"candlestickPoint"};r.core.series.points={},r.core.series.points.Point=t.Class.inherit({ctor:function(n,t){this.update(n,t),this._emptySettings={fill:null,stroke:null}},getColor:function(){return this._styles.normal.fill||this.series.getColor()},_getStyle:function(){var t=this._styles,n;return this.isSelected()?n=t.selection:this.isHovered()?n=t.hover:(this.fullState=f.normalMark,n=t.normal),n},update:function(n,t){this.updateOptions(t),this.updateData(n)},updateData:function(n){this._updateData(n),this.hasValue()?(this._updateLabelData(),this._fillStyle()):this.setInvisibility()},deleteMarker:function(){this.graphic&&this.graphic.detach(),this.graphic=null},deleteTrackerMarker:function(){this.trackerGraphic&&this.trackerGraphic.remove(),this.trackerGraphic=null},draw:function(n,t,i,r,u){this._needDeletingOnDraw&&(this.deleteMarker(),this.deleteTrackerMarker(),this._needDeletingOnDraw=!1),this._needClearingOnDraw&&(this.clearMarker(),this._needClearingOnDraw=!1),this._hasGraphic()?this._updateMarker(r,undefined,t):this._options.visible&&this._drawMarker(n,t,r,u),this._drawLabel(n,i)},applyStyle:function(n){this.graphic&&(n==="normal"?this.clearMarker():this.graphic.toForeground(),this._updateMarker(!0,this._styles[n]))},setHoverState:function(){this.series.setPointHoverState(this)},releaseHoverState:function(n){this.series.releasePointHoverState(this,n),this.graphic&&(this.isSelected()||this.graphic.toBackground())},setSelectedState:function(){this.series.setPointSelectedState(this)},releaseSelectedState:function(){this.series.releasePointSelectedState(this)},select:function(){this.series.selectPoint(this)},clearSelection:function(){this.series.deselectPoint(this)},showTooltip:function(){this.series.showPointTooltip(this)},hideTooltip:function(){this.series.hidePointTooltip(this)},_checkLabelsChanging:function(n,t){if(n){var i=~t.indexOf("range"),r=~n.indexOf("range");return r&&!i||!r&&i}return!1},updateOptions:function(n){if(o(n)){var t=this,i=t._options,f=i&&i.type,r=n.type;u[f]!==u[r]?(t._needDeletingOnDraw=!0,t._needClearingOnDraw=!1,t._checkLabelsChanging(f,r)&&t.deleteLabel(),t._resetType(f),t._setType(r)):(t._needDeletingOnDraw=t._checkSymbol(i,n),t._needClearingOnDraw=t._checkCustomize(i,n)),t.series=n.series,t._options=n,t._fillStyle(),t._updateLabelOptions(u[r])}},translate:function(n){this.translators=n||this.translators,this.translators&&this.hasValue()&&this._translate(this.translators)},drawTracker:function(n,t){this.trackerGraphic?this._updateTracker():this._drawTrackerMarker(n,t)},_checkCustomize:function(n,t){return n.styles.usePointCustomOptions&&!t.styles.usePointCustomOptions},_getCustomLabelVisibility:function(){if(this._styles.useLabelCustomOptions)return this._options.label.visible?"visible":"hidden"},_getGraphicSettings:function(){return{x:this.graphic.settings.x||0,y:this.graphic.settings.y||0,height:this.graphic.settings.height||0,width:this.graphic.settings.width||0}},_resetType:function(n){var t=this;n&&e(r.core.series.points.mixins[u[n]],function(n){delete t[n]})},_setType:function(n){var t=this;e(r.core.series.points.mixins[u[n]],function(n,i){t[n]=i})},_prepareStatesOptions:function(){var n=this;n._options.states&&n._options.states.normal&&n._populatePointShape(n._options.states.normal.r)},isInVisibleArea:function(){return this.inVisibleArea},isSelected:function(){return!!(this.fullState&f.selectedMark)},isHovered:function(){return!!(this.fullState&f.hoverMark)},getOptions:function(){return this._options},animate:function(n,t,i){if(!this.graphic){n&&n();return}this.graphic.animate(t,{partitionDuration:i},n)},getCoords:function(n){return n?this._options.rotated?{x:this.minX,y:this.y}:{x:this.x,y:this.minY}:{x:this.x,y:this.y}},getDefaultCoords:function(){return this._options.rotated?{x:this.defaultX,y:this.y}:{x:this.x,y:this.defaultY}},_calculateVisibility:function(n,t,i,r){var u=this,f,e,s=u._options.rotated;u.translators&&(f=u.translators.x.getCanvasVisibleArea(),e=u.translators.y.getCanvasVisibleArea(),u.inVisibleArea=f.min>n+(i||0)||f.max<n||e.min>t+(r||0)||e.max<t||s&&o(i)&&i!==0&&(f.min===n+i||f.max===n)||!s&&o(r)&&r!==0&&(e.min===t+r||e.max===t)?!1:!0)},correctPosition:i,hasValue:function(){return this.value!==null&&this.minValue!==null},_populatePointShape:i,_checkSymbol:i,hide:i,show:i,hideMarker:i,setInvisibility:i,clearVisibility:i,isVisible:i,resetCorrection:i,correctValue:i,setPercentValue:i,correctCoordinates:i,dispose:function(){this.deleteMarker(),this.deleteTrackerMarker(),this.deleteLabel(),this._options=null,this._styles=null,this.series=null,this.translators=null},getTooltipFormatObject:function(n){var t=this,i=t._getFormatObject(n),r=[],u=[];return t.stackPoints&&(e(t.stackPoints,function(t,i){if(i.isVisible()){var f=i._getFormatObject(n);u.push(i._getFormatObject(n)),r.push(f.seriesName+": "+f.valueText)}}),s(i,{points:u,valueText:r.join("\n"),stackName:t.stackPoints.stackName})),i}})}(jQuery,DevExpress),function(n,t){var f=t.utils.isDefined,u=n.extend,e=Math,i=e.round,r=e.floor,a=n.isEmptyObject,v=n.noop,o=8,s=4,h=10,c={symbolPoint:"_setPositionForSymbol",barPoint:"_setPositionForBar",bubblePoint:"_setPositionForBubble",rangeSymbolPoint:"_setPositionForSymbol",rangeBarPoint:"_setPositionForBar",stockPoint:"_setPositionForFinancial",candlestickPoint:"_setPositionForFinancial"},l={symbolPoint:"_checkPositionForSymbol",barPoint:"_checkPositionForBar",bubblePoint:"_checkPositionForSymbol",rangeSymbolPoint:"_checkPositionForSymbol",rangeBarPoint:"_checkPositionForBar",stockPoint:"_checkPositionForBar",candlestickPoint:"_checkPositionForBar"};t.viz.core.series.points.Label=t.Class.inherit({ctor:function(n,t){this._offset=h,this.updateData(n),this.setOptions(t)},clearVisibility:function(){this._group&&this._group.settings.visibility&&this._group.applySettings({visibility:null})},hide:function(){this._group&&this._group.settings.visibility!=="hidden"&&this._group.applySettings({visibility:"hidden"})},updateData:function(n){f(n)&&(this._data=n.formatObject,this._initialValue=n.initialValue)},updateOptions:function(n){this.setOptions(u(!0,{},{options:this._options},n))},setOptions:function(n){var t=this,i=t._options,n=n||{},r=n.type||"symbolPoint";t._options=n.options,t._rotated=n.rotated,t._isFullStacked=n.isFullStacked,t._isRange=n.isRange,t._setPosition=t[c[r]],t._checkPosition=t[l[r]],i&&(t._isBackgroundChanged(i.background,t._options.background)&&t._deleteBackground(),t._isConnectorChanged(i.connector,t._options.connector)&&t._deleteConnector())},setDataField:function(n,t){this._data=this._data||{},this._data[n]=t},getData:function(){return this._data},setCoords:function(n,t,i,r){this._coords=n,this._graphicBbox=t,this._visibleArea=r,this._location=i},hasText:function(){return!!this._text},getTextCoords:function(){return this._text&&this._text.getBBox()},getCoords:function(){var n={},t=this._insideGroup;return t&&(n=t.getBBox(),n.x=t.settings.translateX||0,n.y=t.settings.translateY||0),n},updatePosition:function(n,t){var r={},i=this._insideGroup;i.applySettings({translateX:n,translateY:t}),this._connector&&this._drawConnector()},_deleteElements:function(){this._deleteConnector(),this._deleteBackground(),this._deleteText(),this._deleteGroups()},dispose:function(){this._data=null,this._options=null,this._positioningFunction=null,this._graphicBbox=null,this._visibleArea=null,this._coords=null,this._deleteElements()},_deleteText:function(){this._text&&this._text.detach(),this._text=null},_deleteGroups:function(){this._insideGroup=null,this._group&&this._group.detach(),this._group=null},_drawGroups:function(n,t){this._group||(this._group=n.createGroup().append(t)),this._insideGroup||(this._insideGroup=n.createGroup().append(this._group))},_drawText:function(n,t){this._text?this._text.applySettings({text:t},this._options.attributes):this._text=n.createText(t,0,0,this._options.attributes).append(this._insideGroup)},_drawBackground:function(n){var t=this,f=t._options,r=f.background||{},i;t._checkBackground(r)&&(i=u(t._getBackgroundSettings(),r),t._background?t._background.applySettings(i):t._background=n.createRect(i.x,i.y,i.width,i.height,0,r).append(t._insideGroup),t._background.toBackground())},_drawConnector:function(n){var t=this,i=t._options.connector||{},r;t._checkConnector(i)&&(r=t._getConnectorPoints()||[],t._connector?t._connector.applySettings(u({points:r},i)):t._connector=n.createPath(r,i).append(t._group),t._connector.toBackground())},_setVisibility:function(n){this._group&&this._group.applySettings({visibility:n})},draw:function(n,t,i){var r=this,e=r._options,o=e.background,u=r._format();f(u)&&u!==""?(r._drawGroups(n,t),r._setVisibility(i),r._drawText(n,u),r._drawBackground(n),r._rotateLabel(),r._setPosition(),r._drawConnector(n)):r._setVisibility("hidden")},_deleteBackground:function(){this._background&&this._background.detach(),this._background=null},_isBackgroundChanged:function(n,t){return this._checkBackground(n||{})!==this._checkBackground(t||{})},_checkBackground:function(n){var t=n.fill&&n.fill!=="none",i=n.strokeWidth&&n.stroke&&n.stroke!=="none";return t||i},_getBackgroundSettings:function(){var n=this._text.getBBox();return{x:n.x-o,y:n.y-s,width:n.width+2*o,height:n.height+2*s}},_deleteConnector:function(){this._connector&&this._connector.detach(),this._connector=null},_isConnectorChanged:function(n,t){return this._checkConnector(n||{})!==this._checkConnector(t||{})},_checkConnector:function(n){return n&&n.strokeWidth},_getConnectorPoints:function(){var i=this,a=i._rotated,n=i._insideGroup.getBBox(),t=i._graphicBbox,s,h,c,l,u,f,e,o;if(n.x+=i._insideGroup.settings.translateX||0,n.y+=i._insideGroup.settings.translateY||0,s=i._background?n.y+n.height/2:null,h=i._background?n.x+n.width/2:null,c=n.x+n.width,l=n.y+n.height,u=r(n.x+n.width/2),f=r(t.x+t.width/2),l<t.y)e=s||l,o=t.y;else if(n.y>t.y+t.height)e=s||n.y,o=t.y+t.height;else{if(n.x>t.x+t.width)u=h||n.x,f=t.x+t.width;else if(c<t.x)u=h||c,f=t.x;else return;e=r(n.y+n.height/2),o=r(t.y+t.height/2)}return[{x:u,y:e},{x:f,y:o}]},_rotateLabel:function(){var n=this._insideGroup.getBBox();this._insideGroup.rotate(this._options.rotationAngle)},_format:function(){var u=this,n=u._data,i=u._options,r=t.formatHelper;return n.valueText=r.format(n.value,i.format,i.precision),n.argumentText=r.format(n.argument,i.argumentFormat,i.argumentPrecision),n.percent!==undefined&&(n.percentText=r.format(n.percent,"percent",i.percentPrecision)),n.total!==undefined&&(n.totalText=r.format(n.total,i.format,i.precision)),n.openValue!==undefined&&(n.openValueText=r.format(n.openValue,i.format,i.precision)),n.closeValue!==undefined&&(n.closeValueText=r.format(n.closeValue,i.format,i.precision)),n.lowValue!==undefined&&(n.lowValueText=r.format(n.lowValue,i.format,i.precision)),n.highValue!==undefined&&(n.highValueText=r.format(n.highValue,i.format,i.precision)),n.reductionValue!==undefined&&(n.reductionValueText=r.format(n.reductionValue,i.format,i.precision)),i.customizeText?i.customizeText.call(n,n):n.valueText},_getOutsideLabelCoords:function(n){var t=this._graphicBbox,i=0,r=0,u=this._location==="top";return this._rotated?(r+=t.y-n.y-n.height/2+t.height/2,i+=u?t.x+t.width-n.x+this._offset:t.x-n.x-n.width-this._offset):(i+=t.width/2+t.x,r+=u?t.y-n.y-n.height-this._offset:t.y+t.height-n.y+this._offset),{x:i,y:r}},_getInsideLabelCoords:function(n){var t=this._graphicBbox,u=this._location==="top",i=0,r=0;return this._isRange?this._rotated?(r+=t.y-n.y-n.height/2+t.height/2,i+=u?t.x+t.width-n.x-n.width-this._offset:t.x-n.x+this._offset):(i+=t.width/2+t.x,r+=u?t.y-n.y-n.height+this._offset+n.height:t.y+t.height-n.y-this._offset-n.height):this._rotated?(r+=t.y-n.y-n.height/2+t.height/2,i+=t.x-n.x-n.width/2+t.width/2):(i+=t.width/2+t.x,r+=t.y-n.y-n.height/2+t.height/2),{x:i,y:r}},_getFullstackedLabelCoords:function(n){var i=0,r=0,t=this._graphicBbox;return this._rotated?(r+=t.y-n.y-n.height/2+t.height/2,i+=this._coords.defaultX-n.x+this._offset):(i+=t.width/2+t.x,r+=this._coords.defaultY-n.y-n.height-this._offset),{x:i,y:r}},_setPositionForSymbol:function(){var t=this,r=t._offset,n=t._insideGroup.getBBox(),i=t._graphicBbox,s=t._location==="top",u=0,f=0,e=0,o=0;t._rotated?(u=i.y-n.y-n.height/2+i.height/2,f=s?i.width-n.x+r:-n.x-n.width-r,f+=i.x):(f=t._coords.x,u=s?-n.y-n.height-r:i.height-n.y+r,u+=i.y),e+=f+t._options.horizontalOffset,o+=u+t._options.verticalOffset,t._checkPosition({x:n.x+e,y:n.y+o,height:n.height,width:n.width},e,o)},_checkPositionForSymbol:function(n,t,r){var e=this,f=e._graphicBbox,u=e._visibleArea,o=e._offset;e._rotated?u.minY<=f.y+f.height&&u.maxY>=f.y&&(u.minX>n.x&&(t+=f.x+f.width-n.x+o),u.maxX<n.x+n.width&&(t-=n.x+n.width-f.x+o),u.minY>f.y&&e.adjustSeriesLabels&&(r+=u.minY-n.y),u.maxY<n.y+n.height&&e.adjustSeriesLabels&&(r-=n.y+n.height-u.maxY)):u.minX<=f.x+f.width&&u.maxX>=f.x&&(u.minX>n.x&&e.adjustSeriesLabels&&(t+=u.minX-n.x),u.maxX<n.x+n.width&&e.adjustSeriesLabels&&(t-=n.x+n.width-u.maxX),u.minY>n.y&&(r+=f.y+f.height-n.y+o),u.maxY<n.y+n.height&&(r-=n.y+n.height-f.y+o)),e._insideGroup.applySettings({translateX:i(t),translateY:i(r)})},_setPositionForBar:function(){var n=this,u=n._offset,r=n._options.position,i=n._insideGroup.getBBox(),t;t=n._initialValue===0&&n._isFullStacked?n._getFullstackedLabelCoords(i):r==="inside"?n._getInsideLabelCoords(i):n._getOutsideLabelCoords(i),t.x+=n._options.horizontalOffset,t.y+=n._options.verticalOffset,n._checkPosition({x:i.x+t.x,y:i.y+t.y,height:i.height,width:i.width},t.x,t.y)},_checkPositionForBar:function(n,t,r){var f=this,e=f._graphicBbox,u=f._visibleArea;if(u.minX<=e.x+e.width&&u.maxX>=e.x&&u.minY<=e.y+e.height&&u.maxY>=e.y&&(f._rotated?(u.minX>n.x&&(t+=u.minX-n.x),u.maxX<n.x+n.width&&(t-=n.x+n.width-u.maxX),u.minY>n.y&&f.adjustSeriesLabels&&(r+=u.minY-n.y),u.maxY<n.y+n.height&&f.adjustSeriesLabels&&(r-=n.y+n.height-u.maxY)):(u.minX>n.x&&f.adjustSeriesLabels&&(t+=u.minX-n.x),u.maxX<n.x+n.width&&f.adjustSeriesLabels&&(t-=n.x+n.width-u.maxX),u.minY>n.y&&(r+=u.minY-n.y),u.maxY<n.y+n.height&&(r-=n.y+n.height-u.maxY))),f._options.resolveLabelsOverlapping&&f._options.position==="inside")if(f._rotated){if(n.width>e.width||n.height>e.height){f.hide();return}}else if(n.height>e.height||n.width>e.width){f.hide();return}f._insideGroup.applySettings({translateX:i(t),translateY:i(r)})},_setPositionForBubble:function(){var n=this,t=n._insideGroup.getBBox(),u=n._graphicBbox,i=0,r=0;n._options.position==="inside"?(i=n._coords.x,r+=u.y+u.height/2-t.y-t.height/2,i+=n._options.horizontalOffset,r+=n._options.verticalOffset,n._checkPosition({x:t.x+i,y:t.y+r,height:t.height,width:t.width},i,r)):n._setPositionForSymbol()},_setPositionForFinancial:function(){var t=this,r=t._offset,i=t._insideGroup.getBBox(),n;n=t._getOutsideLabelCoords(i),n.x+=t._options.horizontalOffset,n.y+=t._options.verticalOffset,t._checkPosition({x:i.x+n.x,y:i.y+n.y,height:i.height,width:i.width},n.x,n.y)}})}(jQuery,DevExpress),function(n,t){var r=t.utils.getCosAndSin,c=n.extend,f=Math,i=f.round,o=f.max,s=n.inArray,e=t.utils.isDefined,h=30,u=20;t.viz.core.series.points.PieLabel=t.viz.core.series.points.Label.inherit({ctor:function(n,t){this.setLabelEllipsis=!1,this.indentFromPie=h,this.updateData(n),this.setOptions(t)},updateData:function(n){e(n)&&(this._data=n.formatObject)},setOptions:function(n){var t=this,i=t._options,n=n||{};t._options=n.options,t._borderWidth=n.borderWidth,i&&(t._isBackgroundChanged(i.background,t._options.background)&&t._deleteBackground(),t._isConnectorChanged(i.connector,t._options.connector)&&t._deleteConnector())},setCoords:function(n,t){this._middleAngle=n.middleAngle,this._radiusOuter=n.radiusOuter,this._centerX=n.centerX,this._centerY=n.centerY,this._canvas=t},updatePosition:function(n){this._setPosition(n),this._checkEllipsis(),this._drawBackground(),this._rotateLabel(),this._checkPosition(),this._connector&&this._drawConnector()},dispose:function(){this._data=null,this._options=null,this._canvas=null,this._deleteElements()},draw:function(n,t,i){var r=this,f=r._options,o=f.background,u=r._format();e(u)&&u!==""?(r._drawGroups(n,t),r._setVisibility(i),r._drawText(n,u),r._setPosition(),r._checkEllipsis(),r._drawBackground(n),r._rotateLabel(),r._checkPosition(),r._drawConnector(n)):r._setVisibility("hidden")},_getOutsideGroupLabelPosition:function(){return this._deleteConnector(),this._group&&this._group.getBBox()},_setPosition:function(n){var t=this,v=t._text.getBBox(),h=t._options,o=r(t._middleAngle),s="center",e=t._radiusOuter+h.radialOffset,c=t._canvas,l=c.width-c.right,a=c.left,f,y;h.position==="inside"?(e-=t.indentFromPie,f=t._centerX+e*o.cos):h.position==="columns"?(e+=u,o.cos>=0?(s="right",f=n?t._centerX+e+n:l,f=f>l?l:f):o.cos<0&&(s="left",f=n?t._centerX-e-n:a,f=f<a?a:f)):(e+=t.indentFromPie,o.cos>.1?s="left":o.cos<-.1&&(s="right"),f=t._centerX+e*o.cos),y=i(t._text.settings.y+t._centerY-e*o.sin-v.y-v.height/2),t._text.applySettings({x:f,y:y,align:s})},_getConnectorPoints:function(){var n=this,c=n._options,l=c.position,f,h=n._radiusOuter,t,e,o,s=[];return l!=="inside"&&(f=r(i(n._middleAngle)),s.push({x:i(n._centerX+(h-n._borderWidth)*f.cos),y:i(n._centerY-(h-n._borderWidth)*f.sin)}),e=i(n._centerX+(h+c.radialOffset+u)*f.cos),l==="columns"?(t=n._insideGroup.getBBox(),t.x=t.x+(n._insideGroup.settings.translateX||0),t.y=t.y+(n._insideGroup.settings.translateY||0),o=t.y+t.height/2,s.push({x:e,y:o}),n._background?e=t.x+t.width/2:f.cos<0?e=t.x+t.width:f.cos>0&&(e=t.x),s.push({x:e,y:o})):(o=i(n._centerY-(h+c.radialOffset+u)*f.sin),s.push({x:e,y:o}))),s},_rotateLabel:function(){var n=this,t=n._options,o=n._radiusOuter+t.radialOffset*2+u,s=r(n._middleAngle),f,e,i=n._insideGroup.getBBox();t.position==="inside"||t.position==="columns"?(f=i.x+i.width/2,e=i.y+i.height/2):(f=n._centerX+o*s.cos,e=n._centerY-o*s.sin),n._insideGroup.applySettings({x:f,y:e,rotate:t.rotationAngle})},_checkEllipsis:function(){var n=this,a,c=10,t,y,d=0,p=[],g=[],nt,h,w,f,v,e,l=r(n._options.rotationAngle),i=n._canvas,tt=n._options,b=r(n._middleAngle),k=n._centerX+(n._radiusOuter+u)*b.cos;if(n._text.tspans&&n.setLabelEllipsis){if(t=n._text.getBBox(),f=t.x+t.width<n._centerX?t.x+t.width:t.x,v=t.y+t.height/2,e=t.x+t.width<n._centerX?-t.width:t.width,v+e*l.sin>i.height-i.bottom+c||v+e*l.sin<i.top-c||f+e*l.cos<i.left-c||f+e*l.cos>i.width-i.right+c||tt.position==="columns"&&(b.cos<0&&k<f||b.cos>0&&k>f))for(a=0;a<n._text.tspans.length;a++)d+=n._text.tspans[a].element.getNumberOfChars(),(!n._text.tspans[a+1]||n._text.tspans[a+1].settings.dy>0)&&(p.push(d),g.push(a),d=0);while(v+e*l.sin>i.height-i.bottom+c||v+e*l.sin<i.top-c||f+e*l.cos<i.left-c||f+e*l.cos>i.width-i.right+c||tt.position==="columns"&&(b.cos<0&&k<f||b.cos>0&&k>f)){if(nt=o.apply(null,p),nt===0)break;w=s(nt,p),h=g[w],n._text.tspans[h].element.textContent==="..."?n._text.tspans[h].settings.dy>0||!n._text.tspans[h-1]?p[w]=0:n._text.tspans[h-1]&&(n._text.tspans[h].element.textContent="",g[w]-=1,n._text.tspans[h-1].element.textContent+="..."):(y=n._text.tspans[h].element.textContent,y=y.substr(0,y.length-4)+"...",n._text.tspans[h].element.textContent=y,p[w]-=1),t=n._text.getBBox(),f=t.x+t.width<n._centerX?t.x+t.width:t.x,v=t.y+t.height/2,e=t.x+t.width<n._centerX?-t.width:t.width}}},_checkPosition:function(){var u=this,f=u._insideGroup,n=f.getBBox(),t=u._canvas,i=0,r=0;n.y+n.height>t.height-t.bottom?r=t.height-n.y-n.height-t.bottom:n.y<t.top&&(r=t.top-n.y),n.x+n.width>t.width-t.right?i=t.width-t.right-n.x-n.width:n.x<t.left&&(i=t.left-n.x),f.applySettings({translateX:i,translateY:r})},setPosition:function(n){this._options.position=n},getPosition:function(){return this._options.position}})}(jQuery,DevExpress),function(n,t){var a=DevExpress.viz,l=a.core,f=l.series,r=n.extend,p=n.each,v=t.utils.isNumber,i=t.utils.isDefined,w=n.isEmptyObject,e=Math,u=e.round,y=e.floor,o=e.ceil,s=20,h=20,c="canvas_position_default";f.points.mixins=f.points.mixins||{},f.points.mixins.symbolPoint={deleteLabel:function(){this._label.dispose(),this._label=null},_hasGraphic:function(){return this.graphic},_clearTrackerVisibility:function(){this.trackerGraphic&&this.trackerGraphic.settings.visibility&&this.trackerGraphic.applySettings({visibility:null})},clearVisibility:function(){this.graphic&&this.graphic.settings.visibility&&this.graphic.applySettings({visibility:null}),this._clearTrackerVisibility(),this._label.clearVisibility()},isVisible:function(){return this.inVisibleArea&&this.series.isVisible()},_setTrackerInvisibility:function(){this.trackerGraphic&&this.trackerGraphic.settings.visibility!=="hidden"&&this.trackerGraphic.applySettings({visibility:"hidden"})},setInvisibility:function(){this.graphic&&this.graphic.settings.visibility!=="hidden"&&this.graphic.applySettings({visibility:"hidden"}),this._setTrackerInvisibility(),this._label.hide()},clearMarker:function(){this.graphic&&this.graphic.applySettings(this._emptySettings)},setAdjustSeriesLabels:function(n){this._label.adjustSeriesLabels=n},_getLabelOptions:function(n){var t=this._options;return{options:t.label,rotated:t.rotated,type:n,isFullStacked:t.series.isFullStackedSeries(),isRange:t.type.indexOf("range")!==-1}},_createLabel:function(){this._label=l.CoreFactory.createLabel(this._options.type)},_updateLabelData:function(){this._label.updateData({formatObject:this._getLabelFormatObject(),initialValue:this.initialValue})},_updateLabelOptions:function(n){this._label||this._createLabel(),this._label.setOptions(this._getLabelOptions(n))},_checkImage:function(n){return i(n)&&(typeof n=="string"||i(n.url))},_fillStyle:function(){this._styles=this._options.styles},_checkSymbol:function(n,t){var i=n.symbol,r=t.symbol,u=i==="circle"&&r!=="circle"||i!=="circle"&&r==="circle",f=this._checkImage(n.image)!==this._checkImage(t.image);return u||f?!0:!1},_getSquareMarkerCoords:function(n){return[{x:-n,y:-n},{x:n,y:-n},{x:n,y:n},{x:-n,y:n},{x:-n,y:-n}]},_getPolygonMarkerCoords:function(n){var t=o(n);return[{x:-t,y:0},{x:0,y:-t},{x:t,y:0},{x:0,y:t},{x:-t,y:0}]},_getTriangleMarkerCoords:function(n){return[{x:-n,y:-n},{x:n,y:-n},{x:0,y:n},{x:-n,y:-n}]},_getCrossMarkerCoords:function(n){var t=o(n),i=y(t/2),r=o(t/2);return[{x:-t,y:-i},{x:-i,y:-t},{x:0,y:-r},{x:i,y:-t},{x:t,y:-i},{x:r,y:0},{x:t,y:i},{x:i,y:t},{x:0,y:r},{x:-i,y:t},{x:-t,y:i},{x:-r,y:0}]},_populatePointShape:function(n,t){switch(n){case"square":return this._getSquareMarkerCoords(t);case"polygon":return this._getPolygonMarkerCoords(t);case"triangle":return this._getTriangleMarkerCoords(t);case"cross":return this._getCrossMarkerCoords(t)}},correctValue:function(n){this.hasValue()&&(this.value=this.initialValue+n,this.minValue=n,this.translate())},resetCorrection:function(){this.value=this.initialValue,this.minValue=c},_getTranslates:function(n){var t,i;return t=this.x,i=this.y,n&&(this._options.rotated?t=this.defaultX:i=this.defaultY),{x:t,y:i}},_createImageMarker:function(n,t,i){var e,r,f,c,o={location:"center",translateX:t.attr.translateX,translateY:t.attr.translateY,visibility:t.attr.visibility};return e=i.url?i.url.toString():i.toString(),r=i.width||s,f=i.height||h,n.createImage(-u(r*.5),-u(f*.5),r,f,e,o)},_createSymbolMarker:function(n,t){var r,u=this._options;switch(u.symbol){case"circle":r=n.createCircle(0,0,t.r,t.attr);break;case"square":case"polygon":case"triangle":case"cross":r=n.createArea(t.points,t.attr)}return r},_createMarker:function(n,t,i,r,u){var f=this._checkImage(i)?this._createImageMarker(n,r,i):this._createSymbolMarker(n,r,u);return f&&f.append(t),f},_getSymbolBbox:function(n,t,i){var r={};return r.x=n-i,r.y=t-i,r.width=r.height=i*2,r},_getImageBbox:function(n,t){var i={},r=this._options.image,f=r.width||s,e=r.height||h;return i.x=n-u(f/2),i.y=t-u(e/2),i.width=f,i.height=e,i},_getGraphicBbox:function(){var n=this._options,t=this.x,i=this.y,r;return r=n.visible?this._checkImage(n.image)?this._getImageBbox(t,i):this._getSymbolBbox(t,i,n.styles.normal.r):{x:t,y:i,width:0,height:0}},_drawLabel:function(n,t){var i=this,u=i._getCustomLabelVisibility(),f,r=i.translators;(i._options.series.getLabelVisibility()||u)&&i.hasValue()?(r&&(f={minX:r.x.getCanvasVisibleArea().min,maxX:r.x.getCanvasVisibleArea().max,minY:r.y.getCanvasVisibleArea().min,maxY:r.y.getCanvasVisibleArea().max}),i._label.setCoords({x:i.x,y:i.y},i._getGraphicBbox(),i._getLabelPosition(),f),i._label.draw(n,t,u)):i._label.hide()},_drawMarker:function(n,t,i){var u=this,e=u._options,o=u._getTranslates(i),s,f=u._getStyle(),h=r({translateX:o.x,translateY:o.y},f),c={attr:h,points:u._populatePointShape(e.symbol,f.r),r:f.r};s=u._createMarker(n,t,e.image,c,i),u.graphic=s},_drawTrackerMarker:function(n,t){var i=this._options.trackerR||this.storeTrackerR();this.trackerGraphic=n.createCircle(this.x,this.y,i).append(t),this.trackerGraphic.data({point:this})},getTooltipCoords:function(){var n;return n=this.graphic?{x:this.x,y:this.y,offset:this.graphic.getBBox().height/2}:{x:this.x,y:this.y,offset:0}},hasValue:function(){return this.value!==null&&this.minValue!==null},setPercentValue:function(n){var i=this.value/n||0,r=i,t=this.minValue/n||0;r-=v(this.minValue)?t:0,this._label.setDataField("percent",r),this._label.setDataField("total",n),this._options.series.isFullStackedSeries()&&this.hasValue()&&(this.value=i,this.minValue=t?t:this.minValue,this.translate())},storeTrackerR:function(){var n=window.navigator,i=this._options.styles.normal.r,t;return t="ontouchstart"in window||n.msPointerEnabled&&n.msMaxTouchPoints||n.pointerEnabled&&n.maxTouchPoints?20:6,this._options.trackerR=i<t?t:i},_translate:function(n){var t=this,i=t._options.rotated?"x":"y",u=i.toUpperCase(),r=n[i],f=t._options.rotated?"y":"x";t[i]=r.translate(t.value),t[f]=n[f].translate(t.argument),t["min"+u]=r.translate(t.minValue),t["default"+u]=r.translate(c),t._calculateVisibility(t.x,t.y),t._prepareStatesOptions()},_changeData:function(n){this.value=this.initialValue=this.originalValue=n.value,this.argument=this.initialArgument=this.originalArgument=n.argument,this.minValue=this.initialMinValue=this.originalMinValue=i(n.minValue)?n.minValue:c,this.tag=n.tag,this.index=n.index},_updateData:function(n){(this.argument!==n.argument||this.value!==n.value||this.tag!==n.tag)&&this._changeData(n)},_getImageSettings:function(n){return{href:n.url||n.toString(),width:n.width||s,height:n.height||h}},_updateMarker:function(n,t){var i=this,f=i._options,t=t||this._getStyle(),u,e=f.image;u=i._checkImage(e)?r({},{visibility:t.visibility},i._getImageSettings(e)):r({},t,{points:i._populatePointShape(f.symbol,t.r)}),n||(u.translateX=i.x,u.translateY=i.y),i.graphic.applySettings(u)},_updateTracker:function(){this.trackerGraphic.applySettings({cx:this.x,cy:this.y,r:this.storeTrackerR()})},_getLabelFormatObject:function(){return{argument:this.initialArgument,value:this.initialValue,originalArgument:this.originalArgument,originalValue:this.originalValue,seriesName:this._options.series.name,point:this}},_getLabelPosition:function(){return this._options.series.isFullStackedSeries()||this.initialValue>0?"top":"bottom"},_getFormatObject:function(n){var t=this._label.getData(),u={argumentText:n.formatValue(this.initialArgument,"argument"),valueText:n.formatValue(this.initialValue)},f=i(t.percent)?{percentText:n.formatValue(t.percent,"percent")}:{},e=i(t.total)?{totalText:n.formatValue(t.total)}:{};return r({},t,u,f,e)}}}(jQuery,DevExpress),function(n){var h=DevExpress.viz,u=h.core.series.points.mixins,f=n.extend,r=Math,c=r.round,e=r.abs,i=r.min,l="canvas_position_default",o=9,s=4;u.barPoint=f({},u.symbolPoint,{correctCoordinates:function(n){var i=n.offset-c(n.width/2),t=this._options.rotated,r=t?"height":"width",u=(t?"y":"x")+"Correction";this[r]=n.width,this[u]=i},_getGraphicBbox:function(){var n={};return n.x=this.x,n.y=this.y,n.width=this.width,n.height=this.height,n},_getLabelPosition:function(){var t,i=this.translators.x.getBusinessRange().invert,r=this.translators.y.getBusinessRange().invert,n=this.series.valueAxisType==="discrete",u=this.series.isFullStackedSeries(),f=!n&&(this.initialValue>=0&&!r||this.initialValue<0&&r)||n&&!r||u,e=!n&&(this.initialValue>=0&&!i||this.initialValue<0&&i)||n&&!i||u;return t=this._options.rotated?e?"top":"bottom":f?"top":"bottom"},_drawLabel:function(n,t){var i=this,u=i._options,f,s=u.series.getLabelVisibility(),e=i._getCustomLabelVisibility(),o,r=i.translators;i.hasValue()&&(u.label.showForZeroValues||i.initialValue)&&(e||s)?(f={x:i.x,y:i.y,defaultX:i.defaultX,defaultY:i.defaultY},r&&(o={minX:r.x.getCanvasVisibleArea().min,maxX:r.x.getCanvasVisibleArea().max,minY:r.y.getCanvasVisibleArea().min,maxY:r.y.getCanvasVisibleArea().max}),i._label.setCoords(f,i._getGraphicBbox(),i._getLabelPosition(),o),i._label.draw(n,t,e)):i._label.hide()},_drawMarker:function(n,t,i){var o=this._getStyle(),r=this.x,u=this.y,f=this.width,e=this.height;i&&(this._options.rotated?(f=0,r=this.defaultX):(e=0,u=this.defaultY)),this.graphic=n.createRect(r,u,f,e,this._options.cornerRadius,o).append(t)},_getSettingsForTracker:function(){var n=this,r=n.y,t=n.height,u=n.x,i=n.width;return n._options.rotated?i===1&&(i=o,u-=s):t===1&&(t=o,r-=s),{x:u,y:r,width:i,height:t}},_drawTrackerMarker:function(n,t){var i=this._getSettingsForTracker();this.trackerGraphic=n.createRect(i.x,i.y,i.width,i.height,this._options.cornerRadius).append(t),this.trackerGraphic.data({point:this})},getGraphicSettings:function(){return{x:this.graphic.settings.x||0,y:this.graphic.settings.y||0,height:this.graphic.settings.height||0,width:this.graphic.settings.width||0}},getTooltipCoords:function(){var n=this.x+this.width/2,t=this.y+this.height/2;return{x:n,y:t,offset:0}},_truncateCoord:function(n,t,i){return n<t?t:n>i?i:n},_translate:function(n){var t=this,o=t._options.rotated,s=o?"x":"y",r=o?"y":"x",w=o?"width":"height",c=o?"height":"width",b=n[r],a=n[s],h=b.getCanvasVisibleArea(),v=a.getCanvasVisibleArea(),y,p,f,u;y=p=b.translate(t.argument)+(t[r+"Correction"]||0),f=a.translate(t.value),u=a.translate(t.minValue),t[w]=e(f-u),t._calculateVisibility(o?i(f,u):i(y,p),o?i(y,p):i(f,u),t.width,t.height),f=t._truncateCoord(f,v.min,v.max),u=t._truncateCoord(u,v.min,v.max),t[r]=y,t["min"+r.toUpperCase()]=p,t[w]=e(f-u),t[s]=i(f,u)+(t[s+"Correction"]||0),t["min"+s.toUpperCase()]=u+(t[s+"Correction"]||0),t["default"+s.toUpperCase()]=a.translate(l),t.inVisibleArea&&(t[r]<h.min&&(t[c]=t[c]-(h.min-t[r]),t[r]=h.min,t["min"+r.toUpperCase()]=h.min),t[r]+t[c]>h.max&&(t[c]=h.max-t[r]))},_updateMarker:function(n,t){var t=t||this._getStyle(),i=f({},t);n?i.sharpEdges=!1:(i.x=this.x,i.y=this.y,i.width=this.width,i.height=this.height),this.graphic.applySettings(i)},_updateTracker:function(){this.trackerGraphic.applySettings(this._getSettingsForTracker())}})}(jQuery,DevExpress),function(n,t){var u=t.viz,i=u.core.series.points.mixins,r=n.extend,f=20;i.bubblePoint=r({},i.symbolPoint,{correctCoordinates:function(n){this.bubbleSize=n/2},_drawMarker:function(n,t,i){var u=this._getStyle(),f=r({translateX:this.x,translateY:this.y},u),e=n.createCircle(0,0,i?0:this.bubbleSize,f).append(t);this.graphic=e},_drawTrackerMarker:function(n,t){this.trackerGraphic=n.createCircle(this.x,this.y,this.bubbleSize).append(t),this.trackerGraphic.data({point:this})},getTooltipCoords:function(){if(this.graphic){var n=this.graphic.getBBox().height;return{x:this.x,y:this.y,offset:n<f?n/2:0}}},_getLabelFormatObject:function(){var t=i.symbolPoint,n=t._getLabelFormatObject.call(this);return n.size=this.initialSize,n},_updateData:function(n){var t=i.symbolPoint;(this.argument!==n.argument||this.value!==n.value||this.size!==n.size||this.tag!==n.tag)&&(t._changeData.call(this,n),this.size=this.initialSize=n.size)},_getGraphicBbox:function(){return this._getSymbolBbox(this.x,this.y,this.bubbleSize)},_updateMarker:function(t,i){var i=i||this._getStyle();t||(i=n.extend({r:this.bubbleSize,translateX:this.x,translateY:this.y},i)),this.graphic.applySettings(i)},_updateTracker:function(){this.trackerGraphic.applySettings({cx:this.x,cy:this.y,r:this.bubbleSize})},_getFormatObject:function(n){var r=i.symbolPoint,t=r._getFormatObject.call(this,n);return t.sizeText=n.formatValue(this.initialSize),t}})}(jQuery,DevExpress),function(n,t){var e=DevExpress.viz,i=e.core.series.points.mixins,r=n.extend,u=Math.round,f=t.utils.getCosAndSin;i.piePoint=r({},i.symbolPoint,{_populatePointShape:function(n,t){var i=f(point.middleAngle);n.x=point.centerX-~~(t*i.cos),n.y=point.centerY+~~(t*i.sin),n.outerRadius=this.radiusOuter+t,n.innerRadius=this.radiusInner,n.startAngle=this.toAngle,n.endAngle=this.fromAngle},_changeData:function(n){var t=this;t.value=t.initialValue=t.originalValue=n.value,t.argument=t.initialArgument=t.originalArgument=n.argument,t.minValue=t.initialMinValue=t.originalMinValue=DevExpress.utils.isDefined(n.minValue)?n.minValue:0,t.tag=n.tag,t._visible=!0,t.index=n.index},animate:function(n,t,i){this.graphic.animate({x:this.centerX,y:this.centerY,outerRadius:this.radiusOuter,innerRadius:this.radiusInner,startAngle:this.toAngle,endAngle:this.fromAngle},{partitionDuration:t,step:i},n)},correctPosition:function(n){this.radiusInner=n.radiusInner,this.radiusOuter=n.radiusOuter,this.centerX=n.centerX,this.centerY=n.centerY},correctValue:function(n,t,i){this.value=(i||this.initialValue)+n,this.minValue=n,this.percent=t,this._label.setDataField("percent",t)},_getLabelOptions:function(){var t=this._options,i=t.series,n=this._options.styles.normal,r=i._options.containerBackgroundColor===n.stroke?u(n.strokeWidth/2):u(-n.strokeWidth/2);return{options:t.label,borderWidth:r}},_updateLabelData:function(){this._label.updateData({formatObject:this._getLabelFormatObject()})},_updateLabelOptions:function(){this._label||this._createLabel(),this._label.setOptions(this._getLabelOptions())},_drawLabel:function(n,t){var r=this._options.series.getLabelVisibility(),i=this._getCustomLabelVisibility();(r||i)&&this.hasValue()?(this._label.setCoords({middleAngle:this.middleAngle,radiusOuter:this.radiusOuter,centerX:this.centerX,centerY:this.centerY},this._options.series.canvas),this._label.draw(n,t,i)):this._label.hide()},_drawMarker:function(n,t,i,r){var s=this._getStyle(),u=this.radiusOuter,f=this.radiusInner,e=this.fromAngle,o=this.toAngle;i&&(f=u=0,r||(e=o=this.shiftedAngle)),this.graphic=n.createArc(this.centerX,this.centerY,u,f,o,e,s).append(t)},_drawTrackerMarker:function(n,t){this.trackerGraphic=n.createArc(this.centerX,this.centerY,this.radiusOuter,this.radiusInner,this.toAngle,this.fromAngle).append(t),this.trackerGraphic.data({point:this})},getTooltipCoords:function(){var n=f(this.middleAngle);return{x:this.centerX+(this.radiusInner+(this.radiusOuter-this.radiusInner)/2)*n.cos,y:this.centerY-(this.radiusInner+(this.radiusOuter-this.radiusInner)/2)*n.sin,offset:0}},_translate:function(n){var t=this.shiftedAngle||0;this.fromAngle=n.translate(this.minValue)+t,this.toAngle=n.translate(this.value)+t,this.middleAngle=n.translate((this.value-this.minValue)/2+this.minValue)+t,this.isVisible()||(this.middleAngle=this.toAngle=this.fromAngle=this.fromAngle||t)},_updateMarker:function(n,t){t=t||this._getStyle(),n||(t=r({x:this.centerX,y:this.centerY,outerRadius:this.radiusOuter,innerRadius:this.radiusInner,startAngle:this.toAngle,endAngle:this.fromAngle},t)),this.graphic.applySettings(t)},_updateTracker:function(){this.trackerGraphic.applySettings({x:this.centerX,y:this.centerY,outerRadius:this.radiusOuter,innerRadius:this.radiusInner,startAngle:this.toAngle,endAngle:this.fromAngle})},getLegendStyles:function(){return this._styles.legendStyles},isInVisibleArea:function(){return!0},hide:function(){this._visible&&(this._visible=!1,this.hideTooltip(),this._options.visibilityChanged(this))},show:function(){this._visible||(this._visible=!0,this._options.visibilityChanged(this))},setInvisibility:function(){this._setTrackerInvisibility(),this._label.hide()},isVisible:function(){return this._visible},_getFormatObject:function(n){var r=i.symbolPoint,t=r._getFormatObject.call(this,n);return t.percent=this.percent,t.percentText=n.formatValue(this.percent,"percent"),t},getColor:function(){return this._styles.normal.fill}})}(jQuery,DevExpress),function(n,t){var e=DevExpress.viz,o=e.core.series.points.mixins,u=n.extend,h=t.utils.isDefined,f=Math,s=f.abs,i=f.min,r=f.max,c=f.round,l=20,a=20;o.rangeSymbolPoint=u({},o.symbolPoint,{deleteLabel:function(){this._topLabel.dispose(),this._topLabel=null,this._bottomLabel.dispose(),this._bottomLabel=null},hideMarker:function(n){var t=this.graphic&&this.graphic[n+"Marker"],i=this["_"+n+"Label"];t&&t.settings.visibility!=="hidden"&&t.applySettings({visibility:"hidden"}),i.hide()},setInvisibility:function(){this.hideMarker("top"),this.hideMarker("bottom"),this._setTrackerInvisibility()},clearVisibility:function(){var n=this.graphic;n&&(n.topMarker&&n.topMarker.settings.visibility&&n.topMarker.applySettings({visibility:null}),n.bottomMarker&&n.bottomMarker.settings.visibility&&n.bottomMarker.applySettings({visibility:null})),this._clearTrackerVisibility(),this._topLabel.clearVisibility(),this._bottomLabel.clearVisibility()},clearMarker:function(){this.graphic&&(this.graphic.topMarker&&this.graphic.topMarker.applySettings(this._emptySettings),this.graphic.bottomMarker&&this.graphic.bottomMarker.applySettings(this._emptySettings))},_getLabelPosition:function(n){var i,t=this._options.rotated,r=this.translators.y.getBusinessRange().invert,u=this.translators.x.getBusinessRange().invert,f=this._options.series._options.valueAxisType==="discrete",e=f&&(!r&&!t||u&&t)||!f&&this.value>this.minValue&&(!r&&!t||!u&&t);return i=n==="top"?e?"top":"bottom":e?"bottom":"top"},_getLabelMinFormatObject:function(){return{index:0,argument:this.initialArgument,value:this.initialMinValue,seriesName:this._options.series.name,originalValue:this.originalMinValue,originalArgument:this.originalArgument,point:this}},_updateLabelData:function(){var n=this._getLabelFormatObject();n.index=1,this._topLabel.updateData({formatObject:n,initialValue:this.initialValue}),this._bottomLabel.updateData({formatObject:this._getLabelMinFormatObject(),initialValue:this.initialMinValue})},_updateLabelOptions:function(n){var t=this._getLabelOptions(n);this._topLabel&&this._bottomLabel||this._createLabel(),this._topLabel.setOptions(t),this._bottomLabel.setOptions(t)},setAdjustSeriesLabels:function(n){this._topLabel.adjustSeriesLabels=n,this._bottomLabel.adjustSeriesLabels=n},_createLabel:function(){this._topLabel=e.core.CoreFactory.createLabel(),this._bottomLabel=e.core.CoreFactory.createLabel()},_getLabelCoords:function(n){var t={},u=n==="top";return this._options.rotated?(t.x=u?r(this.x,this.minX):i(this.x,this.minX),t.y=this.y):(t.x=this.x,t.y=u?i(this.y,this.minY):r(this.y,this.minY)),t},_getGraphicBbox:function(n){var f=this._options,h=f.rotated,e=n==="top",s=this._getImage(f.image),c=e?this._checkImage(s.top):this._checkImage(s.bottom),o,t,u;return h?(t=e?r(this.x,this.minX):i(this.x,this.minX),u=this.y):(t=this.x,u=e?i(this.y,this.minY):r(this.y,this.minY)),o=f.visible?c?this._getImageBbox(t,u):this._getSymbolBbox(t,u,f.styles.normal.r):{x:t,y:u,width:0,height:0}},_checkOverlay:function(n,t,i){return n<t+i},_getOverlayCorrections:function(n,t,i){var s=n==="vertical",u=s?"y":"x",o=s?"height":"width",h=this.translators[u].getCanvasVisibleArea(),l=h.min,a=h.max,r=c((t[u]+t[o]-i[u])/2),f=t[u]-r,e=i[u]+r;return f<l?(r=l-t[u],f+=r,e+=r):e+i[o]>a&&(r=-(i[u]+i[o]-a),f+=r,e+=r),{coord1:f,coord2:e}},_checkLabelsOverlay:function(n){var i=this,r=i._topLabel.getCoords(),u=i._bottomLabel.getCoords(),t={};i._options.rotated?n==="top"?this._checkOverlay(r.x,u.x,u.width)&&(t=this._getOverlayCorrections("horizontal",u,r),i._topLabel.updatePosition(t.coord2),i._bottomLabel.updatePosition(t.coord1)):this._checkOverlay(u.x,r.x,r.width)&&(t=this._getOverlayCorrections("horizontal",r,u),i._topLabel.updatePosition(t.coord1),i._bottomLabel.updatePosition(t.coord2)):n==="top"?this._checkOverlay(u.y,r.y,r.height)&&(t=this._getOverlayCorrections("vertical",r,u),i._topLabel.updatePosition(undefined,t.coord1),i._bottomLabel.updatePosition(undefined,t.coord2)):this._checkOverlay(r.y,u.y,u.height)&&(t=this._getOverlayCorrections("vertical",u,r),i._topLabel.updatePosition(undefined,t.coord2),i._bottomLabel.updatePosition(undefined,t.coord1))},_drawLabel:function(n,t){var l,a,v=this._options.rotated,i=this._getLabelPosition("top"),u=this._getLabelPosition("bottom"),o=this._options.label.position==="inside",s=o?u:i,h=o?i:u,r=this.translators,f,e=this._getCustomLabelVisibility(),c=this._options.series.getLabelVisibility();(c||e)&&this.hasValue()?(r&&(f={minX:r.x.getCanvasVisibleArea().min,maxX:r.x.getCanvasVisibleArea().max,minY:r.y.getCanvasVisibleArea().min,maxY:r.y.getCanvasVisibleArea().max}),this._topLabel.setCoords(this._getLabelCoords(i),this._getGraphicBbox(i),s,f),this._bottomLabel.setCoords(this._getLabelCoords(u),this._getGraphicBbox(u),h,f),this.visibleTopMarker&&this._topLabel.draw(n,t,e),this.visibleBottomMarker&&this._bottomLabel.draw(n,t,e),this._checkLabelsOverlay(i)):(this._topLabel.hide(),this._bottomLabel.hide())},_getImage:function(n){var t={};return h(n)&&(typeof n=="string"?t.top=t.bottom=n:(t.top={url:typeof n.url=="string"?n.url:n.url&&n.url.rangeMaxPoint,width:typeof n.width=="number"?n.width:n.width&&n.width.rangeMaxPoint,height:typeof n.height=="number"?n.height:n.height&&n.height.rangeMaxPoint},t.bottom={url:typeof n.url=="string"?n.url:n.url&&n.url.rangeMinPoint,width:typeof n.width=="number"?n.width:n.width&&n.width.rangeMinPoint,height:typeof n.height=="number"?n.height:n.height&&n.height.rangeMinPoint})),t},_checkSymbol:function(n,t){var i=n.symbol,r=t.symbol,e=i==="circle"&&r!=="circle"||i!=="circle"&&r==="circle",u=this._getImage(n.image),f=this._getImage(t.image),o=this._checkImage(u.top)!==this._checkImage(f.top),s=this._checkImage(u.bottom)!==this._checkImage(f.bottom);return e||o||s},_getSettingsForTwoMarkers:function(n){var t=this,r=t._options,f={},o=r.rotated?i(t.x,t.minX):t.x,s=r.rotated?t.y:i(t.y,t.minY),e=n.r,h=t._populatePointShape(r.symbol,e);return f.top={r:e,points:h,attr:u({translateX:o+t.width,translateY:s},n)},f.bottom={r:e,points:h,attr:u({translateX:o,translateY:s+t.height},n)},f},_hasGraphic:function(){return this.graphic&&this.graphic.topMarker&&this.graphic.bottomMarker},_drawOneMarker:function(n,t,i,r){this.graphic[t]?this._updateOneMarker(t,r):this.graphic[t]=this._createMarker(n,this.graphic,i,r)},_drawMarker:function(n,t,i,r){var u=this,r=r||u._getStyle(),f=u._getSettingsForTwoMarkers(r),e=u._getImage(u._options.image);u._checkImage(e.top)&&(f.top=u._getImageSettings(f.top,e.top)),u._checkImage(e.bottom)&&(f.bottom=u._getImageSettings(f.bottom,e.bottom)),u.graphic=u.graphic||n.createGroup().append(t),u.visibleTopMarker&&u._drawOneMarker(n,"topMarker",e.top,f.top),u.visibleBottomMarker&&u._drawOneMarker(n,"bottomMarker",e.bottom,f.bottom)},_getSettingsForTracker:function(n){var t=this,r=t._options,u=r.rotated?i(t.x,t.minX)-n:t.x-n,f=r.rotated?t.y-n:i(t.y,t.minY)-n,e=t.width+2*n,o=t.height+2*n;return{translateX:u,translateY:f,width:e,height:o}},_drawTrackerMarker:function(n,t){var i=this,u=i._options,f=u.trackerR||i.storeTrackerR(),r=i._getSettingsForTracker(f),e={translateX:r.translateX,translateY:r.translateY};i.trackerGraphic=n.createRect(0,0,r.width,r.height,0,e).append(t),i.trackerGraphic.data({point:i})},isInVisibleArea:function(){var n=this,f=i(n.minX,n.x)||n.x,e=r(n.minX,n.x)||n.x,o=r(n.minY,n.y)||n.y,s=i(n.minY,n.y)||n.y,a,v,y,p,h=!0,c=!0,l=!0,t,u;return n.translators&&(t=n.translators.x.getCanvasVisibleArea(),u=n.translators.y.getCanvasVisibleArea(),a=t.max<f&&t.max<e,v=t.min>f&&t.min>e,p=u.min>s&&u.min>o,y=u.max<s&&u.max<o,p||y||a||v?h=c=l=!1:n._options.rotated?(c=t.min<f&&t.max>f,h=t.min<e&&t.max>e):(h=u.min<s&&u.max>s,c=u.min<o&&u.max>o)),n.visibleTopMarker=h,n.visibleBottomMarker=c,n.visibleRangeArea=l,l},getTooltipCoords:function(){var n=this,o,s,r,u,t,f=n.translators.x.getCanvasVisibleArea(),e=n.translators.y.getCanvasVisibleArea();return n._options.rotated?(t=i(n.x,n.minX),s=n.y,r=f.min>t?f.min:t,u=f.max<t+n.width?f.max:t+n.width,o=r+(u-r)/2):(t=i(n.y,n.minY),o=n.x,r=e.min>t?e.min:t,u=e.max<t+n.height?e.max:t+n.height,s=r+(u-r)/2),{x:o,y:s,offset:0}},_translate:function(n){var t=o.symbolPoint;this.minX=this.minY=n.y.translate(this.minValue),t._translate.call(this,n),this.height=this._options.rotated?0:s(this.minY-this.y),this.width=this._options.rotated?s(this.x-this.minX):0},_updateData:function(n){(this.argument!==n.argument||this.value!==n.value||this.minValue!==n.minValue||this.tag!==n.tag)&&(this._changeData(n),this.minValue=this.initialMinValue=this.originalMinValue=n.minValue)},_getImageSettings:function(n,t){var i=n.attr.translateX,r=n.attr.translateY;return{href:t.url||t.toString(),width:t.width||l,height:t.height||a,attr:{translateX:i,translateY:r}}},_updateOneMarker:function(n,t){this.graphic&&this.graphic[n]&&this.graphic[n].applySettings(u({},t,t.attr))},_updateMarker:function(n,t){this._drawMarker(undefined,undefined,undefined,t)},_updateTracker:function(){var n=this.storeTrackerR(),t=this._getSettingsForTracker(n);this.trackerGraphic.applySettings(t)},_getFormatObject:function(n){var t=n.formatValue(this.initialMinValue),i=n.formatValue(this.initialValue);return{argument:this.initialArgument,argumentText:n.formatValue(this.initialArgument,"argument"),valueText:t+" - "+i,rangeValue1Text:t,rangeValue2Text:i,rangeValue1:this.initialMinValue,rangeValue2:this.initialValue,seriesName:this.series.name,point:this,originalMinValue:this.originalMinValue,originalValue:this.originalValue,originalArgument:this.originalArgument}}})}(jQuery,DevExpress),function(n,t){var u=DevExpress.viz,r=u.core.series.points.mixins,e=t.utils.isDefined,i=r.rangeSymbolPoint,f=n.extend;r.rangeBarPoint=f({},r.barPoint,{deleteLabel:i.deleteLabel,_getFormatObject:i._getFormatObject,setAdjustSeriesLabels:i.setAdjustSeriesLabels,clearVisibility:function(){this.graphic&&this.graphic.settings.visibility&&this.graphic.applySettings({visibility:null}),this._topLabel.clearVisibility(),this._bottomLabel.clearVisibility()},setInvisibility:function(){this.graphic&&this.graphic.settings.visibility!=="hidden"&&this.graphic.applySettings({visibility:"hidden"}),this._topLabel.hide(),this._bottomLabel.hide()},_translate:function(n){var t=r.barPoint;t._translate.call(this,n),this._options.rotated?this.width=this.width||1:this.height=this.height||1},_updateData:i._updateData,_getLabelPosition:i._getLabelPosition,_getLabelMinFormatObject:i._getLabelMinFormatObject,_updateLabelData:i._updateLabelData,_updateLabelOptions:i._updateLabelOptions,_createLabel:i._createLabel,_checkOverlay:i._checkOverlay,_getOverlayCorrections:i._getOverlayCorrections,_drawLabel:function(n,t){var l,a,v=this._options.rotated,e=this._getLabelPosition("top"),h=this._getLabelPosition("bottom"),o=this._getGraphicBbox(),s={x:this.x,y:this.y,defaultX:this.defaultX,defaultY:this.defaultY},r=this.translators,u,f=this._getCustomLabelVisibility(),c=this._options.series.getLabelVisibility();(f||c)&&this.hasValue()?(r&&(u={minX:r.x.getCanvasVisibleArea().min,maxX:r.x.getCanvasVisibleArea().max,minY:r.y.getCanvasVisibleArea().min,maxY:r.y.getCanvasVisibleArea().max}),this._topLabel.setCoords(s,o,e,u),this._bottomLabel.setCoords(s,o,h,u),this._topLabel.draw(n,t,f),this._bottomLabel.draw(n,t,f),i._checkLabelsOverlay.call(this,e)):(this._topLabel.hide(),this._bottomLabel.hide())}})}(jQuery,DevExpress),function(n){var l=DevExpress.viz,e=l.core.series.points.mixins,o=n.isNumeric,s=n.extend,r=Math,u=r.abs,i=r.min,h=r.max,c=r.round,f=2;e.candlestickPoint=s({},e.barPoint,{_getContinuousPoints:function(n,t){var u=this,i=u.x,r=u._options.rotated?function(n,t){return{x:t,y:n}}:function(n,t){return{x:n,y:t}},f=u.width,e=u[n],o=u[t],s;return s=e===o?[r(i,u.highY),r(i,u.lowY),r(i,u.closeY),r(i-f/2,u.closeY),r(i+f/2,u.closeY),r(i,u.closeY)]:[r(i,u.highY),r(i,o),r(i+f/2,o),r(i+f/2,e),r(i,e),r(i,u.lowY),r(i,e),r(i-f/2,e),r(i-f/2,o),r(i,o)]},_getCategoryPoints:function(n){var t=this,i=t.x,r=t._options.rotated?function(n,t){return{x:t,y:n}}:function(n,t){return{x:n,y:t}};return[r(i,t.highY),r(i,t.lowY),r(i,n),r(i-t.width/2,n),r(i+t.width/2,n),r(i,n)]},_getPoints:function(){var n=this,i,u,f,t=n.openValue,r=n.closeValue;return o(t)&&o(r)?(u=t>r?"closeY":"openY",f=t>r?"openY":"closeY",i=n._getContinuousPoints(u,f)):i=t===r?[{x:n.x,y:n.highY},{x:n.x,y:n.lowY}]:n._getCategoryPoints(o(t)?n.openY:n.closeY),i},getColor:function(){return this._isReduction?this._options.reduction.color:this._styles.normal.stroke||this.series.getColor()},_drawMarkerInGroup:function(n,t,i){this.graphic=i.createArea(this._getPoints(),t).append(n)},_fillStyle:function(){var n=this._options.styles;this._styles=this._isReduction&&this._isPositive?n.reductionPositive:this._isReduction?n.reduction:this._isPositive?n.positive:n},_getMinTrackerWidth:function(){return 1+2*this._styles.normal.strokeWidth},correctCoordinates:function(n){var t=this._getMinTrackerWidth(),i=10;this.width=n.width<t?t:n.width>i?i:n.width,this.xCorrection=n.offset},_getMarkerGroup:function(n){var t;return t=this._isReduction&&this._isPositive?n.reductionPositiveMarkersGroup:this._isReduction?n.reductionMarkersGroup:this._isPositive?n.defaultPositiveMarkersGroup:n.defaultMarkersGroup},_drawMarker:function(n,t){var i=this._getStyle(),u=this._options.rotated,r=this._getMarkerGroup(t);this._drawMarkerInGroup(r,i,n)},_getSettingsForTracker:function(){var n=this,t=n.highY,r=n.lowY,e=n._options.rotated,o,s,h,c;return t===r&&(t=e?t+f:t-f,r=e?r-f:r+f),e?(o=i(r,t),s=n.x-n.width/2,h=u(r-t),c=n.width):(o=n.x-n.width/2,s=i(r,t),h=n.width,c=u(r-t)),{x:o,y:s,width:h,height:c}},_drawTrackerMarker:function(n,t){var i=this._getSettingsForTracker();this.trackerGraphic=n.createRect(i.x,i.y,i.width,i.height,0).append(t),this.trackerGraphic.data({point:this})},_getGraphicBbox:function(){var n={},t=this._options.rotated;return n.x=t?this.lowY:this.x-c(this.width/2),n.y=t?this.x-c(this.width/2):this.highY,n.width=t?this.highY-this.lowY:this.width,n.height=t?this.width:this.lowY-this.highY,n},_drawLabel:function(n,t){var r,o=this._options.series.getLabelVisibility(),u=this._getCustomLabelVisibility(),f,e=this._options.reduction.color,i=this.translators;this.hasValue()&&(o||u)&&(f={minX:i.x.getCanvasVisibleArea().min,maxX:i.x.getCanvasVisibleArea().max,minY:i.y.getCanvasVisibleArea().min,maxY:i.y.getCanvasVisibleArea().max},this._isReduction&&this._label.updateOptions({options:{background:{fill:e},connector:{stroke:e}}}),r=this._options.rotated?{x:this.highY,y:this.x}:{x:this.x,y:this.highY},this._label.setCoords(r,this._getGraphicBbox(),"top",f),this._label.draw(n,t,u))},getTooltipCoords:function(){var n=this;if(n.graphic){var u,f,t,r,e=i(n.lowY,n.highY),o=h(n.lowY,n.highY),s=n.translators.x.getCanvasVisibleArea(),c=n.translators.y.getCanvasVisibleArea();return n._options.rotated?(t=h(s.min,e),r=i(s.max,o),f=n.x,u=t+(r-t)/2):(t=h(c.min,e),r=i(c.max,o),u=n.x,f=t+(r-t)/2),{x:u,y:f,offset:0}}},hasValue:function(){return this.highValue!==null&&this.lowValue!==null},_translate:function(){var t=this,r=t._options.rotated,o=r?t.translators.y:t.translators.x,f=r?t.translators.x:t.translators.y,e,s;t.x=o.translate(t.argument)+(t.xCorrection||0),t.openY=t.openValue!==null?f.translate(t.openValue):null,t.highY=f.translate(t.highValue),t.lowY=f.translate(t.lowValue),t.closeY=t.closeValue!==null?f.translate(t.closeValue):null,s=u(t.lowY-t.highY),e=i(t.lowY,t.highY)+u(t.lowY-t.highY)/2,t._calculateVisibility(r?e:t.x,r?t.x:e)},_updateData:function(n){var t=this;(t.argument!==n.argument||t.reductionValue!==n.reductionValue||t.highValue!==n.highValue||t.lowValue!==n.lowValue||t.openValue!==n.openValue||t.closeValue!==n.closeValue||t.tag!==n.tag)&&(t.value=t.initialValue=n.reductionValue,t.originalValue=n.value,t.argument=t.initialArgument=n.argument,t.originalArgument=n.argument,t.lowValue=n.lowValue,t.originalLowValue=n.lowValue,t.highValue=n.highValue,t.originalHighValue=n.highValue,t.openValue=n.openValue,t.originalOpenValue=n.openValue,t.closeValue=n.closeValue,t.originalCloseValue=n.closeValue,t.tag=n.tag,t.pointClassName=n.pointClassName,t._isPositive=n.openValue<n.closeValue,t._isReduction=n.isReduction)},_updateMarker:function(n,t,i){var t=t||this._getStyle();this.graphic.applySettings(s({points:this._getPoints()},t)),i&&this.graphic.append(this._getMarkerGroup(i))},_updateTracker:function(){this.trackerGraphic.applySettings(this._getSettingsForTracker())},_getLabelFormatObject:function(){return{openValue:this.openValue,highValue:this.highValue,lowValue:this.lowValue,closeValue:this.closeValue,reductionValue:this.initialValue,argument:this.initialArgument,value:this.initialValue,seriesName:this._options.series.name,originalOpenValue:this.originalOpenValue,originalCloseValue:this.originalCloseValue,originalLowValue:this.originalLowValue,originalHighValue:this.originalHighValue,originalArgument:this.originalArgument,point:this}},_getFormatObject:function(n){var r=n.formatValue(this.highValue),t=n.formatValue(this.openValue),i=n.formatValue(this.closeValue),u=n.formatValue(this.lowValue),f=e.symbolPoint,o=f._getFormatObject.call(this,n);return s({},o,{valueText:"h: "+r+(t!==""?" o: "+t:"")+(i!==""?" c: "+i:"")+" l: "+u,highValueText:r,openValueText:t,closeValueText:i,lowValueText:u})}})}(jQuery,DevExpress),function(n){var u=DevExpress.viz,i=u.core.series.points.mixins,f=n.extend,r=n.isNumeric;i.stockPoint=f({},i.candlestickPoint,{_getPoints:function(){var n=this,t=n._options.rotated?function(n,t){return{x:t,y:n}}:function(n,t){return{x:n,y:t}},u=r(n.openY),f=r(n.closeY),i=n.x,e=n.width;return[t(i,n.highY),u&&t(i,n.openY),u&&t(i-e/2,n.openY),u&&t(i,n.openY),f&&t(i,n.closeY),f&&t(i+e/2,n.closeY),f&&t(i,n.closeY),t(i,n.lowY)]},_drawMarkerInGroup:function(n,t,i){this.graphic=i.createPath(this._getPoints(),t).append(n)},_getMinTrackerWidth:function(){return 2+this._styles.normal.strokeWidth}})}(jQuery,DevExpress),function(n,t,i){t.viz.themes=t.viz.themes||[];var r="'Segoe UI', 'Helvetica Neue', 'Trebuchet MS', Verdana",e="'Segoe UI Light', 'Helvetica Neue Light', 'Segoe UI', 'Helvetica Neue', 'Trebuchet MS', Verdana",u={containerBackgroundColor:"#ffffff",animation:{enabled:!0,duration:1e3,easing:"easeOutCubic",maxPointCountSupported:300},commonSeriesSettings:{border:{visible:!1,width:2},showInLegend:!0,visible:!0,hoverMode:"excludePoints",selectionMode:"includePoints",hoverStyle:{hatching:{direction:"right",width:2,step:6,opacity:.75},border:{visible:!1,width:3}},selectionStyle:{hatching:{direction:"right",width:2,step:6,opacity:.5},border:{visible:!1,width:3}},label:{visible:!1,alignment:"center",rotationAngle:0,horizontalOffset:0,verticalOffset:0,radialOffset:0,format:"",argumentFormat:"",precision:0,argumentPrecision:0,percentPrecision:0,showForZeroValues:!0,customizeText:i,maxLabelCount:i,position:"outside",font:{color:"#ffffff"},border:{visible:!1,width:1,color:"#d3d3d3",dashStyle:"solid"},connector:{visible:!1,width:1}}},redrawOnResize:!0,margin:{left:0,top:0,right:0,bottom:0},seriesSelectionMode:"single",pointSelectionMode:"single",legend:{hoverMode:"includePoints",verticalAlignment:"top",horizontalAlignment:"right",position:"outside",visible:!0,customizeText:i,itemTextPosition:i,margin:10,equalColumnWidth:!1,markerSize:12,backgroundColor:i,backgroundOpacity:i,border:{visible:!1,width:1,color:"#d3d3d3",cornerRadius:0,dashStyle:"solid"},paddingLeftRight:20,paddingTopBottom:15,columnCount:0,rowCount:0,columnItemSpacing:20,rowItemSpacing:8},tooltip:{enabled:!1,border:{width:1,color:"#d3d3d3",dashStyle:"solid",visible:!0},font:{family:r,weight:400,size:12,color:"#232323"},color:"#ffffff",arrowLength:10,paddingLeftRight:18,paddingTopBottom:15,shared:!1,format:"",argumentFormat:"",precision:0,argumentPrecision:0,percentPrecision:0,customizeText:i,customizeTooltip:i,shadow:{opacity:.4,offsetX:0,offsetY:4,blur:2,color:"#000000"}},size:{width:i,height:i},loadingIndicator:{font:{},backgroundColor:"#ffffff",text:"Loading..."},dataPrepareSettings:{checkTypeForAllData:!1,convertToAxisDataType:!0,sortingMethod:!0},title:{font:{family:e,weight:200,color:"#232323",size:28},margin:10},adaptiveLayout:{width:80,height:80,keepLabels:!0},_rtl:{legend:{itemTextPosition:"left"}}},f={containerBackgroundColor:"#2b2b2b",commonSeriesSettings:{label:{border:{color:"#494949"}}},legend:{border:{color:"#494949"}},loadingIndicator:{backgroundColor:"#2b2b2b"},title:{font:{color:"#929292"}},tooltip:{color:"#2b2b2b",border:{color:"#494949"},font:{color:"#929292"}}};t.viz.themes.push({name:"desktop",font:{color:"#767676",family:r,weight:400,size:12,cursor:"default"},chart:n.extend(!0,{},u,{commonSeriesSettings:{type:"line",stack:"default",point:{visible:!0,symbol:"circle",size:12,border:{visible:!1,width:1},hoverMode:"onlyPoint",selectionMode:"onlyPoint",hoverStyle:{border:{visible:!0,width:4},size:12},selectionStyle:{border:{visible:!0,width:4},size:12}},scatter:{},line:{width:2,dashStyle:"solid",hoverStyle:{width:3,hatching:{direction:"none"}},selectionStyle:{width:3}},stackedline:{width:2,dashStyle:"solid",hoverStyle:{width:3,hatching:{direction:"none"}},selectionStyle:{width:3}},fullstackedline:{width:2,dashStyle:"solid",hoverStyle:{width:3,hatching:{direction:"none"}},selectionStyle:{width:3}},stepline:{width:2,dashStyle:"solid",hoverStyle:{width:3,hatching:{direction:"none"}},selectionStyle:{width:3}},area:{point:{visible:!1},opacity:.5},stackedarea:{point:{visible:!1},opacity:.5},fullstackedarea:{point:{visible:!1},opacity:.5},steparea:{border:{visible:!0,width:2},point:{visible:!1},hoverStyle:{border:{visible:!0,width:3}},selectionStyle:{border:{visible:!0,width:3}},opacity:.5},spline:{width:2,hoverStyle:{width:3,hatching:{direction:"none"}},selectionStyle:{width:3}},splinearea:{point:{visible:!1},opacity:.5},bar:{cornerRadius:0,point:{hoverStyle:{border:{visible:!1}},selectionStyle:{border:{visible:!1}}}},stackedbar:{cornerRadius:0,point:{hoverStyle:{border:{visible:!1}},selectionStyle:{border:{visible:!1}}},label:{position:"inside"}},fullstackedbar:{cornerRadius:0,point:{hoverStyle:{border:{visible:!1}},selectionStyle:{border:{visible:!1}}},label:{position:"inside"}},rangebar:{cornerRadius:0,point:{hoverStyle:{border:{visible:!1}},selectionStyle:{border:{visible:!1}}}},rangearea:{point:{visible:!1},opacity:.5},rangesplinearea:{point:{visible:!1},opacity:.5},bubble:{opacity:.5,point:{hoverStyle:{border:{visible:!1}},selectionStyle:{border:{visible:!1}}}},candlestick:{width:1,innerColor:"#ffffff",reduction:{color:"#ff0000"},hoverStyle:{width:3,hatching:{direction:"none"}},selectionStyle:{width:3},point:{border:{visible:!0}}},stock:{width:1,reduction:{color:"#ff0000"},hoverStyle:{width:3,hatching:{direction:"none"}},selectionStyle:{width:3},point:{border:{visible:!0}}}},crosshair:{enabled:!1,color:"#c6c6c6",width:1,dashStyle:"solid",verticalLine:{visible:!0},horizontalLine:{visible:!0}},commonAxisSettings:{tickInterval:i,setTicksAtUnitBeginning:!0,valueMarginsEnabled:!0,placeholderSize:null,logarithmBase:10,discreteAxisDivisionMode:"betweenLabels",visible:!1,color:"#d3d3d3",width:1,multipleAxesSpacing:5,label:{visible:!0,overlappingBehavior:{mode:"auto",rotationAngle:90,staggeringSpacing:5},precision:0,format:"",customizeText:i,indentFromAxis:10},grid:{visible:!1,color:"#d3d3d3",width:1},tick:{visible:!1,color:"#d3d3d3"},title:{font:{size:16},margin:10},stripStyle:{paddingLeftRight:10,paddingTopBottom:5},constantLineStyle:{paddingLeftRight:10,paddingTopBottom:10,width:1,color:"#000000",dashStyle:"solid",label:{visible:!0,position:"inside"}}},horizontalAxis:{isHorizontal:!0,position:"bottom",axisDivisionFactor:50,label:{alignment:"center"},stripStyle:{label:{horizontalAlignment:"center",verticalAlignment:"top"}},constantLineStyle:{label:{horizontalAlignment:"right",verticalAlignment:"top"}},constantLines:{}},verticalAxis:{isHorizontal:!1,position:"left",axisDivisionFactor:30,label:{alignment:"right",overlappingBehavior:{mode:"enlargeTickInterval"}},stripStyle:{label:{horizontalAlignment:"left",verticalAlignment:"center"}},constantLineStyle:{label:{horizontalAlignment:"left",verticalAlignment:"top"}},constantLines:{}},argumentAxis:{},valueAxis:{grid:{visible:!0}},commonPaneSettings:{backgroundColor:"none",border:{color:"#d3d3d3",width:1,visible:!1,top:!0,bottom:!0,left:!0,right:!0,dashStyle:"solid"}},useAggregation:!1,adjustOnZoom:!0,rotated:!1,synchronizeMultiAxes:!0,equalBarWidth:!0,minBubbleSize:12,maxBubbleSize:.2}),pie:n.extend(!0,{},u,{commonSeriesSettings:{type:"pie",pie:{border:{visible:!1,width:2,color:"#ffffff"},hoverStyle:{hatching:{direction:"right",width:4,step:10,opacity:.75},border:{visible:!1,width:2}},selectionStyle:{hatching:{direction:"right",width:4,step:10,opacity:.5},border:{visible:!1,width:2}}},doughnut:{innerRadius:.5,border:{visible:!1,width:2,color:"#ffffff"},hoverStyle:{hatching:{direction:"right",width:4,step:10,opacity:.75},border:{visible:!1,width:2}},selectionStyle:{hatching:{direction:"right",width:4,step:10,opacity:.5},border:{visible:!1,width:2}}},donut:{innerRadius:.5,border:{visible:!1,width:2,color:"#ffffff"},hoverStyle:{hatching:{direction:"right",width:4,step:10,opacity:.75},border:{visible:!1,width:2}},selectionStyle:{hatching:{direction:"right",width:4,step:10,opacity:.5},border:{visible:!1,width:2}}}},legend:{hoverMode:"markPoint"},adaptiveLayout:{keepLabels:!1}}),pieIE8:{commonSeriesSettings:{pie:{hoverStyle:{border:{visible:!0,color:"#ffffff"}},selectionStyle:{border:{visible:!0,color:"#ffffff"}}},donut:{hoverStyle:{border:{visible:!0,color:"#ffffff"}},selectionStyle:{border:{visible:!0,color:"#ffffff"}}},doughnut:{hoverStyle:{border:{visible:!0,color:"#ffffff"}},selectionStyle:{border:{visible:!0,color:"#ffffff"}}}}},gauge:{containerBackgroundColor:"#ffffff",scale:{majorTick:{visible:!0,length:5,width:2,showCalculatedTicks:!0,useTicksAutoArrangement:!0,color:"#ffffff"},minorTick:{visible:!1,length:3,width:1,showCalculatedTicks:!0,color:"#ffffff"},label:{visible:!0,font:{}}},rangeContainer:{offset:0,width:5,backgroundColor:"#808080"},valueIndicator:{_default:{color:"#c2c2c2"},rangebar:{space:2,size:10,color:"#cbc5cf",backgroundColor:"none",text:{indent:0,font:{size:14,color:null}}},twocolorneedle:{secondColor:"#e18e92"},twocolorrectangle:{secondColor:"#e18e92"}},subvalueIndicator:{_default:{color:"#8798a5"},trianglemarker:{space:2,length:14,width:13,color:"#8798a5"},triangle:{space:2,length:14,width:13,color:"#8798a5"},textcloud:{arrowLength:5,horizontalOffset:6,verticalOffset:3,color:"#679ec5",text:{font:{color:"#ffffff",size:18}}}},valueIndicators:{_default:{color:"#c2c2c2"},rangebar:{space:2,size:10,color:"#cbc5cf",backgroundColor:"none",text:{indent:0,font:{size:14,color:null}}},twocolorneedle:{secondColor:"#e18e92"},trianglemarker:{space:2,length:14,width:13,color:"#8798a5"},textcloud:{arrowLength:5,horizontalOffset:6,verticalOffset:3,color:"#679ec5",text:{font:{color:"#ffffff",size:18}}}},title:{layout:{horizontalAlignment:"center",verticalAlignment:"top",overlay:0},font:{size:16,color:"#232323",family:r,weight:400}},subtitle:{font:{size:14,color:"#232323",family:r,weight:400}},indicator:{hasPositiveMeaning:!0,layout:{horizontalAlignment:"center",verticalAlignment:"bottom",overlay:0},text:{font:{size:18}}},tooltip:{arrowLength:10,paddingLeftRight:18,paddingTopBottom:15,enabled:!1,border:{width:1,color:"#d3d3d3",dashStyle:"solid",visible:!0},color:"#ffffff",font:{color:"#232323",size:12,family:r,weight:400},shadow:{opacity:.4,offsetX:0,offsetY:4,blur:2,color:"#000000"}},loadingIndicator:{font:{},backgroundColor:"#ffffff",text:"Loading..."},_circular:{scale:{orientation:"outside",label:{indentFromTick:10}},rangeContainer:{orientation:"outside"},valueIndicator:{type:"rectangleneedle",_default:{offset:20,indentFromCenter:0,width:2,spindleSize:14,spindleGapSize:10},triangleneedle:{width:4},triangle:{width:4},twocolorneedle:{space:2,secondFraction:.4},twocolorrectangle:{space:2,secondFraction:.4},rangebar:{offset:30}},subvalueIndicator:{type:"trianglemarker",trianglemarker:{offset:6},triangle:{offset:6},textcloud:{offset:-6}},valueIndicators:{_type:"rectangleneedle",_default:{offset:20,indentFromCenter:0,width:2,spindleSize:14,spindleGapSize:10},triangleneedle:{width:4},twocolorneedle:{space:2,secondFraction:.4},rangebar:{offset:30},trianglemarker:{offset:6},textcloud:{offset:-6}}},_linear:{scale:{horizontalOrientation:"right",verticalOrientation:"bottom",label:{indentFromTick:-10}},rangeContainer:{horizontalOrientation:"right",verticalOrientation:"bottom"},valueIndicator:{type:"rangebar",_default:{offset:2.5,length:15,width:15},rectangle:{width:10},rangebar:{offset:10,horizontalOrientation:"right",verticalOrientation:"bottom"}},subvalueIndicator:{type:"trianglemarker",_default:{offset:-1,horizontalOrientation:"left",verticalOrientation:"top"}},valueIndicators:{_type:"rectangle",_default:{offset:2.5,length:15,width:15},rectangle:{width:10},rangebar:{offset:10,horizontalOrientation:"right",verticalOrientation:"bottom"},trianglemarker:{offset:-1,horizontalOrientation:"left",verticalOrientation:"top"},textcloud:{offset:-1,horizontalOrientation:"left",verticalOrientation:"top"}}}},barGauge:{backgroundColor:"#e0e0e0",relativeInnerRadius:.3,barSpacing:4,label:{indent:20,connectorWidth:2,font:{size:16}},title:{layout:{horizontalAlignment:"center",verticalAlignment:"top",overlay:0},font:{size:16,color:"#232323",family:r,weight:400}},subtitle:{font:{size:14,color:"#232323",family:r,weight:400}},indicator:{hasPositiveMeaning:!0,layout:{horizontalAlignment:"center",verticalAlignment:"bottom",overlay:0},text:{font:{size:18}}},tooltip:{arrowLength:10,paddingLeftRight:18,paddingTopBottom:15,enabled:!1,border:{width:1,color:"#d3d3d3",dashStyle:"solid",visible:!0},color:"#ffffff",font:{size:12,color:"#232323",family:r,weight:400},shadow:{opacity:.4,offsetX:0,offsetY:4,blur:2,color:"#000000"}},loadingIndicator:{font:{},backgroundColor:"#ffffff",text:"Loading..."}},rangeSelector:{containerBackgroundColor:"#ffffff",scale:{label:{topIndent:7,font:{size:11}},tick:{width:1,color:"#000000",opacity:.1},marker:{separatorHeight:33,topIndent:10,textLeftIndent:7,textTopIndent:11}},loadingIndicator:{font:{},backgroundColor:"#ffffff",text:"Loading..."},sliderMarker:{padding:7,pointerSize:6,color:"#9b9b9b",invalidRangeColor:"#ff0000",font:{color:"#ffffff",size:11}},sliderHandle:{width:1,color:"#000000",opacity:.2},shutter:{color:i,opacity:.75},background:{color:"#c0bae1"},chart:{containerBackgroundColor:i,commonSeriesSettings:{label:u.commonSeriesSettings.label,border:{visible:!1,width:1},visible:!0,type:"area",hoverMode:"none",hoverStyle:{border:{}},selectionStyle:{border:{}},point:{visible:!1,symbol:"circle",border:{visible:!1,width:1},size:12,hoverStyle:{border:{}},selectionStyle:{border:{}}},line:{width:2},stepline:{width:2},scatter:{point:{visible:!0}},stackedline:{width:2},fullstackedline:{width:2},area:{opacity:.5},stackedarea:{opacity:.5},fullstackedarea:{opacity:.5},spline:{width:2},splinearea:{opacity:.5},steparea:{border:{visible:!0,width:2},opacity:.5},bubble:{opacity:.5,point:{visible:!0}},bar:{cornerRadius:0,point:{visible:!0}},stackedbar:{cornerRadius:0,point:{visible:!0}},fullstackedbar:{cornerRadius:0,point:{visible:!0}},rangebar:{cornerRadius:0,point:{visible:!0}},rangearea:{opacity:.5},rangesplinearea:{opacity:.5},candlestick:{width:1,innerColor:"#ffffff",reduction:{color:"#ff0000"}},stock:{width:1,reduction:{color:"#ff0000"}}},dataPrepareSettings:{checkTypeForAllData:!1,convertToAxisDataType:!0,sortingMethod:!0},useAggregation:!1,equalBarWidth:!0,minBubbleSize:12,maxBubbleSize:.2,topIndent:.1,bottomIndent:0,valueAxis:{min:i,max:i,inverted:!1,logarithmBase:10}}},map:{background:{borderWidth:1,borderColor:"#cacaca",color:"#ffffff"},area:{borderWidth:1,borderColor:"#ffffff",color:"#d2d2d2",hoveredBorderColor:"#303030",selectedBorderWidth:2,selectedBorderColor:"#303030"},marker:{font:{color:"#2b2b2b",size:12},_dot:{borderWidth:2,borderColor:"#ffffff",color:"#ba4d51",size:8,selectedStep:2,backStep:18,backColor:"#ffffff",backOpacity:.32,shadow:!0},_bubble:{minSize:20,maxSize:50,color:"#ba4d51",hoveredBorderWidth:1,hoveredBorderColor:"#303030",selectedBorderWidth:2,selectedBorderColor:"#303030"},_pie:{size:50,hoveredBorderWidth:1,hoveredBorderColor:"#303030",selectedBorderWidth:2,selectedBorderColor:"#303030"},_image:{size:20}},controlBar:{borderColor:"#5d5d5d",borderWidth:3,color:"#ffffff"},tooltip:{borderWidth:1,borderColor:"#d7d7d7",arrowLength:10,paddingLeftRight:18,paddingTopBottom:15,border:{width:1,color:"#d3d3d3",dashStyle:"solid",visible:!0},color:"#ffffff",font:{color:"#232323",size:12,family:r,weight:400},shadow:{opacity:.4,offsetX:0,offsetY:4,blur:2,color:"#000000"}},legend:{verticalAlignment:"bottom",horizontalAlignment:"right",position:"inside",visible:!0,margin:10,equalColumnWidth:!1,markerSize:12,backgroundColor:"#ffffff",backgroundOpacity:.65,border:{visible:!0,width:1,color:"#cacaca",cornerRadius:0,dashStyle:"solid"},paddingLeftRight:16,paddingTopBottom:12,columnItemSpacing:20,rowItemSpacing:8,font:{color:"#2b2b2b",size:12}},loadingIndicator:{backgroundColor:"#ffffff",font:{},text:"Loading..."},_rtl:{legend:{itemTextPosition:"left"}}},sparkline:{lineColor:"#666666",lineWidth:2,areaOpacity:.2,minColor:"#e8c267",maxColor:"#e55253",barPositiveColor:"#a9a9a9",barNegativeColor:"#d7d7d7",winColor:"#a9a9a9",lossColor:"#d7d7d7",firstLastColor:"#666666",pointSymbol:"circle",pointColor:"#ffffff",pointSize:4,tooltip:{enabled:!0,allowContainerResizing:!0,verticalAlignment:"top",horizontalAlignment:"center",format:"",paddingLeftRight:18,paddingTopBottom:15,arrowLength:10,precision:0,color:"#ffffff",border:{width:1,color:"#d3d3d3",dashStyle:"solid",visible:!0},font:{color:"#232323",family:r,size:12,weight:400},shadow:{opacity:.4,offsetX:0,offsetY:4,blur:2,color:"#000000"}}},bullet:{color:"#e8c267",targetColor:"#666666",targetWidth:4,showTarget:!0,showZeroLevel:!0,tooltip:{enabled:!0,allowContainerResizing:!0,verticalAlignment:"top",horizontalAlignment:"center",format:"",precision:0,paddingLeftRight:18,paddingTopBottom:15,arrowLength:10,color:"#ffffff",border:{width:1,color:"#d3d3d3",dashStyle:"solid",visible:!0},font:{color:"#232323",family:r,size:12,weight:400},shadow:{opacity:.4,offsetX:0,offsetY:4,blur:2,color:"#000000"}}}}),t.viz.core.registerTheme({name:"desktop-dark",font:{color:"#808080"},chart:n.extend(!0,{},f,{commonSeriesSettings:{candlestick:{innerColor:"#2b2b2b"}},crosshair:{color:"#515151"},commonAxisSettings:{color:"#494949",grid:{color:"#494949"},tick:{color:"#494949"},constantLineStyle:{color:"#ffffff"}},commonPaneSettings:{border:{color:"#494949"}}}),pie:n.extend(!0,{},f),pieIE8:{commonSeriesSettings:{pie:{hoverStyle:{border:{color:"#2b2b2b"}},selectionStyle:{border:{color:"#2b2b2b"}}},donut:{hoverStyle:{border:{color:"#2b2b2b"}},selectionStyle:{border:{color:"#2b2b2b"}}},doughnut:{hoverStyle:{border:{color:"#2b2b2b"}},selectionStyle:{border:{color:"#2b2b2b"}}}}},gauge:{containerBackgroundColor:"#2b2b2b",scale:{majorTick:{color:"#303030"},minorTick:{color:"#303030"}},rangeContainer:{backgroundColor:"#b5b5b5"},valueIndicator:{_default:{color:"#b5b5b5"},rangebar:{color:"#84788b"},twocolorneedle:{secondColor:"#ba544d"},twocolorrectangle:{secondColor:"#ba544d"}},subvalueIndicator:{_default:{color:"#b7918f"}},valueIndicators:{_default:{color:"#b5b5b5"},rangebar:{color:"#84788b"},twocolorneedle:{secondColor:"#ba544d"},trianglemarker:{color:"#b7918f"},textcloud:{color:"#ba544d"}},title:{font:{color:"#929292"}},subtitle:{font:{color:"#929292"}},loadingIndicator:{backgroundColor:"#2b2b2b"},tooltip:{color:"#2b2b2b",border:{color:"#494949"},font:{color:"#929292"}}},barGauge:{title:{font:{color:"#929292"}},subtitle:{font:{color:"#929292"}},tooltip:{color:"#2b2b2b",border:{color:"#494949"},font:{color:"#929292"}},loadingIndicator:{backgroundColor:"#2b2b2b"}},rangeSelector:{containerBackgroundColor:"#2b2b2b",scale:{tick:{color:"#ffffff",opacity:.05}},loadingIndicator:{backgroundColor:"#2b2b2b"},sliderMarker:{color:"#b5b5b5",font:{color:"#303030"}},sliderHandle:{color:"#ffffff",opacity:.35},shutter:{color:"#2b2b2b",opacity:.9}},map:{background:{borderColor:"#3f3f3f",color:"#303030"},area:{borderColor:"#303030",color:"#686868",hoveredBorderColor:"#ffffff",selectedBorderColor:"#ffffff"},marker:{font:{color:"#ffffff"},_bubble:{hoveredBorderColor:"#ffffff",selectedBorderColor:"#ffffff"},_pie:{hoveredBorderColor:"#ffffff",selectedBorderColor:"#ffffff"}},controlBar:{borderColor:"#c7c7c7",color:"#303030"},legend:{border:{color:"#3f3f3f"},backgroundColor:"#303030",font:{color:"#ffffff"}},tooltip:{color:"#2b2b2b",border:{color:"#494949"},font:{color:"#929292"}},loadingIndicator:{backgroundColor:"#2b2b2b"}},sparkline:{lineColor:"#c7c7c7",firstLastColor:"#c7c7c7",barPositiveColor:"#b8b8b8",barNegativeColor:"#8e8e8e",winColor:"#b8b8b8",lossColor:"#8e8e8e",pointColor:"#303030",tooltip:{color:"#2b2b2b",border:{color:"#494949"},font:{color:"#929292"}}},bullet:{targetColor:"#8e8e8e",tooltip:{color:"#2b2b2b",border:{color:"#494949"},font:{color:"#929292"}}}},"desktop")}(jQuery,DevExpress),function(n,t){var r={containerBackgroundColor:"#050506",title:{font:{color:"#ffffff"}},commonSeriesSettings:{label:{border:{color:"#4c4c4c"}}},legend:{font:{color:"#ffffff",size:11},border:{color:"#4c4c4c"}},loadingIndicator:{backgroundColor:"#050506"},tooltip:{color:"#050506",border:{color:"#4c4c4c"},font:{color:"#ffffff"}}},u={containerBackgroundColor:"#e8e8e8",title:{font:{color:"#808080"}},legend:{font:{color:"#000000",size:11}},loadingIndicator:{backgroundColor:"#e8e8e8"},tooltip:{color:"#e8e8e8",font:{color:"#808080"}}};t.viz.core.registerTheme({name:"android",chart:n.extend(!0,{},r,{commonSeriesSettings:{candlestick:{innerColor:"#050506"}},commonAxisSettings:{color:"#4c4c4c",grid:{color:"#4c4c4c"},tick:{color:"#4c4c4c"},title:{font:{color:"#545455"}},label:{font:{color:"#ffffff",size:11}}},commonPaneSettings:{border:{color:"#4c4c4c"}}}),pie:n.extend(!0,{},r),pieIE8:{commonSeriesSettings:{pie:{hoverStyle:{border:{color:"#050506"}},selectionStyle:{border:{color:"#050506"}}},donut:{hoverStyle:{border:{color:"#050506"}},selectionStyle:{border:{color:"#050506"}}},doughnut:{hoverStyle:{border:{color:"#050506"}},selectionStyle:{border:{color:"#050506"}}}}},gauge:{containerBackgroundColor:"#050506",title:{font:{color:"#ffffff"}},subtitle:{font:{color:"#ffffff"}},loadingIndicator:{backgroundColor:"#050506"},tooltip:{color:"#050506",border:{color:"#4c4c4c"},font:{color:"#ffffff"}}},barGauge:{title:{font:{color:"#ffffff"}},subtitle:{font:{color:"#ffffff"}},tooltip:{color:"#050506",border:{color:"#4c4c4c"},font:{color:"#ffffff"}},loadingIndicator:{backgroundColor:"#050506"}},rangeSelector:{containerBackgroundColor:"#050506",loadingIndicator:{backgroundColor:"#050506"}},map:{loadingIndicator:{backgroundColor:"#050506"},tooltip:{color:"#050506",border:{color:"#4c4c4c"},font:{color:"#ffffff"}}},sparkline:{tooltip:{color:"#050506",border:{color:"#4c4c4c"},font:{color:"#ffffff"}}},bullet:{tooltip:{color:"#050506",border:{color:"#4c4c4c"},font:{color:"#ffffff"}}}},"desktop-dark"),t.viz.core.registerTheme({name:"android-holo-light",chart:n.extend(!0,{},u,{commonSeriesSettings:{candlestick:{innerColor:"#e8e8e8"}},commonAxisSettings:{title:{font:{color:"#939393"}},label:{font:{color:"#404040",size:11}}}}),pie:n.extend(!0,{},u),pieIE8:{commonSeriesSettings:{pie:{hoverStyle:{border:{color:"#e8e8e8"}},selectionStyle:{border:{color:"#e8e8e8"}}},donut:{hoverStyle:{border:{color:"#e8e8e8"}},selectionStyle:{border:{color:"#e8e8e8"}}},doughnut:{hoverStyle:{border:{color:"#e8e8e8"}},selectionStyle:{border:{color:"#e8e8e8"}}}}},gauge:{containerBackgroundColor:"#e8e8e8",title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},loadingIndicator:{backgroundColor:"#e8e8e8"},tooltip:{color:"#e8e8e8",font:{color:"#808080"}}},barGauge:{title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},tooltip:{color:"#e8e8e8",font:{color:"#808080"}},loadingIndicator:{backgroundColor:"#e8e8e8"}},rangeSelector:{containerBackgroundColor:"#e8e8e8",loadingIndicator:{backgroundColor:"#e8e8e8"}},map:{loadingIndicator:{backgroundColor:"#e8e8e8"},tooltip:{color:"#e8e8e8",font:{color:"#808080"}}},sparkline:{tooltip:{color:"#e8e8e8",font:{color:"#808080"}}},bullet:{tooltip:{color:"#e8e8e8",font:{color:"#808080"}}}},"desktop")}(jQuery,DevExpress),function(n,t){var r={containerBackgroundColor:"#cbd0da",title:{font:{color:"#808080"}},commonSeriesSettings:{label:{border:{color:"#b0b3ba"}}},legend:{font:{color:"#000000",size:11},border:{color:"#b0b3ba"}},loadingIndicator:{backgroundColor:"#cbd0da"},tooltip:{font:{color:"#808080"}}},u={containerBackgroundColor:"#ffffff",title:{font:{color:"#808080"}},commonSeriesSettings:{label:{border:{color:"#d3d3d3"}}},legend:{font:{color:"#000000",size:11},border:{color:"#d3d3d3"}},loadingIndicator:{backgroundColor:"#ffffff"},tooltip:{font:{color:"#808080"}}};t.viz.core.registerTheme({name:"ios",chart:n.extend(!0,{},r,{commonSeriesSettings:{candlestick:{innerColor:"#cbd0da"}},commonAxisSettings:{color:"#b0b3ba",grid:{color:"#b0b3ba"},tick:{color:"#b0b3ba"},title:{font:{color:"#939393"}},label:{font:{color:"#000000",size:11}}},commonPaneSettings:{border:{color:"#b0b3ba"}}}),pie:n.extend(!0,{},r),pieIE8:{commonSeriesSettings:{pie:{hoverStyle:{border:{color:"#cbd0da"}},selectionStyle:{border:{color:"#cbd0da"}}},donut:{hoverStyle:{border:{color:"#cbd0da"}},selectionStyle:{border:{color:"#cbd0da"}}},doughnut:{hoverStyle:{border:{color:"#cbd0da"}},selectionStyle:{border:{color:"#cbd0da"}}}}},gauge:{title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},tooltip:{font:{color:"#808080"}}},barGauge:{title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},tooltip:{font:{color:"#808080"}}},map:{tooltip:{font:{color:"#808080"}}},sparkline:{tooltip:{font:{color:"#808080"}}},bullet:{tooltip:{font:{color:"#808080"}}}},"desktop"),t.viz.core.registerTheme({name:"ios:7",chart:n.extend(!0,{},u,{commonAxisSettings:{color:"#d3d3d3",grid:{color:"#d3d3d3"},tick:{color:"#d3d3d3"},title:{font:{color:"#939393"}},label:{font:{color:"#000000",size:11}}},commonPaneSettings:{border:{color:"#d3d3d3"}}}),pie:n.extend(!0,{},u),gauge:{title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},tooltip:{font:{color:"#808080"}}},barGauge:{title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},tooltip:{font:{color:"#808080"}}},map:{tooltip:{font:{color:"#808080"}}},sparkline:{tooltip:{font:{color:"#808080"}}},bullet:{tooltip:{font:{color:"#808080"}}}},"desktop")}(jQuery,DevExpress),function(n,t){var i={containerBackgroundColor:"#000000",title:{font:{color:"#ffffff"}},commonSeriesSettings:{label:{border:{color:"#454545"}}},legend:{font:{color:"#ffffff",size:11},border:{color:"#454545"}},loadingIndicator:{backgroundColor:"#000000"},tooltip:{color:"#000000",font:{color:"#ffffff"}}},r={title:{font:{color:"#808080"}},legend:{font:{color:"#000000",size:11}},tooltip:{font:{color:"#808080"}}};t.viz.core.registerTheme({name:"win8",chart:n.extend(!0,{},i,{commonSeriesSettings:{candlestick:{innerColor:"#000000"}},commonAxisSettings:{color:"#454545",grid:{color:"#454545"},tick:{color:"#454545"},title:{font:{color:"#535353"}},label:{font:{color:"#ffffff",size:11}}},commonPaneSettings:{border:{color:"#454545"}}}),pie:n.extend(!0,{},i),pieIE8:{commonSeriesSettings:{pie:{hoverStyle:{border:{color:"#000000"}},selectionStyle:{border:{color:"#000000"}}},donut:{hoverStyle:{border:{color:"#000000"}},selectionStyle:{border:{color:"#000000"}}},doughnut:{hoverStyle:{border:{color:"#000000"}},selectionStyle:{border:{color:"#000000"}}}}},gauge:{containerBackgroundColor:"#000000",title:{font:{color:"#ffffff"}},subtitle:{font:{color:"#ffffff"}},loadingIndicator:{backgroundColor:"#000000"},tooltip:{color:"#000000",font:{color:"#ffffff"}}},barGauge:{title:{font:{color:"#ffffff"}},subtitle:{font:{color:"#ffffff"}},tooltip:{color:"#000000",font:{color:"#ffffff"}},loadingIndicator:{backgroundColor:"#000000"}},rangeSelector:{containerBackgroundColor:"#000000",loadingIndicator:{backgroundColor:"#000000"}},map:{loadingIndicator:{backgroundColor:"#000000"},tooltip:{color:"#000000",font:{color:"#ffffff"}}},sparkline:{tooltip:{color:"#000000",font:{color:"#ffffff"}}},bullet:{tooltip:{color:"#000000",font:{color:"#ffffff"}}}},"desktop-dark"),t.viz.core.registerTheme({name:"win8-white",chart:n.extend(!0,{},r,{commonAxisSettings:{title:{font:{color:"#939393"}},label:{font:{color:"#404040",size:11}}}}),pie:n.extend(!0,{},r),gauge:{title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},tooltip:{font:{color:"#808080"}}},barGauge:{title:{font:{color:"#808080"}},subtitle:{font:{color:"#808080"}},tooltip:{font:{color:"#808080"}}},map:{tooltip:{font:{color:"#808080"}}},sparkline:{tooltip:{font:{color:"#808080"}}},bullet:{tooltip:{font:{color:"#808080"}}}},"desktop")}(jQuery,DevExpress),function(n,t){t.viz.core.registerTheme({name:"generic"},"desktop"),t.viz.core.registerTheme({name:"generic-dark"},"desktop-dark"),t.viz.core.registerTheme({name:"tizen"},"desktop"),t.viz.core.registerTheme({name:"tizen-black"},"desktop-dark")}(jQuery,DevExpress),function(n){n.viz.renderers={}}(DevExpress),function(n,t){function o(n){return c.createElementNS("http://www.w3.org/2000/svg",n)}function l(n,t){return n!==null?"url("+(t?window.location.href:"")+"#"+n+")":null}function f(t,i){n.each(i,function(n,i){t.setAttribute(n,i)})}function ht(n){for(var i=0,r=n.length,t=[];i<r;)t.push("L",n[i++].toFixed(2),n[i++].toFixed(2));return r?(t[0]="M",t.push("Z"),t=t.join(" ")):t="",t}function ct(n,t,i,r){var u=i+~~r&1;return{cx:u?n+.5:n,cy:u?t+.5:t,r:i/2}}var s=t.viz.renderers,i=t.utils,v=t.Class,c=document,u=1e10,r=v.inherit({ctor:function(t,i,r){this.renderer=t,this.element=this.createElement(i),this.$element=n(this.element),this.applySettings(n.extend({},this.defaultSettings(),r))},defaultSettings:n.noop,createElement:function(n){return this._nodeName=n,o(n)},dispose:function(){this.off(),this.remove(),this.renderer=null,this.element=null,this.settings=null,this.$element=null,this.transformation=null},append:function(n){var t=n||this.renderer.getRoot();return t.element.appendChild(this.element),this},insertBefore:function(n){return n.element.parentNode.insertBefore(this.element,n.element),this},toBackground:function(){return this.element.parentNode&&this.element.parentNode.insertBefore(this.element,this.element.parentNode.firstChild),this},toForeground:function(){return this.element.parentNode&&this.element.parentNode.appendChild(this.element),this},addClass:function(t){var i=this.$element.attr("class"),r,u;return t&&(i?(u=i.split(" "),r=n.inArray(t,u),r===-1&&(i+=" "+t)):i=t,this.$element.attr("class",i)),this.$element},removeClass:function(t){var f=this.$element.attr("class"),r,u,e="",i;if(f&&t&&(r=f.split(" "),u=n.inArray(t,r),u!==-1)){for(i=0;i<r.length;i++)i!==u&&(e+=r[i]+" ");this.$element.attr("class",e.replace(/ $/,""))}return this.$element},applySettings:function(t){var i;return this.settings=n.extend(this.settings||{},t||{}),this.adjustSettings(),i=this._normalizeSettings(this.settings),this.applyStyle(this._style),this._applyAttributes(i),this},_applyAttributes:function(n){this.$element.attr(n)},adjustSettings:function(){},applyStyle:function(n){return this.$element.css(n||{}),this},trigger:function(n,t){this.$element.trigger(n,t)},on:function(){return this.$element.on.apply(this.$element,arguments),this},data:function(n,t){return this.$element.data(n,t),this},removeData:function(){return this.$element.removeData(),this},off:function(n){return this.$element.off(n),this},getBBox:function(){function t(t){var i={};try{if(n.isFunction(t.getBBox))i=t.getBBox();else throw{};}catch(r){i={x:0,y:0,width:t.offsetWidth||0,height:t.offsetHeight||0}}return i}var h=this,t,it=this.element,s=h.transformation,c=s.rotateAngle||0,f=s.rotateX||0,e=s.rotateY||0,o=Math.abs,l=Math.min;if(t=n.extend({},t(it)),c){var a=i.getCosAndSin(c),r=a.sin.toFixed(3),u=a.cos.toFixed(3),v=t.x-f,y=t.y-e,p=t.x+t.width-f,w=t.y-e,b=t.x-f,k=t.y+t.height-e,d=t.x+t.width-f,g=t.y+t.height-e,nt,tt;nt=o(t.height*r)+o(t.width*u),tt=o(t.height*u)+o(t.width*r),t.x=l(v*u-y*r+f,p*u-w*r+f,b*u-k*r+f,d*u-g*r+f),t.y=l(v*r+y*u+e,p*r+w*u+e,b*r+k*u+e,d*r+g*u+e),t.width=nt,t.height=tt}return h._normalizeBBox(t)},_normalizeBBox:function(t){var s=Math.ceil,h=Math.floor,o=n.isNumeric,i=h(t.x),r=h(t.y),c=s(t.width+t.x),l=s(t.height+t.y),f,e;return t.x=o(i)&&i<u&&i>-u?i:0,t.y=o(r)&&r<u&&r>-u?r:0,f=c-i,e=l-r,t.width=o(f)&&f<u&&f>-u?f:0,t.height=o(e)&&e<u&&e>-u?e:0,t.isEmpty=!t.x&&!t.y&&!t.width&&!t.height,t},clear:function(n){return n?this.$element.find(n).remove():this.$element.empty(),this},detach:function(){return this.$element.detach(),this},animate:function(t,r,u){r=r||{};var e=this,f={};u&&n.extend(r,{complete:u}),this.renderer.animOptions.enabled?(n.each(t,function(n,t){switch(n){case"scale":f.transform=f.transform||{};var r=e.transformation.scale||{};f.transform.scale={x:{from:i.isDefined(r.x)?r.x:1,to:i.isDefined(t.x)?t.x:1},y:{from:i.isDefined(r.y)?r.y:1,to:i.isDefined(t.y)?t.y:1}};break;case"rotate":f.transform=f.transform||{},f.transform.rotate={angle:{from:e.transformation.rotateAngle||0,to:t.angle},y:t.y||0,x:t.x||0};break;case"translate":f.transform=f.transform||{},f.transform.translate={x:{from:e.transformation.translateX||0,to:t.x||0},y:{from:e.transformation.translateY||0,to:t.y||0}};break;case"arc":case"points":f[n]=t;break;default:f[n]={from:e.settings[n]||0,to:t}}}),e.renderer.animateElement(e,f,n.extend({},this.renderer.animOptions,r))):(t.translate&&("x"in t.translate&&(t.translateX=t.translate.x),"y"in t.translate&&(t.translateY=t.translate.y),delete t.translate),r&&(r.step&&r.step.call(e,1,1),r.complete&&r.complete.call(e)),this.applySettings(t))},stopAnimation:function(n){var t=this;return t.animation&&t.animation.stop(!0,n),t},move:function(n,t,i,r){return n=n||0,t=t||0,r=r||{},i?this.animate({translate:{x:n,y:t}},r):this.applySettings({translateX:n,translateY:t}),this},rotate:function(n,t,i,r,u){n=n||0,t=t||0,i=i||0,u=u||{},r?this.animate({rotate:{angle:n,x:t,y:i}},u):this.applySettings({rotate:[n,t,i]})},remove:function(){this.$element.remove()},_normalizeSettings:function(i){var o,s,e,f,r,u,h={},a,c=this.renderer.rtl;for(o in i){if(r=o,u=i[r],r==="align")r="text-anchor",u={left:c?"end":"start",center:"middle",right:c?"start":"end"}[u];else if(r==="font"){if(s=this._style=this._style||{},!n.isPlainObject(u))continue;n.each(u,function(n){switch(n){case"color":f="fill";break;case"opacity":f="fillOpacity";break;case"cursor":f=n;break;default:e=n.charAt(0),f="font"+n.replace(e,e.toUpperCase())}s[f]=u[n]});continue}else if(r==="dashStyle")r="stroke-dasharray",u=u.toLowerCase(),u==="solid"||u==="none"?u=null:(u=u.replace(/longdash/g,"8,3,").replace(/dash/g,"4,3,").replace(/dot/g,"1,3,").replace(/,$/,"").split(","),u=n.map(u,function(n){return+n*(i.strokeWidth||1)}).join(","));else if(/^(linecap|linejoin)$/i.test(r))r="stroke-"+r;else if(/^(translateX|translateY|rotate|scale)$/i.test(r)){this["_"+r]=u;continue}else if(r==="clipId")r="clip-path",u=l(u,this.renderer.pathModified);else if(r==="style"){this._style=this._style||{},n.extend(!0,this._style,u);continue}else if(r==="sharpEdges")continue;else if(r==="text")continue;else if(r==="segments")continue;else r=t.inflector.dasherize(r);h[r]=u}return this._applyTransformation(h)},_applyTransformation:function(t){var o,s,h;this.transformation={translateX:this._translateX,translateY:this._translateY,rotateAngle:0,rotateX:0,rotateY:0};var r=this.transformation,u=this._rotate,f=this._scale,e=[];return(i.isDefined(r.translateX)||i.isDefined(r.translateY))&&e.push("translate("+(r.translateX||0)+","+(r.translateY||0)+")"),i.isDefined(u)&&(i.isNumber(u)?(r.rotateAngle=u,r.rotateX=t.x||0,r.rotateY=t.y||0):n.isArray(u)?(r.rotateAngle=u[0]||0,r.rotateX=u[1]||0,r.rotateY=u[2]||0):i.isObject(u)&&(r.rotateAngle=u.angle||0,r.rotateX=u.x||0,r.rotateY=u.y||0),e.push("rotate("+r.rotateAngle+","+r.rotateX+","+r.rotateY+")")),i.isNumber(f)?(o=i.isDefined(f)?f:1,e.push("scale("+o+","+o+")"),r.scale={x:o,y:o}):i.isObject(f)&&(s=i.isDefined(f.x)?f.x:1,h=i.isDefined(f.y)?f.y:1,e.push("scale("+s+","+h+")"),r.scale={x:s,y:h}),e.length&&(t.transform=e.join(" ")),t}}),y=r.inherit({defaultSettings:function(){return{width:0,height:0,style:{"-webkit-tap-highlight-color":"rgba(0, 0, 0, 0)",display:"block",overflow:"hidden"},xmlns:"http://www.w3.org/2000/svg","xmlns:xlink":"http://www.w3.org/1999/xlink",version:"1.1",stroke:"none",strokeWidth:0,fill:"none"}},ctor:function(n,t){this.callBase(n,"svg",t)}}),h={defaultSettings:function(){return{x:0,y:0,width:0,height:0}},adjustSettings:function(){(!i.isDefined(this.settings.sharpEdges)||this.settings.sharpEdges)&&(this.sharpEdges(),delete this.settings.sharpEdges)},prepareSettings:function(n){var f=this.settings?Number(this.settings.strokeWidth)||0:0,t,u,r=!1;i.isDefined(n.width)&&(this._realWidth=Number(n.width)),i.isDefined(n.height)&&(this._realHeight=Number(n.height)),i.isDefined(n.x)&&(this._realX=Number(n.x)),i.isDefined(n.y)&&(this._realY=Number(n.y)),i.isDefined(n.strokeWidth)&&(this._realStrokeWidth=Number(n.strokeWidth)),this._realStrokeWidth=this._realStrokeWidth||this.defaultSettings().strokeWidth||0,u=~~((this._realWidth<this._realHeight?this._realWidth:this._realHeight)/2),t=this._realStrokeWidth<u?this._realStrokeWidth:u,t!==f&&(r=!0,n.sharpEdges=!0,t>0&&(n.strokeWidth=t)),(i.isDefined(n.x)||r)&&(n.x=this._realX+t/2),(i.isDefined(n.y)||r)&&(n.y=this._realY+t/2),(i.isDefined(n.width)||r)&&(n.width=this._realWidth-t),(i.isDefined(n.height)||r)&&(n.height=this._realHeight-t)},applySettings:function(t){var t=n.extend(!0,{},t);return this.prepareSettings(t),this.callBase(t)},sharpEdges:function(){var t=Math.round(this.settings.strokeWidth||0),n=t%2/2;this.settings.x=Math.floor(this.settings.x-n||0)+n,this.settings.y=Math.floor(this.settings.y-n||0)+n,this.settings.width=Math.floor(this.settings.width||0),this.settings.height=Math.floor(this.settings.height||0),this.settings.strokeWidth>0&&(this.settings.strokeWidth=t)}},p=r.inherit(h).inherit({ctor:function(n,t,r,u){var f={full:"none",lefttop:"xMinYMin",leftcenter:"xMinYMid",leftbottom:"xMinYMax",centertop:"xMidYMin",center:"xMidYMid",centerbottom:"xMidYMax",righttop:"xMaxYMin",rightcenter:"xMaxYMid",rightbottom:"xMaxYMax"};this.href=i.isDefined(r)?r:"",this.preserveAspectRatio=f[(u||"").toLowerCase()],this.preserveAspectRatio=this.preserveAspectRatio||"none",this.callBase(n,"image",t)},adjustSettings:function(){this.callBase(),this.element.setAttributeNS("http://www.w3.org/1999/xlink","href",this.href),this.preserveAspectRatio&&this.element.setAttribute("preserveAspectRatio",this.preserveAspectRatio)}}),w=r.inherit(h).inherit({defaultSettings:function(){return{x:0,y:0,width:0,height:0,rx:0,ry:0}},ctor:function(n,t){this.callBase(n,"rect",t)}}),e=r.inherit({defaultSettings:function(){return{points:{x:0,y:0}}},getNodeName:function(){return"path"},getPathAttributeName:function(){return"d"},ctor:function(n,t){this.callBase(n,this.getNodeName(),t)},dispose:function(){this.segments=null,this.fromSegments=null,this.callBase()},adjustSettings:function(){this.prepareSegments(this.settings)},applySettings:function(n){var n=n||{};return this.settings&&n.strokeWidth&&this.settings.strokeWidth!==n.strokeWidth&&(n.sharpEdges=!0),this.callBase(n)},prepareSegments:function(t){if("points"in t){var u=t.points,e=u[0],o=this.closePath||t.closePath,f=[],r;if(i.isObject(e))f=n.map(u,function(n,t){return n?t?[["L",n.x,n.y]]:[["M",n.x,n.y]]:null});else if(i.isNumber(e))for(r=0;r<u.length;r+=2){if(!r){f=[["M",u[r]||0,u[r+1]||0]];continue}f.push(["L",u[r]||0,u[r+1]||0])}else f=[["M",0,0]];o&&f.push(["Z"]),this.segments=f,delete t.points,delete t.closePath,t.sharpEdges=!0}t.sharpEdges&&(this.sharpEdges(),this.combinePathParams(t),delete t.sharpEdges)},customizeSegments:function(n){return n},combinePathParams:function(t){var i;this.segments=this.customizeSegments(this.segments),this.segments&&(i=n.map(this.segments,function(n){return n.join(" ")}),i=i.join(" "),t[this.getPathAttributeName()]=i)},_prepareDifferrentPath:function(n,t){var i={},r;return t.length>n.length?this._makeEqualPath(n,t):(this.combinePathParams(i),this._makeEqualPath(t,n)),i.d},_prepareConstSegment:function(n){n[0]="L"},_makeEqualPath:function(n,t){var r=n[n.length-1].slice(),i;for(this._prepareConstSegment(r),i=n.length;i<t.length;i++)n[i]=r},animate:function(n,t,i){var r=this,u,f;if(!("points"in n)||!r.renderer.animOptions.enabled)return r.callBase(n,t,i);u=r.segments,r.prepareSegments(n),delete n.d,u.length===r.segments.length?n.points={from:u,to:r.segments}:f=r._prepareDifferrentPath(u,r.segments),n.points={from:u,to:r.segments,end:f},r.callBase(n,t,i)},sharpEdges:function(){var o=this,v=o.segments.length,i=0,n,t,s,h,l,a,r,u,f,e,y=Math.round(o.settings.strokeWidth||0),c=y%2/2;for(i;i<v-1;i++){n=o.segments[i],t=o.segments[i+1],t[0]==="Z"&&i&&(t=o.segments[0]);switch(n[0]){case"M":case"L":r=1,u=2;break;case"C":r=5,u=6;break;case"A":r=6,u=7;break;case"Z":continue}switch(t[0]){case"M":case"L":f=1,e=2;break;case"C":f=5,e=6;break;case"A":f=6,e=7;break;case"Z":continue}s=Math.floor(n[r]),h=Math.floor(n[u]),l=t[f]=Math.floor(t[f]),a=t[e]=Math.floor(t[e]),n[r]=i==0?s:n[r],n[u]=i==0?h:n[u],s==l&&(n[r]=s+c,t[f]=l+c),h==a&&(n[u]=h+c,t[e]=a+c)}}}),b=e.inherit(h).inherit({defaultSettings:function(){return n.extend(!0,{},this.callBase(),{segments:{top:!0,bottom:!0,left:!0,right:!0}})},prepareSegments:function(){var h=this,t=h.settings,i=t.x,u=i+t.width,r=t.y,f=r+t.height,e=[],o,s=0,c=0,l={top:[["M",i,r],["L",u,r]],right:[["M",u,r],["L",u,f]],bottom:[["M",u,f],["L",i,f]],left:[["M",i,f],["L",i,r]]};n.each(l,function(n){var i=!!h.settings.segments[n];s=s*2+~~i});switch(s){case 13:case 9:o=["left","top","right","bottom"];break;case 11:o=["bottom","left","top","right"];break;default:o=["top","right","bottom","left"]}n.each(o,function(t,i){var r=!!h.settings.segments[i];r&&n.each(l[i].slice(c),function(n,t){e.push(t)}),c=~~r}),s==15&&e.push(["Z"]),this.segments=e.length?e:[["M",0,0],["Z"]],this.combinePathParams(t)},adjustSettings:function(){this.callBase(),this.prepareSegments()},applySettings:function(t){var i=this.settings&&this.settings.segments||this.defaultSettings().segments;return t.segments=n.extend(!0,{},i||{},t.segments),this.callBase(t)}}),k={defaultSettings:function(){return{points:{x:0,y:0}}},ctor:function(n,t){this.closePath=!0,this.callBase(n,t)},_tailIndex:0,_makeEqualPath:function(n,t){var i,u,r,f,o,s=[],e;if((n.length-1)%2==0&&(t.length-1)%2==0){for(i=(n.length-1)/2-1,u=n.slice(i+1),r=n.slice(0,i+1),f=r[r.length-1],o=u[this._tailIndex],this._prepareConstSegment(f),e=i;e<(t.length-1)/2-1;e++)r.push(f),s.push(o);for(r=this._concatAnimationSegment(r,s,u),i=0;i<r.length;i++)n[i]=r[i]}},_concatAnimationSegment:function(n,t,i){return n.concat(t,i)}},d=e.inherit(k),a=e.inherit({defaultSettings:function(){return{points:{x:0,y:0}}},_prepareConstSegment:function(n){var t=n[n.length-2],i=n[n.length-1];n[0]="C",n[5]=n[3]=n[1]=t,n[6]=n[4]=n[2]=i},prepareSegments:function(n){if("points"in n){var o=n.points,s=o[0],h=this.closePath||n.closePath,u=[],t=[],r,f,e,c=0;if(i.isObject(s)){for(r=0;r<o.length;r++){if(f=o[r].x,e=o[r].y,!r){u=[["M",f,e]];continue}if((r-1)%3==0){t.length>0&&u.push(t),t=["C",f,e];continue}t.push(f),t.push(e)}t.length>0&&u.push(t)}else if(i.isNumber(s)){for(r=0;r<o.length;r+=2){if(f=o[r],e=o[r+1],!r){u=[["M",f,e||0]];continue}if((r-2)%6==0){t.length>0&&u.push(t),t=["C",f,e||0];continue}t.push(f),t.push(e||0)}t.length>0&&u.push(t)}else u=[["M",0,0]];h&&u.push(["Z"]),this.segments=u,delete n.points,delete n.closePath,this.combinePathParams(n)}}}),g=a.inherit(k).inherit({_concatAnimationSegment:function(n,t,i){var r=i.splice(0,1);return n.concat(r.concat(t),i)},_tailIndex:1}),nt=e.inherit({defaultSettings:function(){return{x:0,y:0,linejoin:"round"}},createArcSegments:function(n,t,i,r,u,f,e){var o=Math.floor(Math.abs(f-u)/Math.PI)%2?"1":"0",s=n+r*Math.cos(u),h=t-r*Math.sin(u),c=n+r*Math.cos(f),l=t-r*Math.sin(f),a=n+i*Math.cos(f),v=t-i*Math.sin(f),y=n+i*Math.cos(u),p=t-i*Math.sin(u);return[["M",s,h],["A",r,r,0,o,0,c,l],[e?"M":"L",a,v],["A",i,i,0,o,1,y,p],["Z"]]},prepareSegments:function(n){var o;if("x"in n||"y"in n||"outerRadius"in n||"innerRadius"in n||"startAngle"in n||"endAngle"in n){var s=i.isNumber(n.x)?Number(n.x):0,h=i.isNumber(n.y)?Number(n.y):0,u=i.isNumber(n.outerRadius)?Number(n.outerRadius):0,f=i.isNumber(n.innerRadius)?Number(n.innerRadius):0,t=i.isNumber(n.startAngle)?Number(n.startAngle):0,r=i.isNumber(n.endAngle)?Number(n.endAngle):360,e;this.segments=[["M",0,0],["Z"]],(u||f)&&(o=Math.min(u,f),u=Math.max(u,f),f=o,Math.round(t)!=Math.round(r)&&(Math.abs(r-t)%360==0&&(t=0,r=360,e=!0,r-=.0001),t>360&&(t=t%360),r>360&&(r=r%360),t>r&&(t-=360),t=t*Math.PI/180,r=r*Math.PI/180,this.segments=this.createArcSegments(s,h,f,u,t,r,e))),this.x=n.x,this.y=n.y,this.outerRadius=n.outerRadius,this.innerRadius=n.innerRadius,this.startAngle=n.startAngle,this.endAngle=n.endAngle,delete n.x,delete n.y,delete n.outerRadius,delete n.innerRadius,delete n.startAngle,delete n.endAngle,this.combinePathParams(n)}},animate:function(n){var i=this,t;"x"in n&&"y"in n&&"outerRadius"in n&&"innerRadius"in n&&"startAngle"in n&&"endAngle"in n&&this.renderer.animOptions.enabled&&(t=this.settings,n.arc={from:{x:this.x,y:this.y,outerRadius:this.outerRadius,innerRadius:this.innerRadius,startAngle:this.startAngle,endAngle:this.endAngle},to:{x:n.x,y:n.y,outerRadius:n.outerRadius,innerRadius:n.innerRadius,startAngle:n.startAngle,endAngle:n.endAngle}},delete n.d,delete n.x,delete n.y,delete n.outerRadius,delete n.innerRadius,delete n.startAngle,delete n.endAngle),this.callBase.apply(this,arguments)}}),tt=r.inherit({defaultSettings:function(){return{cx:0,cy:0,r:0}},ctor:function(n,t){this.callBase(n,"circle",t)}}),it=r.inherit({defaultSettings:function(){return{x:0,y:0}},ctor:function(n,t){this.tspans=[],this.callBase(n,"text",t)},dispose:function(){this.tspans=null,this.callBase()},updateText:function(n){i.isDefined(n)||(n=""),this.applySettings({text:n})},adjustSettings:function(){if(!("text"in this.settings)){this.changeX();return}this._createElementWithText(this.settings.text)},changeX:function(){for(var n=0;n<this.tspans.length;n++)this.tspans[n].settings.x!=undefined&&this.tspans[n].applySettings({x:this.settings.x})},_createElementWithText:function(n){var t,i;this.clear(),n=n.toString().replace(/\r/g,""),n=n.replace(/\n/g,"<br/>"),t=c.createElement("div"),t.innerHTML=n,t.params={style:{}},this._orderText(t)},clear:function(){this.callBase(),this.tspans=[]},_orderText:function(n){var i=[],f=(this.settings.font?this.settings.font.size:12)||12,u=function(n,t,i){var r={style:{}},i=i||[],f,o,e;if(t.params=t.params||{},t.parentNode&&t.nodeName!="#text"&&t.parentNode.params)for(f in t.parentNode.params)t.params[f]=t.parentNode.params[f];switch(t.tagName){case"B":t.params.fontWeight="bold";break;case"I":t.params.fontStyle="italic";break;case"U":t.params.textDecoration="underline";break;case"BR":n++}for(t.style&&(t.style.fontSize&&(t.params.fontSize=(parseInt(t.style.fontSize)||t.params.fontSize)+"px"),t.params.fill=t.style.color||t.params.fill,t.params.fontStyle=t.style.fontStyle||t.params.fontStyle,t.params.fontWeight=t.style.fontWeight||t.params.fontWeight,t.params.textDecoration=t.style.textDecoration||t.params.textDecoration),o=t.childNodes.length,e=0;e!=o;)n=u(n,t.childNodes[e++],i);return t.wholeText!=undefined&&(r.fill=t.parentNode.params.fill,r.text=t.wholeText,t.parentNode.params.fontSize&&(r.style.fontSize=t.parentNode.params.fontSize),t.parentNode.params.fontStyle&&(r.style.fontStyle=t.parentNode.params.fontStyle),t.parentNode.params.fontWeight&&(r.style.fontWeight=t.parentNode.params.fontWeight),t.parentNode.params.textDecoration&&(r.style.textDecoration=t.parentNode.params.textDecoration),i.push({params:r,line:n})),n},t,r;for(u(0,n,i),t=0;t<i.length;t++)t!=0?i[t].line!=i[t-1].line?(i[t].params.dy=i[t].params.style.fontSize||f,i[t].params.x=this.settings.x):(i[t].params.dy=0,i[t].params.dx=0):(i[t].params.x=this.settings.x,i[t].params.dy=0),r=new rt(this.renderer,i[t].params),r.append(this),this.tspans.push(r)}}),rt=r.inherit({ctor:function(n,t){var i=t.text||"";delete t.text,this.callBase(n,"tspan",t),this.element.appendChild(c.createTextNode(i))}}),ut=r.inherit({ctor:function(n,t){this.callBase(n,"g",t)},update:n.noop}),ft=r.inherit({ctor:function(n,t){var f=i.getNextDefsSvgId(),e=t.color,u=t.hatching,s=u.opacity,h=u.width||1,r=u.step||6,o=u.direction,c={strokeWidth:h,stroke:e};this.callBase(n,"pattern",{id:f,width:r,height:r}),this.element.setAttribute("patternUnits","userSpaceOnUse"),this._rect=n.createRect(0,0,r,r,0,{fill:e,opacity:s}).append(this),this._path=n.createPath(0,c).append(this),o==="right"?this._path.applySettings({d:"M "+r/2+" "+-r/2+" L "+-r/2+" "+r/2+"M 0 "+r+" L "+r+" 0 M "+r*1.5+" "+r/2+" L "+r/2+" "+r*1.5}):o==="left"&&this._path.applySettings({d:"M 0 0 L "+r+" "+r+" M "+-r/2+" "+r/2+" L "+r/2+" "+r*1.5+" M "+r/2+-r/2+" L "+r*1.5+" "+r/2}),this.id=l(f,n.pathModified)},append:function(){return this.callBase(this.renderer.getDefsSvg())},clear:function(){this.callBase(),this._path=null},dispose:function(){this._path=null,this.callBase()}}),et=r.inherit({ctor:function(n,t){var u=t.x,f=t.y,e=t.w,o=t.h,r=i.getNextDefsSvgId();delete t.x,delete t.y,delete t.w,delete t.h,this.callBase(n,"clipPath",{id:r}),this.id=r,this._rect=n.createRect(u,f,e,o,0,t),this._rect.append(this)},append:function(){return this.callBase(this.renderer.getDefsSvg())},updateRectangle:function(n){this._rect.applySettings(n)},dispose:function(){this._rect=null,this.callBase()}}),st=r.inherit({ctor:function(t){this.applySettings=n.noop,this.callBase(t,"filter"),delete this.applySettings,this.ref=null,this._create()},append:function(){return this.callBase(this.renderer.getDefsSvg())},dispose:function(){while(this.element.firstChild)this.element.removeChild(this.element.firstChild);return this.callBase(),this},applySettings:function(n){return n=n||{},n.id=i.getNextDefsSvgId(),this.$element.attr({id:n.id,x:n.x||null,y:n.y||null,width:n.width||null,height:n.height||null}),this.ref=n.id?l(n.id,this.renderer.pathModified):null,this._update(n),this}}),ot=st.inherit({_create:function(){var n=this,t=n._gaussianBlur=o("feGaussianBlur"),i=n._offset=o("feOffset"),r=n._flood=o("feFlood"),u=n._composite=o("feComposite"),e=o("feComposite");f(t,{"in":"SourceGraphic",result:"gaussianBlurResult"}),f(i,{"in":"gaussianBlurResult",result:"offsetResult"}),f(r,{result:"floodResult"}),f(u,{"in":"floodResult",in2:"offsetResult",operator:"in",result:"compositeResult"}),f(e,{"in":"SourceGraphic",in2:"compositeResult",operator:"over"}),n.element.appendChild(t),n.element.appendChild(i),n.element.appendChild(r),n.element.appendChild(u),n.element.appendChild(e)},_update:function(n){f(this._gaussianBlur,{stdDeviation:n.blur||0}),f(this._offset,{dx:n.dx||0,dy:n.dy||0}),f(this._flood,{"flood-color":n.color,"flood-opacity":n.opacity})}});s.SvgRenderer=v.inherit({ctor:function(n){var t=this;n=n||{},t._setAnimationOptions(n.animation||{}),t.animationController=new s.AnimationController,t.pathModified=n.pathModified,t.rtl=!!n.rtl,t.cssClass=n.cssClass||"",t.recreateCanvas(n.width,n.height)},dispose:function(){var n=this;n.detachContainer(),n.svgRoot&&(n.svgRoot.remove(),n.svgRoot=null),n.animationController.dispose(),n.animOptions=null,n.animationController=null},_setAnimationOptions:function(n){this.animOptions={enabled:!0,duration:1e3,easing:"easeOutCubic"},"enabled"in n&&(this.animOptions.enabled=n.enabled),"duration"in n&&(this.animOptions.duration=n.duration),"easing"in n&&(this.animOptions.easing=n.easing)},animationEnabled:function(){return!!this.animOptions.enabled},updateAnimationOptions:function(t){this._setAnimationOptions(n.extend(this.animOptions||{},t))},stopAllAnimations:function(n){n?this.animationController.lock():this.animationController.stop()},detachContainer:function(){var n=this;n.svgRoot&&n.svgRoot.detach(),n.defsSvg&&(n.defsSvg.remove(),n.defsSvg=null),n.drawn=null},recreateCanvas:function(n,t,i){n>=0&&t>=0&&(this.svgRoot?this.svgRoot.applySettings({width:n,height:t}):(this.cssClass=i||this.cssClass,this.svgRoot=new y(this,{width:n,height:t,"class":this.cssClass,direction:this.rtl?"rtl":"ltr"}),this.animationController.element=this.svgRoot.element),this.defsSvg&&this.defsSvg.clear("pattern"))},resize:function(n,t){var i=this.getRoot();i&&n>0&&t>0&&i.applySettings({width:n,height:t})},getRoot:function(){return this.svgRoot},isInitialized:function(){return!!this.svgRoot},draw:function(n){n&&!this.drawn&&(n.appendChild(this.getRoot().element),this.drawn=!0)},updateParams:function(n,t){t&&t.strokeWidth&&(n.strokeWidth=t.strokeWidth)},animateElement:function(n,t,i){this.animationController.animateElement(n,t,i)},createRect:function(t,i,r,u,f,e){var o={x:t,y:i,width:r,height:u,rx:f,ry:f};return e&&!e.inh&&n.extend(o,e),this.updateParams(o,e),new w(this,o)},createSegmentRect:function(t,i,r,u,f,e,o){var s=n.extend({},o||{},{x:t,y:i,width:r,height:u,rx:f,ry:f,segments:e});return new b(this,s)},createClipRect:function(n,t,i,r){var u={x:n,y:t,w:i,h:r,fill:"none",stroke:"none",strokeWidth:0};return new et(this,u)},createPattern:function(n,t){return(t=t||{},t.direction=(t.direction||"").toLowerCase(),t.direction!=="right"&&t.direction!=="left")?{id:n,append:function(){return this},clear:function(){},dispose:function(){}}:new ft(this,{hatching:t,color:n})},createImage:function(t,i,r,u,f,e){var o=n.extend({},e||{},{x:t,y:i,width:r,height:u});return new p(this,o,f,o.location)},createLine:function(t,i,r,u,f){var o={points:[t,i,r,u]};return f&&!f.inh&&n.extend(o,f),this.updateParams(o,f),new e(this,o)},createPath:function(t,i){var r={points:t};return i&&!i.inh&&n.extend(r,i),this.updateParams(r,i),new e(this,r)},createSimplePath:function(n){return new r(this,"path",n)},createBezierPath:function(t,i){var r={points:t};return i&&!i.inh&&n.extend(r,i),this.updateParams(r,i),new a(this,r)},createArea:function(t,i){var r={points:t};return i&&!i.inh&&n.extend(r,i),this.updateParams(r,i),new d(this,r)},createBezierArea:function(t,i){var r={points:t};return i&&!i.inh&&n.extend(r,i),this.updateParams(r,i),new g(this,r)},createCircle:function(t,i,r,u){var f={cx:t,cy:i,r:r};return u&&!u.inh&&n.extend(f,u),new tt(this,f)},createArc:function(t,i,r,u,f,e,o){var s={x:t,y:i,outerRadius:r,innerRadius:u,startAngle:f,endAngle:e};return o&&!o.inh&&n.extend(s,o),this.updateParams(s,o),new nt(this,s)},createText:function(t,i,r,u){var f={x:i,y:r,text:t};return u&&!u.inh&&n.extend(f,u),new it(this,f)},createGroup:function(n){return new ut(this,n)},createFilter:function(n){var t=n==="shadow"?ot:null;return t?new t(this):null},getDefsSvg:function(){return this.defsSvg=this.defsSvg||new r(this,"defs").append()},svg:function(){return this.svgRoot.$element.parent().html()}}),s._svgBuildPath=ht,s._svgProcessCircleSettings=ct,s._svgRendererInternals={BaseSvgElement:r,RootSvgElement:y,RectSvgElement:w,ImageSvgElement:p,PathSvgElement:e,AreaSvgElement:d,BezierSvgElement:a,BezierAreaSvgElement:g,CircleSvgElement:tt,TextSvgElement:it,TspanSvgElement:rt,GroupSvgElement:ut,ArcSvgElement:nt,RectSvgBaseElement:h,SegmentRectSvgElement:b,ClipRectSvgElement:et,PatternSvgElement:ft,ShadowFilterSvgElement:ot}}(jQuery,DevExpress),function(n,t){function d(n){var t=u.createElement(n);return k.appendChild(t)}function tt(n){return n>=.002?n:n===null?1:.002}function yt(n){for(var i=0,r=n.length,t=[];i<r;)t.push("l",n[i++].toFixed(0),n[i++].toFixed(0));return r?(t[0]="m",t.push("x e"),t=t.join(" ")):t="",t}function pt(n,t,i){return{cx:n,cy:t,r:i/2}}var o=t.viz.renderers,f=t.utils,u=document,i=o._svgRendererInternals,k=u.createDocumentFragment(),c,l=[],g=["position","display","visibility","filter","margin","marginTop","marginLeft","marginRight","marginBottom","whiteSpace","clip","overflow"],s=["stroke","fill","opacity","strokeWidth","align","dashStyle"],nt={x:0,y:0,width:1,height:1,position:"absolute",behavior:"url(#default#VML)",display:"inline-block",xmlns:"urn:schemas-microsoft-com:vml"},y="dx-vml-clip-rect",e=function(t,i){return n.extend(!0,i||{},nt,t)},a=function(t,i,r){var u;return f.isDefined(t)&&(f.isNumber(t)?u={angle:t,x:i||0,y:r||0}:n.isArray(t)?u={angle:t[0]||0,x:t[1]||0,y:t[2]||0}:f.isObject(t)&&(u={angle:t.angle||0,x:t.x||0,y:t.y||0})),u},it=function(n,t,i){var r=n.element,f,u=t[i];(i==="opacity"||i==="fillOpacity")&&r.fill&&(r.fill.opacity=tt(u)),i==="joinStyle"&&r.stroke&&(r.stroke.joinStyle=u),(i==="opacity"||i==="strokeOpacity")&&r.stroke&&(r.stroke.opacity=u>=.002?u:u===null?1:.002),i==="dashstyle"&&r.stroke&&(r.stroke.dashstyle=u)},p=function(n){var r,t,i,e=n.tagName.toLowerCase(),o,u,f;if(!n.className||n.className.indexOf(y)===-1){if(e==="div"){if(n.childNodes.length>0)for(t={},r=0;r<n.childNodes.length;r++)(i=p(n.childNodes[r]),i)&&(t.left=t.left===undefined||i.left<t.left?i.left:t.left,t.top=t.top===undefined||i.top<t.top?i.top:t.top,t.right=t.right===undefined||i.right>t.right?i.right:t.right,t.bottom=t.bottom===undefined||i.bottom>t.bottom?i.bottom:t.bottom)}else if(e==="shape"||e==="vml:shape"){for(o=(n.path.value||n.path).match(/[-0-9]+/g),t={},i=n.getBoundingClientRect(),r=0;r<o.length;r++)u=parseInt(o[r]),r%2?(t.top=t.top===undefined||u<t.top?u:t.top,t.bottom=t.bottom===undefined||u>t.bottom?u:t.bottom):(t.left=t.left===undefined||u<t.left?u:t.left,t.right=t.right===undefined||u>t.right?u:t.right);t.left=t.left||0,t.top=t.top||0,t.right=t.right||0,t.bottom=t.bottom||0,i.right-i.left<=1&&i.top-i.bottom<=1?(t.right=t.right+i.left,t.bottom=t.bottom+i.top,t.left=t.left+i.left,t.top=t.top+i.top):(t.right=t.right-t.left+i.left,t.bottom=t.bottom-t.top+i.top,t.left=i.left,t.top=i.top),f=Math.ceil(parseFloat(n.strokeweight)/2),f&&f>1&&(t.left-=f,t.top-=f,t.right+=f,t.bottom+=f)}else t=n.getBoundingClientRect();return t}},r={isVml:function(){return!0},dispose:function(){this.childElements=null,this._style=null,this._fullSettings=null,this.callBase()},defaultSettings:function(n){return e(n,this.callBase?this.callBase():{})},createElement:function(n){return this._nodeName=n,this.childElements=[],this._fullSettings={},this.isVml()?d("vml:"+n):u.createElement(n)},append:function(t){var i=t||this.renderer.getRoot();return i&&(i.element.appendChild(this.element),i.childElements.push(this),this.parentElement&&this.parentElement.childElements.splice(n.inArray(this,this.parentElement.childElements),1),this.parentElement=i),(i===this.renderer.getRoot()||i._isAppended)&&this.appendComplete(),this},insertBefore:function(t){var i=t.parentElement;return i.element.insertBefore(this.element,t.element),this.parentElement=i,i.childElements.splice(n.inArray(t,i.childElements),0,this),i._isAppended&&this.appendComplete(),this},remove:function(){return this.callBase.apply(this,arguments),this.parentElement&&(this.parentElement.childElements.splice(n.inArray(this,this.parentElement.childElements),1),this.parentElement=null),this},detach:function(){return this.callBase.apply(this,arguments),this._delayAttributes(["opacity"]),this._onDetach(),this.parentElement&&(this.parentElement.childElements.splice(n.inArray(this,this.parentElement.childElements),1),this.parentElement=null),this},clear:function(){return this.callBase.apply(this,arguments),n.each(this.childElements,function(n,t){t._delayAttributes(["opacity"]),t._onDetach(),t.parentElement=null}),this.childElements=[],this},applyStyle:function(n){if(this.callBase(n),n.opacity&&(this.element.style.opacity=n.opacity),n.clip)try{this.element.style.clip=n.clip}catch(t){}},_fillAttributesFromParentAndCurrentStyle:function(t){var u=this.element,e=this.parentElement,r,h={strokeWidth:"stroke-width"},i,o,f={};if(e)for(r=0;r<s.length;r++)i=s[r],!this.settings[i]&&e._fullSettings[i]&&(f[i]=e._fullSettings[i]);if(u.style&&u.currentStyle)for(r=0;r<s.length;r++)i=s[r],o=h[i]||i,u.currentStyle[o]&&(f[i]=u.currentStyle[o]);n.extend(this._fullSettings,this.settings,f),this.isVml()&&n.extend(t,this._normalizeSettings(f))},_applyAttributes:function(t){var i,r;if(t&&t.arcsize!==undefined){try{this.element.setAttribute("arcsize",t.arcsize)}catch(u){}delete t.arcsize}if(t&&t["class"]&&(this.element.className=t["class"],delete t["class"]),this._isAppended){if(t=t||this._delayedAttributes,t){if(this._fillAttributesFromParentAndCurrentStyle(t),this.isVml()){for(i in t)r=t[i],i==="opacity"||i==="fillOpacity"||i==="strokeOpacity"||i==="dashstyle"||i==="joinStyle"?it(this,t,i):this.element[i]=r;n.each(this.element.children,function(n,t){t.style.behavior="url(#default#VML)",t.style.display="inline-block",t.xmlns="urn:schemas-microsoft-com:vml"})}delete this._delayedAttributes}}else this._delayedAttributes=t},_onDetach:function(){this._isAppended=!1,n.each(this.childElements,function(n,t){t._onDetach()})},appendComplete:function(){this.renderer.isElementAppendedToPage(this)?(this._isAppended=!0,this._applyAttributes(),n.each(this.childElements,function(n,t){t.appendComplete()}),this.parentElement instanceof b&&this.parentElement._clipRect&&this.parentElement._clipRect!==this&&(this.parentElement._clipRect._isAppended?this.parentElement._clipRect.toForeground():this.parentElement._clipRect.append(this.parentElement))):(l.push(this),n(this.element).data("vmlNeedAppendComplete",!0),c===undefined&&(c=setTimeout(function(){c=undefined;var t=l;l=[],n.each(t,function(){n(this.element).data("vmlNeedAppendComplete")&&!this._isAppended&&this.appendComplete()})},200)))},_delayAttributes:function(t){var r,u,i,f=this.settings||{};for(t=t||[],this._delayedAttributes=this._delayedAttributes||{},i=0;i<t.length;i++)r=t[i],u=f[r],u&&(this._delayedAttributes[r]=u);n.each(this.childElements||[],function(n,i){i._delayAttributes(t)})},_normalizeSettings:function(t){var s,u={},f={},e,o,i,r;for(s in t)if(i=s,r=t[i],i==="x"||i==="translateX")o=t.x||0,t.translateX&&(o+=t.translateX),u.left=o+"px";else if(i==="y"||i==="translateY")o=t.y||0,t.translateY&&(o+=t.translateY),u.top=o+"px";else if(i==="width")u.width=r+"px";else if(i==="behavior")u[i]=r;else if(i==="height")u.height=r+"px";else if(i==="align")continue;else if(i==="scale")continue;else if(n.inArray(i,g)!=-1)u[i]=r!==null?r:"";else if(i==="font"){if(!n.isPlainObject(r))continue;n.each(r,function(n){var t,i;switch(n){case"color":t="fill";break;case"opacity":t="opacity";break;case"cursor":t=n;break;default:i=n.charAt(0),t="font"+n.replace(i,i.toUpperCase())}t&&(u[t]=r[n])})}else if(i==="style")n.extend(!0,u,r);else if(i==="rotate")this._rotate=r;else if(i==="clipId"){if(e=this.renderer.getClipRect(r,this),e){var a=e.width,v=e.height,h=e.x,c=e.y,y=a+h,p=v+c,l=this.renderer._getSize();u.width=l.width,u.height=l.height,u.clip="rect("+c+"px, "+y+"px, "+p+"px, "+h+"px)"}}else if(i==="segments")continue;else i==="fill"?(f.filled=r==="none"?"f":"t",f.fillcolor=r==="grey"?"#808080":r):i==="opacity"?f.opacity=r<.002?r:r:i==="stroke"?(f.stroked=r==="none"?"f":"t",f.strokecolor=r):i==="strokeWidth"?f.strokeweight=r+"px":i==="lineJoin"?f.joinStyle=r:i==="dashStyle"?(r=r.toLowerCase(),f.dashstyle=r):f[i]=r;return this._style=u,f},_getBBox:function(){var u,f,n,e,i=0,r=0,t=this.element,o;try{n=p(t),u=n.right-n.left,f=n.bottom-n.top,o=this.element.parentNode||this.renderer.getRoot().element,e=o.getBoundingClientRect(),i=n.left-e.left,r=n.top-e.top,t.tagName.toLowerCase()==="div"&&(i=i-(parseInt(t.style.left,10)||0),r=r-(parseInt(t.style.top,10)||0))}catch(s){u=t.offsetWidth||0,f=t.offsetHeight||0}return{x:i,y:r,width:u,height:f,isEmpty:!i&&!r&&!u&&!f}},getBBox:function(){return this._getBBox()},sharpEdges:function(){}},rt=function(n){switch(n){case"M":return"m";case"L":return"l";case"Z":return"x e"}return n},h={defaultSettings:function(){return n.extend(this.callBase(),{coordsize:"1,1"})},getNodeName:function(){return"shape"},getPathAttributeName:function(){return"path"},customizeSegments:function(t){var i=t;return t&&(i=n.map(t,function(n){var i,r=[],u=rt(n[0]);for(r.push(u),i=1;i<n.length;i++)r.push(Math.floor(n[i]));return[r]})),i}},ut=i.BaseSvgElement.inherit(r).inherit({isVml:function(){return!1},defaultSettings:function(){return{width:0,height:0,position:"relative",display:"inline-block",overflow:"hidden",stroke:"none",strokeWidth:0,fill:"none"}},ctor:function(n,t){this.callBase(n,"div",t)}}),ft=i.BaseSvgElement.inherit(i.RectSvgBaseElement).inherit(r).inherit({ctor:function(n,t){this.callBase(n,"image",t)},defaultSettings:function(){return n.extend(this.callBase(),{strokeWidth:0,fill:"none",stroke:"none"})},adjustSettings:function(){var n=this.defaultSettings();this.callBase(),this.settings.href&&(this.settings.src=this.settings.href,delete this.settings.href),this.settings.fill=n.fill,this.settings.stroke=n.stroke,this.settings.strokeWidth=n.strokeWidth}}),et=i.BaseSvgElement.inherit(i.RectSvgBaseElement).inherit(r).inherit({defaultSettings:function(){return e({stroked:"f",strokeWidth:0,rx:0,ry:0})},recreateElement:function(t){var r,i;this._nodeName=t,r=this.$element.parent()[0],r?(i=this.$element,this.element=this.createElement(t),this.$element=n(this.element),this.$element.insertBefore(i),i.remove()):(this.element=this.createElement(t),this.$element=n(this.element)),this.applySettings()},_adjustArcSize:function(){var t=this.settings,f=t.rx||0,e=t.ry||0,o=t.width,s=t.height,r,u,i;(t.rx!==undefined||t.ry!==undefined)&&(r=Math.max(f,e),u=Math.max(o,s)/2,i=r/u,t.arcsize=i,n.isNumeric(i)&&i!=0?this._nodeName!=="roundrect"&&this.recreateElement("roundrect"):this._nodeName==="roundrect"&&this.recreateElement("rect"),delete t.rx,delete t.ry)},_adjustRotation:function(){var n=this.settings,v=this.settings.rotate,e,o,s,h,i,r,c,l,u,f,t;t=a(v,n.x,n.y),t&&(e=t.angle,i=t.x,r=t.y,o=e*Math.PI/180,s=Math.cos(o),h=Math.sin(o),u=n.x+(n.translateX||0)+n.width/2,f=n.y+(n.translateY||0)+n.height/2,l=(u-i)*s-(f-r)*h+i-u,c=(u-i)*h+(f-r)*s+r-f,this.settings.marginLeft=Math.round(l)+"px",this.settings.marginTop=Math.round(c)+"px",this.settings.rotation=e)},adjustSettings:function(){this.callBase(),this._adjustArcSize(),this._adjustRotation()},ctor:function(n,t){this.callBase(n,"rect",t)}}),v=i.PathSvgElement.inherit(r).inherit(h).inherit({prepareSegments:function(t){var i=this,w=t.rotate,l,u,f,v,e,o,s,h,c,y,p,r;this.callBase(t),v=i.segments,r=a(w,t.x,t.y),r&&(l=r.angle,u=r.x,f=r.y,i.segments&&(e=l*Math.PI/180,o=Math.cos(e),s=Math.sin(e),i.segments=n.map(i.segments,function(n){return n.length===3?(h=n[1],c=n[2],y=(h-u)*o-(c-f)*s+u,p=(h-u)*s+(c-f)*o+f,[[n[0],Math.floor(y),Math.floor(p)]]):[n]}),i.combinePathParams(t),i.segments=v))}}),ot=i.BaseSvgElement.inherit(r).inherit({ctor:function(n,t){this.callBase(n,"shape",t)},defaultSettings:function(){return e({coordsize:"1,1"})},adjustSettings:function(){var n=this.settings;n.d!==undefined&&(n.path=n.d,delete n.d)}}),st=v.inherit({defaultSettings:function(){var n=this.callBase();return e({points:{x:0,y:0}},n)},ctor:function(n,t){this.closePath=!0,this.callBase(n,t)}}),ht=i.SegmentRectSvgElement.inherit(r).inherit(h).inherit({defaultSettings:function(){var n=this.callBase();return n.lineJoin="miter",delete n.fill,delete n.stroke,delete n.strokecolor,delete n.stroked,n},prepareSegments:function(){this.callBase(),this.segments=this.customizeSegments(this.segments),this.settings.x=0,this.settings.y=0,this.settings.width=1,this.settings.height=1},applySettings:function(n){var t=n.x,i=n.y,r=n.width,u=n.height;return this.callBase(n),this.settings.x=t,this.settings.y=i,this.settings.width=r,this.settings.height=u,this}}),w=i.BezierSvgElement.inherit(r).inherit(h),ct=w.inherit({defaultSettings:function(){var n=this.callBase();return e({points:{x:0,y:0}},n)},ctor:function(n,t){this.closePath=!0,this.callBase(n,t)}}),lt=i.ArcSvgElement.inherit(r).inherit(h).inherit({createArcSegments:function(n,t,i,r,u,f,e){var o=n+r*Math.cos(u),s=t-r*Math.sin(u),h=n+r*Math.cos(f),c=t-r*Math.sin(f),l=n+i*Math.cos(f),a=t-i*Math.sin(f),v=n+i*Math.cos(u),y=t-i*Math.sin(u);return[["wr",n-i,t-i,n+i,t+i,l,a,v,y],[e?"wr":"at",n-r,t-r,n+r,t+r,o,s,h,c],["x e"]]}}),at=i.BaseSvgElement.inherit(r).inherit({defaultSettings:function(){return e({cx:0,cy:0,r:0})},applySettings:function(n){return n.cx=n.cx||n.x,n.cy=n.cy||n.y,this.callBase(n)},adjustSettings:function(){var n,t,i;(this.settings.cx!==undefined||this.settings.cy!==undefined||this.settings.r!==undefined)&&(n="r"in this.settings?this.settings.r:this.settings.width/2,t="cx"in this.settings?this.settings.cx:this.settings.x+this.settings.width/2,i="cy"in this.settings?this.settings.cy:this.settings.y+this.settings.width/2,this.settings.x=t-n,this.settings.y=i-n,this.settings.width=this.settings.height=n*2,delete this.settings.cx,delete this.settings.cy,delete this.settings.r)},ctor:function(n,t){this.callBase(n,"oval",t)}}),vt=i.BaseSvgElement.inherit(r).inherit({isVml:function(){return!1},defaultSettings:function(){return{x:0,y:0,position:"absolute",whiteSpace:"nowrap"}},ctor:function(n,t){this.callBase(n,"span",t)},adjustSettings:function(){var i,t=this.settings;t.font&&(t.fill=t.fill||t.font.color,t.opacity=t.opacity||t.font.opacity),"text"in t&&(i=f.isDefined(t.text)?t.text:"",i=i.toString().replace(/\r/g,""),i=i.replace(/\n/g,"<br/>"),n(this.element).html(i),delete t.text),this.renderer.rtl&&n(this.element).css("direction","rtl")},updateText:function(n){this.applySettings({text:f.isDefined(n)?n:""})},_applyAttributes:function(n){var tt,it;this.callBase(n),n=this._fullSettings;var rt=n.rotate,t=0,k,d,i=1,r=0,y=0,p=1,ft,w,h,g=n.y+(n.translateY||0),nt=n.x+(n.translateX||0),ut=n.align,f=this.getBBox(),l=this._style||{},s=0,c=0,o,b,v,u,e;this._oldRotate&&!f.isEmpty?(h=this._oldRotate.angle*Math.PI/180,y=Math.sin(h),p=Math.cos(h),(this._oldRotate.angle|0)%90!=0?(this._oldRotate.angle|0)%45==0?(u=f.width,e=f.height):(w=Math.abs(Math.tan(h)),tt=(f.width-f.height*w)/(1-w*w),it=f.width-tt,e=Math.abs(it/y),u=Math.abs(tt/p)):(e=Math.abs(f.height*p-f.width*y),u=Math.abs(f.width*p-f.height*y))):(u=f.width,e=f.height),(e||u)&&(v=a(rt,nt,g),this._oldRotate=v,v&&(t=v.angle,k=v.x,d=v.y,Math.abs(t)>360&&(t=t%360),t<0&&(t=t+360),t?(h=t*Math.PI/180,i=Math.cos(h),r=Math.sin(h),l.filter='progid:DXImageTransform.Microsoft.Matrix(sizingMethod="auto expand", M11 = '+i.toFixed(5)+", M12 = "+(-r).toFixed(5)+", M21 = "+r.toFixed(5)+", M22 = "+i.toFixed(5)+")"):(l.filter="",this._oldRotate=null),s=(nt-k)*(i-1)-(g-d)*r,c=(nt-k)*r+(g-d)*(i-1)),o=e*(.55+.45/2),t<90?(c-=o*i,s-=(e-o)*r):t<180?(c+=(e-o)*i,s+=u*i-(e-o)*r):t<270?(c+=(e-o)*i+u*r,s+=u*i+o*r):(c+=u*r-o*i,s+=o*r),t&&this.renderer.rtl&&(s-=u-(e*Math.abs(r)+u*Math.abs(i))),b={center:.5,right:1}[ut],b&&(s-=u*b*i,c-=u*b*r),l.marginLeft=Math.round(s)+"px",l.marginTop=Math.round(c)+"px"),n.fill&&n.fill!=="none"&&(l.color=n.fill),n.opacity&&(this.element.style.filter="alpha(opacity="+n.opacity*100+")"),this.applyStyle(l)}}),b=i.BaseSvgElement.inherit(r).inherit({isVml:function(){return!1},defaultSettings:function(){return{x:0,y:0,position:"absolute"}},ctor:function(n,t){this.callBase(n,"div",t)},adjustSettings:function(){if(this.settings.clipId||this._clipRect){var n=this.renderer.getClipRect(this.settings.clipId,this);this._clipRect?n?this._clipRect.applySettings({x:n.x,y:n.y,width:n.width,height:n.height}):(this._clipRect.remove(),this._clipRect=null):this._clipRect=this.renderer.createRect(n.x,n.y,n.width,n.height,0,{fill:"none",opacity:.002,"class":y}),this._clipRect&&this.childElements.length&&this._clipRect.append(this)}},applySettings:function(t){var i;return t=t||{},i=t.rotate,i&&(f.isNumber(i)&&(i=[i,t.x||0,t.y||0]),n.each(this.childElements,function(n,t){t.applySettings({rotate:i})})),delete t.rotate,delete t.x,delete t.y,this.callBase(t),n.each(this.childElements||[],function(n,t){t.applySettings({})}),this},getBBox:function(){return this._getBBox()},update:function(){if(this.settings.clipId){var n=this.getBBox();this.applyStyle({left:n.x+(this.settings.translateX||0),right:n.y+(this.settings.translateY||0),width:n.width,height:n.height})}}});o.VmlRenderer=o.SvgRenderer.inherit({ctor:function(n){if(n=n||{},n.animation={enabled:!1},u.namespaces&&!u.namespaces.vml){u.namespaces.add("vml","urn:schemas-microsoft-com:vml");var t="vml\\:fill, vml\\:path, vml\\:shape, vml\\:stroke, vml\\:rect, vml\\:oval{ behavior:url(#default#VML); display: inline-block; };";try{u.createStyleSheet().cssText=t}catch(i){u.styleSheets[0].cssText+=t}}this._clipRects={},this.cssClass=n.cssClass||"",this.callBase(n)},dispose:function(){this.callBase(),this._clipRects=null,this._size=null},updateAnimationOptions:n.noop,draw:function(n){var t=this.getRoot();this.callBase(n),t&&t.appendComplete()},recreateCanvas:function(n,t,i){n>=0&&t>=0&&(this._size={width:n,height:t},this.svgRoot?this.svgRoot.applySettings({width:n,height:t}):(this.cssClass=i||this.cssClass,this.svgRoot=new ut(this,{width:n,height:t,"class":this.cssClass})),this.defsSvg&&this.defsSvg.clear())},_getSize:function(){return this._size||{}},isElementAppendedToPage:function(t){return n(t.element).closest(u.documentElement).length},createRect:function(t,i,r,u,f,e){var o=n.extend(!0,{},e||{},{x:t,y:i,width:r,height:u,rx:f,ry:f});return new et(this,o)},createSegmentRect:function(t,i,r,u,f,e,o){var s=n.extend({},o||{},{x:t,y:i,width:r,height:u,rx:f,ry:f,segments:e});return new ht(this,s)},createClipRect:function(t,i,r,u){var e=f.getNextDefsSvgId(),o=[],s={id:e,x:t,y:i,width:r,height:u,addElement:function(t){var i=!1;n.each(o,function(){if(this===t)return i=!0,!1}),i||o.push(t)},append:function(){return this},remove:function(){},dispose:function(){},updateRectangle:function(t){return"x"in t&&(this.x=t.x),"translateX"in t&&(this.x+=t.translateX),"y"in t&&(this.y=t.y),"translateY"in t&&(this.y+=t.translateY),"width"in t&&(this.width=t.width),"height"in t&&(this.height=t.height),n.each(o,function(){this.applySettings({clipId:e})}),this}};return this._clipRects[e]=s,s},getClipRect:function(n,t){var i=this._clipRects[n];return i&&t&&i.addElement(t),this._clipRects[n]},createImage:function(t,i,r,u,f,e){var o=n.extend(!0,{},e&&!e.inh?e:{},{x:t,y:i,width:r,height:u,href:f});return new ft(this,o)},createLine:function(t,i,r,u,f){var e=n.extend(!0,{},f&&!f.inh?f:{},{points:[t,i,r,u]});return new v(this,e)},createPath:function(t,i){var r=n.extend(!0,{},i&&!i.inh?i:{},{points:t});return new v(this,r)},createSimplePath:function(n){return new ot(this,n)},createBezierPath:function(t,i){var r=n.extend(!0,{},i&&!i.inh?i:{},{points:t});return new w(this,r)},createArea:function(t,i){var r=n.extend(!0,{},i&&!i.inh?i:{},{points:t});return new st(this,r)},createBezierArea:function(t,i){var r=n.extend(!0,{},i&&!i.inh?i:{},{points:t});return new ct(this,r)},createCircle:function(t,i,r,u){var f=n.extend(!0,{},u&&!u.inh?u:{},{cx:t,cy:i,r:r});return new at(this,f)},createArc:function(t,i,r,u,f,e,o){var s=n.extend(!0,{},o&&!o.inh?o:{},{x:t,y:i,outerRadius:r,innerRadius:u,startAngle:f,endAngle:e});return new lt(this,s)},createText:function(t,i,r,u){var f=n.extend(!0,{},u&&!u.inh?u:{},{x:i,y:r,text:t});return new vt(this,f)},createGroup:function(n){return new b(this,n)},createPattern:function(n){return{id:n,append:function(){return this},clear:function(){},dispose:function(){}}},createFilter:function(n){return n==="shadow"?{ref:null,append:function(){return this},dispose:function(){return this},applySettings:function(){return this}}:null},svg:function(){return""}}),o._vmlBuildPath=yt,o._vmlProcessCircleSettings=pt}(jQuery,DevExpress),function(n,t){function u(){return!(r.msie&&r.version<9)||!!document.createElementNS&&!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect}var i=t.viz.renderers,r=t.browser;u()?(i.Renderer=i.SvgRenderer,i.buildPath=i._svgBuildPath,i.processCircleSettings=i._svgProcessCircleSettings):(i.Renderer=i.VmlRenderer,i.buildPath=i._vmlBuildPath,i.processCircleSettings=i._vmlProcessCircleSettings),i.isSvg=u}(jQuery,DevExpress),function(n){var t=n.viz.renderers,u=n.Class,i=function(){},r={easeOutCubic:function(n,t,i){return n===1?i:(1-Math.pow(1-n,3))*(i-t)+ +t},linear:function(n,t,i){return n===1?i:n*(i-t)+ +t}},f;t.easingFunctions=r,t.animationSvgStep={points:function(n,t,i,r,u){for(var e=t.from,l=t.to,c=[],o,s,h,f=0;f<e.length;f++){if(s=[e[f][0]],e[f].length>1)for(o=1;o<e[f].length;o++)s.push(r(i,e[f][o],l[f][o]));c[f]=s.join(" ")}h=c.join(" "),u.d=t.end&&i===1?t.end:h,n.element.setAttribute("d",h)},arc:function(n,t,i,r){var f=t.from,o=t.to,e={},u;for(u in f)e[u]=r(i,f[u],o[u]);n.applySettings(e)},transform:function(n,t,i,r,u){var s=t.translate,e=t.rotate,h=t.scale,o=[],f=n.settings;s?(u.translateX=r(i,s.x.from,s.x.to),u.translateY=r(i,s.y.from,s.y.to),o.push("translate("+u.translateX+","+u.translateY+")")):(f.translateX||f.translateY)&&o.push("translate("+(f.translateX||0)+","+(f.translateY||0)+")"),e?(u.rotate={angle:r(i,e.angle.from,e.angle.to),x:e.x,y:e.y},o.push("rotate("+u.rotate.angle+","+e.x+","+e.y+")")):f.rotate&&o.push("rotate("+f.rotate.angle+","+(f.rotate.x||0)+","+(f.rotate.y||0)+")"),h?(u.scale={x:r(i,h.x.from,h.x.to),y:r(i,h.y.from,h.y.to)},o.push("scale("+u.scale.x+","+u.scale.y+")")):f.scale&&o.push("scale("+f.scale.x+","+f.scale.y+")"),n.element.setAttribute("transform",o.join())},base:function(n,t,i,r,u,f){u[f]=r(i,t.from,t.to),n.element.setAttribute(f,u[f])},_:i,complete:function(n,t){n.applySettings(t)}},f=u.inherit({ctor:function(n,i,u){var f=this;f._progress=0,f.element=n,f.params=i,f.options=u,f.duration=u.partitionDuration?u.duration*u.partitionDuration:u.duration,f._animateStep=u.animateStep||t.animationSvgStep,f._easing=r[u.easing]||r.easeOutCubic,f._currentParams={},f.tick=f._start},_calcProgress:function(n){return Math.min(1,(n-this._startTime)/this.duration)},_step:function(n){var t=this,r=t._animateStep,i,u;t._progress=t._calcProgress(n);for(i in t.params)t.params.hasOwnProperty(i)&&(u=r[i]||r.base,u(t.element,t.params[i],t._progress,t._easing,t._currentParams,i));return(t.options.step&&t.options.step(t._easing(t._progress,0,1),t._progress),t._progress===1)?t.stop():!0},_start:function(n){return this._startTime=n,this.tick=this._step,!0},_end:function(n){var t=this;t.stop=i,t.tick=i,t._animateStep.complete&&t._animateStep.complete(t.element,t._currentParams),t.options.complete&&!n&&t.options.complete()},tick:function(){return!0},stop:function(n,t){var i=this.options;if(!n&&i.repeatCount&&--i.repeatCount>0)return this.tick=this._start,!0;this._end(t)}}),t.AnimationController=u.inherit(function(){var n=1e3/60,t=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){setTimeout(t,n)};return{ctor:function(){var n=this;n.requestAnimationFrame=t,n._animationCount=0,n._timerId=null,n._animations={}},_loop:function(){var n=this,t=n._animations,r=0,u=+new Date,i;for(i in t)t.hasOwnProperty(i)&&(t[i].tick(u)||delete t[i],r++);if(r===0){n.stop();return}n._timerId=n.requestAnimationFrame.call(null,function(){n._loop()},n.element)},addAnimation:function(n){var t=this;t._animations[t._animationCount++]=n,t._timerId||(clearTimeout(t._startDelay),t._startDelay=setTimeout(function(){t._timerId=1,t._loop()},0))},animateElement:function(n,t,i){n&&t&&i&&(n.animation&&n.animation.stop(!0),this.addAnimation(n.animation=new f(n,t,i)))},dispose:function(){this.stop(),this.element=null},stop:function(){this._animations={},this._animationCount=0,clearTimeout(this._startDelay),this._timerId=null},lock:function(){var n=this._animations,t;for(t in n)n.hasOwnProperty(t)&&n[t].stop(!0,!0);this.stop()}}}())}(DevExpress),function(n){n.viz.charts={series:{}}}(DevExpress),function(n){n.viz.charts.consts={dataTypes:{STRING:"string",NUMERIC:"numeric",DATETIME:"datetime"},axisTypes:{DISCRETE:"discrete",CONTINUOUS:"continuous",LOGARITHMIC:"logarithmic"}}}(DevExpress),function(n,t){var o=t.viz,h=new o.core.ParseUtils,s=o.charts.consts,f=s.dataTypes,u=s.axisTypes,r=t.utils,e=n.each,i=r.isDefined,c=function(n,t){function i(n,t,r,u){if(t<r){var f=Math.floor((t+r)/2);i(n,t,f,u),i(n,f+1,r,u),l(n,t,f,r,u)}}var r=n.length;return i(n,0,r-1,t),n},l=function(n,t,r,u,f){for(var c=new Array(u-t+1),s=t,h=r+1,e,o=0;s<=r&&h<=u;)n[s][f]<=n[h][f]||!i(n[h][f])?(c[o]=n[s],s++):(c[o]=n[h],h++),o++;if(s>r)for(e=h;e<=u;e++,o++)c[o]=n[e];else for(e=s;e<=r;e++,o++)c[o]=n[e];for(e=0;e<=u-t;e++)n[e+t]=c[e];return n};o.charts.DataValidator=t.Class.inherit({ctor:function(t,i,r,u){var f=this;i=i||[[]],t||(f._nullData=!0),f.groups=i,f.data=t||[],f._parsers={},f._errorShowList={},f._skipFields={},f.options=u||{},f.incidentOccured=r,f.userArgumentCategories=f.groups.length&&f.groups[0].length&&f.groups[0][0].getArgumentCategories(),r||(f.incidentOccured=n.noop)},validate:function(){var t=this;return t._data=t.data,(!r.isArray(t.data)||t._nullData)&&t._incorrectDataMessage(),t.groups.argumentType=null,t.groups.argumentAxisType=null,n.each(t.groups,function(t,i){i.valueType=null,i.valueAxisType=null,n.each(i,function(n,t){t.updateDataType({})})}),t._checkType(),t._checkAxisType(),t.options.convertToAxisDataType&&(t._createParser(),t._parse()),t._groupData(),t._sort(),n.each(t._skipFields,function(n,i){i===t._data.length&&t.incidentOccured("W2002",[n])}),t._data},_checkType:function(){var t=this,i=[],u=[],f=function(i,r){return n.each(i,function(u,f){n.each(f.getValueFields(),function(n,u){i.valueType=t._getType(r[u],i.valueType)})}),i.valueType?!0:void 0},e=function(i,r){return n.each(i,function(n,i){t.groups.argumentType=t._getType(r[i.getArgumentField()],t.groups.argumentType)}),t.groups.argumentType?!0:void 0};n.each(t.groups,function(n,r){if(!r.length)return null;var f=r[0].getOptions(),e=f.valueType,o=f.argumentType;r.valueType=e,t.groups.argumentType=o,e?null:i.push(r),o?null:u.push(r)}),(i.length||u.length)&&n.each(t.data,function(o,s){var h=!0;if(r.isObject(s))return n.each(i,function(n,t){h=h&&f(t,s)}),n.each(u,function(n,t){h=h&&e(t,s)}),!t.options.checkTypeForAllData&&h?!1:void 0})},_checkAxisType:function(){var t=this;n.each(t.groups,function(i,r){n.each(r,function(n,i){var u={},f=i.getOptions();u.argumentAxisType=t._correctAxisType(t.groups.argumentType,f.argumentAxisType,!!t.userArgumentCategories.length),u.valueAxisType=t._correctAxisType(r.valueType,f.valueAxisType,!!i.getValueCategories().length),t.groups.argumentAxisType=t.groups.argumentAxisType||u.argumentAxisType,r.valueAxisType=r.valueAxisType||u.valueAxisType,u.argumentType=t.groups.argumentType,u.valueType=r.valueType,i.updateDataType(u)})})},_createParser:function(){var t=this;n.each(t.groups,function(i,r){n.each(r,function(i,f){t._parsers[f.getArgumentField()]=t._createParserUnit(t.groups.argumentType,t.groups.argumentAxisType===u.LOGARITHMIC?t._filterForLogAxis:null),n.each(f.getValueFields(),function(n,i){t._parsers[i]=t._createParserUnit(r.valueType,r.valueAxisType===u.LOGARITHMIC?t._filterForLogAxis:null,f.getOptions().ignoreEmptyPoints)}),f.getTagField()&&(t._parsers[f.getTagField()]=null)})})},_parse:function(){var t=this,i=[];n.each(t.data,function(u,f){var e={};if(!r.isObject(f)){f&&t._incorrectDataMessage();return}n.each(t._parsers,function(n,t){e[n]=t?t(f[n],n):f[n],e["original"+n]=f[n]}),i.push(e)}),this._data=i},_groupMinSlices:function(n,t,r){var h=this,r=r||{},f=r.mode,l=r.topCount,a=r.threshold,v=r.groupName||"others",u={},o=h._data.slice(),s,c=function(n){!i(n)||n<0||e(o.slice(n),function(n,r){i(r[t])&&(u[t]+=r[t],r[t]=undefined,r["original"+t]=undefined)})};f&&f!=="none"&&(u[n]=v+"",u[t]=0,o.sort(function(n,r){return i(r[t])&&i(n[t])?r[t]-n[t]:!i(r[t])&&n[t]?-1:!i(n[t])&&r[t]?1:void 0}),f==="smallValueThreshold"?(e(o,function(n,r){!i(s)&&i(r[t])&&a>r[t]&&(s=n)}),c(s)):f==="topN"&&c(l),u[t]&&h._data.push(u))},_groupData:function(){var t=this,n=t.groups,f=n.length&&n[0].length&&(n[0][0].type==="pie"||n[0][0].type==="doughnut"||n[0][0].type==="donut"),i,r;f&&e(n,function(f,o){e(o,function(f,e){i=e.getArgumentField(),r=e.getValueFields(),n.argumentAxisType===u.DISCRETE&&t._groupSameArguments(i,r),t._groupMinSlices(i,r[0],e.getOptions().smallValuesGrouping)})})},_groupSameArguments:function(n,t){var o=this,r,u={},f=o._data;e(f,function(o,s){if(i(s[n])&&i(s[t[0]]))if(r=s[n],i(u[r])){var h=f[u[r]];e(t,function(n,t){h[t]+=s[t],s[t]=undefined,s["original"+t]=undefined})}else u[r]=o})},_getType:function(n,t){return t===f.STRING||r.isString(n)?f.STRING:t===f.DATETIME||r.isDate(n)?f.DATETIME:r.isNumber(n)?f.NUMERIC:t},_correctAxisType:function(n,t,i){return(n===f.STRING&&(t===u.CONTINUOUS||t===u.LOGARITHMIC)&&this.incidentOccured("E2002"),t===u.LOGARITHMIC)?u.LOGARITHMIC:(t=(i||t===u.DISCRETE||n===f.STRING)&&u.DISCRETE,t||u.CONTINUOUS)},_filterForLogAxis:function(n,t){return n<=0?(this.incidentOccured("E2004",[t]),null):n},_createParserUnit:function(n,t,i){var r=this,u=n?h.getParser(n,undefined,!0):function(n){return n};return function(f,e){var o=u(f);return t&&(o=t.call(r,o,e)),o===null&&i&&(o=undefined),o===undefined&&(r._addSkipFields(e),r._validUnit(f,e,n)),o}},_validUnit:function(n,t){if(n){if(!r.isNumber(n)&&!r.isDate(n)&&!r.isString(n)){this.incidentOccured("E2003",[t]);return}this.incidentOccured("E2004",[t])}},_sort:function(){var t=this,i=t.groups,u={},e=i.length&&i[0].length&&i[0][0].getArgumentField();r.isFunction(t.options.sortingMethod)?t._data.sort(t.options.sortingMethod):t.userArgumentCategories.length?(n.each(t.userArgumentCategories,function(n,t){u[t]=n}),t._data.sort(function(n,t){return n=n[e],t=t[e],u[n]-u[t]})):t.options.sortingMethod===!0&&i.argumentType!==f.STRING&&c(t._data,e)},_addSkipFields:function(n){this._skipFields[n]=(this._skipFields[n]||0)+1},_incorrectDataMessage:function(){this._erorrDataSource!==!0&&(this._erorrDataSource=!0,this.incidentOccured("E2001"))}})}(jQuery,DevExpress),function(n,t,i){var u=t.viz,f=u.core.Palette,r=t.utils,e=20,o=50;u.charts.ThemeManager=u.core.BaseThemeManager.inherit(function(){var a=function(n,i){var r=this;n=n||{},r._userOptions=n,r._mergeAxisTitleOptions=[],i&&(r._themeSection=i),r._IE8=t.browser.msie&&t.browser.version<9,r.setTheme(n.theme),r.palette=new f(n.palette,{stepHighlight:o,theme:r._themeName})},v=function(){var n=this;n.palette.dispose(),n.palette=n._userOptions=n._mergedSettings=null,n.callBase()},y=function(n){var t=n._theme.commonSeriesSettings;t.point=t.point||{},t.label=t.label||{},n._initializeFont(t.label.font)},p=function(n){var t=n._theme.commonAxisSettings;t&&(t.label=t.label||{},t.grid=t.grid||{},t.ticks=t.ticks||{},t.line=t.line||{},t.title=t.title||{},t.label.font=t.label.font||{},n._initializeFont(t.label.font),t.title.font=t.title.font||{},n._initializeFont(t.title.font))},w=function(){this.palette.reset()},b=function(n){this.palette=new f(n||this._theme.defaultPalette,{stepHighlight:o,theme:this.themeName})},s=function(n){return r.isString(n)?{text:n}:n},h=function(t){if(t)return t=n.extend(!0,{},t),t.title=s(t.title),(t.type==="logarithmic"&&t.logarithmBase<=0||t.logarithmBase&&!n.isNumeric(t.logarithmBase))&&(t.logarithmBase=i,t.logarithmBaseError=!0),t.label&&(t.label.alignment&&(t.label.userAlignment=!0),t.label.overlappingBehavior||(t.label.staggered&&(t.label.overlappingBehavior={mode:"stagger",staggeringSpacing:t.label.staggeringSpacing}),t.label.rotationAngle&&(t.label.overlappingBehavior={mode:"rotate",rotationAngle:t.label.rotationAngle})),r.isString(t.label.overlappingBehavior)&&(t.label.overlappingBehavior={mode:t.label.overlappingBehavior}),t.label.overlappingBehavior&&t.label.overlappingBehavior.mode||(t.label.overlappingBehavior=t.label.overlappingBehavior||{})),t},c=function(t,i,r){var u=this._theme,f=r^t==="valueAxis"?"verticalAxis":"horizontalAxis",e=h(this._userOptions.commonAxisSettings,t);return n.extend(!0,{},u.commonAxisSettings,u[f],u[t],e,h(i,t))},u=function(t,i){i=i||this._userOptions[t];var f=this._theme[t],u=this._mergedSettings[t];return u?u:(u=n.isPlainObject(f)&&n.isPlainObject(i)?n.extend(!0,{},f,i):r.isDefined(i)?i:f,this._mergedSettings[t]=u,u)},l={base:u,argumentAxis:c,valueAxisRangeSelector:function(){return u.call(this,"valueAxis")},valueAxis:c,title:function(n){var t=s(this._userOptions[n]);return u.call(this,n,t)},series:function(t,i,r){var l=this._theme,f=this._userOptions.commonSeriesSettings||{},o=l.commonSeriesSettings,e=((i.type||f.type||o.type)+"").toLowerCase(),u,h=this.palette,a=~e.indexOf("bar"),v=~e.indexOf("bubble"),s,y=this.getOptions("containerBackgroundColor"),c;return(a||v)&&(i=n.extend(!0,{},f,f[e],i),c=i.visible,f={type:{}},n.extend(!0,i,i.point),i.visible=c),u=n.extend(!0,{},o,o[e],f,f[e],i),u.type=e,u.containerBackgroundColor=y,r?(u.widgetType="pieChart",s=function(){return h.getNextColor()}):(u.widgetType="chart",s=u.color||h.getNextColor()),u.mainSeriesColor=s,u._IE8=this._IE8,u},pieSegment:function(i,r,u){var f=n.extend(!0,{},r,u),o=new t.Color(f.color||this.palette.getNextColor());return f.color=o.toHex(),f.border.color=f.border.color||o.toHex(),f.hoverStyle.color=f.hoverStyle.color||this._IE8&&o.highlight(e)||o.toHex(),f.hoverStyle.border.color=f.hoverStyle.border.color||o.toHex(),f.selectionStyle.color=f.selectionStyle.color||this._IE8&&o.highlight(e)||o.toHex(),f.selectionStyle.border.color=f.selectionStyle.border.color||o.toHex(),f},animation:function(t){var i=this._userOptions[t];return i=n.isPlainObject(i)?i:r.isDefined(i)?{enabled:!!i}:{},u.call(this,t,i)}};return{_themeSection:"chart",ctor:a,dispose:v,_initializeTheme:function(){var t=this,n=this._theme;n.legend=n.legend||{},n.legend.font=n.legend.font||{},t._initializeFont(n.legend.font),y(t),p(t),n.title=n.title||{},n.title.font=n.title.font||{},t._initializeFont(n.title.font),n.tooltip=n.tooltip||{},n.tooltip.font=n.tooltip.font||{},t._initializeFont(n.tooltip.font),n.loadingIndicator=n.loadingIndicator||{},n.loadingIndicator.font=n.loadingIndicator.font||{},t._initializeFont(n.loadingIndicator.font)},resetPalette:w,getOptions:function(n){return(l[n]||l.base).apply(this,arguments)},setTheme:function(t){var i=this;i._mergedSettings={},i.callBase(t),i.getOptions("rtlEnabled")&&n.extend(!0,i._theme,i._theme._rtl)},resetOptions:function(n){this._mergedSettings[n]=null},update:function(n){this._userOptions=n},updatePalette:b}}())}(jQuery,DevExpress),function(n,t){var r=t.viz,i=r.charts,u=i.series;i.factory=function(){var n=function(n){return new u.SeriesFamily(n)},t=function(n,t){return new i.Axis(n,t)},r=function(n,t){return new i.ThemeManager(n,t)},f=function(n,t,r,u){return new i.DataValidator(n,t,r,u)},e=function(n){return new i.Tracker(n)},o=function(n,t,r,u){return new i.ChartTitle(n,t,r,u)},s=function(n){return new i.LayoutManager(n)};return{createSeriesFamily:n,createAxis:t,createThemeManager:r,createDataValidator:f,createTracker:e,createChartLayoutManager:s,createTitle:o}}()}(jQuery,DevExpress),function(n,t,i){var u=t.viz.core,r=t.utils;t.viz.core.BaseWidget=t.DOMComponent.inherit({NAMESPACE:t.ui,_init:function(){this._setRedrawOnResize(this._getOptionRedrawOnResize()),this._incidentOccured=this._createIncidentOccured(),this._renderVisiblityChange()},_optionChanged:function(n,t,i){var r=this;switch(n){case"redrawOnResize":r._setRedrawOnResize(r._getOptionRedrawOnResize());break;case"loadingIndicator":r._updateLoadIndicator(r._getLoadIndicatorOption());break;default:r._invalidate()}r.callBase(n,t,i)},_getOptionRedrawOnResize:function(){var n=this.option("redrawOnResize");return n=n!==i?!!n:!0},_getLoadIndicatorOption:function(){return this.option("loadingIndicator")},_dispose:function(){var n=this;n._resizeHandlerCallback&&n._removeResizeCallbacks(),n._incidentOccured=null,n.callBase()},_visibilityChanged:function(n){n&&this.render()},_setRedrawOnResize:function(n){var i=this;n?!i._resizeHandlerCallback&&r.isFunction(i._resize)&&(i._resizeHandlerCallback=t.utils.createResizeHandler(function(){i._resize()}),r.windowResizeCallbacks.add(i._resizeHandlerCallback)):i._removeResizeCallbacks()},_removeResizeCallbacks:function(){var n=this;n._resizeHandlerCallback&&n._resizeHandlerCallback.stop(),r.windowResizeCallbacks.remove(n._resizeHandlerCallback),delete n._resizeHandlerCallback},_showLoadIndicator:function(n,t){var r=this;r._loadIndicator=this._loadIndicator||u.CoreFactory.createLoadIndicator(n,r._element()),r._loadIndicator.show(t.width,t.height),r._initializing&&r._loadIndicator.endLoading(i,!0)},_updateLoadIndicator:function(n,t,i){this._loadIndicator&&this._loadIndicator.applyOptions(n,t,i)},_endLoading:function(n){this._loadIndicator?this._loadIndicator.endLoading(n):n&&n()},_reappendLoadIndicator:function(){this._loadIndicator&&this._loadIndicator.toForeground()},_disposeLoadIndicator:function(){this._loadIndicator&&this._loadIndicator.dispose(),this._loadIndicator=null},_setDefaultOptions:function(){this.callBase(),this.option({incidentOccured:function(n){var t=""+n.id+" - "+n.text,i=n.version.split(".").slice(0,2).join("_"),u="http://js.devexpress.com/error/"+i+"/"+n.id;r.logger.warn(t+"\n"+u)}})},_createIncidentOccured:function(){var n=this;return function(t,i){var s=t[0]==="E",h=s?"error":"warning",f=i?i.slice(0):[],e,o=n.option("incidentOccured");f.unshift(u.errorsWarnings[t]),e=r.stringFormat.apply(null,f),r.isFunction(o)&&setTimeout(function(){o({id:t,type:h,args:i,text:e,widget:n.NAME,version:DevExpress.VERSION})})}},_normalizeHtml:function(n){var i=/xmlns="[\s\S]*?"/gi,t=!0;return n=n.replace(i,function(n){return t?(t=!1,n):""}),n.replace(/xmlns:NS1="[\s\S]*?"/gi,"").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi,'xmlns:xlink="$1"')},_drawn:function(){var n=this,t=n.option("drawn");r.isFunction(t)&&setTimeout(function(){t(n)})},showLoadingIndicator:function(){this._showLoadIndicator(this.option("loadingIndicator"),this.canvas||{})},hideLoadingIndicator:function(){this._loadIndicator&&this._loadIndicator.hide()},endUpdate:function(){this._updateLockCount!==1||this._requireRefresh||this.hideLoadingIndicator(),this.callBase()},svg:function(){var n=this.renderer||this._renderer;return n?this._normalizeHtml(n.svg()):""}})}(jQuery,DevExpress),function(n){var r=n.viz.renderers,i=n.viz.core;n.viz.core.CoreFactory=function(){return{createSeries:function(n,t){return new i.series.Series(n,t)},createPoint:function(n,t){return new i.series.points.Point(n,t)},createLabel:function(n,t,r){return n==="pie"||n==="doughnut"||n==="donut"?new i.series.points.PieLabel(t,r):new i.series.points.Label(t,r)},createRenderer:function(n){return new r.Renderer(n)},createTranslator1D:function(n,t,r,u){return(new i.Translator1D).setDomain(n,t).setCodomain(r,u)},createTranslator2D:function(n,t,r){return new i.Translator2D(n,t,r)},getTickProvider:function(){return i.tickProvider},createTooltip:function(n,t,r){return new i.Tooltip(n,t,r)},createLoadIndicator:function(n,t){return new i.LoadIndicator(n,t)},createLegend:function(n,t,r,u){return new i.Legend(n,t,r,u)},createSeriesFamily:function(n){return new i.series.helpers.SeriesFamily(n)}}}()}(DevExpress),DevExpress.MOD_VIZ_CORE=!0}