import setuptools


def get_readme():
    with open('README.rst') as f:
        return f.read()


setuptools.setup(
    # the first three fields are a must according to the documentation
    name="pymyenv",
    version="0.0.6",
    packages=[
        'pymyenv',
        'pymyenv.endpoints',
    ],
    # from here all is optional
    description="pymyenv manages environments for you",
    long_description=get_readme(),
    long_description_content_type="text/x-rst",
    author="Mark Veltzer",
    author_email="mark.veltzer@gmail.com",
    maintainer="Mark Veltzer",
    maintainer_email="mark.veltzer@gmail.com",
    keywords=[
        'pipenv',
        'pip',
        'virtualenv',
    ],
    url="https://veltzer.github.io/pymyenv",
    download_url="https://github.com/veltzer/pymyenv",
    # license="MIT",
    platforms=[
        'python3',
    ],
    install_requires=[
        'pytconf',
        'pylogconf',
    ],
    extras_require={
    },
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3 :: Only',
        'Topic :: Utilities',
        'License :: OSI Approved :: MIT License',
    ],
    data_files=[
    ],
    entry_points={"console_scripts": [
        'pymyenv=pymyenv.endpoints.main:main',
    ]},
    python_requires=">=3.5",
)
