import setuptools
from cli.consts import VP_CLI_VERSION

with open("README.md") as f:
    long_description = f.read()

setuptools.setup(
    name="vp-cli",
    version=VP_CLI_VERSION,
    author="VantagePoint",
    author_email="developers@vantagepoint.co",
    description="VantagePoint CLI",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=setuptools.find_packages(
        exclude=["tests.*", "tests"],
    ),
   install_requires=[
        "alabaster==0.7.12",
        "attrs==19.3.0",
        "Babel==2.8.0",
        "bcrypt==3.2.0",
        "boto3==1.17",
        "botocore==1.20.0",
        "certifi==2019.11.28",
        "cffi==1.14.4",
        "chardet==5.1.0",
        "checkov==2.3.22",
        "cryptography==3.2.1",
        "dateparser==0.7.6",
        "docopt==0.6.2",
        "docutils==0.16",
        "ezenv==0.91",
        "filelock==3.9.0",
        "idna==2.8",
        "imagesize==1.2.0",
        "importlib-metadata==4.4",
        "Jinja2==2.11.1",
        "jmespath==0.10.0",
        "jsonpointer==2.0",
        "jsonschema==4.6.0",
        "MarkupSafe==1.1.1",
        "mock==3.0.5",
        "more-itertools==8.1.0",
        "orjson==3.8.6",
        "packaging==23.0",
        "paramiko==2.7.2",
        "pluggy==1",
        "py==1.8.1",
        "pycparser==2.20",
        "Pygments==2.5.2",
        "PyNaCl==1.4.0",
        "pyparsing==2.4.6",
        "pypsrp==0.5.0",
        "pyrsistent==0.16.0",
        "pyspnego==0.1.5",
        "python-dateutil==2.8.1",
        "pytz==2019.3",
        "PyYAML==5.4.1",
        "regex==2022.1.18",
        "requests==2.28.2",
        "s3transfer==0.3.3",
        "six==1.14.0",
        "snowballstemmer==2.0.0",
        "termcolor==1.1.0",
        "texttable==1.6.2",
        "toml==0.10.0",
        "tzlocal==2.1",
        "urllib3==1.26.0",
        "wcwidth==0.1.8",
        "zipp==1.0.0",
        "activedirectory==0.14",
# install me pycurl

        ],
    include_package_data=True,
    entry_points={
        "console_scripts": ["vp-cli=cli.main:main"],
    },
    classifiers=[
        "Environment :: Console",
        "Programming Language :: Python :: 3",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
        "Operating System :: POSIX",
        "Intended Audience :: End Users/Desktop",
        "Intended Audience :: Developers",
        "Intended Audience :: System Administrators",
    ],
    python_requires=">=3.7",
)
