## ASAPPpy
ASAPPpy is a Python package for developing models to compute the Semantic Textual Similarity (STS) between texts in Portuguese. These models follow a supervised learning approach to learn an STS function from annotated sentence pairs, considering a variety of lexical, syntactic, semantic and distributional features.

ASAPPpy can also be used to develop STS based dialogue agents and deploy them to Slack.


### Development
If you want to contribute to this project, please follow the [Google Python Style Guide](https://google.github.io/styleguide/pyguide.html).


#### Source Code

To check the latest version use the following command:
```bash
    git clone https://github.com/ZPedroP/ASAPPpy.git
```

### Project History
ASAP(P) is the name of a collection of systems developed by the [Natural Language Processing group](http://nlp.dei.uc.pt) at [CISUC](https://www.cisuc.uc.pt/home) for computing STS based on a regression method and a set of lexical, syntactic, semantic and distributional features extracted from text.
It was used to participate in several STS evaluation tasks, for English and Portuguese, but was only recently integrated into two single independent frameworks: ASAPPpy (available here), in Python, and ASAPPj, in Java.


### Help and Support

#### Documentation
Coming soon...

#### Communication
If you have any questions feel free to open a new issue and we will respond as soon as possible.

#### Citation

When [citing ASAPPpy in academic papers and theses](http://ceur-ws.org/Vol-2583/2_ASAPPpy.pdf), please use the following BibTeX entry:

    @inproceedings{santos_etal:assin2020,
        title = {ASAPPpy: a Python Framework for Portuguese STS},
        author = {José Santos and Ana Alves and Hugo {Gonçalo Oliveira}},
        url = {http://ceur-ws.org/Vol-2583/2_ASAPPpy.pdf},
        year = {2020},
        date = {2020-01-01},
        booktitle = {Proceedings of the ASSIN 2 Shared Task: Evaluating Semantic Textual Similarity and Textual Entailment in Portuguese},
        volume = {2583},
        pages = {14--26},
        publisher = {CEUR-WS.org},
        series = {CEUR Workshop Proceedings},
        keywords = {aia, asap, sts},
        pubstate = {published},
        tppubtype = {inproceedings}
    }


