## 引用

- `翻訳言語集` = [./multilang.md]
- `日本語ファイル` = [./message.ja.yml]
- `claude3` = [./claude.md]

## TODO

以下の手順で翻訳を行います。

1. 以下を`翻訳言語集`にて`言語`に対して繰り返し実行します
    実行状況がわかるように、進行バーと隣に何の言語を翻訳しているか記述
    1-1. Claude3実行、以下変数群は忠実に再現
            japanese_content = `日本語ファイル`（全内容ファイルに忠実にpythonファイルに記載すること。ファイル読み込みはしない）
            model="claude-3-haiku-20240307"
            messages=[
            {
                "role": "user",
                "content": f"{japanese_content}"を{language_name}で翻訳"
            }
        ]
    注意: `日本語ファイル`を1行ずつ訳すのではなく、一括翻訳すること
    2. message.`言語記号`.ymlに出力します
    3. プログレスバーの説明を更新
        # 翻訳結果をファイルに出力
        with open(f"message.{language_code}.yml", "w", encoding="utf-8") as f:
            f.write(translated_text)
        "{language_name}翻訳完了"と書く

出力表示は以下の通り （全てprintoutは残す） 
翻訳中:   0%|                                             | 0/10 [00:00<?, ?it/s]  
翻訳中:  10%|███▋                                 | 1/10 [00:03<00:32,  3.60s/it]フランス語翻訳完了  
翻訳中:  20%|███████▍                             | 2/10 [00:07<00:29,  3.63s/it]ドイツ語翻訳完了  
翻訳中:  30%|███████████                          | 3/10 [00:10<00:23,  3.29s/it]英語翻訳完了  
翻訳中:  40%|██████████████▊                      | 4/10 [00:13<00:19,  3.32s/it]スペイン語翻訳完了  
翻訳中:  50%|██████████████████▌                  | 5/10 [00:17<00:17,  3.42s/it]イタリア語翻訳完了  
翻訳中:  60%|██████████████████████▏              | 6/10 [00:20<00:13,  3.43s/it]ポルトガル語翻訳完了  
翻訳中:  70%|█████████████████████████▉           | 7/10 [00:24<00:10,  3.48s/it]ロシア語翻訳完了  
翻訳中:  80%|█████████████████████████████▌       | 8/10 [00:27<00:06,  3.39s/it]中国語翻訳完了  
翻訳中:  90%|█████████████████████████████████▎   | 9/10 [00:30<00:03,  3.47s/it]韓国語翻訳完了  
翻訳中: 100%|████████████████████████████████████| 10/10 [00:35<00:00,  3.55s/it]アラビア語翻訳完了  


## 実行言語
- python
- 1枚のファイル

## 条件
- `日本語ファイル`と同じスタイルで出力
- 注意: `日本語ファイル`を1行ずつ訳すのではなく、一括翻訳すること
- allow_unicode=True 文字化け対策

