#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyprocessors_openai_completion']

package_data = \
{'': ['*']}

install_requires = \
['pymultirole-plugins>=0.5.0,<0.6.0',
 'openai>=0.27.8',
 'pydantic==1.7.4',
 'Jinja2',
 'tenacity',
 'log-with-context',
 'StrEnum',
 'requests']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest>=7.0',
          'pytest-cov',
          'pytest-flake8',
          'pytest-black',
          'flake8==3.9.2',
          'tox',
          'dirty-equals',
          'werkzeug==2.0.0',
          'flask==2.1.3']}

entry_points = \
{'pyprocessors.plugins': ['azure_openai_completion = '
                          'pyprocessors_openai_completion.openai_completion:AzureOpenAICompletionProcessor',
                          'deepinfra_openai_completion = '
                          'pyprocessors_openai_completion.openai_completion:DeepInfraOpenAICompletionProcessor',
                          'openai_completion = '
                          'pyprocessors_openai_completion.openai_completion:OpenAICompletionProcessor']}

setup(name='pyprocessors-openai_completion',
      version='0.5.225',
      description='OpenAICompletion processor',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://kairntech.com/',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
