import io
import os
import sys
from shutil import rmtree
import setuptools
from setuptools import find_packages, setup, Command
VERSION = '0.0.2'

REQUIRED = [
    'requests','django'
]
with open("README.md", "r") as fh:
    long_description = fh.read()
REQUIRED = [
    'requests',
]
here = os.path.abspath(os.path.dirname(__file__))

try:
    with io.open(os.path.join(here, 'README.md'), encoding='utf-8') as f:
        long_description = '\n' + f.read()
except FileNotFoundError:
    long_description = DESCRIPTION

# Load the package's __version__.py module as a dictionary.
about = {}
if not VERSION:
    with open(os.path.join(here, MODULE, '__version__.py')) as f:
        exec(f.read(), about)
else:
    about['__version__'] = VERSION


class UploadCommand(Command):
    """Support setup.py upload."""

    description = 'Build and publish the package.'
    user_options = []

    @staticmethod
    def status(s):
        """Prints things in bold."""
        print('\033[1m{0}\033[0m'.format(s))

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        try:
            self.status('Removing previous builds…')
            rmtree(os.path.join(here, 'dist'))
        except OSError:
            pass

        self.status('Building Source and Wheel (universal) distribution…')
        os.system('{0} setup.py sdist bdist_wheel --universal'.format(sys.executable))

        self.status('Uploading the package to PyPI via Twine…')
        os.system('twine upload dist/*')

        self.status('Pushing git tags…')
        os.system('git tag v{0}'.format(about['__version__']))
        os.system('git push --tags')

        sys.exit()

setup(
    name="nestpay", # Replace with your own username
    version="0.0.2",
    author="Cavid Rzayev",
    author_email="rzayev592@gmail.com",
    description="Django nestpay odeme sistemine inteqraciya",
    long_description=long_description,
    long_description_content_type="text/markdown",
    install_requires=REQUIRED,
    url="https://github.com/CavidRzayev/nestpay_py",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
    cmdclass={
        'upload': UploadCommand,
    },
)