--[[
Simple signal/slot implementation
]]
local signal_mt = {
  __index = {
      register = table.insert
  }
}
function signal_mt.__index:emit(... --[[ Comment in params ]])
  for _, slot in ipairs(self) do
      slot(self, ...)
  end
end
local function create_signal()
  return setmetatable({}, signal_mt)
end

-- Signal test
local signal = create_signal()
signal:register(function(signal, ...)
  print(...)
end)
signal:emit('Answer to Life, the Universe, and Everything:', 42)

--[==[ [=[ [[
Nested ]]
multi-line ]=]
comment ]==]
[==[ Nested
[=[ multi-line
[[ string
]] ]=] ]==]
