from datetime import date
from datetime import datetime as dt
from datetime import time
from datetime import timedelta as td
from datetime import timezone as tz

import pytest

from atoml._utils import _utc, parse_rfc3339


@pytest.mark.parametrize(
    "string, expected",
    [
        ("1979-05-27T07:32:00", dt(1979, 5, 27, 7, 32, 0)),
        ("1979-05-27T07:32:00Z", dt(1979, 5, 27, 7, 32, 0, tzinfo=_utc)),
        (
            "1979-05-27T07:32:00-07:00",
            dt(1979, 5, 27, 7, 32, 0, tzinfo=tz(td(seconds=-7 * 3600), "-07:00")),
        ),
        (
            "1979-05-27T00:32:00.999999-07:00",
            dt(
                1979,
                5,
                27,
                0,
                32,
                0,
                999999,
                tzinfo=tz(td(seconds=-7 * 3600), "-07:00"),
            ),
        ),
    ],
)
def test_parse_rfc3339_datetime(string, expected):
    assert parse_rfc3339(string) == expected


@pytest.mark.parametrize("string, expected", [("1979-05-27", date(1979, 5, 27))])
def test_parse_rfc3339_date(string, expected):
    assert parse_rfc3339(string) == expected


@pytest.mark.parametrize(
    "string, expected",
    [("12:34:56", time(12, 34, 56)), ("12:34:56.123456", time(12, 34, 56, 123456))],
)
def test_parse_rfc3339_time(string, expected):
    assert parse_rfc3339(string) == expected
