# coding: utf-8

"""
    College Football Data API

    This is an API for accessing all sorts of college football data.  Please note that API keys should be supplied with \"Bearer \" prepended (e.g. \"Bearer your_key\"). API keys can be acquired from the CollegeFootballData.com website.  # noqa: E501

    OpenAPI spec version: 4.1.12
    Contact: admin@collegefootballdata.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cfbd.configuration import Configuration


class Coach(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'first_name': 'str',
        'last_name': 'str',
        'hire_date': 'str',
        'seasons': 'list[object]'
    }

    attribute_map = {
        'first_name': 'first_name',
        'last_name': 'last_name',
        'hire_date': 'hire_date',
        'seasons': 'seasons'
    }

    def __init__(self, first_name=None, last_name=None, hire_date=None, seasons=None, _configuration=None):  # noqa: E501
        """Coach - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._first_name = None
        self._last_name = None
        self._hire_date = None
        self._seasons = None
        self.discriminator = None

        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if hire_date is not None:
            self.hire_date = hire_date
        if seasons is not None:
            self.seasons = seasons

    @property
    def first_name(self):
        """Gets the first_name of this Coach.  # noqa: E501


        :return: The first_name of this Coach.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this Coach.


        :param first_name: The first_name of this Coach.  # noqa: E501
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this Coach.  # noqa: E501


        :return: The last_name of this Coach.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this Coach.


        :param last_name: The last_name of this Coach.  # noqa: E501
        :type: str
        """

        self._last_name = last_name

    @property
    def hire_date(self):
        """Gets the hire_date of this Coach.  # noqa: E501


        :return: The hire_date of this Coach.  # noqa: E501
        :rtype: str
        """
        return self._hire_date

    @hire_date.setter
    def hire_date(self, hire_date):
        """Sets the hire_date of this Coach.


        :param hire_date: The hire_date of this Coach.  # noqa: E501
        :type: str
        """

        self._hire_date = hire_date

    @property
    def seasons(self):
        """Gets the seasons of this Coach.  # noqa: E501


        :return: The seasons of this Coach.  # noqa: E501
        :rtype: list[object]
        """
        return self._seasons

    @seasons.setter
    def seasons(self, seasons):
        """Sets the seasons of this Coach.


        :param seasons: The seasons of this Coach.  # noqa: E501
        :type: list[object]
        """

        self._seasons = seasons

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Coach, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Coach):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Coach):
            return True

        return self.to_dict() != other.to_dict()
