# coding: utf-8

"""
    Unity Cloud Build

    This API is intended to be used in conjunction with the Unity Cloud Build service. A tool for building your Unity projects in the Cloud.  See https://developer.cloud.unity3d.com for more information.  ## Making requests This website is built to allow requests to be made against the API. If you are currently logged into Cloud Build you should be able to make requests without entering an API key.   You can find your API key in the Unity Cloud Services portal by clicking on 'Cloud Build Preferences' in the sidebar. Copy the API Key and paste it into the upper left corner of this website. It will be used in all subsequent requests.  ## Clients The Unity Cloud Build API is based upon Swagger. Client libraries to integrate with your projects can easily be generated with the [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen).  The JSON schema required to generate a client for this API version is located here:  ``` [API_URL][BASE_PATH]/api.json ```  ## Authorization The Unity Cloud Build API requires an access token from your Unity Cloud Build account, which can be found by selecting **Settings** under **DevOps > Cloud Build** at https://dashboard.unity3d.com/cloud-build  To authenticate requests, include a Basic Authentication header with your API key as the value. e.g.  ``` Authorization: Basic [YOUR API KEY] ```  ## Pagination Paged results will take two parameters. A page number that is calculated based upon the per_page amount. For instance if there are 40 results and you specify page 2 with per_page set to 10 you will receive records 11-20.  Paged results will also return a Content-Range header. For the example above the content range header would look like this:  ``` Content-Range: items 11-20/40 ```  ## Versioning The API version is indicated in the request URL. Upgrading to a newer API version can be done by changing the path.  The API will receive a new version in the following cases:    * removal of a path or request type   * addition of a required field   * removal of a required field  The following changes are considered backwards compatible and will not trigger a new API version:    * addition of an endpoint or request type   * addition of an optional field   * removal of an optional field   * changes to the format of ids  ## Identifiers It should not be assumed that any of the identifiers used in paths will be a perfect match for your user-entered information. If you see unexpected 403s or 404s from API calls then check your identifiers match the ones used by the API. In particular, `projectId` does NOT typically change when the project is renamed and in fact may not be a direct match for the project name even at initial creation time.  To avoid confusion we recommend that instead of using the human-readable autogenerated orgId and projectId available from the API you should instead use:   * org foreign key for `orgId` (available from project APIs as `orgFk` and org APIs as `coreForeignKey`)   * `guid` for `projectId`  All links generated by the API and the Dashboard should follow this format already, making it easy to figure out the correct parameters by making a comparison.  ## Rate Limiting Requests against the Cloud Build API are limited to a rate of 100 per minute. To preserve the quality of service throughout Cloud Build, additional rate limits may apply to some actions. For example, polling aggressively instead of using webhooks or making API calls with a high concurrency may result in rate limiting.  It is not intended for these rate limits to interfere with any legitimate use of the API. Please contact support at <cloudbuild@unity3d.com> if your use is affected by this rate limit.  You can check the returned HTTP headers for any API request to see your current rate limit status.   * __X-RateLimit-Limit:__ maximum number of requests per minute   * __X-RateLimit-Remaining:__ remaining number of requests in the current window   * __X-RateLimit-Reset:__ time at which the current window will reset (UTC epoch seconds)  Once you go over the rate limit you will receive an error response: ``` HTTP Status: 429 {   \"error\": \"Rate limit exceeded, retry in XX seconds\" } ```   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ucb_client.api_client import ApiClient


class WebhooksApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_hook_for_org(self, orgid, **kwargs):  # noqa: E501
        """Add hook for organization  # noqa: E501

        Adds a new organization level hook. An organization level hook is triggered by events from all projects belonging to the organziation. NOTE: you must be a manager in the organization to add new hooks. <h4>Hook Type Configuration Parameters</h4> <div class=\"webhook-tag-desc\"> <table> <tr><th>Type</th><th>Configuration Options</th></tr> <tr>    <td><code>web</code>    <td>       <table>          <tr><th>url</th><td>Endpoint to submit POST request</td></tr>          <tr><th>encoding</th><td>Either <code>json</code> (default) or <code>form</code></td></tr>          <tr><th>sslVerify</th><td>Verify SSL certificates of HTTPS endpoint</td></tr>          <tr><th>secret</th><td>Used to compute the SHA256 HMAC signature of the hook body and adds          a <code>X-UnityCloudBuild-Signature</code> header to the payload</td></tr>       </table>    </td> </tr> <tr>    <td><code>slack</code>    <td>       <table>          <tr><th>url</th><td>Slack incoming webhook URL. Learn more at https://api.slack.com/incoming-webhooks</td></tr>       </table>    </td> </tr> </table> </div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_hook_for_org(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param Options2 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_hook_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_hook_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
            return data

    def add_hook_for_org_with_http_info(self, orgid, **kwargs):  # noqa: E501
        """Add hook for organization  # noqa: E501

        Adds a new organization level hook. An organization level hook is triggered by events from all projects belonging to the organziation. NOTE: you must be a manager in the organization to add new hooks. <h4>Hook Type Configuration Parameters</h4> <div class=\"webhook-tag-desc\"> <table> <tr><th>Type</th><th>Configuration Options</th></tr> <tr>    <td><code>web</code>    <td>       <table>          <tr><th>url</th><td>Endpoint to submit POST request</td></tr>          <tr><th>encoding</th><td>Either <code>json</code> (default) or <code>form</code></td></tr>          <tr><th>sslVerify</th><td>Verify SSL certificates of HTTPS endpoint</td></tr>          <tr><th>secret</th><td>Used to compute the SHA256 HMAC signature of the hook body and adds          a <code>X-UnityCloudBuild-Signature</code> header to the payload</td></tr>       </table>    </td> </tr> <tr>    <td><code>slack</code>    <td>       <table>          <tr><th>url</th><td>Slack incoming webhook URL. Learn more at https://api.slack.com/incoming-webhooks</td></tr>       </table>    </td> </tr> </table> </div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_hook_for_org_with_http_info(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param Options2 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_hook_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `add_hook_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/hooks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_hook_for_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Add hook for project  # noqa: E501

        Adds a new project level hook. A project level hook is only triggered by events from the specific project. NOTE: you must be a manager in the organization to add new hooks. <h4>Hook Type Configuration Parameters</h4> <div class=\"webhook-tag-desc\"> <table> <tr><th>Type</th><th>Configuration Options</th></tr> <tr>    <td><code>web</code>    <td>       <table>          <tr><th>url</th><td>Endpoint to submit POST request</td></tr>          <tr><th>encoding</th><td>Either <code>json</code> (default) or <code>form</code></td></tr>          <tr><th>sslVerify</th><td>Verify SSL certificates of HTTPS endpoint</td></tr>          <tr><th>secret</th><td>Used to compute the SHA256 HMAC signature of the hook body and adds          a <code>X-UnityCloudBuild-Signature</code> header to the payload</td></tr>       </table>    </td> </tr> <tr>    <td><code>slack</code>    <td>       <table>          <tr><th>url</th><td>Slack incoming webhook URL. Learn more at https://api.slack.com/incoming-webhooks</td></tr>       </table>    </td> </tr> </table> </div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_hook_for_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param Options4 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_hook_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.add_hook_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def add_hook_for_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Add hook for project  # noqa: E501

        Adds a new project level hook. A project level hook is only triggered by events from the specific project. NOTE: you must be a manager in the organization to add new hooks. <h4>Hook Type Configuration Parameters</h4> <div class=\"webhook-tag-desc\"> <table> <tr><th>Type</th><th>Configuration Options</th></tr> <tr>    <td><code>web</code>    <td>       <table>          <tr><th>url</th><td>Endpoint to submit POST request</td></tr>          <tr><th>encoding</th><td>Either <code>json</code> (default) or <code>form</code></td></tr>          <tr><th>sslVerify</th><td>Verify SSL certificates of HTTPS endpoint</td></tr>          <tr><th>secret</th><td>Used to compute the SHA256 HMAC signature of the hook body and adds          a <code>X-UnityCloudBuild-Signature</code> header to the payload</td></tr>       </table>    </td> </tr> <tr>    <td><code>slack</code>    <td>       <table>          <tr><th>url</th><td>Slack incoming webhook URL. Learn more at https://api.slack.com/incoming-webhooks</td></tr>       </table>    </td> </tr> </table> </div>   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_hook_for_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param Options4 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_hook_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `add_hook_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `add_hook_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/hooks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hook_for_org(self, orgid, id, **kwargs):  # noqa: E501
        """Delete organization hook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hook_for_org(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
            return data

    def delete_hook_for_org_with_http_info(self, orgid, id, **kwargs):  # noqa: E501
        """Delete organization hook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hook_for_org_with_http_info(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hook_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `delete_hook_for_org`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_hook_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/hooks/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hook_for_project(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Delete project hook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hook_for_project(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
            return data

    def delete_hook_for_project_with_http_info(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Delete project hook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hook_for_project_with_http_info(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hook_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `delete_hook_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `delete_hook_for_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_hook_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/hooks/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hook_for_org(self, orgid, id, **kwargs):  # noqa: E501
        """Get organization hook details  # noqa: E501

        Get details of a hook by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hook_for_org(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
            return data

    def get_hook_for_org_with_http_info(self, orgid, id, **kwargs):  # noqa: E501
        """Get organization hook details  # noqa: E501

        Get details of a hook by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hook_for_org_with_http_info(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hook_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_hook_for_org`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_hook_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/hooks/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hook_for_project(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Get project hook details  # noqa: E501

        Get details of a hook by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hook_for_project(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
            return data

    def get_hook_for_project_with_http_info(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Get project hook details  # noqa: E501

        Get details of a hook by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hook_for_project_with_http_info(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hook_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_hook_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `get_hook_for_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_hook_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/hooks/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hooks_for_org(self, orgid, **kwargs):  # noqa: E501
        """List hooks for organization  # noqa: E501

        List all hooks configured for the specified organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hooks_for_org(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :return: list[InlineResponse2005]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_hooks_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_hooks_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
            return data

    def list_hooks_for_org_with_http_info(self, orgid, **kwargs):  # noqa: E501
        """List hooks for organization  # noqa: E501

        List all hooks configured for the specified organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hooks_for_org_with_http_info(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :return: list[InlineResponse2005]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hooks_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `list_hooks_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/hooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2005]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_hooks_for_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """List hooks for project  # noqa: E501

        List all hooks configured for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hooks_for_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: list[InlineResponse2005]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_hooks_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_hooks_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def list_hooks_for_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """List hooks for project  # noqa: E501

        List all hooks configured for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_hooks_for_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: list[InlineResponse2005]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_hooks_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `list_hooks_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `list_hooks_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/hooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2005]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ping_hook_for_org(self, orgid, id, **kwargs):  # noqa: E501
        """Ping an org hook  # noqa: E501

        Send a ping event to an org hook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_hook_for_org(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ping_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.ping_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
            return data

    def ping_hook_for_org_with_http_info(self, orgid, id, **kwargs):  # noqa: E501
        """Ping an org hook  # noqa: E501

        Send a ping event to an org hook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_hook_for_org_with_http_info(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ping_hook_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `ping_hook_for_org`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `ping_hook_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/hooks/{id}/ping', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ping_hook_for_project(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Ping a project hook  # noqa: E501

        Send a ping event to a project hook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_hook_for_project(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ping_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.ping_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
            return data

    def ping_hook_for_project_with_http_info(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Ping a project hook  # noqa: E501

        Send a ping event to a project hook.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_hook_for_project_with_http_info(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ping_hook_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `ping_hook_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `ping_hook_for_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `ping_hook_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/hooks/{id}/ping', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hook_for_org(self, orgid, id, **kwargs):  # noqa: E501
        """Update hook for organization  # noqa: E501

        Update a new hook. NOTE: you must be a manager in the organization to update hooks.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hook_for_org(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :param Options3 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hook_for_org_with_http_info(orgid, id, **kwargs)  # noqa: E501
            return data

    def update_hook_for_org_with_http_info(self, orgid, id, **kwargs):  # noqa: E501
        """Update hook for organization  # noqa: E501

        Update a new hook. NOTE: you must be a manager in the organization to update hooks.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hook_for_org_with_http_info(orgid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str id: Hook record identifier (required)
        :param Options3 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'id', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hook_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `update_hook_for_org`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `update_hook_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/hooks/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_hook_for_project(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Update hook for project  # noqa: E501

        Update an existing hook. NOTE: you must be a manager of the project to update hooks.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hook_for_project(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :param Options5 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_hook_for_project_with_http_info(orgid, projectid, id, **kwargs)  # noqa: E501
            return data

    def update_hook_for_project_with_http_info(self, orgid, projectid, id, **kwargs):  # noqa: E501
        """Update hook for project  # noqa: E501

        Update an existing hook. NOTE: you must be a manager of the project to update hooks.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_hook_for_project_with_http_info(orgid, projectid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str id: Hook record identifier (required)
        :param Options5 options:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'id', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_hook_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `update_hook_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `update_hook_for_project`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `update_hook_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/hooks/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
