# coding: utf-8

"""
    Unity Cloud Build

    This API is intended to be used in conjunction with the Unity Cloud Build service. A tool for building your Unity projects in the Cloud.  See https://developer.cloud.unity3d.com for more information.  ## Making requests This website is built to allow requests to be made against the API. If you are currently logged into Cloud Build you should be able to make requests without entering an API key.   You can find your API key in the Unity Cloud Services portal by clicking on 'Cloud Build Preferences' in the sidebar. Copy the API Key and paste it into the upper left corner of this website. It will be used in all subsequent requests.  ## Clients The Unity Cloud Build API is based upon Swagger. Client libraries to integrate with your projects can easily be generated with the [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen).  The JSON schema required to generate a client for this API version is located here:  ``` [API_URL][BASE_PATH]/api.json ```  ## Authorization The Unity Cloud Build API requires an access token from your Unity Cloud Build account, which can be found by selecting **Settings** under **DevOps > Cloud Build** at https://dashboard.unity3d.com/cloud-build  To authenticate requests, include a Basic Authentication header with your API key as the value. e.g.  ``` Authorization: Basic [YOUR API KEY] ```  ## Pagination Paged results will take two parameters. A page number that is calculated based upon the per_page amount. For instance if there are 40 results and you specify page 2 with per_page set to 10 you will receive records 11-20.  Paged results will also return a Content-Range header. For the example above the content range header would look like this:  ``` Content-Range: items 11-20/40 ```  ## Versioning The API version is indicated in the request URL. Upgrading to a newer API version can be done by changing the path.  The API will receive a new version in the following cases:    * removal of a path or request type   * addition of a required field   * removal of a required field  The following changes are considered backwards compatible and will not trigger a new API version:    * addition of an endpoint or request type   * addition of an optional field   * removal of an optional field   * changes to the format of ids  ## Identifiers It should not be assumed that any of the identifiers used in paths will be a perfect match for your user-entered information. If you see unexpected 403s or 404s from API calls then check your identifiers match the ones used by the API. In particular, `projectId` does NOT typically change when the project is renamed and in fact may not be a direct match for the project name even at initial creation time.  To avoid confusion we recommend that instead of using the human-readable autogenerated orgId and projectId available from the API you should instead use:   * org foreign key for `orgId` (available from project APIs as `orgFk` and org APIs as `coreForeignKey`)   * `guid` for `projectId`  All links generated by the API and the Dashboard should follow this format already, making it easy to figure out the correct parameters by making a comparison.  ## Rate Limiting Requests against the Cloud Build API are limited to a rate of 100 per minute. To preserve the quality of service throughout Cloud Build, additional rate limits may apply to some actions. For example, polling aggressively instead of using webhooks or making API calls with a high concurrency may result in rate limiting.  It is not intended for these rate limits to interfere with any legitimate use of the API. Please contact support at <cloudbuild@unity3d.com> if your use is affected by this rate limit.  You can check the returned HTTP headers for any API request to see your current rate limit status.   * __X-RateLimit-Limit:__ maximum number of requests per minute   * __X-RateLimit-Remaining:__ remaining number of requests in the current window   * __X-RateLimit-Reset:__ time at which the current window will reset (UTC epoch seconds)  Once you go over the rate limit you will receive an error response: ``` HTTP Status: 429 {   \"error\": \"Rate limit exceeded, retry in XX seconds\" } ```   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ucb_client.api_client import ApiClient


class ProjectsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_project(self, orgid, options, **kwargs):  # noqa: E501
        """Create project  # noqa: E501

        Create a project for the specified organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_project(orgid, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param object options: Options for project create/update (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_project_with_http_info(orgid, options, **kwargs)  # noqa: E501
        else:
            (data) = self.add_project_with_http_info(orgid, options, **kwargs)  # noqa: E501
            return data

    def add_project_with_http_info(self, orgid, options, **kwargs):  # noqa: E501
        """Create project  # noqa: E501

        Create a project for the specified organization  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_project_with_http_info(orgid, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param object options: Options for project create/update (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `add_project`")  # noqa: E501
        # verify the required parameter 'options' is set
        if self.api_client.client_side_validation and ('options' not in params or
                                                       params['options'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `options` when calling `add_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def archive_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Archive project  # noqa: E501

        This will archive the project in Cloud Build ONLY. Use with caution - this process is not reversible. The projects UPID will be removed from Cloud Build allowing the project to be reconfigured.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.archive_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.archive_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def archive_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Archive project  # noqa: E501

        This will archive the project in Cloud Build ONLY. Use with caution - this process is not reversible. The projects UPID will be removed from Cloud Build allowing the project to be reconfigured.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `archive_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `archive_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def billing_plan(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get billing plan  # noqa: E501

        Get the billing plan for the specified organization (but pull from project)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_plan(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.billing_plan_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.billing_plan_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def billing_plan_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get billing plan  # noqa: E501

        Get the billing plan for the specified organization (but pull from project)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.billing_plan_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method billing_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `billing_plan`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `billing_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/billingplan_alpha', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_log_for_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get audit log  # noqa: E501

        Retrieve a list of historical settings changes for this project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_for_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_log_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_log_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def get_audit_log_for_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get audit log  # noqa: E501

        Retrieve a list of historical settings changes for this project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_log_for_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param float per_page: Number of audit log records to retrieve
        :param float page: Skip to page number, based on per_page value
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'per_page', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_log_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_audit_log_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `get_audit_log_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/auditlog', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2006]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_billing_plans_for_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get billing plan  # noqa: E501

        Get the billing plan for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_billing_plans_for_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_billing_plans_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_billing_plans_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def get_billing_plans_for_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get billing plan  # noqa: E501

        Get the billing plan for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_billing_plans_for_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_billing_plans_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_billing_plans_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `get_billing_plans_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/billingplan', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_env_variables_for_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get environment variables  # noqa: E501

        Get all configured environment variables for a given project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_env_variables_for_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_env_variables_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_env_variables_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def get_env_variables_for_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get environment variables  # noqa: E501

        Get all configured environment variables for a given project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_env_variables_for_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_env_variables_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_env_variables_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `get_env_variables_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/envvars', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get project details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str include: Extra fields to include in the response
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def get_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get project details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param str include: Extra fields to include in the response
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `get_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_by_upid(self, projectupid, **kwargs):  # noqa: E501
        """Get project details  # noqa: E501

        Gets the same data as /orgs/{orgid}/project/{projectid} but looks up the project by the Unity Project ID. This value is returned in the project's guid field.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_by_upid(projectupid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str projectupid: Project UPID - Unity global id (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_by_upid_with_http_info(projectupid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_by_upid_with_http_info(projectupid, **kwargs)  # noqa: E501
            return data

    def get_project_by_upid_with_http_info(self, projectupid, **kwargs):  # noqa: E501
        """Get project details  # noqa: E501

        Gets the same data as /orgs/{orgid}/project/{projectid} but looks up the project by the Unity Project ID. This value is returned in the project's guid field.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_by_upid_with_http_info(projectupid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str projectupid: Project UPID - Unity global id (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['projectupid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_by_upid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'projectupid' is set
        if self.api_client.client_side_validation and ('projectupid' not in params or
                                                       params['projectupid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectupid` when calling `get_project_by_upid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'projectupid' in params:
            path_params['projectupid'] = params['projectupid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{projectupid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_ssh_key_for_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get SSH Key  # noqa: E501

        Get the ssh public key for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_key_for_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_ssh_key_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_ssh_key_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def get_ssh_key_for_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get SSH Key  # noqa: E501

        Get the ssh public key for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_ssh_key_for_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_ssh_key_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_ssh_key_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `get_ssh_key_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/sshkey', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stats_for_project(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get project statistics  # noqa: E501

        Get statistics for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stats_for_project(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_stats_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_stats_for_project_with_http_info(orgid, projectid, **kwargs)  # noqa: E501
            return data

    def get_stats_for_project_with_http_info(self, orgid, projectid, **kwargs):  # noqa: E501
        """Get project statistics  # noqa: E501

        Get statistics for the specified project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stats_for_project_with_http_info(orgid, projectid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stats_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `get_stats_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `get_stats_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_projects_for_org(self, orgid, **kwargs):  # noqa: E501
        """List all projects (org)  # noqa: E501

        List all projects that belong to the specified organization. Add \"?include=settings\" as a query parameter to include the project settings with the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects_for_org(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str include: Extra fields to include in the response
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_projects_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_projects_for_org_with_http_info(orgid, **kwargs)  # noqa: E501
            return data

    def list_projects_for_org_with_http_info(self, orgid, **kwargs):  # noqa: E501
        """List all projects (org)  # noqa: E501

        List all projects that belong to the specified organization. Add \"?include=settings\" as a query parameter to include the project settings with the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects_for_org_with_http_info(orgid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str include: Extra fields to include in the response
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_projects_for_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `list_projects_for_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_projects_for_user(self, **kwargs):  # noqa: E501
        """List all projects (user)  # noqa: E501

        List all projects that you have permission to access across all organizations. Add \"?include=settings\" as a query parameter to include the project settings with the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects_for_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str include: Extra fields to include in the response
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_projects_for_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_projects_for_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_projects_for_user_with_http_info(self, **kwargs):  # noqa: E501
        """List all projects (user)  # noqa: E501

        List all projects that you have permission to access across all organizations. Add \"?include=settings\" as a query parameter to include the project settings with the response.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects_for_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str include: Extra fields to include in the response
        :return: list[object]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_projects_for_user" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'filetoken']  # noqa: E501

        return self.api_client.call_api(
            '/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[object]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_env_variables_for_project(self, orgid, projectid, envvars, **kwargs):  # noqa: E501
        """Set environment variables  # noqa: E501

        Set all configured environment variables for a given project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_env_variables_for_project(orgid, projectid, envvars, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param object envvars: Environment variables (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_env_variables_for_project_with_http_info(orgid, projectid, envvars, **kwargs)  # noqa: E501
        else:
            (data) = self.set_env_variables_for_project_with_http_info(orgid, projectid, envvars, **kwargs)  # noqa: E501
            return data

    def set_env_variables_for_project_with_http_info(self, orgid, projectid, envvars, **kwargs):  # noqa: E501
        """Set environment variables  # noqa: E501

        Set all configured environment variables for a given project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_env_variables_for_project_with_http_info(orgid, projectid, envvars, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param object envvars: Environment variables (required)
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'envvars']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_env_variables_for_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `set_env_variables_for_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `set_env_variables_for_project`")  # noqa: E501
        # verify the required parameter 'envvars' is set
        if self.api_client.client_side_validation and ('envvars' not in params or
                                                       params['envvars'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `envvars` when calling `set_env_variables_for_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'envvars' in params:
            body_params = params['envvars']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}/envvars', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project(self, orgid, projectid, options, **kwargs):  # noqa: E501
        """Update project details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project(orgid, projectid, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param object options: Options for project create/update (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_project_with_http_info(orgid, projectid, options, **kwargs)  # noqa: E501
        else:
            (data) = self.update_project_with_http_info(orgid, projectid, options, **kwargs)  # noqa: E501
            return data

    def update_project_with_http_info(self, orgid, projectid, options, **kwargs):  # noqa: E501
        """Update project details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_with_http_info(orgid, projectid, options, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str orgid: Organization identifier (required)
        :param str projectid: Project identifier (required)
        :param object options: Options for project create/update (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['orgid', 'projectid', 'options']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'orgid' is set
        if self.api_client.client_side_validation and ('orgid' not in params or
                                                       params['orgid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `orgid` when calling `update_project`")  # noqa: E501
        # verify the required parameter 'projectid' is set
        if self.api_client.client_side_validation and ('projectid' not in params or
                                                       params['projectid'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `projectid` when calling `update_project`")  # noqa: E501
        # verify the required parameter 'options' is set
        if self.api_client.client_side_validation and ('options' not in params or
                                                       params['options'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `options` when calling `update_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'orgid' in params:
            path_params['orgid'] = params['orgid']  # noqa: E501
        if 'projectid' in params:
            path_params['projectid'] = params['projectid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'options' in params:
            body_params = params['options']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain', 'text/html', 'text/csv'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'permissions']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgid}/projects/{projectid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
