# coding: utf-8

"""
    Unity Cloud Build

    This API is intended to be used in conjunction with the Unity Cloud Build service. A tool for building your Unity projects in the Cloud.  See https://developer.cloud.unity3d.com for more information.  ## Making requests This website is built to allow requests to be made against the API. If you are currently logged into Cloud Build you should be able to make requests without entering an API key.   You can find your API key in the Unity Cloud Services portal by clicking on 'Cloud Build Preferences' in the sidebar. Copy the API Key and paste it into the upper left corner of this website. It will be used in all subsequent requests.  ## Clients The Unity Cloud Build API is based upon Swagger. Client libraries to integrate with your projects can easily be generated with the [Swagger Code Generator](https://github.com/swagger-api/swagger-codegen).  The JSON schema required to generate a client for this API version is located here:  ``` [API_URL][BASE_PATH]/api.json ```  ## Authorization The Unity Cloud Build API requires an access token from your Unity Cloud Build account, which can be found by selecting **Settings** under **DevOps > Cloud Build** at https://dashboard.unity3d.com/cloud-build  To authenticate requests, include a Basic Authentication header with your API key as the value. e.g.  ``` Authorization: Basic [YOUR API KEY] ```  ## Pagination Paged results will take two parameters. A page number that is calculated based upon the per_page amount. For instance if there are 40 results and you specify page 2 with per_page set to 10 you will receive records 11-20.  Paged results will also return a Content-Range header. For the example above the content range header would look like this:  ``` Content-Range: items 11-20/40 ```  ## Versioning The API version is indicated in the request URL. Upgrading to a newer API version can be done by changing the path.  The API will receive a new version in the following cases:    * removal of a path or request type   * addition of a required field   * removal of a required field  The following changes are considered backwards compatible and will not trigger a new API version:    * addition of an endpoint or request type   * addition of an optional field   * removal of an optional field   * changes to the format of ids  ## Identifiers It should not be assumed that any of the identifiers used in paths will be a perfect match for your user-entered information. If you see unexpected 403s or 404s from API calls then check your identifiers match the ones used by the API. In particular, `projectId` does NOT typically change when the project is renamed and in fact may not be a direct match for the project name even at initial creation time.  To avoid confusion we recommend that instead of using the human-readable autogenerated orgId and projectId available from the API you should instead use:   * org foreign key for `orgId` (available from project APIs as `orgFk` and org APIs as `coreForeignKey`)   * `guid` for `projectId`  All links generated by the API and the Dashboard should follow this format already, making it easy to figure out the correct parameters by making a comparison.  ## Rate Limiting Requests against the Cloud Build API are limited to a rate of 100 per minute. To preserve the quality of service throughout Cloud Build, additional rate limits may apply to some actions. For example, polling aggressively instead of using webhooks or making API calls with a high concurrency may result in rate limiting.  It is not intended for these rate limits to interfere with any legitimate use of the API. Please contact support at <cloudbuild@unity3d.com> if your use is affected by this rate limit.  You can check the returned HTTP headers for any API request to see your current rate limit status.   * __X-RateLimit-Limit:__ maximum number of requests per minute   * __X-RateLimit-Remaining:__ remaining number of requests in the current window   * __X-RateLimit-Reset:__ time at which the current window will reset (UTC epoch seconds)  Once you go over the rate limit you will receive an error response: ``` HTTP Status: 429 {   \"error\": \"Rate limit exceeded, retry in XX seconds\" } ```   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import unittest

import ucb_client
from ucb_client.api.builds_api import BuildsApi  # noqa: E501
from ucb_client.rest import ApiException


class TestBuildsApi(unittest.TestCase):
    """BuildsApi unit test stubs"""

    def setUp(self):
        self.api = ucb_client.api.builds_api.BuildsApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_batch_delete_build_artifacts(self):
        """Test case for batch_delete_build_artifacts

        Delete artifacts for a batch of builds  # noqa: E501
        """
        pass

    def test_cancel_all_builds(self):
        """Test case for cancel_all_builds

        Cancel all builds  # noqa: E501
        """
        pass

    def test_cancel_build(self):
        """Test case for cancel_build

        Cancel build  # noqa: E501
        """
        pass

    def test_cancel_builds_for_org(self):
        """Test case for cancel_builds_for_org

        Cancel builds for org  # noqa: E501
        """
        pass

    def test_create_share(self):
        """Test case for create_share

        Create a new link to share a project  # noqa: E501
        """
        pass

    def test_delete_all_build_artifacts(self):
        """Test case for delete_all_build_artifacts

        Delete all artifacts associated with all non-favorited builds for a specified buildtargetid (_all is allowed).  # noqa: E501
        """
        pass

    def test_delete_build_artifacts(self):
        """Test case for delete_build_artifacts

        Delete all artifacts associated with a specific build  # noqa: E501
        """
        pass

    def test_get_audit_log(self):
        """Test case for get_audit_log

        Get audit log  # noqa: E501
        """
        pass

    def test_get_audit_log_for_build_target(self):
        """Test case for get_audit_log_for_build_target

        Get audit log  # noqa: E501
        """
        pass

    def test_get_build(self):
        """Test case for get_build

        Build Status  # noqa: E501
        """
        pass

    def test_get_build_log(self):
        """Test case for get_build_log

        Get build log  # noqa: E501
        """
        pass

    def test_get_build_steps(self):
        """Test case for get_build_steps

        Get the build steps for a given build  # noqa: E501
        """
        pass

    def test_get_builds(self):
        """Test case for get_builds

        List all builds  # noqa: E501
        """
        pass

    def test_get_builds_for_org(self):
        """Test case for get_builds_for_org

        List all builds for org  # noqa: E501
        """
        pass

    def test_get_share(self):
        """Test case for get_share

        Get the share link  # noqa: E501
        """
        pass

    def test_modify_share(self):
        """Test case for modify_share

        Modify existing share link  # noqa: E501
        """
        pass

    def test_resign_build_artifact(self):
        """Test case for resign_build_artifact

        Re-sign a build artifact  # noqa: E501
        """
        pass

    def test_revoke_share(self):
        """Test case for revoke_share

        Revoke a shared link  # noqa: E501
        """
        pass

    def test_start_builds(self):
        """Test case for start_builds

        Create new build  # noqa: E501
        """
        pass

    def test_update_build(self):
        """Test case for update_build

        Update build information  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
