/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.queue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.queue.ErrorMode;
import org.apache.curator.framework.recipes.queue.MultiItem;
import org.apache.curator.framework.recipes.queue.QueueBase;
import org.apache.curator.framework.recipes.queue.QueuePutListener;
import org.apache.curator.framework.recipes.queue.QueueSerializer;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.cloud.ml.platform.model.util.queue.MyChildrenCache;
import ru.yandex.cloud.ml.platform.model.util.queue.MyItemSerializer;

public class MyDistributedQueue<T>
implements QueueBase<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final QueueSerializer<T> serializer;
    private final String queuePath;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final String lockPath;
    private final AtomicReference<ErrorMode> errorMode = new AtomicReference<ErrorMode>(ErrorMode.REQUEUE);
    private final ListenerContainer<QueuePutListener<T>> putListenerContainer = new ListenerContainer();
    private final AtomicInteger lastChildCount = new AtomicInteger(0);
    private int maxItems;
    private final int finalFlushMs = 5000;
    private final boolean putInBackground;
    private final MyChildrenCache childrenCache;
    private final AtomicInteger putCount = new AtomicInteger(0);
    private static final String QUEUE_ITEM_NAME = "queue-";

    public MyDistributedQueue(CuratorFramework client, QueueSerializer<T> serializer, String queuePath, String lockPath, int maxItems, boolean putInBackground) {
        Preconditions.checkNotNull(client, "client cannot be null");
        Preconditions.checkNotNull(serializer, "serializer cannot be null");
        Preconditions.checkArgument(maxItems > 0, "maxItems must be a positive number");
        this.lockPath = lockPath == null ? null : PathUtils.validatePath(lockPath);
        this.putInBackground = putInBackground;
        this.client = client;
        this.serializer = serializer;
        this.queuePath = PathUtils.validatePath(queuePath);
        this.maxItems = maxItems;
        this.childrenCache = new MyChildrenCache(client, queuePath);
        if (putInBackground) {
            this.log.warn("Bounded queues should set putInBackground(false) in the builder. Putting in the background will result in spotty maxItem consistency.");
        }
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    @Override
    public void start() throws Exception {
        if (!this.state.compareAndSet(State.LATENT, State.STARTED)) {
            throw new IllegalStateException();
        }
        try {
            this.client.create().creatingParentContainersIfNeeded().forPath(this.queuePath);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        if (this.lockPath != null) {
            try {
                this.client.create().creatingParentContainersIfNeeded().forPath(this.lockPath);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
        this.childrenCache.start();
    }

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            try {
                this.flushPuts(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            CloseableUtils.closeQuietly(this.childrenCache);
            this.putListenerContainer.clear();
        }
    }

    public T poll(int timeout, TimeUnit unit) throws InterruptedException {
        long currentVersion = -1L;
        long maxWaitMs = -1L;
        long timeoutMillis = unit.toMillis(timeout);
        try {
            while (this.state.get() == State.STARTED) {
                long startTime = System.currentTimeMillis();
                MyChildrenCache.Data data = this.childrenCache.blockingNextGetData(currentVersion, timeoutMillis, TimeUnit.MILLISECONDS);
                currentVersion = data.version;
                ArrayList<String> children = Lists.newArrayList(data.children);
                this.sortChildren(children);
                for (String child : children) {
                    T result = this.processChildren(child, currentVersion);
                    if (result == null) continue;
                    return result;
                }
                long endTime = System.currentTimeMillis();
                if ((timeoutMillis -= endTime - startTime) >= 0L) continue;
                this.log.info("Timeout polling pool item!");
                return null;
            }
        }
        catch (InterruptedException e) {
            this.log.info("Polling was cancelled", e);
            throw e;
        }
        catch (Exception e) {
            this.log.error("Exception caught in poll handler", e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public int size() {
        try {
            return this.getChildren().size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListenerContainer<QueuePutListener<T>> getPutListenerContainer() {
        return this.putListenerContainer;
    }

    @Override
    public void setErrorMode(ErrorMode newErrorMode) {
        Preconditions.checkNotNull(this.lockPath, "lockPath cannot be null");
        if (newErrorMode == ErrorMode.REQUEUE) {
            this.log.warn("ErrorMode.REQUEUE requires ZooKeeper version 3.4.x+ - make sure you are not using a prior version");
        }
        this.errorMode.set(newErrorMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushPuts(long waitTime, TimeUnit timeUnit) throws InterruptedException {
        long msWaitRemaining = TimeUnit.MILLISECONDS.convert(waitTime, timeUnit);
        AtomicInteger atomicInteger = this.putCount;
        synchronized (atomicInteger) {
            while (this.putCount.get() > 0) {
                if (msWaitRemaining <= 0L) {
                    return false;
                }
                long startMs = System.currentTimeMillis();
                this.putCount.wait(msWaitRemaining);
                long elapsedMs = System.currentTimeMillis() - startMs;
                msWaitRemaining -= elapsedMs;
            }
        }
        return true;
    }

    public void put(T item) throws Exception {
        this.put(item, 0, null);
    }

    public boolean put(T item, int maxWait, TimeUnit unit) throws Exception {
        this.checkState();
        String path = this.makeItemPath();
        return this.internalPut(item, null, path, maxWait, unit);
    }

    public void putMulti(MultiItem<T> items) throws Exception {
        this.putMulti(items, 0, null);
    }

    public boolean putMulti(MultiItem<T> items, int maxWait, TimeUnit unit) throws Exception {
        this.checkState();
        String path = this.makeItemPath();
        return this.internalPut(null, items, path, maxWait, unit);
    }

    @Override
    public int getLastMessageCount() {
        return this.lastChildCount.get();
    }

    private boolean internalPut(T item, MultiItem<T> multiItem, String path, int maxWait, TimeUnit unit) throws Exception {
        if (!this.blockIfMaxed(maxWait, unit)) {
            return false;
        }
        MultiItem<T> givenMultiItem = multiItem;
        if (item != null) {
            AtomicReference ref = new AtomicReference(item);
            multiItem = () -> ref.getAndSet(null);
        }
        this.putCount.incrementAndGet();
        byte[] bytes = MyItemSerializer.serialize(multiItem, this.serializer);
        if (this.putInBackground) {
            this.doPutInBackground(item, path, givenMultiItem, bytes);
        } else {
            this.doPutInForeground(item, path, givenMultiItem, bytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutInForeground(T item, String path, MultiItem<T> givenMultiItem, byte[] bytes) throws Exception {
        ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(path, bytes);
        AtomicInteger atomicInteger = this.putCount;
        synchronized (atomicInteger) {
            this.putCount.decrementAndGet();
            this.putCount.notifyAll();
        }
        this.putListenerContainer.forEach(listener -> {
            if (item != null) {
                listener.putCompleted(item);
            } else {
                listener.putMultiCompleted(givenMultiItem);
            }
            return null;
        });
    }

    private void doPutInBackground(final T item, String path, final MultiItem<T> givenMultiItem, byte[] bytes) throws Exception {
        BackgroundCallback callback = (client, event) -> {
            if (event.getResultCode() != KeeperException.Code.OK.intValue()) {
                return;
            }
            if (event.getType() == CuratorEventType.CREATE) {
                AtomicInteger atomicInteger = this.putCount;
                synchronized (atomicInteger) {
                    this.putCount.decrementAndGet();
                    this.putCount.notifyAll();
                }
            }
            this.putListenerContainer.forEach(new Function<QueuePutListener<T>, Void>(){

                @Override
                public Void apply(QueuePutListener<T> listener) {
                    if (item != null) {
                        listener.putCompleted(item);
                    } else {
                        listener.putMultiCompleted(givenMultiItem);
                    }
                    return null;
                }
            });
        };
        this.internalCreateNode(path, bytes, callback);
    }

    @VisibleForTesting
    void internalCreateNode(String path, byte[] bytes, BackgroundCallback callback) throws Exception {
        ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).inBackground(callback)).forPath(path, bytes);
    }

    void checkState() throws Exception {
        if (this.state.get() != State.STARTED) {
            throw new IllegalStateException();
        }
    }

    String makeItemPath() {
        return ZKPaths.makePath(this.queuePath, QUEUE_ITEM_NAME);
    }

    @VisibleForTesting
    MyChildrenCache getCache() {
        return this.childrenCache;
    }

    protected void sortChildren(List<String> children) {
        Collections.sort(children);
    }

    protected List<String> getChildren() throws Exception {
        return (List)this.client.getChildren().forPath(this.queuePath);
    }

    public List<T> toList() {
        try {
            return ((List)this.client.getChildren().forPath(this.queuePath)).stream().map(child -> {
                try {
                    return this.processMessageBytes((String)child, (byte[])this.client.getData().forPath(ZKPaths.makePath(this.queuePath, child)));
                }
                catch (KeeperException.NoNodeException ignored) {
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected long getDelay(String itemNode) {
        return 0L;
    }

    private boolean blockIfMaxed(int maxWait, TimeUnit unit) throws Exception {
        MyChildrenCache.Data data = this.childrenCache.getData();
        while (data.children.size() >= this.maxItems) {
            long previousVersion = data.version;
            data = this.childrenCache.blockingNextGetData(data.version, maxWait, unit);
            if (data.version != previousVersion) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private T processChildren(String child, long currentVersion) throws Exception {
        boolean isUsingLockSafety;
        boolean bl = isUsingLockSafety = this.lockPath != null;
        if (!child.startsWith(QUEUE_ITEM_NAME)) {
            this.log.warn("Foreign node in queue path: " + child);
        }
        try {
            if (isUsingLockSafety) {
                return this.processWithLockSafety(child, ProcessType.NORMAL);
            }
            return this.processNormally(child, ProcessType.NORMAL);
        }
        catch (Exception e) {
            this.log.warn("Failed to process children ", e);
            return null;
        }
    }

    private T processMessageBytes(String itemNode, byte[] bytes) throws Exception {
        MultiItem<T> items;
        try {
            items = MyItemSerializer.deserialize(bytes, this.serializer);
        }
        catch (Throwable e) {
            ThreadUtils.checkInterrupted(e);
            this.log.error("Corrupted queue item: " + itemNode, e);
            return null;
        }
        T item = items.nextItem();
        if (item == null) {
            return null;
        }
        try {
            return item;
        }
        catch (Throwable e) {
            ThreadUtils.checkInterrupted(e);
            this.log.error("Exception processing queue item: " + itemNode, e);
            return null;
        }
    }

    private T processNormally(String itemNode, ProcessType type) throws Exception {
        try {
            String itemPath = ZKPaths.makePath(this.queuePath, itemNode);
            Stat stat = new Stat();
            byte[] bytes = null;
            if (type == ProcessType.NORMAL) {
                bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(itemPath);
            }
            if (this.client.getState() == CuratorFrameworkState.STARTED) {
                ((BackgroundPathable)this.client.delete().withVersion(stat.getVersion())).forPath(itemPath);
            }
            if (type == ProcessType.NORMAL) {
                return this.processMessageBytes(itemNode, bytes);
            }
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (KeeperException.BadVersionException badVersionException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected T processWithLockSafety(String itemNode, ProcessType type) throws Exception {
        String lockNodePath = ZKPaths.makePath(this.lockPath, itemNode);
        boolean lockCreated = false;
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().withMode(CreateMode.EPHEMERAL)).forPath(lockNodePath);
            lockCreated = true;
            String itemPath = ZKPaths.makePath(this.queuePath, itemNode);
            byte[] bytes = null;
            T result = null;
            if (type == ProcessType.NORMAL) {
                bytes = (byte[])this.client.getData().forPath(itemPath);
                result = this.processMessageBytes(itemNode, bytes);
            }
            if (result == null) {
                ((CuratorTransactionBridge)((ACLPathAndBytesable)((CuratorTransactionBridge)this.client.inTransaction().delete().forPath(itemPath)).and().create().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(this.makeRequeueItemPath(itemPath), bytes)).and().commit();
            } else {
                this.client.delete().forPath(itemPath);
            }
            T t = result;
            return t;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (KeeperException.BadVersionException badVersionException) {
        }
        finally {
            if (lockCreated) {
                ((ChildrenDeletable)this.client.delete().guaranteed()).forPath(lockNodePath);
            }
        }
        return null;
    }

    protected String makeRequeueItemPath(String itemPath) {
        return this.makeItemPath();
    }

    private static enum ProcessMessageBytesCode {
        NORMAL,
        REQUEUE;

    }

    @VisibleForTesting
    protected static enum ProcessType {
        NORMAL,
        REMOVE;

    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

