/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.latch;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;
import ru.yandex.cloud.ml.platform.model.util.latch.Latch;
import ru.yandex.cloud.ml.platform.model.util.latch.LatchManager;
import ru.yandex.cloud.ml.platform.model.util.latch.LocalLatch;

@Service(value="LocalLatchManager")
public class LocalLatchManager
implements LatchManager {
    private final Map<String, LocalLatch> latches;
    private final String prefix;

    public LocalLatchManager() {
        this.latches = new ConcurrentHashMap<String, LocalLatch>();
        this.prefix = "LocalLatchManager-";
    }

    private LocalLatchManager(Map<String, LocalLatch> latches, String prefix) {
        this.latches = latches;
        this.prefix = prefix;
    }

    @Override
    public LatchManager withPrefix(String prefix) {
        return new LocalLatchManager(this.latches, this.prefix + "-" + prefix);
    }

    @Override
    public Latch create(String key, int count) {
        if (this.latches.containsKey(this.prefix + "-" + key)) {
            throw new RuntimeException("Cannot create latch for key " + key + ": latch already exists");
        }
        LocalLatch latch = new LocalLatch(count);
        this.latches.put(this.prefix + "-" + key, latch);
        return latch;
    }

    @Override
    @Nullable
    public Latch get(String key) {
        return this.latches.get(this.prefix + "-" + key);
    }

    @Override
    public void remove(String key) {
        LocalLatch latch = this.latches.remove(this.prefix + "-" + key);
        if (latch != null) {
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }
}

