/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.latch;

import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import ru.yandex.cloud.ml.platform.model.util.latch.DistributedLatch;
import ru.yandex.cloud.ml.platform.model.util.latch.Latch;
import ru.yandex.cloud.ml.platform.model.util.latch.LatchManager;

@Lazy
@Service(value="DistributedLatchManager")
public class DistributedLatchManager
implements LatchManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLatchManager.class);
    private final Map<String, DistributedLatch> latches;
    private final CuratorFramework zookeeperClient;
    private final String prefix;
    private final int latchTimeoutMins;

    @Autowired
    public DistributedLatchManager(CuratorFramework zookeeperClient, int latchTimeoutMins) {
        this.zookeeperClient = zookeeperClient;
        this.latches = new ConcurrentHashMap<String, DistributedLatch>();
        this.prefix = "/DistributedLatchManager";
        this.latchTimeoutMins = latchTimeoutMins;
    }

    private DistributedLatchManager(CuratorFramework zookeeperClient, Map<String, DistributedLatch> latches, String prefix, int latchTimeoutMins) {
        this.zookeeperClient = zookeeperClient;
        this.latches = latches;
        this.prefix = prefix;
        this.latchTimeoutMins = latchTimeoutMins;
    }

    @Override
    public LatchManager withPrefix(String prefix) {
        return new DistributedLatchManager(this.zookeeperClient, this.latches, this.prefix + "-" + prefix, this.latchTimeoutMins);
    }

    @Override
    public Latch create(String key, int count) {
        DistributedLatch latch = this.latches.get(this.prefix + "-" + key);
        if (latch != null && latch.count() >= 0 && !this.isExpired(key, latch)) {
            throw new RuntimeException("Cannot create latch for key " + key + ": latch already exists");
        }
        latch = new DistributedLatch(this.zookeeperClient, count, this.prefix + "-" + key);
        this.latches.put(this.prefix + "-" + key, latch);
        return latch;
    }

    @Override
    @Nullable
    public Latch get(String key) {
        DistributedLatch latch = this.latches.computeIfAbsent(this.prefix + "-" + key, k -> new DistributedLatch(this.zookeeperClient, -1, this.prefix + "-" + key));
        if (this.isExpired(key, latch)) {
            return null;
        }
        return latch.count() >= 0 ? latch : null;
    }

    private boolean isExpired(String key, DistributedLatch latch) {
        if (latch.createdAt() + (long)this.latchTimeoutMins * 60L * 1000L < Instant.now().toEpochMilli()) {
            this.latches.remove(this.prefix + "-" + key);
            latch.close();
            LOGGER.warn("Latch for key " + key + " expired " + (double)(Instant.now().toEpochMilli() - latch.createdAt() - (long)this.latchTimeoutMins * 60L * 1000L) / 1000.0 / 60.0 + " minutes ago");
            return true;
        }
        return false;
    }

    @Override
    public void remove(String key) {
        DistributedLatch latch = this.latches.get(this.prefix + "-" + key);
        this.latches.remove(this.prefix + "-" + key);
        if (latch != null) {
            latch.close();
        }
    }
}

