/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.integer;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.curator.framework.recipes.shared.VersionedValue;
import ru.yandex.cloud.ml.platform.model.util.integer.SharedInteger;

public class DistributedSharedInteger
implements SharedInteger {
    private final SharedCount sharedCount;

    DistributedSharedInteger(CuratorFramework zookeeperClient, String key, int defaultValue) {
        this.sharedCount = new SharedCount(zookeeperClient, key, defaultValue);
        try {
            this.sharedCount.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int get() {
        return this.sharedCount.getCount();
    }

    @Override
    public boolean compareAndSet(int oldValue, int newValue) {
        VersionedValue<Integer> versionedValue = this.sharedCount.getVersionedValue();
        if (oldValue != versionedValue.getValue()) {
            return false;
        }
        try {
            return this.sharedCount.trySetCount(versionedValue, newValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int inc() {
        int count = this.sharedCount.getCount();
        while (!this.compareAndSet(count, count + 1)) {
            count = this.sharedCount.getCount();
        }
        return count + 1;
    }

    @Override
    public int dec() {
        int count = this.sharedCount.getCount();
        while (!this.compareAndSet(count, count - 1)) {
            count = this.sharedCount.getCount();
        }
        return count - 1;
    }
}

