/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.election;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import ru.yandex.cloud.ml.platform.model.util.election.LeaderElection;

@Lazy
@Service(value="DistributedLeaderElection")
public class DistributedLeaderElection
implements LeaderElection {
    private final LeaderLatch leaderLatch;

    @Autowired
    public DistributedLeaderElection(CuratorFramework curatorFramework, @Value(value="${leader.election.prefix}") String prefix) {
        this.leaderLatch = new LeaderLatch(curatorFramework, "/" + prefix);
        try {
            this.leaderLatch.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isLeader() {
        try {
            while (!this.leaderLatch.getLeader().isLeader()) {
                Thread.sleep(1000L);
            }
            return this.leaderLatch.hasLeadership();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

