/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.slots;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.model.util.lock.LocalLockManager;
import ru.yandex.cloud.ml.platform.model.util.lock.LockManager;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;

public class SlotConnectionManager {
    private static final Logger LOG = LogManager.getLogger(SlotConnectionManager.class);
    private final Map<URI, Connection> connections = new ConcurrentHashMap<URI, Connection>();
    private final Map<String, List<URI>> connectedChannels = new ConcurrentHashMap<String, List<URI>>();
    private final LockManager lockManager = new LocalLockManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SlotController getOrCreate(String slotName, URI slotUri, ControllerCreator controllerCreator) {
        LOG.info("Create connection to " + slotUri);
        URI uri = this.getOnlyHostPortURI(slotUri);
        Lock lock = this.lockManager.getOrCreate(slotName);
        lock.lock();
        try {
            if (this.connections.containsKey(slotUri)) {
                SlotController slotController = this.connections.get((Object)slotUri).controller;
                return slotController;
            }
            Connection connection = new Connection(uri, controllerCreator);
            this.connections.put(slotUri, connection);
            if (!this.connectedChannels.containsKey(slotName)) {
                this.connectedChannels.put(slotName, Collections.singletonList(slotUri));
            } else {
                List<URI> uris = this.connectedChannels.get(slotName);
                uris.add(slotUri);
            }
            SlotController slotController = connection.controller;
            return slotController;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownConnections(String slotName) {
        LOG.info("Shutdown connections from slot " + slotName);
        Lock lock = this.lockManager.getOrCreate(slotName);
        lock.lock();
        try {
            if (!this.connectedChannels.containsKey(slotName)) {
                LOG.info("No connections from slot " + slotName + " exit");
                return;
            }
            for (URI uri : this.connectedChannels.get(slotName)) {
                Connection connection = this.connections.remove(uri);
                connection.channel.shutdown();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private URI getOnlyHostPortURI(URI fullUri) {
        try {
            return new URI(fullUri.getScheme(), null, fullUri.getHost(), fullUri.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface ControllerCreator {
        public SlotController create(ManagedChannel var1);
    }

    public static interface SlotController {
        public Iterator<Servant.Message> openOutputSlot(Servant.SlotRequest var1);
    }

    private static class Connection {
        private final SlotController controller;
        private final ManagedChannel channel;

        Connection(URI uri, ControllerCreator controllerCreator) {
            this.channel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(uri.getHost(), uri.getPort()).usePlaintext()).build();
            this.controller = controllerCreator.create(this.channel);
        }
    }
}

