/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.slots;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.model.gRPCConverter;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyInputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LzySlotBase;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.SlotConnectionManager;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;

public abstract class LzyInputSlotBase
extends LzySlotBase
implements LzyInputSlot {
    private static final Logger LOG = LogManager.getLogger(LzyInputSlotBase.class);
    private final String tid;
    private long offset = 0L;
    private URI connected;
    private SlotConnectionManager.SlotController slotController;

    LzyInputSlotBase(String tid, Slot definition) {
        super(definition);
        this.tid = tid;
    }

    @Override
    public void connect(URI slotUri, SlotConnectionManager.SlotController slotController) {
        this.connected = slotUri;
        this.slotController = slotController;
    }

    @Override
    public void disconnect() {
        LOG.info("LzyInputSlotBase:: disconnecting slot " + this);
        if (this.connected == null) {
            LOG.warn("Slot " + this + " was already disconnected");
            return;
        }
        this.connected = null;
        this.slotController = null;
        LOG.info("LzyInputSlotBase:: disconnected " + this);
        this.state(Operations.SlotStatus.State.SUSPENDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAll() {
        Iterator<Servant.Message> msgIter = this.slotController.openOutputSlot(Servant.SlotRequest.newBuilder().setSlot(this.connected.getPath()).setOffset(this.offset).setSlotUri(this.connected.toString()).build());
        try {
            while (msgIter.hasNext()) {
                Servant.Message next = msgIter.next();
                if (next.hasChunk()) {
                    ByteString chunk = next.getChunk();
                    try {
                        LOG.info("From {} chunk received {}", (Object)this.name(), (Object)chunk.toString(StandardCharsets.UTF_8));
                        this.onChunk(chunk);
                        continue;
                    }
                    catch (IOException ioe) {
                        LOG.warn("Unable write chunk of data of size " + chunk.size() + " to input slot " + this.name(), (Throwable)ioe);
                        continue;
                    }
                    finally {
                        this.offset += (long)chunk.size();
                        continue;
                    }
                }
                if (next.getControl() != Servant.Message.Controls.EOS) continue;
                break;
            }
        }
        finally {
            LOG.info("Opening slot {}", (Object)this.name());
            this.state(Operations.SlotStatus.State.OPEN);
        }
    }

    @Override
    public Operations.SlotStatus status() {
        Operations.SlotStatus.Builder builder = Operations.SlotStatus.newBuilder().setState(this.state()).setPointer(this.offset).setDeclaration(gRPCConverter.to(this.definition()));
        if (this.tid != null) {
            builder.setTaskId(this.tid);
        }
        if (this.connected != null) {
            builder.setConnectedTo(this.connected.toString());
        }
        return builder.build();
    }

    protected abstract void onChunk(ByteString var1) throws IOException;
}

