/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.slots;

import com.google.protobuf.ByteString;
import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.gRPCConverter;
import ru.yandex.cloud.ml.platform.lzy.model.slots.TextLinesOutSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyOutputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LzySlotBase;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;

public class LineReaderSlot
extends LzySlotBase
implements LzyOutputSlot {
    private static final Logger LOG = LogManager.getLogger(LineReaderSlot.class);
    private final String tid;
    private final CompletableFuture<LineNumberReader> reader = new CompletableFuture();
    private long offset = 0L;

    public LineReaderSlot(String tid, TextLinesOutSlot definition) {
        super(definition);
        this.state(Operations.SlotStatus.State.OPEN);
        this.tid = tid;
    }

    public void setStream(LineNumberReader lnr) {
        this.reader.complete(lnr);
    }

    @Override
    public Operations.SlotStatus status() {
        return Operations.SlotStatus.newBuilder().setState(this.state()).setPointer(this.offset).setDeclaration(gRPCConverter.to(this.definition())).setTaskId(this.tid).build();
    }

    @Override
    public Stream<ByteString> readFromPosition(long offset) throws IOException {
        if (offset != 0L) {
            throw new EOFException();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<ByteString>(){
            private String line;

            @Override
            public boolean hasNext() {
                try {
                    this.line = LineReaderSlot.this.reader.get().readLine();
                    return this.line != null;
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    LOG.warn("Unable to read line from reader", (Throwable)e);
                    this.line = null;
                    return false;
                }
            }

            @Override
            public ByteString next() {
                if (this.line == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ByteString bytes = ByteString.copyFromUtf8(this.line + "\n");
                LineReaderSlot.this.offset += (long)bytes.size();
                LOG.info("Send from slot {} data {}", (Object)LineReaderSlot.this.name(), (Object)this.line);
                this.line = null;
                return bytes;
            }
        }, 1041), false);
    }
}

