/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.slots;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ForkJoinPool;
import jnr.ffi.Pointer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.FileContents;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LzyInputSlotBase;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.SlotConnectionManager;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;

public class InFileSlot
extends LzyInputSlotBase
implements LzyFileSlot {
    private static final Logger LOG = LogManager.getLogger(InFileSlot.class);
    private final Path storage;
    private final OutputStream outputStream;

    public InFileSlot(String tid, Slot definition) throws IOException {
        this(tid, definition, Files.createTempFile("lzy", "file-slot", new FileAttribute[0]));
    }

    public InFileSlot(String tid, Slot definition, Path storage) throws IOException {
        super(tid, definition);
        this.storage = storage;
        this.outputStream = Files.newOutputStream(storage, new OpenOption[0]);
    }

    @Override
    public void connect(URI slotUri, SlotConnectionManager.SlotController slotController) {
        ForkJoinPool.commonPool().execute(() -> {
            LOG.info("LzyInputSlotBase:: Attempt to connect to " + slotUri + " slot " + this);
            super.connect(slotUri, slotController);
            this.readAll();
        });
    }

    @Override
    protected void onChunk(ByteString bytes) throws IOException {
        this.outputStream.write(bytes.toByteArray());
    }

    @Override
    public Path location() {
        return Path.of(URI.create(this.name()).getPath(), new String[0]);
    }

    @Override
    public long size() {
        LOG.info("InFileSlot::size() for slot " + this.name());
        this.waitForState(Operations.SlotStatus.State.OPEN);
        try {
            return Files.size(this.storage);
        }
        catch (IOException e) {
            LOG.warn("Unable to get a storage file size", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long ctime() {
        try {
            return ((FileTime)Files.getAttribute(this.storage, "unix:creationTime", new LinkOption[0])).toMillis();
        }
        catch (IOException e) {
            LOG.warn("Unable to get file creation time", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long mtime() {
        try {
            return ((FileTime)Files.getAttribute(this.storage, "unix:lastModifiedTime", new LinkOption[0])).toMillis();
        }
        catch (IOException e) {
            LOG.warn("Unable to get file creation time", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long atime() {
        try {
            return ((FileTime)Files.getAttribute(this.storage, "unix:lastAccessTime", new LinkOption[0])).toMillis();
        }
        catch (IOException e) {
            LOG.warn("Unable to get file creation time", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public int mtype() {
        return 32768;
    }

    @Override
    public void remove() throws IOException {
        Files.delete(this.storage);
    }

    @Override
    public FileContents open(FuseFileInfo fi) throws IOException {
        this.waitForState(Operations.SlotStatus.State.OPEN);
        final SeekableByteChannel channel = Files.newByteChannel(this.storage, new OpenOption[0]);
        return new FileContents(){

            @Override
            public int read(Pointer buf, long offset, long size) throws IOException {
                byte[] bytes = new byte[(int)size];
                channel.position(offset);
                ByteBuffer bb = ByteBuffer.wrap(bytes);
                int read = channel.read(bb);
                LOG.info("Read slot {} from file {}: {}", (Object)InFileSlot.this.name(), (Object)InFileSlot.this.storage.toString(), (Object)read);
                if (read < 0) {
                    return 0;
                }
                buf.put(0L, bytes, 0, read);
                return read;
            }

            @Override
            public int write(Pointer buf, long offset, long size) throws IOException {
                throw new IOException("Attempt to write into read-only file");
            }

            @Override
            public void close() throws IOException {
                InFileSlot.this.suspend();
                channel.close();
            }
        };
    }

    public String toString() {
        return "InFileSlot:" + this.definition().name() + "->" + this.storage.toString();
    }
}

