/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.commands;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import ru.yandex.cloud.ml.platform.lzy.servant.commands.LzyCommand;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFS;
import yandex.cloud.priv.datasphere.v2.lzy.Channels;
import yandex.cloud.priv.datasphere.v2.lzy.IAM;
import yandex.cloud.priv.datasphere.v2.lzy.LzyKharonGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.LzyServantGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;

public class Touch
implements LzyCommand {
    private static final Options options = new Options();

    @Override
    public int execute(CommandLine command) throws Exception {
        Operations.Slot.Builder slotBuilder;
        CommandLine localCmd;
        if (command.getArgs().length < 2) {
            throw new IllegalArgumentException("Please specify the name of file to create");
        }
        if (command.getArgs().length < 3) {
            throw new IllegalArgumentException("Please specify the name of channel to connect to");
        }
        String channelName = command.getArgs()[2];
        HelpFormatter cliHelp = new HelpFormatter();
        try {
            localCmd = new DefaultParser().parse(options, command.getArgs(), false);
        }
        catch (ParseException e) {
            cliHelp.printHelp("channel", options);
            return -1;
        }
        ManagedChannel terminalCh = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress("localhost", Integer.parseInt(command.getOptionValue('p'))).usePlaintext()).build();
        LzyServantGrpc.LzyServantBlockingStub terminal = LzyServantGrpc.newBlockingStub(terminalCh);
        Servant.CreateSlotCommand.Builder createCommandBuilder = Servant.CreateSlotCommand.newBuilder();
        if (localCmd.hasOption('s')) {
            Path lzyFsRoot;
            slotBuilder = Operations.Slot.newBuilder();
            Path originalPath = Paths.get(command.getArgs()[1], new String[0]).toAbsolutePath();
            if (!originalPath.startsWith(lzyFsRoot = Paths.get(command.getOptionValue('m'), new String[0]))) {
                throw new IllegalArgumentException("Slot path must be in lzy-fs: " + lzyFsRoot);
            }
            Path relativePath = lzyFsRoot.relativize(originalPath);
            if (LzyFS.roots().stream().anyMatch(p -> relativePath.startsWith("/" + p))) {
                throw new IllegalArgumentException("System paths: " + LzyFS.roots() + " are prohibited for slots declaration");
            }
            slotBuilder.setName("/" + relativePath);
            String slotDefinition = localCmd.getOptionValue('s');
            if (slotDefinition.endsWith(".json")) {
                JsonFormat.parser().merge(Files.newBufferedReader(Paths.get(slotDefinition, new String[0])), (Message.Builder)slotBuilder);
            } else if (slotDefinition.endsWith("}")) {
                JsonFormat.parser().merge(slotDefinition, (Message.Builder)slotBuilder);
            } else {
                URI serverAddr = URI.create(command.getOptionValue('z'));
                IAM.Auth auth = IAM.Auth.parseFrom(Base64.getDecoder().decode(command.getOptionValue('a')));
                ManagedChannel serverCh = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(serverAddr.getHost(), serverAddr.getPort()).usePlaintext()).build();
                LzyKharonGrpc.LzyKharonBlockingStub server = LzyKharonGrpc.newBlockingStub(serverCh);
                Channels.ChannelCommand channelReq = Channels.ChannelCommand.newBuilder().setAuth(auth).setChannelName(channelName).setState(Channels.ChannelState.newBuilder().build()).build();
                Channels.ChannelStatus channelStatus = server.channel(channelReq);
                slotBuilder.setContentType(channelStatus.getChannel().getContentType());
                switch (slotDefinition) {
                    case "input": 
                    case "inpipe": {
                        slotBuilder.setMedia(Operations.Slot.Media.PIPE);
                        slotBuilder.setDirection(Operations.Slot.Direction.INPUT);
                        break;
                    }
                    case "infile": {
                        slotBuilder.setMedia(Operations.Slot.Media.FILE);
                        slotBuilder.setDirection(Operations.Slot.Direction.INPUT);
                        break;
                    }
                    case "output": 
                    case "outpipe": {
                        slotBuilder.setMedia(Operations.Slot.Media.PIPE);
                        slotBuilder.setDirection(Operations.Slot.Direction.OUTPUT);
                        break;
                    }
                    case "outfile": {
                        slotBuilder.setMedia(Operations.Slot.Media.FILE);
                        slotBuilder.setDirection(Operations.Slot.Direction.OUTPUT);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Please provide a slot definition with -s option");
        }
        createCommandBuilder.setSlot(slotBuilder.build());
        createCommandBuilder.setChannelId(channelName);
        Servant.SlotCommandStatus status = terminal.configureSlot(Servant.SlotCommand.newBuilder().setCreate(createCommandBuilder.build()).build());
        System.out.println(JsonFormat.printer().print(status));
        return 0;
    }

    static {
        options.addOption(new Option("s", "slot", true, "Slot definition"));
    }
}

