/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.commands;

import java.io.FileReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import ru.yandex.cloud.ml.platform.lzy.model.utils.Credentials;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyAgentConfig;
import ru.yandex.cloud.ml.platform.lzy.servant.agents.LzyTerminal;
import ru.yandex.cloud.ml.platform.lzy.servant.commands.LzyCommand;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFS;

public class Terminal
implements LzyCommand {
    @Override
    public int execute(CommandLine parse) throws Exception {
        if (!parse.hasOption('z')) {
            throw new IllegalArgumentException("Provide lzy server address with -z option to start a task.");
        }
        UUID terminalToken = UUID.randomUUID();
        Object serverAddress = parse.getOptionValue('z');
        if (!((String)serverAddress).contains("//")) {
            serverAddress = "http://" + (String)serverAddress;
        }
        int port = Integer.parseInt(parse.getOptionValue('p', "9999"));
        Path privateKeyPath = Paths.get(parse.getOptionValue('k', System.getenv("HOME") + "/.ssh/id_rsa"), new String[0]);
        Path lzyRoot = Path.of(parse.getOptionValue('m', System.getenv("HOME") + "/.lzy"), new String[0]);
        Runtime.getRuntime().exec("umount " + lzyRoot);
        String host = parse.getOptionValue('h', LzyFS.lineCmd("hostname"));
        LzyAgentConfig.LzyAgentConfigBuilder builder = LzyAgentConfig.builder().serverAddress(URI.create((String)serverAddress)).user(System.getenv("USER")).token(terminalToken.toString()).agentName(host).agentInternalName(parse.getOptionValue('i', host)).agentPort(port).root(lzyRoot);
        if (Files.exists(privateKeyPath, new LinkOption[0])) {
            try (FileReader keyReader = new FileReader(String.valueOf(privateKeyPath));){
                String tokenSignature = Credentials.signToken(terminalToken, keyReader);
                builder.tokenSign(tokenSignature);
            }
        }
        LzyTerminal terminal = new LzyTerminal(builder.build());
        terminal.start();
        terminal.awaitTermination();
        return 0;
    }
}

